TomTomFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "FuBarPlugin-2.0", "AceDB-2.0");
local tablet = AceLibrary("Tablet-2.0"); 

TomTomFu.hasIcon = true;
TomTomFu.defaultPosition = "RIGHT";

local self = TomTomFu

function TomTomFu:OnInitialize()
TomTomFu:RegisterDB("TomTomFuDB")
	TomTomFu:RegisterDefaults("profile", {		
	})	
	
if IsAddOnLoaded("QuestHelper") then
 local optionsTable = {
	type = 'group',
	args = {
		QHFUGRP = {
			order = 1,
			type = 'group',
			name = "QuestHelper Group",
			desc = "Set QuestHelper Group Properties",
			args = {		
		QHFUSHR = {
			name = "QH Share",
			desc = "Toggles objective sharing on and off. When on, will share quest objectives and progress with other party members that are using QuestHelper 0.17 or higher, and also have sharing enabled.",
			type = "execute",
			func = function() TomTomFu:ToggleShare() end,
		},
		QHFUSOL = {
			name = "QH Solo",
			desc = "Will disable quest sharing and ignore anyone you might be partied with, basically assume you will receive no aid from your party members.",
			type = "execute",
			func = function() TomTomFu:ToggleSolo() end,
		},		
	},
},

QHFUFIL = {
			order = 1,
			type = 'group',
			name = "QuestHelper Filters",
			desc = "Set QuestHelper Filters",
			args = {
		QHFUFIZ = {
			name = "QH Filter Zone",
			desc = "Shows or hides objective that aren't in your current zone.",
			type = 'toggle',
			get = "FilterZone",
			set = "ToggleFilterZone",
		},
		QHFUFID = {
			name = "QH Filter Done",
			desc = "Shows or hides quests that aren't complete.",
			type = 'toggle',
			get = "FilterDone",
			set = "ToggleFilterDone",
		},
		QHFUFIL = {
			name = "QH Filter Level",
			desc = "Shows or hides objective that you probably can't do. Note that this considers the the levels of everyone in your party, not just you. If you're partied with somebody higher than you, it might not hide a quest that it otherwise would have.",
			type = 'toggle',
			get = "FilterLevel",
			set = "ToggleFilterLevel",
		},
	},
},
QHFUMAP = {
			order = 1,
			type = 'group',
			name = "QuestHelper Map",
			desc = "Set QuestHelper Map Options",
			args = {		
    QHFUCAL = {
			name = "QH ReCalc",
			desc = "Recreates the world graph and location and distance information for the active objectives. You probably don't need to worry about this.",
			type = "execute",
			func = function() TomTomFu:ToggleCalc() end,
		},
    QHFUANT = {
			name = "QH Ants",
			desc = "Toggles the display of the Ants on the world graph.",
			type = "execute",
			func = function() TomTomFu:ToggleAnts() end,
		},
		QHFUFLYT = {
			name = "QH FlightTimer",
			desc = "Toggles the display of the FlightTimer.",
			type = "execute",
			func = function() TomTomFu:ToggleFlightTimes() end,
		},
		QHFUTOG = {
			name = "TomTom Waypoints",
			desc = "Toggles using TomTom Waypoints to display your current objective.",
			type = "execute",
			func = function() TomTomFu:ToggleTomTomWP() end,
		},
		QHFUTRK = {
			name = "QH Tracker",
			desc = "Toggles using QuestHelpers built in Quest Tracker to display your current objective.",
			type = "execute",
			func = function() TomTomFu:TogQHTRK() end,
		},
	},
},
    QHFUHID = {
			name = "QH Hide",
			desc = "Hides QuestHelper's minimap arrow and World Map icons and paths, and suspends the calculation of routes.",
			type = "execute",
			func = function() TomTomFu:ToggleHide() end,
		},
		QHFUHIDTIP = {
			name = "QH Tooltips",
			desc = "Toggles QuestHelper's Quest Objectives Tooltips.",
			type = "execute",
			func = function() TomTomFu:TogHideTips() end,
		},
	},
}
	TomTomFu.OnMenuRequest = optionsTable
 end
end

function TomTomFu:OnTextUpdate()
	if (self:IsTextShown()) then
		self:ShowText();
		self:SetText("WayPoints");
	else
		self:HideText();
	end
end

function TomTomFu:OnTooltipUpdate()
   if IsAddOnLoaded("TomTOm") then
    tablet:SetTitle("TomTom")
	  local cat = tablet:AddCategory()
	  cat:AddLine(
		   "text", "|cffffff78USAGE:|r",
		   'size', 16
	    )
	  cat:AddLine(
		   "text", "      |cff00ff00 <x> <y> [desc]|r ",
		   'size', 14 
	   )
	   cat:AddLine(
		   "text", "    Adds a waypoint at |cff00ff00x,y|r with descrtiption |cff00ff00[desc]|r",
		   'size', 12 
	   )
	   cat:AddLine(
		   "text", ""		   
	   )
	  cat:AddLine(
		   "text", "      |cff00ff00 <zone> <x> <y> [desc]|r ",
		   'size', 14
	    )
	  cat:AddLine(
		   "text", "    Adds a waypoint at |cff00ff00x,y|r in |cff00ff00x,y|rzone|r with description |cff00ff00[desc]|r",
		   'size', 12    
	    )		
  end  
   tablet:SetHint("|cffeda55fShift+LeftClick|r Clears ALL WPs" .. ".".."|cffeda55fLeftClick|r Toggels Input Mode")  
end

function TomTomFu:OnClick() 
	if IsShiftKeyDown() and IsAddOnLoaded("TomTom") then 
	  if TomTom.db.profile.general.confirmremoveall then 
      StaticPopup_Show("TOMTOM_REMOVE_ALL_CONFIRM") else 
      StaticPopupDialogs["TOMTOM_REMOVE_ALL_CONFIRM"].OnAccept()
      return 
    end 
      UIErrorsFrame:AddMessage("<WayPoints> - Cleared. No longer searching.", 1.0, 
      1.0, 1.0, 1.0); PlaySound("MapPing"); 
  elseif IsAltKeyDown() and IsAddOnLoaded("QuestHelper") then 
  	 QuestHelper.ToggleTomTomWP(QuestHelper); 
     PlaySound("MapPing"); 
  else 
  	TomTomFu_Toggle(); 
  end		
end

function TomTomFu_Submit()   
	msg = TomTomFuFrameEdit:GetText();   
	SlashCmdList["WAY"](msg)
	if (TomTomFuFrame:IsVisible() ) then
		HideUIPanel(TomTomFuFrame);
		TomTomFuFrameEdit:SetText("");
	end	
end

function TomTomFu_Clear()
  if TomTom.db.profile.general.confirmremoveall then
		StaticPopup_Show("TOMTOM_REMOVE_ALL_CONFIRM")
	else
		StaticPopupDialogs["TOMTOM_REMOVE_ALL_CONFIRM"].OnAccept()
		return
	end 
	UIErrorsFrame:AddMessage("<WayPoints> - Cleared. No longer searching.", 1.0, 1.0, 1.0, 1.0);
  PlaySound("MapPing");  
  if (TomTomFuFrame:IsVisible() ) then
		HideUIPanel(TomTomFuFrame);
		TomTomFuFrameEdit:SetText("");
	end
end

-- function TomTomFu_View()			
--  if (TomTomFuFrame:IsVisible() ) then
--		HideUIPanel(Cart_TomTomFu1Frame);
--		TomTomFuFrameEdit:SetText("");
--	end
-- end

function TomTomFu_Toggle()  
  if(TomTomFuFrame:IsVisible()) then
		HideUIPanel(TomTomFuFrame);
	else
		ShowUIPanel(TomTomFuFrame);
	end
end

function TomTomFu:ToggleTomTomWP()
	QuestHelper.ToggleTomTomWP(QuestHelper);
end

function TomTomFu:ToggleShare()
	QuestHelper.ToggleShare(QuestHelper);	
end

function TomTomFu:ToggleSolo()
	QuestHelper.ToggleSolo(QuestHelper);	
end

function TomTomFu:ToggleHide()
	QuestHelper.ToggleHide(QuestHelper);
end

function TomTomFu:FilterZone()
	return QuestHelper_Pref.filter_zone;
end

function TomTomFu:ToggleFilterZone()
	QuestHelper_Pref.filter_zone = not QuestHelper_Pref.filter_zone;
end

function TomTomFu:FilterDone()
	return QuestHelper_Pref.filter_done;
end

function TomTomFu:ToggleFilterDone()
	QuestHelper_Pref.filter_done = not QuestHelper_Pref.filter_done;
end

function TomTomFu:FilterLevel()
	return QuestHelper_Pref.filter_level;
end

function TomTomFu:ToggleFilterLevel()
	QuestHelper_Pref.filter_level = not QuestHelper_Pref.filter_level;
end

function TomTomFu:ToggleCalc()
	QuestHelper.WantPathingReset(QuestHelper);
end

function TomTomFu:ToggleAnts()
	QuestHelper.ToggleAnts(QuestHelper);
end

function TomTomFu:ToggleFlightTimes()
	QuestHelper:ToggleFlightTimes(QuestHelper);
end

function TomTomFu:TogQHTRK()
	QuestHelper:ToggleTrack(QuestHelper);
end

function TomTomFu:TogHideTips()
	QuestHelper:ToggleTooltip(QuestHelper);
end
