-- ShowHelm(bool) and ShowingHelm() for helmet stuff


local VERSION = tonumber(("$Revision: 67074 $"):match("%d+"))

local TitleHider = Rock:NewAddon("TitleHider", "LibRockDB-1.0", "LibRockEvent-1.0", "LibRockConsole-1.0", "LibRockHook-1.0", "LibRockModuleCore-1.0", "LibRockConfig-1.0")

-- set the global variable of TitleHider to the new addon
_G.TitleHider = TitleHider
local self = TitleHider
TitleHider.title = 'Title Hider'
TitleHider.version = TH_VERSION .."-".. VERSION
TitleHider.revision = VERSION
TitleHider.date = ("$Date: 2008-03-30 09:06:52 -0400 (Sun, 30 Mar 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")

-- register the CVars to make sure they're available.
-- additions from Gnowknayme of GCR, Mal'Ganis

    RegisterCVar(TH_CVAR_NAME_FRIENDLY);
    RegisterCVar(TH_CVAR_NAME_ENEMY);
    RegisterCVar(TH_CVAR_PVP);
    RegisterCVar(TH_CVAR_GUILD);
    RegisterCVar(TH_CVAR_NPC);
    RegisterCVar(TH_CVAR_PET_FRIENDLY);
    RegisterCVar(TH_CVAR_PET_ENEMY);
    RegisterCVar(TH_CVAR_CREATION_FRIENDLY);
    RegisterCVar(TH_CVAR_CREATION_ENEMY);
    RegisterCVar(TH_CVAR_COMPANION);


local _G = _G
local geterrorhandler = _G.geterrorhandler
local pcall = _G.pcall
local ipairs = _G.ipairs
local InCombatLockdown = _G.InCombatLockdown
local UIParent = _G.UIParent
local rawget = _G.rawget
local pairs = _G.pairs
local setmetatable = _G.setmetatable
local type = _G.type


-- Function for locales
local localeTables = {}
function TitleHider:L(name, defaultTable)
	if not localeTables[name] then
		localeTables[name] = setmetatable(defaultTable or {}, {__index = function(self, key)
			self[key] = key
			return key
		end})
	end
	return localeTables[name]
end

local L = TitleHider:L("TitleHider", localization)


-- [[set up the storage for prefered values]] --
-- basic values - hopefully only written once, and doesn't overwrite everytime

-- doesn't work as I want
TitleHider:SetDatabase("TitleHider2DB")
--[[TitleHider:SetDatabaseDefaults("default", {
  ['**'] = {
    name = GetCVar(TH_CVAR_NAME_FRIENDLY),
    enemy_name = GetCVar(TH_CVAR_NAME_ENEMY),
    pvp = GetCVar(TH_CVAR_PVP),
    guild = GetCVar(TH_CVAR_GUILD),
    npc = GetCVar(TH_CVAR_NPC),
    pet = GetCVar(TH_CVAR_PET_FRIENDLY),
    enemy_pet = GetCVar(TH_CVAR_PET_ENEMY),
    creation = GetCVar(TH_CVAR_CREATION_FRIENDLY),
    enemy_creation = GetCVar(TH_CVAR_CREATION_ENEMY),
    companion = GetCVar(TH_CVAR_COMPANION),
    hat = ShowingHelm()
  },
  default = { size = 40 },
  city = {},
  world = { size = 40 },
  instance = { size = 40 },
  bg = { size = 40 }

})]]

--TitleHider:SetDefaultProfile("default")

function TitleHider:OnInitialize()
	self:SetConfigTable(self.options)
	self:SetConfigSlashCommand('/TitleHider', '/TH')
	
end

function TitleHider:OnEnable()
  TitleHider:AddEventListener("PARTY_MEMBERS_CHANGED")
  TitleHider:AddEventListener("RAID_ROSTER_UPDATE")
  TitleHider:AddEventListener("ZONE_CHANGED_NEW_AREA")
  TitleHider:AddEventListener("VARIABLES_LOADED")
  TitleHider:AddEventListener("PLAYER_LEAVING_WORLD")
end

function TitleHider:ZONE_CHANGED_NEW_AREA()
  updateTitles()
end

function TitleHider:PARTY_MEMBERS_CHANGED()
  updateTitles()
end

function TitleHider:RAID_ROSTER_UPDATE()
  updateTitles()
end

function TitleHider:VARIABLES_LOADED()
  TitleHider:Print("Settings loaded")
  updateTitles()
end

--[[ set everything to the default values, so if we create a new character, they'll use them ]]--
function TitleHider:PLAYER_LEAVING_WORLD()
  friendly_player = TitleHider.db.profile['defaultFriendlyPlayer']
  enemy_player = TitleHider.db.profile['defaultEnemyPlayer']
  pvp = TitleHider.db.profile['defaultPvp']
  guild = TitleHider.db.profile['defaultGuild']
  npc = TitleHider.db.profile['defaultNPC']
  pet = TitleHider.db.profile['defaultFriendlyPet']
  enemy_pet = TitleHider.db.profile['defaultEnemyPet']
  creation = TitleHider.db.profile['defaultCreation']
  enemy_creation = TitleHider.db.profile['defaultEnemyCreation']
  companion =  TitleHider.db.profile['defaultCompanion']
  hat = TitleHider.db.profile['defaultHat']

  SetCVar(TH_CVAR_PVP, pvp)
  SetCVar(TH_CVAR_GUILD, guild)
  SetCVar(TH_CVAR_NAME_FRIENDLY, friendly_player)
  SetCVar(TH_CVAR_NAME_ENEMY, enemy_player)
  SetCVar(TH_CVAR_PET_FRIENDLY, pet)
  SetCVar(TH_CVAR_PET_ENEMY, enemy_pet)
  SetCVar(TH_CVAR_CREATION_FRIENDLY, creation)
  SetCVar(TH_CVAR_CREATION_ENEMY, enemy_creation)
  SetCVar(TH_CVAR_NPC, npc)
  SetCVar(TH_CVAR_COMPANION, companion)
  
  ShowHelm(hat)

end


function updateTitles() -- rather it was local, but well...
  -- update all the titles upon a state change
  
  -- store the zone name text
  local zone = GetRealZoneText()

  local player, pvp, guild, npc, hat

  -- store whether we're in a BG - code given to me by gnowknayme
  local bgstatus = false;
	for i=1, MAX_BATTLEFIELD_QUEUES do
		local s, _, _ = GetBattlefieldStatus(i);
		if (s == "active") then	
			bgstatus = true;
			break;
		end
	end

  -- are we in a BG?
  if (bgstatus and (GetNumPartyMembers()+1 >= TitleHider.db.profile['bgThreshold'] or 
    GetNumRaidMembers() >= TitleHider.db.profile['bgThreshold'])) then
    -- get the BG values ready

    friendly_player = TitleHider.db.profile['bgFriendlyPlayer']
    enemy_player = TitleHider.db.profile['bgEnemyPlayer']
    pvp = TitleHider.db.profile['bgPvp']
    guild = TitleHider.db.profile['bgGuild']
    npc = TitleHider.db.profile['bgNPC']
    pet = TitleHider.db.profile['bgFriendlyPet']
    enemy_pet = TitleHider.db.profile['bgEnemyPet']
    creation = TitleHider.db.profile['bgCreation']
    enemy_creation = TitleHider.db.profile['bgEnemyCreation']
    companion =  TitleHider.db.profile['bgCompanion']
    hat = TitleHider.db.profile['bgHat']

  -- are we in a city - has to be an easier way to check
  elseif (zone == L["Ironforge"] or zone == L["Silvermoon City"] or zone == L["Stormwind City"]
    or zone == L["Undercity"] or zone == L["Darnassus"] or zone == L["Orgrimmar"]
    or zone == L["Thunder Bluff"] or zone == L["Shattrath City"]) then

    friendly_player = TitleHider.db.profile['cityFriendlyPlayer']
    enemy_player = TitleHider.db.profile['cityEnemyPlayer']
    pvp = TitleHider.db.profile['cityPvp']
    guild = TitleHider.db.profile['cityGuild']
    npc = TitleHider.db.profile['cityNPC']
    pet = TitleHider.db.profile['cityFriendlyPet']
    enemy_pet = TitleHider.db.profile['cityEnemyPet']
    creation = TitleHider.db.profile['cityCreation']
    enemy_creation = TitleHider.db.profile['cityEnemyCreation']
    companion =  TitleHider.db.profile['cityCompanion']
    hat = TitleHider.db.profile['cityHat']

  -- in an instance?
  elseif (IsInInstance() and (GetNumPartyMembers()+1 >= TitleHider.db.profile['instanceThreshold'] or 
    GetNumRaidMembers() >= TitleHider.db.profile['instanceThreshold'])) then

    friendly_player = TitleHider.db.profile['instanceFriendlyPlayer']
    enemy_player = TitleHider.db.profile['instanceEnemyPlayer']
    pvp = TitleHider.db.profile['instancePvp']
    guild = TitleHider.db.profile['instanceGuild']
    npc = TitleHider.db.profile['instanceNPC']
    pet = TitleHider.db.profile['instanceFriendlyPet']
    enemy_pet = TitleHider.db.profile['instanceEnemyPet']
    creation = TitleHider.db.profile['instanceCreation']
    enemy_creation = TitleHider.db.profile['instanceEnemyCreation']
    companion =  TitleHider.db.profile['instanceCompanion']
    hat = TitleHider.db.profile['instanceHat']

  -- we must be in the world
  elseif(GetNumPartyMembers()+1 >= TitleHider.db.profile['instanceThreshold'] or 
    GetNumRaidMembers() >= TitleHider.db.profile['instanceThreshold']) then

    friendly_player = TitleHider.db.profile['worldFriendlyPlayer']
    enemy_player = TitleHider.db.profile['worldEnemyPlayer']
    pvp = TitleHider.db.profile['worldPvp']
    guild = TitleHider.db.profile['worldGuild']
    npc = TitleHider.db.profile['worldNPC']
    pet = TitleHider.db.profile['worldFriendlyPet']
    enemy_pet = TitleHider.db.profile['worldEnemyPet']
    creation = TitleHider.db.profile['worldCreation']
    enemy_creation = TitleHider.db.profile['worldEnemyCreation']
    companion =  TitleHider.db.profile['worldCompanion']
    hat = TitleHider.db.profile['worldHat']

  -- however, conditions not met
  else
    friendly_player = TitleHider.db.profile['defaultFriendlyPlayer']
    enemy_player = TitleHider.db.profile['defaultEnemyPlayer']
    pvp = TitleHider.db.profile['defaultPvp']
    guild = TitleHider.db.profile['defaultGuild']
    npc = TitleHider.db.profile['defaultNPC']
    pet = TitleHider.db.profile['defaultFriendlyPet']
    enemy_pet = TitleHider.db.profile['defaultEnemyPet']
    creation = TitleHider.db.profile['defaultCreation']
    enemy_creation = TitleHider.db.profile['defaultEnemyCreation']
    companion =  TitleHider.db.profile['defaultCompanion']
    hat = TitleHider.db.profile['defaultHat']


  end


  SetCVar(TH_CVAR_PVP, pvp)
  SetCVar(TH_CVAR_GUILD, guild)
  SetCVar(TH_CVAR_NAME_FRIENDLY, friendly_player)
  SetCVar(TH_CVAR_NAME_ENEMY, enemy_player)
  SetCVar(TH_CVAR_PET_FRIENDLY, pet)
  SetCVar(TH_CVAR_PET_ENEMY, enemy_pet)
  SetCVar(TH_CVAR_CREATION_FRIENDLY, creation)
  SetCVar(TH_CVAR_CREATION_ENEMY, enemy_creation)
  SetCVar(TH_CVAR_COMPANION, companion)
  SetCVar(TH_CVAR_NPC, npc)

  ShowHelm(hat)

end

-- [[for setting and getting values]]--
local function setValue(key, value)

  -- change boolean to int, or leave as is if not boolean
  -- unless someone knows type casting in lua?
  local insert = 0
  if (value == true) then
    insert = 1
  elseif (value == false) then
    insert = 0
  else
    insert = value
  end

  TitleHider.db.profile[key] = insert
  updateTitles()
end

local function getValue(key)
  if (TitleHider.db.profile[key] == 1) then 
    return true
  else
    return false
  end

  -- return a false, just in case
  return false 
end

-- threshold retrieval
local function getValueThresh(key)
  return TitleHider.db.profile[key]
end


--[[ set up the menus ]]--
TitleHider.options = {
  type = 'group',
  name = "TitleHider",
  desc = L["Hide player name and guild titles"],
  icon = [[Interface\FriendsFrame\FriendsFrameScrollIcon]],
  args = {
    default = 
    {
      type = 'group',
      name = L["Default Settings"],
      desc = L["Default settings for when thresholds aren't met"],
      order = 1,
      args = 
      {
        playername = 
        {
          type = 'boolean',
          name = L["Player names"],
          desc = L["Display player names"],
          get = getValue,
          set = setValue,
          passValue = 'defaultFriendlyPlayer',
          order = 1,
        },
        enemyplayername = 
        {
          type = 'boolean',
          name = L["Enemy player names"],
          desc = L["Display enemy player names"],
          get = getValue,
          set = setValue,
          passValue = 'defaultEnemyPlayer',
          order = 2,
        },
        pvp = 
        {
          type = 'boolean',
          name = L["PvP titles"],
          desc = L["Display PvP titles on players"],
          get = getValue,
          set = setValue,
          passValue = 'defaultPvp',
          order = 3,
        },
        guildname = 
        {
          type = 'boolean',
          name = L["Guild names"],
          desc = L["Display guild names under players' names"],
          get = getValue,
          set = setValue,
          passValue = 'defaultGuild',
          order = 5,
        },
        npcname = 
        {
          type = 'boolean',
          name = L["NPC names"],
          desc = L["Display names of NPCs"],
          get = getValue,
          set = setValue,
          passValue = 'defaultNPC',
          order = 7,
        },
        petname = 
        {
          type = 'boolean',
          name = L["Pet names"],
          desc = L["Display names of pets"],
          get = getValue,
          set = setValue,
          passValue = 'defaultFriendlyPet',
          order = 8,
        },
        enemypetname = 
        {
          type = 'boolean',
          name = L["Enemy pet names"],
          desc = L["Display names of enemy pets"],
          get = getValue,
          set = setValue,
          passValue = 'defaultEnemyPet',
          order = 9,
        },
        creationname = 
        {
          type = 'boolean',
          name = L["Creation names"],
          desc = L["Display names of creations"],
          get = getValue,
          set = setValue,
          passValue = 'defaultCreation',
          order = 10,
        },
        enemycreationname = 
        {
          type = 'boolean',
          name = L["Enemy creation names"],
          desc = L["Display names of enemy creations"],
          get = getValue,
          set = setValue,
          passValue = 'defaultEnemyCreation',
          order = 11,
        },
        companionname = 
        {
          type = 'boolean',
          name = L["Companion names"],
          desc = L["Display names of companionss"],
          get = getValue,
          set = setValue,
          passValue = 'defaultCompanion',
          order = 12,
        },
        hat = 
        {
          type = 'boolean',
          name = L["Show Hat"],
          desc = L["Show your hat"],
          get = getValue,
          set = setValue,
          passValue = 'defaultHat',
          order = 15,
        },
      }
    }, -- default
    world = 
    {
      type = 'group',
      name = L["World"],
      desc = L["Settings for in the world"],
      order = 3,
      args = 
      {
        playername = 
        {
          type = 'boolean',
          name = L["Player names"],
          desc = L["Display player names"],
          get = getValue,
          set = setValue,
          passValue = 'worldFriendlyPlayer',
          order = 1,
        },
        enemyplayername = 
        {
          type = 'boolean',
          name = L["Enemy player names"],
          desc = L["Display enemy player names"],
          get = getValue,
          set = setValue,
          passValue = 'worldEnemyPlayer',
          order = 2,
        },
        pvp = 
        {
          type = 'boolean',
          name = L["PvP titles"],
          desc = L["Display PvP titles on players"],
          get = getValue,
          set = setValue,
          passValue = 'worldPvp',
          order = 3,
        },
        guildname = 
        {
          type = 'boolean',
          name = L["Guild names"],
          desc = L["Display guild names under players' names"],
          get = getValue,
          set = setValue,
          passValue = 'worldGuild',
          order = 5,
        },
        npcname = 
        {
          type = 'boolean',
          name = L["NPC names"],
          desc = L["Display names of NPCs"],
          get = getValue,
          set = setValue,
          passValue = 'worldNPC',
          order = 7,
        },
        petname = 
        {
          type = 'boolean',
          name = L["Pet names"],
          desc = L["Display names of pets"],
          get = getValue,
          set = setValue,
          passValue = 'worldFriendlyPet',
          order = 8,
        },
        enemypetname = 
        {
          type = 'boolean',
          name = L["Enemy pet names"],
          desc = L["Display names of enemy pets"],
          get = getValue,
          set = setValue,
          passValue = 'worldEnemyPet',
          order = 9,
        },
        creationname = 
        {
          type = 'boolean',
          name = L["Creation names"],
          desc = L["Display names of creations"],
          get = getValue,
          set = setValue,
          passValue = 'worldCreation',
          order = 10,
        },
        enemycreationname = 
        {
          type = 'boolean',
          name = L["Enemy creation names"],
          desc = L["Display names of enemy creations"],
          get = getValue,
          set = setValue,
          passValue = 'worldEnemyCreation',
          order = 11,
        },
        companionname = 
        {
          type = 'boolean',
          name = L["Companion names"],
          desc = L["Display names of companionss"],
          get = getValue,
          set = setValue,
          passValue = 'worldCompanion',
          order = 12,
        },
        threshold = 
        {
          type = 'number',
          name = L["Party size threshold"],
          desc = L["Set the size of party at which the chosen settings take effect"],
          get = getValueThresh,
          set = setValue,
          min = 0,
          max = 40,
          step = 1,
          bigStep = 5,
          passValue = 'worldThreshold',
          order = 14,
        },
        hat = 
        {
          type = 'boolean',
          name = L["Show Hat"],
          desc = L["Show your hat"],
          get = getValue,
          set = setValue,
          passValue = 'worldHat',
          order = 15,
        },
      }
    }, -- world
    city = 
    {
      type = 'group',
      name = L["City"],
      desc = L["Settings for in cities"],
      order = 5,
      args = 
      {
        playername = 
        {
          type = 'boolean',
          name = L["Player names"],
          desc = L["Display player names"],
          get = getValue,
          set = setValue,
          passValue = 'cityFriendlyPlayer',
          order = 1,
        },
        enemyplayername = 
        {
          type = 'boolean',
          name = L["Enemy player names"],
          desc = L["Display enemy player names"],
          get = getValue,
          set = setValue,
          passValue = 'cityEnemyPlayer',
          order = 2,
        },
        pvp = 
        {
          type = 'boolean',
          name = L["PvP titles"],
          desc = L["Display PvP titles on players"],
          get = getValue,
          set = setValue,
          passValue = 'cityPvp',
          order = 3,
        },
        guildname = 
        {
          type = 'boolean',
          name = L["Guild names"],
          desc = L["Display guild names under players' names"],
          get = getValue,
          set = setValue,
          passValue = 'cityGuild',
          order = 5,
        },
        npcname = 
        {
          type = 'boolean',
          name = L["NPC names"],
          desc = L["Display names of NPCs"],
          get = getValue,
          set = setValue,
          passValue = 'cityNPC',
          order = 7,
        },
        petname = 
        {
          type = 'boolean',
          name = L["Pet names"],
          desc = L["Display names of pets"],
          get = getValue,
          set = setValue,
          passValue = 'cityFriendlyPet',
          order = 8,
        },
        enemypetname = 
        {
          type = 'boolean',
          name = L["Enemy pet names"],
          desc = L["Display names of enemy pets"],
          get = getValue,
          set = setValue,
          passValue = 'cityEnemyPet',
          order = 9,
        },
        creationname = 
        {
          type = 'boolean',
          name = L["Creation names"],
          desc = L["Display names of creations"],
          get = getValue,
          set = setValue,
          passValue = 'cityCreation',
          order = 10,
        },
        enemycreationname = 
        {
          type = 'boolean',
          name = L["Enemy creation names"],
          desc = L["Display names of enemy creations"],
          get = getValue,
          set = setValue,
          passValue = 'cityEnemyCreation',
          order = 11,
        },
        companionname = 
        {
          type = 'boolean',
          name = L["Companion names"],
          desc = L["Display names of companionss"],
          get = getValue,
          set = setValue,
          passValue = 'cityCompanion',
          order = 12,
        },
        hat = 
        {
          type = 'boolean',
          name = L["Show Hat"],
          desc = L["Show your hat"],
          get = getValue,
          set = setValue,
          passValue = 'cityHat',
          order = 15,
        },
      }
    }, -- city
    instance = 
    {
      type = 'group',
      name = L["Instance"],
      desc = "Settings for in instances",
      order = 7,
      args = 
      {
        playername = 
        {
          type = 'boolean',
          name = L["Player names"],
          desc = L["Display player names"],
          get = getValue,
          set = setValue,
          passValue = 'instanceFriendlyPlayer',
          order = 1,
        },
        enemyplayername = 
        {
          type = 'boolean',
          name = L["Enemy player names"],
          desc = L["Display enemy player names"],
          get = getValue,
          set = setValue,
          passValue = 'instanceEnemyPlayer',
          order = 2,
        },
        pvp = 
        {
          type = 'boolean',
          name = L["PvP titles"],
          desc = L["Display PvP titles on players"],
          get = getValue,
          set = setValue,
          passValue = 'instancePvp',
          order = 3,
        },
        guildname = 
        {
          type = 'boolean',
          name = L["Guild names"],
          desc = L["Display guild names under players' names"],
          get = getValue,
          set = setValue,
          passValue = 'instanceGuild',
          order = 5,
        },
        npcname = 
        {
          type = 'boolean',
          name = L["NPC names"],
          desc = L["Display names of NPCs"],
          get = getValue,
          set = setValue,
          passValue = 'instanceNPC',
          order = 7,
        },
        petname = 
        {
          type = 'boolean',
          name = L["Pet names"],
          desc = L["Display names of pets"],
          get = getValue,
          set = setValue,
          passValue = 'instanceFriendlyPet',
          order = 8,
        },
        enemypetname = 
        {
          type = 'boolean',
          name = L["Enemy pet names"],
          desc = L["Display names of enemy pets"],
          get = getValue,
          set = setValue,
          passValue = 'instanceEnemyPet',
          order = 9,
        },
        creationname = 
        {
          type = 'boolean',
          name = L["Creation names"],
          desc = L["Display names of creations"],
          get = getValue,
          set = setValue,
          passValue = 'instanceCreation',
          order = 10,
        },
        enemycreationname = 
        {
          type = 'boolean',
          name = L["Enemy creation names"],
          desc = L["Display names of enemy creations"],
          get = getValue,
          set = setValue,
          passValue = 'instanceEnemyCreation',
          order = 11,
        },
        companionname = 
        {
          type = 'boolean',
          name = L["Companion names"],
          desc = L["Display names of companionss"],
          get = getValue,
          set = setValue,
          passValue = 'instanceCompanion',
          order = 12,
        },
        threshold = 
        {
          type = 'number',
          name = L["Party size threshold"],
          desc = L["Set the size of party at which the chosen settings take effect"],
          get = getValueThresh,
          set = setValue,
          min = 0,
          max = 40,
          step = 1,
          bigStep = 5,
          passValue = 'instanceThreshold',
          order = 14,
        },
        hat = 
        {
          type = 'boolean',
          name = L["Show Hat"],
          desc = L["Show your hat"],
          get = getValue,
          set = setValue,
          passValue = 'instanceHat',
          order = 15,
        },
      }
    }, -- instance
    bg = 
    {
      type = 'group',
      name = L["Battleground"],
      desc = L["Settings for in battlegrounds"],
      order = 9,
      args = 
      {
        playername = 
        {
          type = 'boolean',
          name = L["Player names"],
          desc = L["Display player names"],
          get = getValue,
          set = setValue,
          passValue = 'bgFriendlyPlayer',
          order = 1,
        },
        enemyplayername = 
        {
          type = 'boolean',
          name = L["Enemy player names"],
          desc = L["Display enemy player names"],
          get = getValue,
          set = setValue,
          passValue = 'bgEnemyPlayer',
          order = 2,
        },
        pvp = 
        {
          type = 'boolean',
          name = L["PvP titles"],
          desc = L["Display PvP titles on players"],
          get = getValue,
          set = setValue,
          passValue = 'bgPvp',
          order = 3,
        },
        guildname = 
        {
          type = 'boolean',
          name = L["Guild names"],
          desc = L["Display guild names under players' names"],
          get = getValue,
          set = setValue,
          passValue = 'bgGuild',
          order = 5,
        },
        npcname = 
        {
          type = 'boolean',
          name = L["NPC names"],
          desc = L["Display names of NPCs"],
          get = getValue,
          set = setValue,
          passValue = 'bgNPC',
          order = 7,
        },
        petname = 
        {
          type = 'boolean',
          name = L["Pet names"],
          desc = L["Display names of pets"],
          get = getValue,
          set = setValue,
          passValue = 'bgFriendlyPet',
          order = 8,
        },
        enemypetname = 
        {
          type = 'boolean',
          name = L["Enemy pet names"],
          desc = L["Display names of enemy pets"],
          get = getValue,
          set = setValue,
          passValue = 'bgEnemyPet',
          order = 9,
        },
        creationname = 
        {
          type = 'boolean',
          name = L["Creation names"],
          desc = L["Display names of creations"],
          get = getValue,
          set = setValue,
          passValue = 'bgCreation',
          order = 10,
        },
        enemycreationname = 
        {
          type = 'boolean',
          name = L["Enemy creation names"],
          desc = L["Display names of enemy creations"],
          get = getValue,
          set = setValue,
          passValue = 'bgEnemyCreation',
          order = 11,
        },
        companionname = 
        {
          type = 'boolean',
          name = L["Companion names"],
          desc = L["Display names of companionss"],
          get = getValue,
          set = setValue,
          passValue = 'bgCompanion',
          order = 12,
        },
        threshold = 
        {
          type = 'number',
          name = L["Party size threshold"],
          desc = L["Set the size of party at which the chosen settings take effect"],
          get = getValueThresh,
          set = setValue,
          min = 0,
          max = 40,
          step = 1,
          bigStep = 5,
          passValue = 'bgThreshold',
          order = 14,
        },
        hat = 
        {
          type = 'boolean',
          name = L["Show Hat"],
          desc = L["Show your hat"],
          get = getValue,
          set = setValue,
          passValue = 'bgHat',
          order = 15,
        },
      }
    }, -- bg
  } -- args
} -- options
