-- Titan Panel support

Titan_Skills_list = {};
local Skills_ID = "Skills";
local Skills_Name = "Titan Skills";
local Skills_Version = "1.0.5";

function Titan_Skills_OnLoad()
	if not TitanPanelButton_UpdateButton then
	return;
	end

	this.registry = {
		id = Skills_ID,
		menuText = Skills_Name,
		version = Skills_Version,
		category = "Information",
		buttonTextFunction = "TitanPanelSkillsButton_GetButtonText", 
		icon = "Interface\\Icons\\Ability_Parry",
		iconWidth = 16,
		tooltipTitle = Skills_Name,
		tooltipTextFunction = "TitanPanelSkillsButton_GetTooltipText",
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			UseColor = 1,
		}
	};
end

function Titan_Skills_OnClick(button)
	if ( button == "LeftButton" ) then
	end
end

function Titan_Skills_OnEvent()
	TitanPanelSkillsButton_GetTooltipText();
	TitanPanelButton_UpdateButton(Skills_ID);
end

function TitanPanelSkillsButton_GetButtonText()
	return Skills_Name;
end

function TitanSkills_GetColor(min,max)
	local level = UnitLevel("player");
	local color = HIGHLIGHT_FONT_COLOR_CODE;
	local lvlskill = (5*level);

	if (TitanGetVar(Skills_ID, "UseColor") == nil) then
		return color;
	end

	if (min == max) then
		return "|cff8080FF";
	end

	if (TitanGetVar(Skills_ID, "ColorToLevel") == 1) then
		max = lvlskill;
	end

	local percent = min/max;

	if percent >= 0.666666666 then
		color = GREEN_FONT_COLOR_CODE;
	elseif percent >= 0.333333333 then
		color = "|cffffff00";
	elseif (min == 1) then
		color = GRAY_FONT_COLOR_CODE;
	else
		color = RED_FONT_COLOR_CODE;
	end

	return color;
end

function TitanPanelSkillsButton_GetTooltipText()
	Titan_Skills_GenerateList();

	local result = " \n";
	local a = Titan_Skills_list;

	for group,gv in pairs(a) do
		result = result..TitanUtils_GetNormalText(group).."\n";
		for skill,sv in pairs(a[group]) do
			if a[group][skill]["maxrank"] >= 5 then
				result = result.."    "..Titan_Skills_GetSkill(skill).."\n";
			end
		end
	end

	return result;

end

function Titan_Skills_GetSkill(skillname)
	local a = Titan_Skills_list;
	for group,v in pairs(a) do
		for skill,v in pairs(a[group]) do
			if (skill == skillname) then
				local mod ="";
				if a[group][skill]["modifier"] > 0 then
					mod = TitanUtils_GetGreenText("+"..a[group][skill]["modifier"]);
				end
				result = TitanSkills_GetColor(a[group][skill]["rank"],a[group][skill]["maxrank"])..skill.." ("..a[group][skill]["rank"]..mod.."/"..a[group][skill]["maxrank"]..")"..FONT_COLOR_CODE_CLOSE;
				return result;
			end
		end
	end
end

function Titan_Skills_GenerateList()
	Titan_Skills_list = {};
	local Current_Header;
	local hasClassSkills;

	-- Pre-scan for Class Skills
	for i=1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, numTempPoints, skillModifier, skillMaxRank, _, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);

		if (isHeader~=nil) then
			Current_Header = skillName;
		end

		if (Current_Header == "Class Skills") then
			if (skillMaxRank > 1) then
				hasClassSkills = 1;
			end
		end
	end

	-- Main Scan
	Current_Header = nil;

	for i=1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, numTempPoints, skillModifier, skillMaxRank, _, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);

		if (isHeader~=nil) then
			Current_Header = skillName;
			if ((Current_Header == "Class Skills") and (hasClassSkills ~= nil)) or (Current_Header ~= "Class Skills" and Current_Header ~= "Armor Proficiencies" and Current_Header ~= "Languages") then
				if not (Titan_Skills_list[Current_Header]) then
					Titan_Skills_list[Current_Header] = {};
				end
			end
		elseif (isHeader == nil) then
			if ((Current_Header == "Class Skills") and (hasClassSkills ~= nil)) or (Current_Header ~= "Class Skills" and Current_Header ~= "Armor Proficiencies" and Current_Header ~= "Languages") then
				Titan_Skills_list[Current_Header][skillName] = {
					["rank"] = skillRank,
					["numtemp"] = numTempPoints,
					["modifier"] = skillModifier,
					["maxrank"] =  skillMaxRank,
					["desc"] = skillDescription,
				}
			end
		end
	end
end

function Titan_SKills_OnShow()
	local hasTimer = TitanPanel:HasTimer("TitanPanel"..Skills_ID);
	if hasTimer then
		--do nothing
	else
		TitanPanel:AddRepeatingTimer("TitanPanel"..Skills_ID, 1, TitanPanelPluginHandle_OnUpdate, Skills_ID, TITAN_PANEL_UPDATE_TOOLTIP)
	end
end

function Titan_SKills_OnHide()
	local hasTimer = TitanPanel:HasTimer("TitanPanel"..Skills_ID);
	if hasTimer then
		TitanPanel:RemoveTimer("TitanPanel"..Skills_ID);
	end
end

function TitanPanelRightClickMenu_PrepareSkillsMenu()
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[Skills_ID].menuText.." "..Skills_Version);

	TitanPanelRightClickMenu_AddSpacer();

	-- Toggle for Coloring the Skills
	info = {};
	info.text = "Color the Skills";
	info.func = TitanSkills_UseColor;
	info.checked = TitanGetVar(Skills_ID, "UseColor");
	info.keepShownOnClick = 1;
	UIDropDownMenu_AddButton(info);

	-- Toggle for Coloring according to your level
	info = {};
	info.text = "Color According to Level";
	info.func = TitanSkills_ColorToLevel;
	info.checked = TitanGetVar(Skills_ID, "ColorToLevel");
	info.keepShownOnClick = 1;
	UIDropDownMenu_AddButton(info);

	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddToggleIcon(Skills_ID);
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, Skills_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end

function TitanSkills_UseColor()
	TitanToggleVar(Skills_ID, "UseColor");
	TitanPanelButton_UpdateButton(Skills_ID);
	
end

function TitanSkills_ColorToLevel()
	TitanToggleVar(Skills_ID, "ColorToLevel");
	TitanPanelButton_UpdateButton(Skills_ID);
end