------------------------------------------------------------------------------------------------------------------------
-- Titan Rider Autocam - an addon by Everglow
------------------------------------------------------------------------------------------------------------------------

local TRAC_Ver="2.401"
local TRAC_Tag="|c00FF66FFTitan Rider Auto Cam "..TRAC_Ver.."|r: "

TR_UseAutoCam = TR_UseAutoCam or false

function TitanRiderAutoCam_OnLoad()
	DEFAULT_CHAT_FRAME:AddMessage(TRAC_Tag.."loaded")
end

local ORIG_OnClick = TitanPanelRiderButton_OnClick;
function TitanPanelRiderButton_OnClick(button)
	ORIG_OnClick();
	if ( button == "LeftButton" ) then
		if IsControlKeyDown() then
			TitanRiderAutoCam_Frame:Show()
		else
			if TR_UseAutoCam then
				TR_UseAutoCam = false
				DEFAULT_CHAT_FRAME:AddMessage(TRAC_Tag.."Rider Cam disabled")
			else
				TR_UseAutoCam = true
				DEFAULT_CHAT_FRAME:AddMessage(TRAC_Tag.."Rider Cam enabled")
			end
		end
	elseif ( button == "RightButton" ) then
		TitanPanelRightClickMenu_Toggle()
	end
end

function TitanPanelRiderButton_GetTooltipText()
    local retstr = "";
	local TRACstate = "";
	if TR_UseAutoCam == true then
		TRACstate = "Enabled"
	else
		TRACstate = "Disabled"
	end
	retstr = 
		TitanUtils_GetGreenText("RightClick: |rRider menu").."\n"..
		TitanUtils_GetGreenText("LeftClick: |rToggle AutoCam").."\n"..
		TitanUtils_GetGreenText("CTRL-LeftClick: |rSet AutoCam views").."\n\n"..
		TitanUtils_GetGreenText("Rider AutoCam: |r")..TRACstate.."\n"..
		TitanUtils_GetGreenText("Currently: |r")..TITAN_RIDER_STATES[TitanGetVar(TITAN_RIDER_ID,"PlayerState")];
	return retstr;
end

local ORIG_SwitchGear = TitanRider_SwitchGear;
function TitanRider_SwitchGear()
	ORIG_SwitchGear()
	if (TITAN_RIDER_IS_MOUNTED) then
		if (TR_UseAutoCam) then
			SetView(3)
		end
	else
		if (TR_UseAutoCam) then
			if (UnitAffectingCombat("player") and CombatCamFrame) then -- supports CombatCam Addon
				SetView(4)
			else
				SetView(2)
			end
		end
     end               
end