TITAN_PROFESSIONS_ID =  "Professions"
TITAN_PROFESSIONS_VERSION = "1.0.2"

local L = AceLibrary("AceLocale-2.2"):new("TitanProfessions")

TitanProfessions = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0")

-- Arrays containing all professions available in WoW
local mainprof = {L["Alchemy"], L["Blacksmithing"], L["Enchanting"], L["Engineering"], L["Jewelcrafting"], L["Leatherworking"], L["Mining"], L["Tailoring"] }
local secprof = { L["Cooking"], L["First Aid"], L["Poisons"] }
local gathering = { L["Fishing"], L["Herbalism"], L["Skinning"] }

-- Arrays containing professions known by the character and their skill levels
local mainprof_user = {}
local mainprof_userskill = {}
local secprof_user = {}
local secprof_userskill = {}
local gathering_user = {}
local gathering_userskill = {}

local menuFrame
local init = true

function TitanPanelProfessionsButton_OnLoad()
	local mainProfTitle, secProfTitle, skillLevel, font, i, j, y, button

	this.registry = { 
		id = TITAN_PROFESSIONS_ID,
		version = TITAN_PROFESSIONS_VERSION,
		menuText = "Titan Professions", 
		buttonTextFunction = "TitanPanelProfessionsButton_GetButtonText",
		tooltipTitle = L["Overview"], 
		tooltipTextFunction = "TitanPanelProfessionsButton_GetTooltipText",
		icon = "Interface\\Addons\\TitanProfessions\\icon",	
		iconWidth = 16,
		category = "Profession",
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredText = 1,
		}
	}
	menuFrame = CreateFrame("Frame", "TitanPanelProfessionsControlFrame", UIParent)
	menuFrame:SetFrameStrata("DIALOG")
	menuFrame:SetWidth(256)
	menuFrame:SetHeight(250)
	menuFrame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
                                            edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
                                            tile = true, tileSize = 16, edgeSize = 16, 
                                            insets = { left = 4, right = 4, top = 4, bottom = 4 }});
	menuFrame:SetBackdropColor(0,0,0,1)
	
	TitanProfessions:RegisterEvent("CHAT_MSG_SKILL")
end

function TitanProfessions:CHAT_MSG_SKILL()
		self:Update()
end


function TitanPanelProfessionsIconButton_OnLoad()
	local mainProfTitle, secProfTitle, skillLevel, font, i, j, y, button

	this.registry = { 
		id = TITAN_PROFESSIONS_ID .. "Icon",
		version = TITAN_PROFESSIONS_VERSION,
		menuText = "Titan Professions (Icon)", 
		buttonTextFunction = "TitanPanelProfessionsButton_GetButtonText",
		tooltipTitle = L["Overview"], 
		tooltipTextFunction = "TitanPanelProfessionsButton_GetTooltipText",
		icon = "Interface\\Addons\\TitanProfessions\\icon",	
		iconWidth = 16,
		category = "Profession",
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredText = 1,
		}
	}
end

function TitanProfessions:Init()
	local key, value
	local skillIndex
	local skillName, isHeader, skillRank
	local i, j, k, y
	
	mainprof_user = {}
	mainprof_userskill = {}
	secprof_user = {}
	secprof_userskill = {}
	gathering_user = {}
	gathering_userskill = {}

	TitanPanelProfessionsIconControlFrame = TitanPanelProfessionsControlFrame
	-- Fill character profession arrays. 
	for skillIndex = 1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, _, _, _, _, _, _, _, _, _ = GetSkillLineInfo(skillIndex)
		if isHeader == nil then
			for key,value in pairs(mainprof) do  
				if value == skillName then
					if value == L["Mining"] then
						value = L["Smelting"]
					end
					table.insert(mainprof_user, value)
					table.insert(mainprof_userskill, skillRank)
				end
			end
			for key,value in pairs(secprof) do  
				if value == skillName then
					table.insert(secprof_user, value)
					table.insert(secprof_userskill, skillRank)
				end
			end
			for key,value in pairs(gathering) do
				if value == skillName then
					table.insert(gathering_user, value)
					table.insert(gathering_userskill, skillRank)
				end
			end
		end
	end

	mainProfTitle = menuFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal") 
	mainProfTitle:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 14, -14)
	font, _ = mainProfTitle:GetFont()
	mainProfTitle:SetFont(font, 12)
	mainProfTitle:SetText(L["Main Professions"])
	
	i = 0
	y = 12
	for key, value in pairs(mainprof_user) do 
		button = CreateFrame("Button", "TitanPanelProfessionsItemButton" .. i, menuFrame)
		y = y + 18
		button:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 20, -y)	
		button:SetFont(font, 12)
		button:SetText(value)
		button:SetHeight(18)
		button:SetWidth(button:GetFontString():GetStringWidth())
		button:SetScript("OnClick", function() TitanPanelProfessionsItemButton_OnClick(value) end)
		skillLevel = menuFrame:CreateFontString("FontStringMain" .. i, "ARTWORK", "GameFontNormal") 
		skillLevel:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 220, -y)
		skillLevel:SetFont(font, 12)
		skillLevel:SetText(mainprof_userskill[key])
		skillLevel:SetTextColor(1.0, 1.0, 1.0)
		i = i + 1
	end
	
	y = y + 30
	secProfTitle = menuFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal") 
	secProfTitle:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 14, -y)
	font, _ = secProfTitle:GetFont()
	secProfTitle:SetFont(font, 12)
	secProfTitle:SetText(L["Secondary Professions"])
	j = 0
	for key, value in pairs(secprof_user) do 
		button = CreateFrame("Button", "TitanPanelProfessionsItemButton" .. i + j, menuFrame)
		y = y + 18
		button:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 20, -y)
		button:SetText(value)
		button:SetFont(font, 12)
		button:SetHeight(18)
		button:SetWidth(button:GetFontString():GetStringWidth())
		button:SetScript("OnClick", function() TitanPanelProfessionsItemButton_OnClick(value) end)
		skillLevel = menuFrame:CreateFontString("FontStringSec" .. j, "ARTWORK", "GameFontNormal") 
		skillLevel:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 220, -y)
		skillLevel:SetFont(font, 12)
		skillLevel:SetText(secprof_userskill[key])
		skillLevel:SetTextColor(1.0, 1.0, 1.0)
		j = j + 1
	end
	
	y = y + 30
	gatheringTitle = menuFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal") 
	gatheringTitle:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 14, -y)
	font, _ = gatheringTitle:GetFont()
	gatheringTitle:SetFont(font, 12)
	gatheringTitle:SetText(L["Gathering"])
	k = 0
	for key, value in pairs(gathering_user) do 
		button = CreateFrame("Button", "TitanPanelProfessionsItemButton" .. i + j + k, menuFrame)
		y = y + 18
		button:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 20, -y)
		button:SetText(value)
		button:SetFont(font, 12)
		button:SetHeight(18)
		button:SetWidth(button:GetFontString():GetStringWidth())
		button:SetScript("OnClick", function() TitanPanelProfessionsItemButtonGathering_OnClick(value) end)
		skillLevel = menuFrame:CreateFontString("FontStringGath" .. k, "ARTWORK", "GameFontNormal") 
		skillLevel:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 220, -y)
		skillLevel:SetFont(font, 12)
		skillLevel:SetText(gathering_userskill[key])
		skillLevel:SetTextColor(1.0, 1.0, 1.0)
		k = k + 1
	end
	
	if (IsAddOnLoaded("ProfessionsBook") == 1) then
		button = CreateFrame("Button", "TitanPanelProfessionsItemButton" .. i + j, menuFrame)
		button:SetPoint("TOPLEFT", menuFrame, "TOPLEFT", 20, -y - 46)
		button:SetText(L["Open ProfessionsBook"])
		button:SetFont(font, 12)
		button:SetHeight(18)
		button:SetWidth(button:GetFontString():GetStringWidth())
		button:SetScript("OnClick", function() TitanPanelProfessionsItemButton_OnClick(L["Open ProfessionsBook"]) end)
	end
end

function TitanProfessions:Update()
	local key, value
	local skillIndex
	local skillName, isHeader, skillRank
	local i, j, k, y
	
	mainprof_user = {}
	mainprof_userskill = {}
	secprof_user = {}
	secprof_userskill = {}
	gathering_user = {}
	gathering_userskill = {}
	
	-- Fill character profession arrays. 
	for skillIndex = 1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, _, _, _, _, _, _, _, _, _ = GetSkillLineInfo(skillIndex)
		if isHeader == nil then
			for key,value in pairs(mainprof) do  
				if value == skillName then
					if value == L["Mining"] then
						value = L["Smelting"]
					end
					table.insert(mainprof_user, value)
					table.insert(mainprof_userskill, skillRank)
				end
			end
			for key,value in pairs(secprof) do  
				if value == skillName then
					table.insert(secprof_user, value)
					table.insert(secprof_userskill, skillRank)
				end
			end
			for key,value in pairs(gathering) do
				if value == skillName then
					table.insert(gathering_user, value)
					table.insert(gathering_userskill, skillRank)
				end
			end
		end
	end
	i = 0
	for key, value in pairs(mainprof_user) do 
		skillLevel = getglobal("FontStringMain" .. i) 
		skillLevel:SetText(mainprof_userskill[key])
		i = i + 1
	end
	j = 0
	for key, value in pairs(secprof_user) do 
		skillLevel = getglobal("FontStringSec" .. j) 
		skillLevel:SetText(secprof_userskill[key])
		j = j + 1
	end
	k = 0
	for key, value in pairs(gathering_user) do 
		skillLevel = getglobal("FontStringGath" .. k) 
		skillLevel:SetText(gathering_userskill[key])
		k = k + 1
	end
end

function TitanPanelProfessions_OnShow()
	local hasTimer = TitanPanel:HasTimer("TitanPanel"..TITAN_PROFESSIONS_ID)
    if (hasTimer == false) then
		TitanPanel:AddRepeatingTimer("TitanPanel"..TITAN_PROFESSIONS_ID, 1, TitanPanelProfessions_CheckSkills, nil, nil)
    end
end

function MyAddon_OnHide()
   local hasTimer = TitanPanel:HasTimer("TitanPanel"..TITAN_PROFESSIONS_ID)
     if (hasTimer) then
       TitanPanel:RemoveTimer("TitanPanel"..TITAN_PROFESSIONS_ID)
     end
end

function TitanPanelProfessions_CheckSkills()
	-- It takes some thime until the skills have been initialized. So we check every second if the data is available.
	if GetNumSkillLines() > 0 then
		TitanPanel:RemoveTimer("TitanPanel"..TITAN_PROFESSIONS_ID)
		TitanProfessions:Init()
	end
end

function TitanPanelProfessionsButton_GetButtonText()
  return L["Professions"]
end

function TitanPanelProfessionsButton_GetTooltipText()
	return TitanUtils_GetGreenText(L["Hint: left click to open menu"])
end

function TitanPanelRightClickMenu_PrepareProfessionsMenu()
  TitanPanelRightClickMenu_AddTitle(TitanPlugins["Professions"].menuText)
  TitanPanelRightClickMenu_AddToggleIcon("Professions")
  TitanPanelRightClickMenu_AddSpacer()
  TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, "Professions", TITAN_PANEL_MENU_FUNC_HIDE)
end

function TitanPanelProfessionsItemButton_OnClick(value)
	TitanPanelProfessionsButton:Click()
	if value == L["Open ProfessionsBook"] then
		ProfessionsBook:ShowFrame()
	else
		if value ~= L["Alchemy"] then
			CastSpellByName(value)
		else
			CastSpell(1, "spell")
		end
	end
end

function TitanPanelProfessionsItemButtonGathering_OnClick(value)
	-- Nothing to do here yet.
end

