--------------------------------------------------------------------------------------------------
-- Titan [BeadTracker] Deluxe V1.01
-- Author: Tabethial of Silver Hand - based on Titan[BlacksmithingTracker] thanks for the nice start
--------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------
-- Some vars for color and some for saving settings/player
--------------------------------------------------------------------------------------------------

--TITAN_PTBTRACKER_RED = 20; --It's a complete stack !

--------------------------------------------------------------------------------------------------
-- Global Variables (do not change)
--------------------------------------------------------------------------------------------------
-- Names
TITAN_PTBTRACKER_ID =  "BeadTracker";

TITAN_PTBTRACKER_BUTTON_TEXT = "%s";

-- Text colors
TEXT_COLOR_WHITE = "|cffffffff";
TEXT_COLOR_GOLD = "|cffCEA208";
TEXT_COLOR_RED = "|cffff0000";
TEXT_COLOR_GREEN = "|cff00ff00";

BEADS = "item:25433";  -- Obsidian Warbeads

-- Others
bank_opened = false;	-- Checks if the bank screen in open.
bank_updating = false; 	-- Checks if the bank items are being updated (to avoid count problems)
mail_updating = false;	-- Checks if the mail items are being updated (to avoid count problems)

-- colors
BT = {};
BT.Color = {};
BT.Color["red"] = { r = 1.0, g = 0.0, b = 0.0 }
BT.Color["green"] = { r = 0.0, g = 1.0, b = 0.0 }
BT.Color["blue"] = { r = 0.0, g = 0.0, b = 1.0 }
BT.Color["rug"] = { r = 0.6, g = 0.6, b = 0.6 }
BT.Color["thi"] = { r = 0.7, g = 0.7, b = 0.7 }
BT.Color["hvy"] = { r = 0.8, g = 0.8, b = 0.8 }
BT.Color["med"] = { r = 0.9, g = 0.9, b = 0.9 }
BT.Color["lit"] = { r = 1.0, g = 1.0, b = 1.0 }
BT.Color["white"] = { r = 1.0, g = 1.0, b = 1.0 }
BT.Color["pink"] = { r = 1.0, g = 0.3, b = 0.3 }
BT.Color["magenta"] = { r = 1.0, g = 0.0, b = 1.0 }
BT.Color["yellow"] = { r = 1.0, g = 1.0, b = 0.0 }
BT.Color["cyan"] = { r = 0.0, g = 1.0, b = 1.0 }
BT.Color["gray"] = { r = 0.7, g = 0.7, b = 0.7 }
BT.Color["black"] = { r = 0.5, g = 0.5, b = 0.5 }

BT.Color["gold"] = { r = 1.0, g = 0.6, b = 0.0 }
BT.Color["pink"] = { r = 1.0, g = 0.3, b = 0.3 }


--------------------------------------------------------------------------------------------------
-- OnLoad Functions
--------------------------------------------------------------------------------------------------
function PBT_OnLoad()

--	TITAN_PTBTRACKER_BUTTON_ICON = "Interface\\Icons\\Trade_BrewPoison";
	TITAN_PTBTRACKER_BUTTON_ICON = "Interface\\Icons\\INV_Jewelry_Necklace_19";
	this.registry = { 
		
		id 									= TITAN_PTBTRACKER_ID,
		menuText 						= TITAN_PTBTRACKER_ID, 
		buttonTextFunction 	= "TitanPanelBeadTracker_GetButtonText", 
		tooltipTitle 				= TITAN_PTBTRACKER_ID.." "..TITAN_PTBTRACKER_VERSION,
		category 						= "Information",
		tooltipTextFunction = "PBT_getToolTip", 
		icon 								= TITAN_PTBTRACKER_BUTTON_ICON,
		iconWidth 					= 16,
		
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredButton = TITAN_NIL,

		},
	};
	
	--BT_Msg("Titan [BeadTracker]".. TITAN_PTBTRACKER_VERSION.." : Database loaded!"); 
	BeadTracker_DBInit();
	BeadTracker_RegisterEvents(); -- register Events to update the Buttons
end	
--------------------------------------------------------------------------------------------------
-- Register & Unregister Event functions.
--------------------------------------------------------------------------------------------------
-- RegisterEvent
function BeadTracker_RegisterEvents()	
	
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("SPELLCAST_STOP");
	this:RegisterEvent("MERCHANT_SHOW");
	this:RegisterEvent("MERCHANT_CLOSED");
	this:RegisterEvent("MAIL_CLOSED");
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("BANKFRAME_CLOSED");
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	this:RegisterEvent("ITEM_PUSH"); -- Fired when an item is pushed onto the "inventory-stack". For instance when you manufacture something with your trade skills or picks something up.
	this:RegisterEvent("BANKFRAME_OPENED");
	this:RegisterEvent("PLAYERBANKSLOTS_CHANGED");
end
-- UnregisterEvent
function BeadTracker_UnregisterEvents()
	this:UnregisterEvent("PLAYER_ENTERING_WORLD");
	this:UnregisterEvent("VARIABLES_LOADED");
	this:UnregisterEvent("SPELLCAST_STOP");
	this:UnregisterEvent("MERCHANT_SHOW");
	this:UnregisterEvent("MERCHANT_CLOSED");
	this:UnregisterEvent("MAIL_CLOSED");
	this:UnregisterEvent("BAG_UPDATE");
	this:UnregisterEvent("BANKFRAME_CLOSED");
	this:UnregisterEvent("UNIT_INVENTORY_CHANGED");
	this:UnregisterEvent("ITEM_PUSH"); -- Fired when an item is pushed onto the "inventory-stack". For instance when you manufacture something with your trade skills or picks something up.
	this:UnregisterEvent("BANKFRAME_OPENED");
	this:UnregisterEvent("PLAYERBANKSLOTS_CHANGED");
end

--------------------------------------------------------------------------------------------------
-- OnEvent
--------------------------------------------------------------------------------------------------
function PBT_OnEvent(event)
--DEFAULT_CHAT_FRAME:AddMessage("PT:onEvent:2", 1.0, 0.22, 0);
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		if ( PTBTRACKER_SETTINGS == nil ) then
			PBT_Initialize();
		end

		if ( PTBTRACKER_SETTINGS["VERSION"] ~= TITAN_PTBTRACKER_VERSION ) then
			BT_Update(PTBTRACKER_SETTINGS["VERSION"]);
		end

		TitanPanelButton_UpdateTooltip();
		TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);

		return;
	end

	if (event == "VARIABLES_LOADED") then
		-- NOTE : UPDATE INVENTORY
		BT_Msg("|cffff0000"..TITAN_PTBTRACKER_ID.." "..TITAN_PTBTRACKER_NAME_VERSION.." "..TITAN_PTBTRACKER_VERSION.." "..TITAN_PTBTRACKER_LOADED..".");
		TitanPanelButton_UpdateTooltip();
		TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);
	end

	-- MAIL EVENTS
	if( event == "MAIL_SHOW" ) or ( event == "MAIL_CLOSED" ) or ( event == "MAIL_INBOX_UPDATE" ) then
	    BeadTracker_SaveMail();
	    BeadTracker_SaveInv();
	    TitanPanelButton_UpdateTooltip();
	    TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);
	end
	
	-- BANK EVENTS
	if( event == "BANKFRAME_OPENED" ) or ( event == "BANKFRAME_CLOSED" ) or ( event == "PLAYERBANKSLOTS_CHANGED" ) then
	    BeadTracker_SaveBank();
	    BeadTracker_SaveInv();
	    TitanPanelButton_UpdateTooltip();
	    TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);
	end
	
	-- INV EVENTS
	if( event == "ITEM_PUSH" ) or ( event == "UNIT_INVENTORY_CHANGED" ) or (event == "MERCHANT_SHOW" ) or (event == "BAG_UPDATE") or (event == "PLAYERBAGSLOTS_CHANGED")
	or( event == "MERCHANT_SHOW") or (event == "MERCHANT_CLOSED" )then
	    BeadTracker_SaveInv();
	    TitanPanelButton_UpdateTooltip();
	    TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);
	end
end
function BT_OnClick(button)
	if ( button == "LeftButton" and IsShiftKeyDown() ) then
	end
end
--------------------------------------------------------------------------------------------------
-- GetItemFrom functions!
--------------------------------------------------------------------------------------------------
-- * FromInventory
function BeadTracker_GetItemQuantityFromInv(arg1)
	--BT_Msg(arg1);
	local iItemCount = 0;
	
	for bag = 4, 0, -1 do
		local size = GetContainerNumSlots(bag);
		if (size > 0) then
			for slot=1, size, 1 do
				
				local itemIcon, itemQuantity = GetContainerItemInfo(bag, slot);
				
				if (itemQuantity) then
					local itemName = GetItemInfo(GetContainerItemLink(bag,slot));
					--BT_Msg(itemName);
					if ((itemName) and (itemName ~= "")) then
						--**
						local name = GetItemInfo(arg1)
						--if(itemName == arg1) then
						if(itemName == name) then
							iItemCount = iItemCount + itemQuantity;
						end
						--**

					end
				end
			end
		end
	end	
	return iItemCount;
end
-- * FromMail
function BeadTracker_GetItemQuantityFromMail(arg1)

   	local items = GetInboxNumItems();
   	local itemName, itemIcon, itemQuantity;
   	local iItemCount = 0;

	if(items > 0) then -- if your mailbox contains something
		for index = 1, items, 1 do --Loop trough the items.
			itemName, itemIcon, itemQuantity = GetInboxItem(index); -- Grab the info about item "index"
			--**
			local name  = GetItemInfo(arg1)
			--if(itemName == arg1)then
			if(itemName == name)then
				iItemCount = iItemCount + itemQuantity;
			end
			--**
		end
	end
	return iItemCount;
end
-- * FromBank
function BeadTracker_GetItemQuantityFromBank(arg1)
	local maxContainerItems;
	local containerItemNum;
	local bagNum;
	local link;
	local quantity;
	local icon;
	local itemName;

	local iItemCount=0;

	maxContainerItems = GetContainerNumSlots(BANK_CONTAINER);
	if ( maxContainerItems ) then
		for containerItemNum = 1, maxContainerItems do
			link = GetContainerItemLink(BANK_CONTAINER, containerItemNum);
			icon, quantity = GetContainerItemInfo(BANK_CONTAINER, containerItemNum);
			if( link ) then
				--LinkToName
				itemName = GetItemInfo(link);
				local name = GetItemInfo(arg1)
				--if(itemName == arg1) then
				if(itemName == name) then
					iItemCount = iItemCount + quantity;
				end
			end
		end
	end

	for bagNum = 5, 10 do
		maxContainerItems = GetContainerNumSlots(bagNum);
		if( maxContainerItems ) then
			local id = BankButtonIDToInvSlotID(bagNum, 1);
			link = GetInventoryItemLink("player", id);
			icon = GetInventoryItemTexture("player", id);
			for containerItemNum = 1, maxContainerItems do
				link = GetContainerItemLink(bagNum, containerItemNum);
				icon, quantity = GetContainerItemInfo(bagNum, containerItemNum);
				if( link ) then
					--LinkToName
					itemName = GetItemInfo(link);
					name = GetItemInfo(arg1)
					--if(itemName == arg1) then
					if (itemName == name) then
						iItemCount = iItemCount + quantity;
					end
				end
			end
		end
	end
	return iItemCount;
end


function BeadTracker_SaveInv()
	BeadTracker_SetVar("PTBTRACKER_INVENTORY_BEADS", 			BeadTracker_GetItemQuantityFromInv(BEADS));


	


end

function BeadTracker_SaveBank()
	BeadTracker_SetVar("PTBTRACKER_BANK_BEADS", 			BeadTracker_GetItemQuantityFromBank(BEADS));


end

function BeadTracker_SaveMail()
	BeadTracker_SetVar("PTBTRACKER_MAIL_BEADS", 			BeadTracker_GetItemQuantityFromBank(BEADS));

end


--------------------------------------------------------------------------------------------------
-- DATABASE + setvar/getvar FUNCTION
--------------------------------------------------------------------------------------------------
-- * DBInit()
function BeadTracker_DBInit()
	PTBTRACKER_COUNT = {};
	-- Ores
	PTBTRACKER_COUNT["PTBTRACKER_INVENTORY_BEADS"] = 0;

	
	PTBTRACKER_COUNT["PTBTRACKER_BANK_BEADS"] = 0;

	PTBTRACKER_COUNT["PTBTRACKER_MAIL_BEADS"] = 0;


-------------------------------- GLOBAL ITEMS ---------------------------------
	GPTBTRACKER_COUNT = {};
	GPTBTRACKER_COUNT["PTBTRACKER_INVENTORY_BEADS"] = 0;

	GPTBTRACKER_COUNT["PTBTRACKER_MAIL_BEADS"] = 0;

	GPTBTRACKER_COUNT["PTBTRACKER_BANK_BEADS"] = 0;
	

end

function GBeadTracker_GetVar(var)
	return GPTBTRACKER_COUNT[var];
end

function BeadTracker_SetVar(var, value)
	PTBTRACKER_COUNT[var] = value;
	--GPTBTRACKER_COUNT[var] = value;
end
-- * GETVAR
function BeadTracker_GetVar(var)
	return PTBTRACKER_COUNT[var];
end
--------------------------------------------------------------------------------------------------
-- BeadTracker functions - Initialize, Update & Reset
--------------------------------------------------------------------------------------------------
-- * Initialize
function PBT_Initialize()
--	BT_DEBUG("Initializing ...");
	PTBTRACKER_SETTINGS = {};
	PTBTRACKER_SETTINGS["VERSION"] = TITAN_PTBTRACKER_VERSION;
	PTBTRACKER_SETTINGS["COUNT"] = 0;
	BeadTracker_DBInit();
--  BT_DEBUG("Initializing done !");
end
-- * Update
function BT_Update(version)
	if ( version == nil or version == "UNKNOWN" ) then
		PBT_Initialize();
	else
		BT_Msg(TITAN_PTBTRACKER_SYS_NOUPDATE.." !");
		PTBTRACKER_SETTINGS["VERSION"] = TITAN_PTBTRACKER_VERSION;
		return;
	end
	BT_Msg(TITAN_PTBTRACKER_SYS_UPDATE.." !");
end

-- * Reset
function PBT_Reset()
	--BT_DEBUG("Resetting database ...");
	PBT_Initialize();
	--BT_DEBUG("Resetting done !");
end
--------------------------------------------------------------------------------------------------
-- Titan Panel Functions
--------------------------------------------------------------------------------------------------
function TitanPanelBeadTracker_GetButtonText(id)
TITAN_PTBTRACKER_BUTTON_LABEL		=	"";
	local buttonText;
	
	--buttonText = TitanUtils_GetColoredText(BeadTracker_GetVar("PTBTRACKER_INV_ORE_TRUESILVER"), BT.Color["black"]);
	buttonText = TitanUtils_GetColoredText(BeadTracker_GetVar("PTBTRACKER_INVENTORY_BEADS"), BT.Color["yellow"])
			
		
	return TITAN_PTBTRACKER_BUTTON_LABEL, buttonText;
end


--------------------------------------------------------------------------------------------------
-- Prepare the BeadTracker menu
--------------------------------------------------------------------------------------------------
function TitanPanelRightClickMenu_PrepareBeadTrackerMenu()
--	BT_DEBUG("Preparing "..TITAN_PTBTRACKER_ID.." menu ...");
	local id = TITAN_PTBTRACKER_ID;
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[id].menuText..TITAN_PTBTRACKER_VERSION);
	TitanPanelRightClickMenu_AddToggleIcon(id);
	TitanPanelRightClickMenu_AddToggleLabelText(id);
	TitanPanelRightClickMenu_AddSpacer();
    local info = {};
    
	info.text = TITAN_PTBTRACKER_MENU_RESET;
	info.func = PBT_Reset;
	UIDropDownMenu_AddButton(info);
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, id, TITAN_PANEL_MENU_FUNC_HIDE);
	
end
--------------------------------------------------------------------------------------------------
-- The tooltip text
--------------------------------------------------------------------------------------------------
function PBT_getToolTip()
	

	
	BeadTracker_SaveInv();
--	BeadTracker_SaveMail();
	
	text = "";
		

		local mote_earth_stack =0;
	
		
		mote_earth_stack = math.floor((BeadTracker_GetVar("PTBTRACKER_INVENTORY_BEADS") + BeadTracker_GetVar("PTBTRACKER_BANK_BEADS") + BeadTracker_GetVar("PTBTRACKER_MAIL_BEADS")));
		
	
		
		text= text..TITAN_PTBTRACKER_HEADER;
		
		--text=text..TitanUtils_GetHighlightText(PT_MOTES);	
			
	--	text= text.."\n"..TitanUtils_GetColoredText(PT_EARTH..":\t" .. mote_earth_stack, BT.Color["yellow"]);
	--text = text.."\nTotal Beads:"\t" .. mote_earth_stack;
		text= text.."\n"..TitanUtils_GetColoredText("Total Beads:\t" .. mote_earth_stack, BT.Color["yellow"]);
	
	return text;
end

--------------------------------------------------------------------------------------------------
-- Misc BeadTracker Functions
--------------------------------------------------------------------------------------------------
-- * Toggle colored button ( NOTE: NOT BEING USED)
function TitanPanelBeadTracker_ToggleColoredButton()
	TitanToggleVar(TITAN_PTBTRACKER_ID, "ShowColoredButton");
	TitanPanelButton_UpdateButton(TITAN_PTBTRACKER_ID);
end

function BT_Msg(msg)
	if ( msg == nil ) then
		msg = "------------------------------";
	end
	if ( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage(msg, 1.0, 0.82, 0);
	end
end

function BT_DEBUG(msg)
	if ( msg == nil or msg == false ) then
		msg = "nil";
	end
	if ( DEFAULT_CHAT_FRAME and TDC_DEBUG ) then
		DEFAULT_CHAT_FRAME:AddMessage(msg, 1.0, 0.22, 0);
	end
end

function BT_Round(num)
	if(num - math.floor(num) >= 0.5) then
		num = num + 0.5;
	end
	return math.floor(num);
end

function BT_COLOR(color, msg)
	if ( msg == nil ) then
		msg = color;
		color = TEXT_COLOR_GOLD;
	end
	return color..msg..FONT_COLOR_CODE_CLOSE;
end




