
-- idea based on lynstats, and adjusted and optimized a bit for my needs

-- addon frame
local addon = CreateFrame("Button", "TinyStats", UIParent)

-- locals
local color = RAID_CLASS_COLORS[select(2, UnitClass("player"))] -- default text color
local text -- text inside our frame
local update, slowupdate = 1, 60 -- update timer
local addonmem, totalmem = 0,0
local fps, lag, xp, rested

local textformat = "|c00ffffff%d|rfps |c00ffffff%d|rms |c00ffffff%.2f|r/|c00ffffff%.2f|rmb"
local textformat_exp = textformat.."\n|c00ffffff%d|rxp |c00ffffff%d|rrested" 

local playerLevel = UnitLevel("player")
local MAX_PLAYER_LEVEL = MAX_PLAYER_LEVEL -- local upvalue

-- frame functions
local function OnEvent(self, event, level) -- we only register for one event anyway
	playerLevel = level
end

local function OnUpdate(self, elapsed)
	update = update + elapsed
	slowupdate = slowupdate + elapsed
	if not InCombatLockdown() and slowupdate > 60 then -- I'll update after combat is over kthx
		slowupdate = 0
		totalmem= collectgarbage("count")
		addonmem = 0
		UpdateAddOnMemoryUsage()
		for i=1, GetNumAddOns(), 1 do
			addonmem = addonmem + GetAddOnMemoryUsage(i)
		end
		totalmem = totalmem / 1024
		addonmem = addonmem / 1024
	end
	if update > 1 then
		update = 0
		fps = floor(GetFramerate())
		lag = select(3, GetNetStats())
		if playerLevel < MAX_PLAYER_LEVEL then
			xp = UnitXPMax("player") - UnitXP("player")
			rested = GetXPExhaustion()
			text:SetFormattedText(textformat_exp, fps, lag, addonmem, totalmem, xp, rested)
		else
			text:SetFormattedText(textformat, fps, lag, addonmem, totalmem)
		end
		local width = text:GetStringWidth()/addon:GetEffectiveScale()
		local height = text:GetStringHeight()/addon:GetEffectiveScale()
		addon:SetWidth(width)
		addon:SetHeight(height)
	end
end

-- Fix our addon frame
text = addon:CreateFontString(nil, "OVERLAY")
text:SetFont("Fonts\\ARIALN.TTF", 14)
text:SetShadowOffset(.8,-.8)
text:SetShadowColor(0,0,0)
text:SetTextColor(color.r, color.g, color.b)
text:SetPoint("TOP", addon)
	
addon:SetScript("OnUpdate", OnUpdate)
addon:SetScript("OnEvent", OnEvent)

addon:SetHeight(20)

addon:SetPoint("TOP", Minimap, "BOTTOM", 0, -3) -- offset slightly from the minimap bottom

addon:RegisterEvent("PLAYER_LEVEL_UP")
