------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("TimeToDie")
local dewdrop = AceLibrary:HasInstance("Dewdrop-2.0") and AceLibrary("Dewdrop-2.0")
local SML = LibStub("LibSharedMedia-2.0")

local _G = _G
local UIParent = UIParent
local UnitIsFriend = _G.UnitIsFriend
local UnitHealth = _G.UnitHealth
local UnitIsPlayer = _G.UnitIsPlayer
local GetTime = _G.GetTime
local abs = _G.abs

local defaultFont = _G.GameFontNormal:GetFont()
local p, frame, texture, text
local events = {target = 'PLAYER_TARGET_CHANGED', focus = 'PLAYER_FOCUS_CHANGED'}

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["TimeToDie"] = true,
	["Estimated time until current target will die."] = true,
	["Locked"] = true,
	["Toggle frame locked."] = true,
	["Enemy only"] = true,
	["Use focus instead of target."] = true,
	["Only track enemy targets."] = true,
	["Target"] = true,
	["Focus"] = true,
	["Font"] = true,
	["Set font."] = true,
	["Font size"] = true,
	["Set font size."] = true,
	["Color"] = true,
	["Set font color."] = true,
	["Outline"] = true,
	["Set font outline."] = true,
	["None"] = true,
	["Normal"] = true,
	["Thick"] = true,
	["Strata"] = true,
	["Set frame strata."] = true,
	["High"] = true,
	["Medium"] = true,
	["Low"] = true,
	["Background"] = true,
	["Update period"] = true,
	["Set time between updates."] = true,
} end)
-- Russian localization by StingerSoft (Eritnull aka )
L:RegisterTranslations("ruRU", function() return {
	["TimeToDie"] = "TimeToDie",
	["Estimated time until current target will die."] = "       .",
	["Locked"] = "",
	["Toggle frame locked."] = "/ ",
	["Enemy only"] = " ",
	["Use focus instead of target."] = "   ",
	["Only track enemy targets."] = "   ",
	["Target"] = "",
	["Focus"] = "",
	["Font"] = "",
	["Set font."] = " ",
	["Font size"] = " ",
	["Set font size."] = "  ",
	["Color"] = "",
	["Set font color."] = "  ",
	["Outline"] = "",
	["Set font outline."] = "  ",
	["None"] = "",
	["Normal"] = "",
	["Thick"] = "",
	["Strata"] = "",
	["Set frame strata."] = "  ",
	["High"] = "",
	["Medium"] = "",
	["Low"] = "",
	["Background"] = "",
	["Update period"] = " ",
	["Set time between updates."] = "   ",
} end)

---------------------------------
--      Addon Declaration      --
---------------------------------

local TimeToDie = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
_G.TimeToDie = TimeToDie
TimeToDie.revision = tonumber(string.sub("$Revision", 12, -3))

---------------------------------
--      AceOptions Config      --
---------------------------------

local options = {
	name = L["TimeToDie"], type='group',
	desc = L["Estimated time until current target will die."],
	pass = true,
	get = "GetValue",
	set = "SetValue",
	args = {
		locked = {
			name = L["Locked"], type='toggle',
			desc = L["Toggle frame locked."],
			order = 100,
			disabled = '~IsActive',
		},
		enemy = {
			name = L["Enemy only"], type='toggle',
			desc = L["Only track enemy targets."],
			order = 105,
			disabled = '~IsActive',
		},
		focus = {
			name = L["Focus"], type='toggle',
			desc = L["Use focus instead of target."],
			set = "SetFocus",
			get = "GetFocus",
			order = 107,
			disabled = '~IsActive',
		},
		font = {
			name = L["Font"], type='text',
			desc = L["Set font."],
			validate = SML and SML:List('font') or {defaultFont},
			order = 110,
			disabled = '~IsActive',
		},
		size = {
			name = L["Font size"], type='range',
			desc = L["Set font size."],
			min = 4, max = 48, step = 1,
			order = 120,
			disabled = '~IsActive',
		},
		color = {
			name = L["Color"], type='color',
			desc = L["Set font color."],
			set = "SetColor",
			get = "GetColor",
			order = 130,
			disabled = '~IsActive',
		},
		outline = {
			name = L["Outline"], type='text',
			desc = L["Set font outline."],
			validate = {[''] = L["None"], OUTLINE = L["Normal"], THICKOUTLINE = L["Thick"]},
			order = 140,
			disabled = '~IsActive',
		},
		strata = {
			name = L["Strata"], type='text',
			desc = L["Set frame strata."],
			validate = {HIGH = L["High"], MEDIUM = L["Medium"], LOW = L["Low"], BACKGROUND = L["Background"]},
			order = 150,
			disabled = '~IsActive',
		},
--~ 		update = {
--~ 			name = L["Update period"], type='range',
--~ 			desc = L["Set time between updates."],
--~ 			min = .1, max = 5, step = .1,
--~ 			order = 160,
--~ 			disabled = '~IsActive',
--~ 		},
	},
}

------------------------------
--      Initialization      --
------------------------------

function TimeToDie:OnInitialize()
	TimeToDie:RegisterDB("TimeToDieDB")
	TimeToDie:RegisterDefaults('profile', {
		locked = false,
		enemy = true,
		target = 'target',
		font = defaultFont,
		size = 24,
		r = 1,
		g = .82,
		b = 0,
		outline = '',
		strata = 'LOW',
		update = 1,
		
		p1 = 'CENTER',
		p2 = 'CENTER',
		x = 0,
		y = 0,
	})
	TimeToDie:RegisterChatCommand("/TimeToDie", options)
	p = self.db.profile
	self:CreateFrame()
end

function TimeToDie:OnEnable(first)
--~ 	self:SetDebugging(true)
	
	self:ApplySettings()
	
	return frame:Show()
end

function TimeToDie:OnDisable()
	if frame then
		frame:Hide()
	end
end

function TimeToDie:OnProfileEnable()
	p = self.db.profile
	if frame then
		self:ApplySettings()
	end
end

-------------------------------
--      Event Functions      --
-------------------------------

local health0, time0 -- initial health and time point
local mhealth, mtime -- current midpoint

function TimeToDie:UNIT_HEALTH(unit)
	if unit ~= p.target or p.enemy and (UnitIsFriend('player', p.target) or UnitIsPlayer(p.target)) then return end
	
	local health, time = UnitHealth(p.target), GetTime()
	
	if not health0 then
		health0, time0 = health, time
		return
	end
	if not mhealth then
		mhealth, mtime = health, time
	else
		mhealth, mtime = (mhealth + health) / 2, (mtime + time) / 2
	end
	
	local dhealth = mhealth - health0
	if dhealth ~= 0 then
		time = health * (time0 - mtime) / dhealth
		if abs(time) > 60 then
			text:SetText(format("%dm %ds", time/60, time%60))
		else
			text:SetText(format("%ds", time%60))
		end
	else
		text:SetText("0s")
	end
end

function TimeToDie:OnChange(arg1)
	if events[p.target] ~= event then return end
	text:SetText(not p.locked and L["TimeToDie"] or nil)
	health0, time0, mhealth, mtime = nil
end

------------------------------
--      Core Functions      --
------------------------------

function TimeToDie:CreateFrame()
	frame = _G.TimeToeDieFrame or _G.CreateFrame('frame', "TimeToDieFrame", UIParent)
	frame:RegisterForDrag('LeftButton')
	frame:SetClampedToScreen(true)
	frame:SetMovable(true)
	frame:SetWidth(120)
	frame:SetHeight(30)

	frame.isMoving = false
	frame:SetScript('OnDragStart', function(frame)
		frame:StartMoving()
		frame.isMoving = true
	end)
	frame:SetScript('OnDragStop', function(frame)
		if frame.isMoving then
			frame:StopMovingOrSizing()
			frame.isMoving = false
			p.p1, _, p.p2, p.x, p.y = frame:GetPoint()
		end
	end)

	texture = frame.texture or frame:CreateTexture("TimeToDieFrameTexture", 'BACKGROUND')
	texture:SetTexture(0, 0, 0, 0.5)
	texture:ClearAllPoints()
	texture:SetAllPoints(frame)
	frame.texture = texture

	text = frame.text or frame:CreateFontString("TimeToDieFrameText", 'OVERLAY', 'GameFontNormal')
	text:SetFont(p.font, p.size, p.outline)
	text:SetJustifyH('CENTER')
	text:SetPoint('CENTER', frame)
	frame.text = text

	if (dewdrop) then
		dewdrop:Register(frame, 'children', function()
			dewdrop:FeedAceOptionsTable(options)
		end)
	end
	
	frame:Hide()
end

function TimeToDie:GetValue(name)
	return p[name]
end

function TimeToDie:SetValue(name, v)
	p[name] = v
	return self:ApplySettings()
end

function TimeToDie:GetFocus()
	return p.target == 'focus'
end

function TimeToDie:SetFocus(v)
	if v then
		p.target = 'focus'
	else
		p.target = 'target'
	end
	return self:ApplySettings()
end

function TimeToDie:GetColor()
	return p.r, p.g, p.b
end

function TimeToDie:SetColor(r,g,b)
	p.r, p.g, p.b = r,g,b
	return self:ApplySettings()
end

function TimeToDie:ApplySettings()
	frame:SetFrameStrata(p.strata)
	frame:ClearAllPoints()
	frame:SetPoint(p.p1, UIParent, p.p2, p.x, p.y)
	if p.locked then
		texture:Hide()
		frame:EnableMouse(false)
		if text:GetText() == L["TimeToDie"] then
			text:SetText()
		end
	else
		texture:Show()
		frame:EnableMouse(true)
		if not text:GetText() then
			text:SetText(L["TimeToDie"])
		end
	end
	text:SetFont(SML and SML:Fetch('font', p.font) or defaultFont, p.size, p.outline)
	text:SetTextColor(p.r,p.g,p.b)
	self:UnregisterAllEvents()
	timer, health0, time0, mhealth, mtime = nil
	self:RegisterEvent(events[p.target], "OnChange")
	self:RegisterEvent('UNIT_HEALTH')
end
