-- To do list:
--
-- default to off? currently on
-- GUILD is a valid channel but undocumented as it probably shouldn't be used (unless you want to be /gkicked? spam potential with this mod is very high:p)
-- add shortcuts for people to add variables into custom spam like SCT?
-- change source/target to source/dest? target,target is confusing... and change spellname to spell
-- add auto update to target/focus on target change? if affiliation = target then it autoupdates.

--------------------------
-- Variables, Defined --
--------------------------
local orange =	"|cffffaa11";
local red = "|cFFFF0000";
local yellow = "|cFFFFFF00";
local cyan = "|cFF00FFFF";
local white = "|cFFFFFFFF";
local TJH_delrule = "";
local TJH_eventType = "";	-- event to watch
local TJH_sourceName = "";	-- source of event
local TJH_destName = "";	-- target of event
local TJH_spellName = "";	-- spell name to watch for
local TJH_affFlag = "";	-- self/party/raid/friend/enemy/target/focus
local TJH_powerType = "";
local TJH_spellSchool = "";
TJH_Channel = "SELF";	-- output channel
TJH_ruleSpam = "";	
TJH_Rules = {};
TJH_whisperTarget = UnitName("player"); -- defaults to player if whisper is activated to avoid unwanted spam
TJH_Options = {enabled=0};

-- affiliation/type filters below
local bit_bor = _G.bit.bor;
local bit_band = _G.bit.band;
local string_gsub = string.gsub;
local string_sub = string.sub;
local string_find = string.find;
local CombatLog_Object_IsA = CombatLog_Object_IsA;

--local COMBATLOG_FILTER_MY_PET = bit_bor(
--	COMBATLOG_OBJECT_AFFILIATION_MINE,
--	COMBATLOG_OBJECT_REACTION_FRIENDLY,
--	COMBATLOG_OBJECT_CONTROL_PLAYER,
--	COMBATLOG_OBJECT_TYPE_GUARDIAN,
--	COMBATLOG_OBJECT_TYPE_PET
--	);
local COMBATLOG_FILTER_MINE = bit_bor(
	COMBATLOG_OBJECT_AFFILIATION_MINE,
	COMBATLOG_OBJECT_REACTION_FRIENDLY,
	COMBATLOG_OBJECT_CONTROL_PLAYER,
	COMBATLOG_OBJECT_TYPE_PLAYER,
	COMBATLOG_OBJECT_TYPE_OBJECT
	);
local COMBATLOG_FILTER_FRIENDLY_UNITS = bit_bor(
	COMBATLOG_OBJECT_AFFILIATION_MINE,
	COMBATLOG_OBJECT_AFFILIATION_PARTY,
	COMBATLOG_OBJECT_AFFILIATION_RAID,
	COMBATLOG_OBJECT_AFFILIATION_OUTSIDER,
	COMBATLOG_OBJECT_REACTION_FRIENDLY,
	COMBATLOG_OBJECT_CONTROL_PLAYER,
	COMBATLOG_OBJECT_CONTROL_NPC,
	COMBATLOG_OBJECT_TYPE_PLAYER,
	COMBATLOG_OBJECT_TYPE_NPC,
	COMBATLOG_OBJECT_TYPE_PET,
	COMBATLOG_OBJECT_TYPE_GUARDIAN,
	COMBATLOG_OBJECT_TYPE_OBJECT
	);
local COMBATLOG_FILTER_HOSTILE_UNITS = bit_bor(
--	COMBATLOG_OBJECT_REACTION_NEUTRAL,
	COMBATLOG_OBJECT_REACTION_HOSTILE,
	COMBATLOG_OBJECT_CONTROL_PLAYER,
	COMBATLOG_OBJECT_CONTROL_NPC,
	COMBATLOG_OBJECT_TYPE_PLAYER,
	COMBATLOG_OBJECT_TYPE_NPC,
	COMBATLOG_OBJECT_TYPE_PET,
	COMBATLOG_OBJECT_TYPE_GUARDIAN,
	COMBATLOG_OBJECT_TYPE_OBJECT
	);
local COMBATLOG_FILTER_PARTY = bit_bor(
	COMBATLOG_OBJECT_AFFILIATION_MINE,
	COMBATLOG_OBJECT_AFFILIATION_PARTY,
	COMBATLOG_OBJECT_REACTION_FRIENDLY,
	COMBATLOG_OBJECT_CONTROL_PLAYER,
	COMBATLOG_OBJECT_TYPE_PLAYER,
	COMBATLOG_OBJECT_TYPE_PET,
	COMBATLOG_OBJECT_TYPE_GUARDIAN,
	COMBATLOG_OBJECT_TYPE_OBJECT
	);
local COMBATLOG_FILTER_RAID = bit_bor(
	COMBATLOG_OBJECT_AFFILIATION_MINE,
	COMBATLOG_OBJECT_AFFILIATION_PARTY,
	COMBATLOG_OBJECT_AFFILIATION_RAID,
	COMBATLOG_OBJECT_REACTION_FRIENDLY,
	COMBATLOG_OBJECT_CONTROL_PLAYER,
	COMBATLOG_OBJECT_TYPE_PLAYER,
	COMBATLOG_OBJECT_TYPE_PET,
	COMBATLOG_OBJECT_TYPE_GUARDIAN,
	COMBATLOG_OBJECT_TYPE_OBJECT
	);
local COMBATLOG_OBJECT_TARGET = COMBATLOG_OBJECT_TARGET;
local COMBATLOG_OBJECT_FOCUS = COMBATLOG_OBJECT_FOCUS;


--------------------------
-- Functions --
--------------------------

function TJH_OnLoad()
	--define slash command parsing
 	SlashCmdList["ThatJustHappened"] = TJH_SlashCMD;
 	SLASH_ThatJustHappened1 = "/tjh";
 	SLASH_ThatJustHappened2 = "/thatjusthappened";
	--register all variable and combat events to the frame
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
end


-- slash handler
function TJH_SlashCMD(msg)
	local msg1, msg2 = strsplit(";",msg);
	local msg_lower = strlower(msg1);
--	help text
	if (msg_lower=="gui" or msg_lower == "") then TJH_MainForm:Show(); return; end
	if (msg_lower == "help") then
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh"..orange.." or "..white.."/tjh gui"..orange.." for GUI");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh help"..orange.." for this list");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh on"..orange.." to activate");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh off"..orange.." to deactivate");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh rule EVENT_NAME;Sourcename;TargetName;SpellName;\nAffiliation;Channel;Spam"..orange.." (leave blank to see all of a type, ex: /tjh rule INTERRUPT;;;;;;); affiliation: self/party/raid/friend/enemy/target/focus");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh list"..orange.." to list current rules");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh delete"..orange.." to delete all rules");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh delete;3"..orange.." to delete the third rule");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh report"..orange.." to print basic settings");
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."/tjh reset"..orange.." deletes all rules, resets output to SELF");
--	toggle on/off
	elseif (msg_lower == "on") then
		TJH_Options.enabled = 1;
		TJH_EnableButton();
		TJH_Print(orange.."TJH enabled.","SELF");
	elseif (msg_lower == "off") then
		TJH_Options.enabled = 0;
		TJH_EnableButton();
		this:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		TJH_Print(orange.."TJH disabled.","SELF");
	elseif (msg_lower == "report") then
		TJH_ListRules();
	elseif (msg_lower == "list") then
		TJH_ListRules();
	elseif (string_sub(strlower(msg),1,7) == "delete;") then
		TJH_delrule = string_sub(msg,8);
		TJH_DeleteRule(TJH_delrule);
	elseif msg_lower == "delete" then
		TJH_ClearRules();
	elseif (msg_lower == "reset") then
		TJH_Channel = "SELF";
		TJH_ClearRules();
		TJH_Print(orange.."TJH: No rules defined.", "SELF");
--	rule setting code
	elseif (string_sub(strlower(msg),1,3) == "ssc") then
		-- Add a default set of rules
		TJH_addRule("", "Lurker", "", "Spout", "", "RAID", "");
		TJH_addRule("SUMMON", "Greyheart Tidecaller", "", "Water Elemental Totem", "", "RW", "Kill the Totem!");
		TJH_addRule("AURA_APPLIED", "", "", "Spell Reflection", "", "SELF", "");
		TJH_addRule("DAMAGE", "", "", "", "Tidal Wave", "", "SELF");
		TJH_addRule("SUMMON", "Fathom-Guard Tidalvess", "", "", "Spitfire Totem", "", "RW");

	elseif (string_sub(strlower(msg),1,5) == "rule ") then
		local TJH_ruleString = string_gsub(string_sub(msg,6),"[%[%]]","");
		local TJH_eventType, TJH_sourceName, TJH_destName, TJH_spellName, TJH_affFlag, TJH_Channel, TJH_ruleSpam = strsplit(";",TJH_ruleString);
		if TJH_eventType == nil then TJH_eventType = ""; end
		if TJH_sourceName == nil then TJH_sourceName = ""; end
		if TJH_destName == nil then TJH_destName = ""; end
		if TJH_spellName == nil then TJH_spellName = ""; end
		if TJH_affFlag == nil then TJH_affFlag = ""; end
		if TJH_Channel == nil then TJH_Channel = "SELF"; end
		if TJH_ruleSpam == nil then TJH_ruleSpam = ""; end
		
		-- will set source/target to target or focus; if you want it to update to current target when you change target/focus use "target" or "focus" affiliation option
		if TJH_sourceName == "target" then if UnitName("target")~= nil then TJH_sourceName = UnitName("target") else TJH_Print(orange.."TJH: You don't have a target!", "SELF"); end end
		if TJH_sourceName == "focus" then if UnitName("focus")~= nil then TJH_sourceName = UnitName("focus") else TJH_Print(orange.."TJH: You don't have a focus!", "SELF"); end end
		if TJH_destName == "target" then if UnitName("target")~= nil then TJH_destName = UnitName("target") else TJH_Print(red.."TJH: You don't have a target!", "SELF"); end end
		if TJH_destName == "focus" then if UnitName("focus")~= nil then TJH_destName = UnitName("focus") else TJH_Print(red.."TJH: You don't have a focus!", "SELF"); end end
		if TJH_affFlag ~= ("self" or "party" or "raid" or "friend" or "enemy" or "target" or "focus" or "") then DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..orange.."Affiliation: self/party/raid/friend/enemy/target/focus"); end

		TJH_addRule(strupper(strtrim(TJH_eventType)), strtrim(TJH_sourceName), strtrim(TJH_destName), strtrim(TJH_spellName), strtrim(TJH_affFlag), strtrim(TJH_Channel), TJH_ruleSpam);

	else
	end
end


-- OnEvent, where most of the work takes place
function TJH_OnEvent(event, ...)
	-- check if the mod is disabled, if so return
	if TJH_Options.enabled == 0 then return; end

	if event == "VARIABLES_LOADED" then
		if(not TJH_eventType) then TJH_eventType = ""; end;
		if(not TJH_sourceName) then TJH_sourceName = ""; end;
		if(not TJH_destName) then TJH_destName = ""; end;
		if(not TJH_spellName) then TJH_spellName = ""; end;
		if(not TJH_affFlag) then TJH_affFlag = ""; end;
		if(not TJH_Channel) then TJH_Channel = "SELF"; end;
		if(not TJH_ruleSpam) then TJH_ruleSpam = ""; end;
	end

	local playerid = UnitGUID("player");
	local targetid = UnitGUID("target");
	if arg2 == nil then arg2 = ""; end
	if arg4 == nil then arg4 = ""; end
	if arg7 == nil then arg7 = ""; end
	if arg9 == nil then arg9 = ""; end
	if arg10 == nil then arg10 = ""; end
	if arg12 == nil then arg12 = ""; end

	local rules=#(TJH_Rules);	--the table will be iterated only once
	for i=1,rules do
		msg=TJH_Rules[i];	--msg syntax: event, source, dest, spell
		TJH_eventType, TJH_sourceName, TJH_destName, TJH_spellName, TJH_affFlag, TJH_Channel, TJH_ruleSpam = strsplit(";", msg);

--		arguments 1-8: timestamp, eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags...
		if TJH_affFlag == "self" then
			if (CombatLog_Object_IsA(arg5, COMBATLOG_FILTER_MINE) or CombatLog_Object_IsA(arg8, COMBATLOG_FILTER_MINE)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "party" then
			if (CombatLog_Object_IsA(arg5, COMBATLOG_FILTER_PARTY) or CombatLog_Object_IsA(arg8, COMBATLOG_FILTER_PARTY)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "raid" then
			if (CombatLog_Object_IsA(arg5, COMBATLOG_FILTER_RAID) or CombatLog_Object_IsA(arg8, COMBATLOG_FILTER_RAID)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "friend" then
			if ((arg5 ~= nil) and (bit_band(arg5, COMBATLOG_OBJECT_REACTION_FRIENDLY) == COMBATLOG_OBJECT_REACTION_FRIENDLY)) or ((arg8 ~= nil) and (bit_band(arg8, COMBATLOG_OBJECT_REACTION_FRIENDLY) == COMBATLOG_OBJECT_REACTION_FRIENDLY)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "enemy" then
			if ((arg5 ~= nil) and (bit_band(arg5, COMBATLOG_OBJECT_REACTION_HOSTILE) == COMBATLOG_OBJECT_REACTION_HOSTILE)) or ((arg8 ~= nil) and (bit_band(arg8, COMBATLOG_OBJECT_REACTION_HOSTILE) == COMBATLOG_OBJECT_REACTION_HOSTILE)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "target" then
			if (CombatLog_Object_IsA(arg5, COMBATLOG_OBJECT_TARGET) or CombatLog_Object_IsA(arg8, COMBATLOG_OBJECT_TARGET)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "focus" then
			if (CombatLog_Object_IsA(arg5, COMBATLOG_OBJECT_FOCUS) or CombatLog_Object_IsA(arg8, COMBATLOG_OBJECT_FOCUS)) then
				TJH_EventScan();
			end
		elseif TJH_affFlag == "" then
			TJH_EventScan();
		end
	end
end


function TJH_EventScan()
	if (TJH_eventType ~= nil) and (TJH_sourceName ~= nil) and (TJH_destName ~= nil) and (TJH_spellName ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) and (string_find(arg4, TJH_sourceName) ~= nil) and (string_find(arg7, TJH_destName) ~= nil) and (string_find(arg10, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_eventType ~= nil) and (TJH_sourceName ~= nil) and (TJH_destName ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) and (string_find(arg4, TJH_sourceName) ~= nil) and (string_find(arg7, TJH_destName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_sourceName ~= nil) and (TJH_destName ~= nil) and (TJH_spellName ~= nil) then
		if (string_find(arg4, TJH_sourceName) ~= nil) and (string_find(arg7, TJH_destName) ~= nil) and (string_find(arg10, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_eventType ~= nil) and (TJH_sourceName ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) and (string_find(arg4, TJH_sourceName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_eventType ~= nil) and (TJH_destName ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) and (string_find(arg7, TJH_destName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_eventType ~= nil) and (TJH_spellName ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) and (string_find(arg10, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_sourceName ~= nil) and (TJH_destName ~= nil) then
		if (string_find(arg4, TJH_sourceName) ~= nil) and (string_find(arg7, TJH_destName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_sourceName ~= nil) and (TJH_spellName ~= nil) then
		if (string_find(arg4, TJH_sourceName) ~= nil) and (string_find(arg10, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_destName ~= nil) and (TJH_spellName ~= nil) then
		if (string_find(arg7, TJH_destName) ~= nil) and (string_find(arg10, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_eventType ~= nil) then
		if (string_find(arg2, TJH_eventType) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_sourceName ~= nil) then
		if (string_find(arg2, TJH_sourceName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_destName ~= nil) then
		if (string_find(arg2, TJH_destName) ~= nil) then
			 TJH_SpammitySpam();
		end
	elseif (TJH_spellName ~= nil) then
		if (string_find(arg2, TJH_spellName) ~= nil) then
			 TJH_SpammitySpam();
		end
	else
		 TJH_SpammitySpam();
	end
end


function TJH_SpammitySpam()
	if TJH_ruleSpam ~= "" then
		TJH_ruleSpam = string_gsub(TJH_ruleSpam, "*event", arg10);
		TJH_ruleSpam = string_gsub(TJH_ruleSpam, "*source", arg4);
		TJH_ruleSpam = string_gsub(TJH_ruleSpam, "*target", arg7);	
		TJH_ruleSpam = string_gsub(TJH_ruleSpam, "*spell", arg10);	
		TJH_Print(TJH_ruleSpam, TJH_Channel);
	return;
	end
	
	if (arg2 == "SPELL_CAST_START") then
		TJH_Print(arg4.." begins casting "..arg10..".", TJH_Channel);
		return;
	elseif (arg10 ~= nil and arg10 ~= 1 and (string_find(arg2, "ENCHANT") ~= nil)) then
		if (string_find(arg2, "ENCHANT_APPLIED") ~= nil) then
			TJH_Print(arg4.." cast "..arg9.."on "..arg7.."'s "..arg11..".", TJH_Channel);
		elseif (string_find(arg2, "ENCHANT_REMOVED")) then
			TJH_Print(arg9.." fades from "..arg7.."'s "..arg11..".", TJH_Channel);
		end
		return;
	elseif (arg2 == "PARTY_KILL") then
		TJH_Print(arg7.." killed by "..arg4.."!", TJH_Channel);
		return;
	elseif (arg2 == "INSTAKILL") then
		TJH_Print(arg7.." insta-killed by "..arg4.."!", TJH_Channel);
		return;
	elseif (arg2 == "UNIT_DIED") then
		TJH_Print(arg7.." died.", TJH_Channel);
		return;
	elseif (arg2 == "UNIT_DESTROYED") then
		TJH_Print(arg7.." destroyed!", TJH_Channel);
		return;
	elseif (string_find(arg2, "HEAL") ~= nil) then
		if (arg2 == "SPELL_HEAL") then
			TJH_Print(arg4.."'s "..arg10.." heals "..arg7.." for "..arg12..".", TJH_Channel);
		elseif (arg2 == "SPELL_PERIODIC_HEAL") then
			TJH_Print(arg4.."'s "..arg10.." heals "..arg7.." for "..arg12..".", TJH_Channel);
		end
		return;
	elseif string_find(arg2, "FAILED") then
		if (arg2 == "SPELL_CAST_FAILED") then
			TJH_Print(arg10.." failed: "..arg12, TJH_Channel);
		elseif (arg2 == "SPELL_DISPEL_FAILED") then	-- check to make sure all such events have destinations
			TJH_Print(arg10.." failed to dispel "..arg7..".", TJH_Channel);
		end
		return;
	elseif string_find(arg2, "INTERRUPT") then
		TJH_Print(arg7.."'s "..arg13.." interrupted by "..arg4..".", TJH_Channel);
		return;
	elseif (arg2 == "SPELL_EXTRA_ATTACKS") then
		TJH_Print(arg4.." gains "..arg12.." extra attack(s) from "..arg10..".", TJH_Channel);
		return;
	elseif (string_find(arg2, "DAMAGE") ~= nil) then
		if (string_find(arg2, "MISSED") == nil) then
			if (arg2 == "SWING_DAMAGE") then
				TJH_SchoolTypeParser();
				TJH_Print(arg4.. " does "..arg9.." "..TJH_spellSchool.." damage to "..arg7..".", TJH_Channel);
			elseif (arg2 == "SPELL_DAMAGE") then
				TJH_SchoolTypeParser();
				TJH_Print(arg4.. "'s "..arg10.." does "..arg12.." "..TJH_spellSchool.." damage to "..arg7..".", TJH_Channel);
			elseif (arg2 == "RANGE_DAMAGE") then
				TJH_SchoolTypeParser();
				TJH_Print(arg4.. "'s "..arg10.." does "..arg12.." "..TJH_spellSchool.." damage to "..arg7..".", TJH_Channel);
			elseif (arg2 == "SPELL_PERIODIC_DAMAGE") then
				TJH_SchoolTypeParser();
				TJH_Print(arg4.. "'s "..arg10.." does "..arg12.." "..TJH_spellSchool.." damage to "..arg7..".", TJH_Channel);
			elseif (arg2 == "DAMAGE_SHIELD") then
				TJH_SchoolTypeParser();
				TJH_Print(arg4.. "'s "..arg10.." does "..arg12.." "..TJH_spellSchool.." damage to "..arg7..".", TJH_Channel);
			elseif (arg2 == "ENVIRONMENTAL_DAMAGE") then
				TJH_Print(arg7.. " suffers "..arg10.." "..strlower(arg9).." damage.", TJH_Channel);
			end
		end
		return;
	elseif (string_find(arg2, "AURA") ~= nil) then
		if (string_find(arg2, "AURA_APPLIED") ~= nil) then
			if (arg2 == "SPELL_AURA_APPLIED_DOSE") then
				TJH_Print(arg7.." gains "..arg10.." ("..arg13..").", TJH_Channel);
			elseif arg12 == "BUFF" then
					TJH_Print(arg7.." gains "..arg10..".", TJH_Channel);
			elseif arg12 == "DEBUFF" then
				TJH_Print(arg7.." is afflicted by "..arg10..".", TJH_Channel);
			end
		elseif (string_find(arg2, "SPELL_AURA_REMOVED") ~= nil) then	-- to catch regular and _DOSE (add dose: arg13/amount later?)
			TJH_Print(arg10.." fades from "..arg7..".", TJH_Channel);
		elseif (arg2 == "SPELL_AURA_DISPELLED") then
			TJH_Print(arg10.." dissipates from "..arg7..".", TJH_Channel);
		elseif (arg2 == "SPELL_AURA_STOLEN") then
			TJH_Print(arg4.." steals the "..arg13.." "..strlower(arg15)..".", TJH_Channel);
		else
			TJH_Print("The "..arg10.." "..strlower(arg12).." triggered on "..arg7..".", TJH_Channel);
		end
		return;
	elseif (string_find(arg2, "SUMMON") ~= nil) then
		TJH_Print(arg4.. "'s "..arg7.." summons "..arg10..".", TJH_Channel);
		return;
	elseif (arg2 == "SPELL_CREATE") then
		TJH_Print(arg4.." creates "..arg10..".", TJH_Channel);
		return;
	elseif (string_find(arg2, "SPELL_CAST_SUCCESS") ~= nil) and (string_find(arg10, "Create") ~= nil) then
		TJH_Print(arg4.." casts "..arg10..".", TJH_Channel);
		return;
	elseif (string_find(arg2, "SUCCESS") ~= nil) then
		if arg7 ~= "" then
			TJH_Print(arg4.." casts "..arg10.." at "..arg7..".", TJH_Channel);
		else
			TJH_Print(arg4.." casts "..arg10..".", TJH_Channel);
		end
		return;
	elseif (string_find(arg2, "SPELL_CAST") ~= nil) then
		if arg7 ~= "" then
			TJH_Print(arg4.." casts "..arg10.." on "..arg7..".", TJH_Channel);
		else
			TJH_Print(arg4.." casts "..arg10..".", TJH_Channel);
		end
		return;
	elseif (string_find(arg2, "REMOVED") ~= nil) then
		TJH_Print(arg10.." fades from "..arg7..".", TJH_Channel);
		return;
	elseif string_find(arg2, "MISSED") then
		if (arg2 == "SWING_MISSED") then
			TJH_Print(arg4.."'s swing misses ("..strlower(arg9)..").", TJH_Channel);	-- simplify?
		elseif (arg2 == "SPELL_MISSED") then
			TJH_Print(arg4.."'s "..arg10.." misses ("..strlower(arg12)..").", TJH_Channel);
		elseif (arg2 == "SPELL_PERIODIC_MISSED") then
			TJH_Print(arg4.."'s "..arg10.." misses ("..strlower(arg12)..").", TJH_Channel);
		elseif (arg2 == "RANGE_MISSED") then
			TJH_Print(arg4.."'s "..arg10.." misses ("..strlower(arg12)..").", TJH_Channel);
		elseif (arg2 == "DAMAGE_SHIELD_MISSED") then
			TJH_Print(arg4.."'s "..arg10.." misses ("..strlower(arg12)..").", TJH_Channel);
		end
		return;
	elseif string_find(arg2, "ENERGIZE") then
		TJH_PowerTypeParser();
		TJH_Print(arg4.." gains "..arg12.. " "..TJH_powerType.." from "..arg4.."'s "..arg10..".", TJH_Channel);
		return;
	elseif string_find(arg2, "LEECH") then
		TJH_PowerTypeParser();
		TJH_Print(arg4.."'s "..arg10.." drains "..arg12.. " "..TJH_powerType.." from "..arg7..".", TJH_Channel);
		return;
	elseif string_find(arg2, "DRAIN") then
		TJH_PowerTypeParser();
		TJH_Print(arg4.."'s "..arg10.." drains "..arg12.. " "..TJH_powerType.." from "..arg7..".", TJH_Channel);
		return;
	elseif (string_find(arg2, "SPELL") ~= nil) then
		TJH_Print(arg10.." cast.", TJH_Channel);
		return;
	elseif arg2 ~= "" then
		TJH_Print("TJH: ("..strlower(arg2)..") just happened.", TJH_Channel);
		return;
	else
--		TJH_Print("TJH: Shake and bake!", TJH_Channel);	--debugging
	end
end


function TJH_SchoolTypeParser()
	TJH_spellSchool = "";
	if arg2 == "SWING_DAMAGE" then
		if arg10 == 1 then
			TJH_spellSchool = "physical";
			return;
		elseif arg10 == 2 then
			TJH_spellSchool = "holy";
			return;
		elseif arg10 == 4 then
			TJH_spellSchool = "fire";
			return;
		elseif arg10 == 8 then
			TJH_spellSchool = "nature";
			return;
		elseif arg10 == 16 then
			TJH_spellSchool = "frost";
			return;
		elseif arg10 == 32 then
			TJH_spellSchool = "shadow";
			return;
		elseif arg10 == 64 then
			TJH_spellSchool = "arcane";
			return;
		end
	else
		if arg13 == 1 then
			TJH_spellSchool = "physical";
			return;
		elseif arg13 == 2 then
			TJH_spellSchool = "holy";
			return;
		elseif arg13 == 4 then
			TJH_spellSchool = "fire";
			return;
		elseif arg13 == 8 then
			TJH_spellSchool = "nature";
			return;
		elseif arg13 == 16 then
			TJH_spellSchool = "frost";
			return;
		elseif arg13 == 32 then
			TJH_spellSchool = "shadow";
			return;
		elseif arg13 == 64 then
			TJH_spellSchool = "arcane";
			return;
		end
	end
end

function TJH_PowerTypeParser()
	if (string_find(arg2, "DRAIN") ~= nil) or (string_find(arg2, "LEECH") ~= nil) or (string_find(arg2, "ENERGIZE") ~= nil) then
		if arg13 == -2 then
			TJH_powerType = "health";
			return;
		elseif arg13 == 0 then
			TJH_powerType = "mana";
			return;
		elseif arg13 == 1 then
			TJH_powerType = "rage";
			return;
		elseif arg13 == 2 then
			TJH_powerType = "focus";
			return;
		elseif arg13 == 3 then
			TJH_powerType = "energy";
			return;
		elseif arg13 == 4 then
			TJH_powerType = "pet happiness";
			return;
		end
	end
end



-- Function to insert rule into the table (data assumed good)
function TJH_addRule(eventname, sourcename, destname, spellname, affflag, outputchann, rulespam)
	table.insert(TJH_Rules, eventname..";"..sourcename..";"..destname..";"..spellname..";"..affflag..";"..strupper(outputchann)..";"..rulespam);
	TJH_ListRules();
end



--function to get single rule from GUI and pass it on to delete function
function TJH_GUIDeleteRule()
	local count=#(TJH_Rules);
	TJH_delrule=TJH_IndivRuleBox:GetText();
	TJH_DeleteRule(TJH_delrule);
end



--function to delete rule 
function TJH_DeleteRule(TJH_delrule)
	local count=#(TJH_Rules);
	local ruletodelete=tonumber(TJH_delrule);
	if (count == 0) then
		TJH_Print(red.."TJH: There are no rules defined.", "SELF");
	elseif ruletodelete == "" then
		TJH_Print(red.."TJH: Please specify a Rule # to delete. /tjh list may help you out here.", "SELF");
	else
		table.remove(TJH_Rules,ruletodelete);
		TJH_Print(orange.."TJH: Custom Rules were updated!", "SELF")
		TJH_ListRules();
	end
end



--function to delete all rules on button press
function TJH_ClearRules()
	for k in pairs(TJH_Rules) do TJH_Rules[k]=nil; end
	TJH_Rules={};
	TJH_Print(yellow.."TJH: Event rules deleted.", "SELF")
end


-- function to list all rules on button press
function TJH_ListRules()
	local count=#(TJH_Rules);
	if (count == 0) then
		TJH_Print(orange.."TJH: There are no rules defined.", "SELF");
	else
		TJH_Print(orange.."TJH: Rule #: event;source;target;spellname;affiliation;channel;spam", "SELF");
		for i=1,count do
		TJH_Print("TJH: Rule "..i..": "..TJH_Rules[i], "SELF");
		end
	end
end


function TJH_Print(msg, channel)
	if channel == nil then
		DEFAULT_CHAT_FRAME:AddMessage(orange.."TJH: "..white.."channel=SELF/PARTY/RAID/RAID_WARNING/PlayerName/ChannelName/auto"..orange.." to set output channel");
		DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
	end

	if channel == "AUTO" then
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(msg, "RAID");
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(msg, "PARTY");
		else 
			DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
		end 
	elseif channel == "SELF" then
		DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
	elseif channel == "WARN" then
		DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
		UIErrorsFrame:AddMessage(msg, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME);		
	elseif channel == "RAID" then
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(msg, channel);
		else
			DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
		end
	elseif channel == "RAID_WARNING" or channel == "RW" or channel == "RS" then
		SendChatMessage(msg, "RAID_WARNING");
	elseif channel == "PARTY" then
		if (GetNumPartyMembers() > 0) then 
			SendChatMessage(msg, channel);
		else
			DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
		end
	elseif channel == "SAY" then
		SendChatMessage(msg, channel);
	elseif channel == "YELL" then
		SendChatMessage(msg, channel);
	elseif channel == "GUILD" then
		SendChatMessage(msg, channel);
	elseif channel == "" then
		DEFAULT_CHAT_FRAME:AddMessage(yellow..msg);
	elseif GetChannelName(channel) > 0 then
			SendChatMessage(msg, "CHANNEL", nil, GetChannelName(channel));
	else
		SendChatMessage(msg, "WHISPER", nil, channel);
	end
end



-- GUI support
function TJH_Enablee()
	local gtext = TJH_MainFormButtonEnable:GetText();
	if gtext == "Disabled" then
		TJH_MainFormButtonEnable:SetTextFontObject("GameFontNormal");
		TJH_MainFormButtonEnable:SetText("*Enabled*");
		TJH_Options.enabled = 1;
	elseif gtext == "*Enabled*" then
		TJH_MainFormButtonEnable:SetTextFontObject("GameFontDisable");
		TJH_MainFormButtonEnable:SetText("Disabled");
		TJH_Options.enabled = 0;
	end
end


function TJH_EnableButton()
	if TJH_Options.enabled == 0 then
		TJH_MainFormButtonEnable:SetTextFontObject("GameFontDisable");
		TJH_MainFormButtonEnable:SetText("Disabled");
	elseif TJH_Options.enabled == 1 then
		TJH_MainFormButtonEnable:SetTextFontObject("GameFontNormal");
		TJH_MainFormButtonEnable:SetText("*Enabled*");
	end
end



--Update the window info
function TJH_GUIRefresh()
--	TJH_ChannelBox:SetText(strlower(TJH_Channel));
	TJH_RuleEventBoxText:SetText("");
	TJH_RuleAffiliationBoxText:SetText("");
	TJH_IndivRuleBox:SetText("")
end


--function to add channel to GUI and properly update text if custom channel
function TJH_CurrentChannel()
	if TJH_AutoChannelBox:GetChecked() == nil then
--		if TJH_Channel == "WHISPER" then	-- code to load current channel into gui on show, but it's a bit annoying
--			TJH_ChannelBox:SetText(TJH_whisperTarget);
----		elseif TJH_ChannelTarget == nil then
----			TJH_ChannelBox:SetText(string.lower(TJH_Channel));
--		else
--			if TJH_Channel == nil then
--				TJH_ChannelBox:SetText("self");
--			else
--				if TJH_Channel == "AUTO" then
--					TJH_ChannelBox:SetText("self");
--				else
--					TJH_ChannelBox:SetText(strlower(TJH_Channel));
--				end
--			end
--		end

		TJH_ChannelBox:SetText("SELF");	-- replaced above with "self" on show for simplicity and reduced public spam; consider restoring  if it gets annoying not having previous channel name after gui close
	
	elseif TJH_AutoChannelBox:GetChecked() ~= nil then
		TJH_GUIAutoChannel();
	end
end


--supports gui channel auto select
function TJH_GUIAutoChannel()
	local isChecked = TJH_AutoChannelBox:GetChecked();
	if isChecked == 1 then
		TJH_Channel = "auto";
		TJH_ChannelBox:SetText("auto");
	elseif isChecked ~= 1 then
		TJH_ChannelBox:SetText("SELF");
	end
end


-- function to update master channel from GUI, if I decide to have a master channel
--function TJH_AutoUpdate()
--	if TJH_AutoChannelBox:GetChecked() == nil then
--		if TJH_ChannelBox:GetText() == nil or TJH_ChannelBox:GetText() == "" then 
--			local channelString = "channel,SELF";
--			TJH_SlashCMD(channelString);
--		else
--			local channelString = ("channel,"..TJH_ChannelBox:GetText());
--			TJH_SlashCMD(channelString);
--		end
--	elseif TJH_AutoChannelBox:GetChecked() == 1 then
--		TJH_GUIAutoChannel(); 
--		TJH_Print(orange.."TJH: Channel set to ["..TJH_Channel.."].","SELF");
--	end
--end


-- function to add a rule via GUI
function TJH_GUIAddCustomRule()
	local guievent = "";
	if TJH_RuleEventManualBox:GetText() ~= "" then guievent = TJH_RuleEventManualBox:GetText(); else guievent = TJH_RuleEventBoxText:GetText(); end
	local guisource = TJH_RuleSourceBox:GetText();
	local guitarget = TJH_RuleTargetBox:GetText();
	local guispell = TJH_RuleSpellnameBox:GetText();
	local guiaff = TJH_RuleAffiliationBoxText:GetText();
	local guichann = strupper(TJH_ChannelBox:GetText());
	local guispam = strtrim(TJH_RuleSpamBox:GetText());
	if guievent == nil then guievent = ""; end
	if guisource == nil then guisource = ""; end
	if guitarget == nil then guitarget = ""; end
	if guispell == nil then guispell = ""; end
	if guiaff == nil then guiaff = ""; end
	if guichann == nil then guichann = "SELF"; end
	if guispam == nil then guispam = ""; end
	local ruleString = ("rule "..guievent..";"..guisource..";"..guitarget..";"..guispell..";"..guiaff..";"..guichann..";"..guispam);
	TJH_SlashCMD(ruleString);
	-- clear most rule fields on Add Rule
	TJH_RuleEventManualBox:SetText("");
	TJH_RuleEventBoxText:SetText("");
	TJH_RuleSourceBox:SetText("");
	TJH_RuleTargetBox:SetText("");
	TJH_RuleSpellnameBox:SetText("");
	TJH_RuleAffiliationBoxText:SetText("");
	TJH_RuleSpamBox:SetText("");
end



-- function to load rule into gui
function TJH_LoadRule()
	local count=#(TJH_Rules);
	local loadrule=tonumber(TJH_IndivRuleBox:GetText());
	local i = loadrule;
	if (count == 0) then
		TJH_Print(red.."TJH: There are no rules defined.", "SELF");
	elseif i > count then
		TJH_Print(red.."TJH: There is no such rule. /tjh list may help you out here.", "SELF");
	elseif loadrule == "" then
		TJH_Print(red.."TJH: Please specify a Rule # to load. /tjh list may help you out here.", "SELF");
	else
		local ruleString = TJH_Rules[loadrule];
		local levent, lsource, ldest, lspell, laff, lchannel, lspam = strsplit(";", ruleString);
		if levent == nil then levent = ""; end
		if lsource == nil then lsource = ""; end
		if ldest == nil then ldest = ""; end
		if lspell == nil then lspell = ""; end
		if laff == nil then laff = ""; end
		if lchannel == nil then lchannel = "SELF"; end
		if lspam == nil then lspam = ""; end
		TJH_RuleEventManualBox:SetText(levent);
		TJH_RuleEventBoxText:SetText("");
		TJH_RuleSourceBox:SetText(lsource);
		TJH_RuleTargetBox:SetText(ldest);
		TJH_RuleSpellnameBox:SetText(lspell);
		TJH_RuleAffiliationBoxText:SetText(laff);
		TJH_ChannelBox:SetText(lchannel);
		TJH_RuleSpamBox:SetText(lspam);
	end
end



-- function to add a rule via GUI
function TJH_ClearGUI()
	TJH_RuleEventManualBox:SetText("");
	TJH_RuleEventBoxText:SetText("");
	TJH_RuleSourceBox:SetText("");
	TJH_RuleTargetBox:SetText("");
	TJH_RuleSpellnameBox:SetText("");
	TJH_RuleAffiliationBoxText:SetText("");
	TJH_RuleSpamBox:SetText("");
end
