-- Component Template
--
-- You can make your own TextSpy component using the following template.
-- Just drop it in TextSpy/code/components and add the entry to TextSpy.toc
-- Soon, I should have a function which will allow you to create the
-- component as its own addon which will make it even easier.
-- Feel free to look at AudioAlerts.lua and CombatText.lua for examples if needed.

-- Localization
local LComponent = AceLibrary("AceLocale-2.2"):new("TextSpy_YourComponent")
LComponent:RegisterTranslations("enUS", function() return {
	["YourComponent"] = true,
	-- etc
} end)

-- Add a field to the component list.
TextSpy.componentList["yourComponent"] = {
	
	-- Name and description of your component.  Required.
	name = "My Component",
	desc = "Allows triggers to do something special.",
	
	-- Optional variables if you need them for your component
	yourComponentVar = "Store static variables your component will need here if you like.",
	
	-- Required: triggerDefaults and enabled = bool
	-- These are default settings which will be used if the user has not changed them in game.
	-- Put all variables you need to save between sessions here with their default values.
	-- These get added to TextSpy.db.profile.triggers[*]["yourComponent"], if you need to access them later
	triggerDefaults = {
		enabled = false,
		someVar = "blahblah",
	},
	
	-- This is where you should store the functions your component provides.
	-- You must provide a fire(data) and postFire(data) function, which is called automatically when the trigger fires
	functions = {
			-- fire() gets called if the text trigger is found and yourComponent is enabled globally AND
			-- for the trigger which fired.  It happens just before the message is sent to AddMessage()
			-- data is a table which contains the following data:
			--	data = {
			--		needle, 	<-- The search string
			--		haystack, 	<-- The text which contains the search string
			--		match, 		<-- Pattern match capture, if search string requested it
			--		index, 		<-- The index of the trigger
			--		event = {			<-- This table will exist, the values inside might not. Be sure to test for their presence before using these values
			--			type,			<-- CHAT_MSG_SOMETHING
			--			author,			<-- The person who sent the message
			--			channelNumber,	<-- The channel number the message arrived in
			--			channelName,	<-- The channel name the message arrived in
			--		},
			--	}
			-- if you need more data, please feel free to add it yourself and/or contact me, and if possible, I will include that data
			-- in future versions to the function call.
		fire = function(data)
			-- The following line is a sample of how to access your variables for this trigger
			TextSpy.db.profile.triggers[data.index]["yourComponent"].yourComponentVar
		end,
		postFire = function(data)
		end,		
		-- A sample function
		isEnabled = function(index)
			return TextSpy.db.profile.triggers[index]["yourComponent"].enabled
		end,
	},
	
	-- This sets up the menus which appear inside of each trigger
	triggerMenu = function(index)
			
			-- This small code checks if the index is 0, and you should keep this first section
			-- If the index is 0, we're storing the menu into the default trigger settings (used to create
			-- new triggers).  This also shortens the reference to the location of the trigger data for your
			-- component to triggerData, giving you easy access to the variables
			local triggerData
			if index == 0 then
				triggerData = TextSpy.db.profile.global["yourComponent"]
			else
				triggerData = TextSpy.db.profile.triggers[index]["yourComponent"]
			end
			
			-- Create the table as a variable, return the variable after you're done.
			-- Your table should be of type 'group', but can contain anything you want
			-- as args to show on the menu.  You should provide an enable toggle and a
			-- spacer which shows if there are other menu options as shown below.
		menuTable = {
			type = 'group',
			name = "Your Component",
			desc = "Settings",
			hidden = function()
				return not TextSpy.db.profile.components["yourComponent"].enabled
			end,
			args = {
				enable = {
					type = 'toggle',
					name = "Enable",
					desc = "Enable this trigger to do whatever your component does",
					get = function()
						return triggerData.enabled
					end,
					set = function()
						triggerData.enabled = not triggerData.enabled
					end,
					order = 5,
				},
				spacerOne = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled -- hide the spacer if not enabled
					end,
					order = 10,
				},
				someSetting = {
					type = 'text',
					name = "Some Setting",
					desc = "Perhaps you needed to store user-defined text?",
					usage = "sometext",
					get = function()
						return triggerData.yourComponentVar
					end,
					set = function(var)
						triggerData.yourComponentVar = var
					end,
					order = 10,
					-- Hides this setting if the component is not enabled for this trigger
					hidden = function()
						return not triggerData.enabled
					end,
				},
			},
		}
	return menuTable
	end
}