-- Screen Flash, a TextSpy component
-- Recluse@Norgannon
-- Causes the LowHealthFrame to flash for a user specified duration
-- By default, causes two slow-ish pulses
-- TODO: Figure out a way for the user to customize the color. LowHealthFrame is a static red
--		LowHealthFrame:Hide()
--		UIFrameFlash(LowHealthFrame, 0.25, 0.75, 2.2, false, 0, 0.1)
--		UIFrameFlash(frame, fadeInTime, fadeOutTime, flashDuration, showWhenDone, flashInHoldTime, flashOutHoldTime)
local LSFlash = AceLibrary("AceLocale-2.2"):new("TextSpy_SFlash")
LSFlash:RegisterTranslations("enUS", function() return {
	["Screen Flash"] = true,
	["Allows triggers to cause the screen to flash."] = true,
	["Settings"] = true,
	["Enable"] = true,
	["Enable this trigger to flash the screen when fired."] = true,
	["Fade In"] = true,
	["Duration of the fade in effect"] = true,
	["Fade Out"] = true,
	["Duration of the fade out effect"] = true,
	["Flash Duration"] = true,
	["Duration in seconds to repeat the fade in/out cycle."] = true,
	["Flash In Hold Time"] = true,
	["Number of seconds to hold the fully hidden state."] = true,
	["Flash Out Hold Time"] = true,
	["Number of seconds to hold the fully visible state."] = true,
} end)
LSFlash:RegisterTranslations("deDE", function() return {
	["Screen Flash"] = true,
	["Allows triggers to cause the screen to flash."] = true,
	["Settings"] = true,
	["Enable"] = "Aktivieren",
	["Enable this trigger to flash the screen when fired."] = true,
	["Fade In"] = true,
	["Duration of the fade in effect"] = true,
	["Fade Out"] = true,
	["Duration of the fade out effect"] = true,
	["Flash Duration"] = true,
	["Duration in seconds to repeat the fade in/out cycle."] = true,
	["Flash In Hold Time"] = true,
	["Number of seconds to hold the fully hidden state."] = true,
	["Flash Out Hold Time"] = true,
	["Number of seconds to hold the fully visible state."] = true,
} end)

TextSpy.componentList["screenFlash"] = {
	name = LSFlash["Screen Flash"],
	desc = LSFlash["Allows triggers to cause the screen to flash."],
	triggerDefaults = {
		enabled = false,
		fadeInTime = 0.25,
		fadeOutTime = 0.75,
		flashDuration = 2.2,
		showWhenDone = false,
		flashInHoldTime = 0,
		flashOutHoldTime = 0.1,
	},
	functions = {
		fire = function(data)
			thisTrigger = TextSpy.db.profile.triggers[data.index]["screenFlash"]
			LowHealthFrame:Hide()
			UIFrameFlash(LowHealthFrame, thisTrigger.fadeInTime, thisTrigger.fadeOutTime, thisTrigger.flashDuration, thisTrigger.showWhenDone, thisTrigger.flashInHoldTime, thisTrigger.flashOutHoldTime			)
		end,
		postFire = function(data)
		end,
	},
	triggerMenu = function(index)
		local triggerData
		if index == 0 then
			triggerData = TextSpy.db.profile.global["screenFlash"]
		else
			triggerData = TextSpy.db.profile.triggers[index]["screenFlash"]
		end
		menuTable = {
			type = 'group',
			name = LSFlash["Screen Flash"],
			desc = LSFlash["Settings"],
			hidden = function()
				return not TextSpy.db.profile.components["screenFlash"].enabled
			end,
			args = {
				enable = {
					type = 'toggle',
					name = LSFlash["Enable"],
					desc = LSFlash["Enable this trigger to flash the screen when fired."],
					get = function()
						return triggerData.enabled
					end,
					set = function()
						triggerData.enabled = not triggerData.enabled
					end,
					order = 5,
				},
				spacerOne = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled
					end,
					order = 10,
				},
				fadeInTime = {
					type = 'range',
					name = LSFlash["Fade In"],
					desc = LSFlash["Duration of the fade in effect"],
					step = 0.05,
					min = 0,
					max = 2,
					get = function()
						return triggerData.fadeInTime
					end,
					set = function(newValue)
						triggerData.fadeInTime = newValue
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				fadeOutTime = {
					type = 'range',
					name = LSFlash["Fade Out"],
					desc = LSFlash["Duration of the fade out effect"],
					step = 0.05,
					min = 0,
					max = 2,
					get = function()
						return triggerData.fadeOutTime
					end,
					set = function(newValue)
						triggerData.fadeOutTime = newValue
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				flashDuration = {
					type = 'range',
					name = LSFlash["Flash Duration"],
					desc = LSFlash["Duration in seconds to repeat the fade in/out cycle."],
					step = 0.1,
					min = 0,
					max = 5,
					get = function()
						return triggerData.flashDuration
					end,
					set = function(newValue)
						triggerData.flashDuration = newValue
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				flashInHoldTime = {
					type = 'range',
					name = LSFlash["Flash In Hold Time"],
					desc = LSFlash["Number of seconds to hold the fully hidden state."],
					step = 0.1,
					min = 0,
					max = 5,
					get = function()
						return triggerData.flashInHoldTime
					end,
					set = function(newValue)
						triggerData.flashInHoldTime = newValue
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				flashOutHoldTime = {
					type = 'range',
					name = LSFlash["Flash Out Hold Time"],
					desc = LSFlash["Number of seconds to hold the fully visible state."],
					step = 0.1,
					min = 0,
					max = 5,
					get = function()
						return triggerData.flashOutHoldTime
					end,
					set = function(newValue)
						triggerData.flashOutHoldTime = newValue
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
			},
		}
	return menuTable
	end
}