-- Retort, a TextSpy component
-- Recluse@Norgannon
-- If enabled for a trigger, sends a message of the users design to another user.
-- By default, it will whisper the user who spoke the words which fired the trigger.
-- There is an option which you can type in the name of a user you would like to send to instead.
local LRetort = AceLibrary("AceLocale-2.2"):new("TextSpy_Retort")
LRetort:RegisterTranslations("enUS", function() return {
	["Retort"] = true,
	["Sends a message when a trigger is fired."] = true,
	["Settings"] = true,
	["Enable"] = true,
	["Enable this trigger to send a message when fired."] = true,
	["Retort to Author"] = true,
	["If enabled, the message will be sent to whoever wrote the text which fired this trigger. NOTE: If message was not sent by a user, nothing will be sent to anyone."] = true,
	["Retort to..."] = true,
	["You chose not to reply to the author - enter here the name of a user to send this message to."] = true,
	["Message"] = true,
	["Enter the message to send."] = true,
	["Any message. %s is replaced by any pattern captures used in your pattern."] = true,

	-- I'm not for certain if these two need to be translated when used in SendChatMessage()
	-- If translating, please test in-game before submitting (please XD)
	["Common"] = true,
	["Orcish"] = true,
} end)
LRetort:RegisterTranslations("deDE", function() return {
	["Retort"] = true,
	["Sends a message when a trigger is fired."] = true,
	["Settings"] = true,
	["Enable"] = "Aktivieren",
	["Enable this trigger to send a message when fired."] = true,
	["Retort to Author"] = true,
	["If enabled, the message will be sent to whoever wrote the text which fired this trigger. NOTE: If message was not sent by a user, nothing will be sent to anyone."] = true,
	["Retort to..."] = true,
	["You chose not to reply to the author - enter here the name of a user to send this message to."] = true,
	["Message"] = true,
	["Enter the message to send."] = true,
	["Any message. %s is replaced by any pattern captures used in your pattern."] = true,

	-- I'm not for certain if these two need to be translated when used in SendChatMessage()
	-- If translating, please test in-game before submitting (please XD)
	["Common"] = true,
	["Orcish"] = true,
} end)

TextSpy.componentList["retort"] = {
	name = LRetort["Retort"],
	desc = LRetort["Sends a message when a trigger is fired."],
	triggerDefaults = {
		enabled = false,
		useAuthor = true,
		replyTo = "",
		message = "",
	},
	functions = {
		fire = function(data)
		end,
		postFire = function(data)
			-- AFICT the pre-release bug is now fixed...
			-- Essentially the author must exist OR the user has to have selected not to use the author and have a custom user defined.
			-- Oddly, just making sure the author was > 0 length and/or that author was not "" still made it past the check here. Not sure why, but this exhaustive check seems to have fixed it.
			if (string.len(data.event.author) > 0) or ((not TextSpy.db.profile.triggers[data.index]["retort"].useAuthor) and (string.len(TextSpy.db.profile.triggers[data.index]["retort"].replyTo) > 0)) then
				if TextSpy.db.profile.triggers[data.index]["retort"].useAuthor then -- Make sure the text has an author and that the user wants us to send to the author
					sendToUser = data.event.author
				else
					sendToUser = TextSpy.db.profile.triggers[data.index]["retort"].replyTo
				end
				local messageToSend
				if (data.match) then
					messageToSend = string.format(TextSpy.db.profile.triggers[data.index]["retort"].message, data.match)
				else
					messageToSend = TextSpy.db.profile.triggers[data.index]["retort"].message
				end
				-- Get player's faction and use the 'common' language for that faction.
				local userFaction, langOut
				userFaction, _ = UnitFactionGroup("player")
				if userFaction == "Alliance" then
					langOut = LRetort["Common"]
				else
					langOut = LRetort["Orcish"]
				end
				SendChatMessage(messageToSend, "WHISPER", langOut, sendToUser)
			end
		end,
	},
	triggerMenu = function(index)
		local triggerData
		if index == 0 then
			triggerData = TextSpy.db.profile.global["retort"]
		else
			triggerData = TextSpy.db.profile.triggers[index]["retort"]
		end
		menuTable = {
			type = 'group',
			name = LRetort["Retort"],
			desc = LRetort["Settings"],
			hidden = function()
				return not TextSpy.db.profile.components["retort"].enabled
			end,
			args = {
				enable = {
					type = 'toggle',
					name = LRetort["Enable"],
					desc = LRetort["Enable this trigger to send a message when fired."],
					get = function()
						return triggerData.enabled
					end,
					set = function()
						triggerData.enabled = not triggerData.enabled
					end,
					order = 5,
				},
				spacerOne = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled -- hide the spacer if not enabled
					end,
					order = 10,
				},
				useAuthor = {
					type = 'toggle',
					name = LRetort["Retort to Author"],
					desc = LRetort["If enabled, the message will be sent to whoever wrote the text which fired this trigger. NOTE: If message was not sent by a user, nothing will be sent to anyone."],
					get = function()
						return triggerData.useAuthor
					end,
					set = function()
						triggerData.useAuthor = not triggerData.useAuthor
					end,
					order = 15,
					-- Hides this setting if the component is not enabled for this trigger
					hidden = function()
						return not triggerData.enabled
					end,
				},
				toAuthor = {
					type = 'text',
					name = LRetort["Retort to..."],
					desc = LRetort["You chose not to reply to the author - enter here the name of a user to send this message to."],
					usage = "Username",
					get = function()
						return triggerData.replyTo
					end,
					set = function(newUser)
						triggerData.replyTo = newUser
					end,
					order = 20,
					hidden = function()
						return ((not triggerData.enabled) or triggerData.useAuthor)
					end,
				},
				spacerTwo = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled
					end,
					order = 25,
				},
				sendMessage = {
					type = 'text',
					name = LRetort["Message"],
					desc = LRetort["Enter the message to send."],
					usage = LRetort["Any message. %s is replaced by any pattern captures used in your pattern."],
					get = function()
						return triggerData.message
					end,
					set = function(newMessage)
						triggerData.message = newMessage
					end,
					order = 30,
					hidden = function()
						return not triggerData.enabled
					end,
				},
			},
		}
	return menuTable
	end
}