-- Combat Text, a TextSpy component
-- Recluse@Norgannon
-- Allows triggers to send the name of the trigger or a custom text message through combat text addons
-- Supports SCT, MSBT, and Parrot
local LCText = AceLibrary("AceLocale-2.2"):new("TextSpy_CombatText")
LCText:RegisterTranslations("enUS", function() return {
	["Combat Text"] = true,
	["Allows triggers to send text to combat text addons.  Currently supports MSBT, Parrot, and SCT"] = true,
	["Settings"] = true,
	["Enable"] = true,
	["Enable this trigger to send text via combat text addons."] = true,
	["SCT Options"] = true,
	["SCT Detected. Set options here."] = true,
	["Output this trigger to SCT"] = true,
	["Custom Output"] = true,
	["If checked, you can specify what text will be output. Unchecked, TextSpy will send the name of the trigger."] = true,
	["Custom Text"] = true,
	["Enter the custom text that will be shown for this trigger.  If not set, TextSpy will send the name of the trigger.  If you used pattern matching to return a capture, use %s to insert it in your text."] = true,
	["Output text"] = true,
	["Crit Modifier"] = true,
	["Add a crit modifier to the output"] = true,
	["SCT Output Frame"] = true,
	["Select the SCT frame to send the text to."] = true,
	["Color Settings"] = true,
	["Change the color of the output text"] = true,
	["Parrot Options"] = true,
	["Parrot Detected. Set options here."] = true,
	["Output this trigger to Parrot"] = true,
	["Parrot Output Frame"] = true,
	["or a custom frame you created"] = true,
	["MSBT Options"] = true,
	["MSBT Detected. Set options here."] = true,
	["Output this trigger to MSBT"] = true,
	["MSBT Output Frame"] = true,
} end)
LCText:RegisterTranslations("deDE", function() return {
	["Combat Text"] = true,
	["Allows triggers to send text to combat text addons.  Currently supports MSBT, Parrot, and SCT"] = true,
	["Settings"] = true,
	["Enable"] = "Aktivieren",
	["Enable this trigger to send text via combat text addons."] = true,
	["SCT Options"] = "Optionen: SCT",
	["SCT Detected. Set options here."] = "SCT entdeckt. Optionen hier festlegen.",
	["Output this trigger to SCT"] = "Diesen Ausl\195\182ser \195\188ber SCT ausgeben",
	["Custom Output"] = "Benutzerdefinierte Ausgabe",
	["If checked, you can specify what text will be output. Unchecked, TextSpy will send the name of the trigger."] = "Wenn markiert, kannst du den Ausgabetext bestimmen. Falls nicht markiert, sendet TextSpy den Namen des Ausl\195\182sers.",
	["Custom Text"] = "Benutzerdefinierter Text",
	["Enter the custom text that will be shown for this trigger.  If not set, TextSpy will send the name of the trigger.  If you used pattern matching to return a capture, use %s to insert it in your text."] = "Gib den benutzerdefinierten Text ein der f\195\188r diesen Ausl\195\182ser angezeigt werden soll.  Wenn nicht festgelegt, wird TextSpy den Namen des Ausl\195\182sers senden.  If you used pattern matching to return a capture, use %s to insert it in your text.",
	["Output text"] = "Ausgabetext",
	["Crit Modifier"] = "Crit-Modifikator",
	["Add a crit modifier to the output"] = "Einen Crit-Modifikator zur Ausgabe hinzuf\195\188gen",
	["SCT Output Frame"] = "SCT Output Frame",
	["Select the SCT frame to send the text to."] = "W\195\164hle den SCT-Frame, an welchen der Text gesendet werden soll.",
	["Color Settings"] = "Farbeinstellungen",
	["Change the color of the output text"] = "Die Farbe des Output-Textes \195\164ndern",
	["Parrot Options"] = "Optionen: Parrot",
	["Parrot Detected. Set options here."] = "Parrot entdeckt. Optionen hier festlegen.",
	["Output this trigger to Parrot"] = "Diesen Ausl\195\182ser \195\188ber Parrot ausgeben",
	["Parrot Output Frame"] = "Parrot Output Frame",
	["or a custom frame you created"] = "oder ein benutzerdefiniertes Fenster welches du erstellt hast",
	["MSBT Options"] = "Optionen: MSBT",
	["MSBT Detected. Set options here."] = "MSBT entdeckt. Optionen hier festlegen.",
	["Output this trigger to MSBT"] = "Diesen Ausl\195\182ser \195\188ber MSBT ausgeben",
	["MSBT Output Frame"] = "MSBT Output Frame",
} end)

TextSpy.componentList["combatText"] = {
	name = LCText["Combat Text"],
	desc = LCText["Allows triggers to send text to combat text addons.  Currently supports MSBT, Parrot, and SCT"],
	triggerDefaults = {
		enabled = false,
		customText = "",
		sct = { -- SCT default settings
			enabled = false,
			critmodifier = false,
			frame = "10",
			usecustomtext = false,
			customtext = "",
			color = {
				r = 1,
				g = 1,
				b = 1,
			},
		},
		parrot = { -- Parrot default settings
			enabled = false,
			critmodifier = false,
			frame = "Notification",
			usecustomtext = false,
			customtext = "",
			color = {
				r = 1,
				g = 1,
				b = 1,
			},
		},
		msbt = { -- MSBT default settings
			enabled = false,
			critmodifier = false,
			frame = "1",
			usecustomtext = false,
			customtext = "",
			color = {
				r = 1,
				g = 1,
				b = 1,
			},
		},
	},
	functions = {
		fire = function(data)
			TextSpy.componentList["combatText"].functions.outputParrot(data.match, data.index)
			TextSpy.componentList["combatText"].functions.outputSCT(data.match, data.index)
			TextSpy.componentList["combatText"].functions.outputMSBT(data.match, data.index)
		end,
		postFire = function(data)
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Sends a TextSpy trigger to a Parrot output frame
		Arguments:
		integer - the index of the trigger we're going to attempt to send to SCT
		------------------------------------------------------------------------------------]]
		outputParrot = function(match, index)
			local parrotprefix = TextSpy.db.profile.triggers[index]["combatText"].parrot
			if (IsAddOnLoaded("Parrot")) then
				if ((Parrot:IsActive()) and parrotprefix.enabled) then
					local textmessage = ""
					if (parrotprefix.usecustomtext and parrotprefix.customtext and (parrotprefix.customtext ~= "")) then
						if (match) then
							textmessage = string.format(parrotprefix.customtext, match)
						else
							textmessage = parrotprefix.customtext
						end
					else
						textmessage = TextSpy.db.profile.triggers[index].name
					end
					Parrot:ShowMessage(textmessage, parrotprefix.frame, parrotprefix.critmodifier, parrotprefix.color.r, parrotprefix.color.g, parrotprefix.color.b)
				end
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Sends a TextSpy trigger to an SCT output frame
		Arguments:
		integer - the index of the trigger we're going to attempt to send to SCT
		------------------------------------------------------------------------------------]]
		outputSCT = function(match, index)
			local sctprefix = TextSpy.db.profile.triggers[index]["combatText"].sct
			if (IsAddOnLoaded("SCT")) then
				if ((SCT:IsActive()) and sctprefix.enabled) then
					local textmessage = ""
					if (sctprefix.usecustomtext and sctprefix.customtext and (sctprefix.customtext ~= "")) then
						if (match) then
							textmessage = string.format(sctprefix.customtext, match)
						else
							textmessage = sctprefix.customtext
						end
					else
						textmessage = TextSpy.db.profile.triggers[index].name
					end
					if (sctprefix.frame == "10") then
						SCT:DisplayMessage(textmessage, sctprefix.color)
					else
						SCT:DisplayText(textmessage, sctprefix.color, sctprefix.critmodifier, "damage", tonumber(sctprefix.frame), nil, nil, nil);
					end
				end
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Sends a TextSpy trigger to a MSBT output frame
		Arguments:
		integer - the index of the trigger we're going to attempt to send to MSBT
		------------------------------------------------------------------------------------]]
		outputMSBT = function(match, index)
			local msbtprefix = TextSpy.db.profile.triggers[index]["combatText"].msbt
			if ((TextSpy.componentList["combatText"].functions.hasMSBT()) and (msbtprefix.enabled)) then
				local textmessage = ""
				if (msbtprefix.usecustomtext and msbtprefix.customtext and (msbtprefix.customtext ~= "")) then
					if (match) then
						textmessage = string.format(msbtprefix.customtext, match)
					else
						textmessage = msbtprefix.customtext
					end
				else
					textmessage = TextSpy.db.profile.triggers[index].name
				end
				MikSBT.DisplayMessage(textmessage, msbtprefix.frame, msbtprefix.critmodifier, msbtprefix.color.r * 255, msbtprefix.color.g * 255, msbtprefix.color.b * 255, nil, nil, nil) -- nils are fontsize, fontname, outline
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Checks to see if Parrot is loaded AND enabled
		Returns:
		* bool - True if Parrot is loaded and enabled. False if Parrot is not loaded and enabled.
		------------------------------------------------------------------------------------]]
		hasParrot = function()
			if (IsAddOnLoaded("Parrot")) then
				if Parrot:IsActive() then
					return true
				else
					return false
				end
			else
				return false
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Checks to see if SCT is loaded AND enabled
		Returns:
		* bool - True if SCT is loaded and enabled. False if SCT is not loaded and enabled.
		------------------------------------------------------------------------------------]]
		hasSCT = function()
			if (IsAddOnLoaded("SCT")) then
				if SCT:IsActive() then
					return true
				else
					return false
				end
			else
				return false
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Checks to see if SCTD is loaded
		* SCTD has no :IsActive() flag.  It appears to utilize the SCT:IsActive() flag to determine if it can be utilized.
		Returns:
		* bool - True if SCTD is loaded. False if SCTD is not loaded.
		------------------------------------------------------------------------------------]]
		hasSCTD = function()
			if (IsAddOnLoaded("SCTD")) then
				return true
			else
				return false
			end
		end,
		--[[----------------------------------------------------------------------------------
		Notes:
		* Checks to see if MSBT is loaded
		Returns:
		* bool - True if MSBT is loaded. False if MSBT is not loaded.
		------------------------------------------------------------------------------------]]
		hasMSBT = function()
			if ((_G.MikSBT) and (_G.MSBTProfiles) and (_G.MSBTProfiles.GetSavedVariables()) and (not (MSBTProfiles.GetSavedVariables().UserDisabled))) then
				return true
			else
				return false
			end
		end,
	},
	triggerMenu = function(index)
	local functionLink = TextSpy.componentList["combatText"].functions
	local triggerData
	if index == 0 then
		triggerData = TextSpy.db.profile.global["combatText"]
	else
		triggerData = TextSpy.db.profile.triggers[index]["combatText"]
	end
	menuTable = {
		type = 'group',
		name = LCText["Combat Text"],
		desc = LCText["Settings"],
		hidden = function()
			return not TextSpy.db.profile.components["combatText"].enabled
		end,
		args = {
			enable = {
				type = 'toggle',
				name = LCText["Enable"],
				desc = LCText["Enable this trigger to send text via combat text addons."],
				get = function()
					return triggerData.enabled
				end,
				set = function()
					triggerData.enabled = not triggerData.enabled
				end,
				order = 5,
			},
			spacerOne = {
				type = 'header',
				name = " ",
				hidden = function()
					return not triggerData.enabled
				end,
				order = 10,
			},
			triggersct = {
					type='group',
					name = LCText["SCT Options"],
					desc = LCText["SCT Detected. Set options here."],
					args = {
						triggersctenabled = {
							type='toggle',
							name = LCText["Enable"],
							desc = LCText["Output this trigger to SCT"],
							get = function()
								return triggerData.sct.enabled
							end,
							set = function()
								triggerData.sct.enabled = (not triggerData.sct.enabled)
							end,
							order = 10,
						},
						triggersctusecustomtext = {
							type = 'toggle',
							name = LCText["Custom Output"],
							desc = LCText["If checked, you can specify what text will be output. Unchecked, TextSpy will send the name of the trigger."],
							get = function()
								return triggerData.sct.usecustomtext
							end,
							set = function()
								triggerData.sct.usecustomtext = (not(triggerData.sct.usecustomtext))
							end,
							order = 14,
						},
						triggersctcutomtext = {
							type = 'text',
							name = LCText["Custom Text"],
							desc = LCText["Enter the custom text that will be shown for this trigger.  If not set, TextSpy will send the name of the trigger.  If you used pattern matching to return a capture, use %s to insert it in your text."],
							usage = LCText["Output text"],
							canCopy = true,
							copyType = "text",
							get = function()
								return triggerData.sct.customtext
							end,
							set = function(val)
								triggerData.sct.customtext = val
							end,
							hidden = function()
								return (not(triggerData.sct.usecustomtext))
							end,
							order = 15,
						},
						sctspacertwo = {
							name = " ",
							type = "header",
							order = 16,
							hidden = function()
								return triggerData.sct.usecustomtext
							end,
						},
						triggersctcritmodifier = {
							type='toggle',
							name = LCText["Crit Modifier"],
							desc = LCText["Add a crit modifier to the output"],
							get = function()
								return triggerData.sct.critmodifier
							end,
							set = function()
								triggerData.sct.critmodifier = (not triggerData.sct.critmodifier)
							end,
							order = 17,
						},
						triggersctframe = {
							type='text',
							name = LCText["SCT Output Frame"],
							desc = LCText["Select the SCT frame to send the text to."],
							usage = "SCT1, SCT2, SC3, SCTMSG",
							validate = {},
							get = function()
								return triggerData.sct.frame
							end,
							set = function(v) triggerData.sct.frame = v end,
							order = 20,
						},
						triggersctcolor = {
							type='color',
							name = LCText["Color Settings"],
							desc = LCText["Change the color of the output text"],
							get = function()
								return triggerData.sct.color.r, triggerData.sct.color.g, triggerData.sct.color.b
							end,
							set = function(r, g, b)
								triggerData.sct.color.r, triggerData.sct.color.g, triggerData.sct.color.b = r, g, b
							end,
							hasAlpha = false,
							order = 25,
						},
					},
					hidden = function()
						return (not(functionLink.hasSCT()) or not(triggerData.enabled))
					end,
					order = 15,
				},
			triggerparrot = {
			type='group',
			name = LCText["Parrot Options"],
			desc = LCText["Parrot Detected. Set options here."],
			args = {
				triggerparrotenabled = {
						type='toggle',
						name = LCText["Enable"],
						desc = LCText["Output this trigger to Parrot"],
						get = function()
							return triggerData.parrot.enabled
						end,
						set = function()
							triggerData.parrot.enabled = (not triggerData.parrot.enabled)
						end,
						order = 10,
					},
				triggerparrotusecustomtext = {
						type = 'toggle',
						name = LCText["Custom Output"],
						desc = LCText["If checked, you can specify what text will be output. Unchecked, TextSpy will send the name of the trigger."],
						get = function()
							return triggerData.parrot.usecustomtext
						end,
						set = function()
							triggerData.parrot.usecustomtext = (not(triggerData.parrot.usecustomtext))
						end,
						order = 14,
					},
				triggerparrotcutomtext = {
						type = 'text',
						name = LCText["Custom Text"],
						desc = LCText["Enter the custom text that will be shown for this trigger.  If not set, TextSpy will send the name of the trigger.  If you used pattern matching to return a capture, use %s to insert it in your text."],
						usage = LCText["Output text"],
						canCopy = true,
						copyType = "text",
						get = function()
							return triggerData.parrot.customtext
						end,
						set = function(val)
							triggerData.parrot.customtext = val
						end,
						hidden = function()
							return (not(triggerData.parrot.usecustomtext))
						end,
						order = 15,
					},
				parrotspacertwo = {
						name = " ",
						type = "header",
						order = 16,
						hidden = function()
							return triggerData.parrot.usecustomtext
						end,
					},
				triggerparrotcritmodifier = {
						type='toggle',
						name = LCText["Crit Modifier"],
						desc = LCText["Add a crit modifier to the output"],
						get = function()
							return triggerData.parrot.critmodifier
						end,
						set = function()
							triggerData.parrot.critmodifier = (not triggerData.parrot.critmodifier)
						end,
						order = 17,
					},
				triggerparrotframe = {
						type='text',
						name = LCText["Parrot Output Frame"],
						desc = "Notification, Incoming, Outgoing, "..LCText["or a custom frame you created"],
						usage = "Notification, Incoming",
						validate = {},
						get = function()
							return triggerData.parrot.frame
						end,
						set = function(v) triggerData.parrot.frame = v end,
						handler = self,
						order = 20,
					},
				triggerparrotcolor = {
						type='color',
						name = LCText["Color Settings"],
						desc = LCText["Change the color of the output text"],
						get = function()
							return triggerData.parrot.color.r, triggerData.parrot.color.g, triggerData.parrot.color.b
						end,
						set = function(r, g, b)
							triggerData.parrot.color.r, triggerData.parrot.color.g, triggerData.parrot.color.b = r, g, b
						end,
						hasAlpha = false,
						order = 25,
					},
			},
			hidden = function() 
				return (not(functionLink.hasParrot()) or not(triggerData.enabled))
			end,
			order = 20,
			},
			triggermsbt = {
				type='group',
				name = LCText["MSBT Options"],
				desc = LCText["MSBT Detected. Set options here."],
				args = {
					triggermsbtenabled = {
							type='toggle',
							name = LCText["Enable"],
							desc = LCText["Output this trigger to MSBT"],
							get = function()
								return triggerData.msbt.enabled
							end,
							set = function()
								triggerData.msbt.enabled = (not triggerData.msbt.enabled)
							end,
							order = 10,
						},
						triggermsbtusecustomtext = {
							type = 'toggle',
							name = LCText["Custom Output"],
							desc = LCText["If checked, you can specify what text will be output. Unchecked, TextSpy will send the name of the trigger."],
							get = function()
								return triggerData.msbt.usecustomtext
							end,
							set = function()
								triggerData.msbt.usecustomtext = (not(triggerData.msbt.usecustomtext))
							end,
							order = 14,
						},
						triggermsbtcutomtext = {
							type = 'text',
							name = LCText["Custom Text"],
							desc = LCText["Enter the custom text that will be shown for this trigger.  If not set, TextSpy will send the name of the trigger.  If you used pattern matching to return a capture, use %s to insert it in your text."],
							usage = "Output text",
							canCopy = true,
							copyType = "text",
							get = function()
								return triggerData.msbt.customtext
							end,
							set = function(val)
								triggerData.msbt.customtext = val
							end,
							hidden = function()
								return (not(triggerData.msbt.usecustomtext))
							end,
							order = 15,
						},
						msbtspacertwo = {
							name = " ",
							type = "header",
							order = 16,
							hidden = function()
								return triggerData.msbt.usecustomtext
							end,
						},
						triggermsbtcritmodifier = {
							type='toggle',
							name = LCText["Crit Modifier"],
							desc = LCText["Add a crit modifier to the output"],
							get = function()
								return triggerData.msbt.critmodifier
							end,
							set = function()
								triggerData.msbt.critmodifier = (not triggerData.msbt.critmodifier)
							end,
							order = 17,
						},
						triggermsbtframe = {
							type='text',
							name = LCText["MSBT Output Frame"],
							desc = "Notification, Incoming, Outgoing",
							usage = "Notification, Incoming",
							validate = {},
							get = function()
								return triggerData.msbt.frame
							end,
							set = function(v) triggerData.msbt.frame = v end,
							handler = self,
							order = 20,
						},
						triggermsbtcolor = {
							type='color',
							name = LCText["Color Settings"],
							desc = LCText["Change the color of the output text"],
							get = function()
								return triggerData.msbt.color.r, triggerData.msbt.color.g, triggerData.msbt.color.b
							end,
							set = function(r, g, b)
								triggerData.msbt.color.r, triggerData.msbt.color.g, triggerData.msbt.color.b = r, g, b
							end,
							hasAlpha = false,
							order = 25,
						},
					},
					hidden = function() 
						return (not(functionLink.hasMSBT()) or not(triggerData.enabled))
					end,
					order = 25,
				},
			},
		}
		-- Generate the output frame choices
		if functionLink.hasParrot() then
			-- Newer Rock-based Parrot has a different database.  We check for it first.
			-- If the new database style returns nil, then we go back to the old style.
			if (Parrot.db.raw.namespaces.ScrollAreas.profiles.Default.areas) then
				for k, v in pairs(Parrot.db.raw.namespaces.ScrollAreas.profiles.Default.areas) do
					menuTable.args.triggerparrot.args.triggerparrotframe.validate[k] = k
				end
			else
				for k, v in pairs(Parrot.db.namespaces.ScrollAreas.db.namespaces.ScrollAreas.profile.areas) do
					menuTable.args.triggerparrot.args.triggerparrotframe.validate[k] = k
				end
			end
		end
		if (functionLink.hasSCTD() and functionLink.hasSCT()) then
			menuTable.args.triggersct.args.triggersctframe.validate = {
				["1"] = "SCT1",
				["2"] = "SCT2",
				["3"] = "SCTD",
				["10"] = "SCTMSG",
			}
		elseif functionLink.hasSCT() then
			menuTable.args.triggersct.args.triggersctframe.validate = {
				["1"] = "SCT1",
				["2"] = "SCT2",
				["10"] = "SCTMSG",
			}
		end
		if (functionLink.hasMSBT()) then
			for k,v in pairs(MSBTProfiles.CurrentProfile.ScrollAreaSettings) do
				menuTable.args.triggermsbt.args.triggermsbtframe.validate[k] = v.Name
			end
		end
		return menuTable
	end,
}