-- Audio Alerts, a TextSpy component
-- Recluse@Norgannon
-- Plays a user-defined sound file when a trigger is fired.
-- TODO: I'd love to get SharedMedia integrated, but swapping to it would endanger the whole "custom sound"
--		ability. As an option perhaps "SharedMedia >" "[] Use custom sound" or something?
local LAAlerts = AceLibrary("AceLocale-2.2"):new("TextSpy_AudioAlerts")
LAAlerts:RegisterTranslations("enUS", function() return {
	["Audio Alerts"] = true,
	["Allows triggers to play a sound file."] = true,
	["Settings"] = true,
	["Enable"] = true,
	["Enable this trigger to play a sound file when fired."] = true,
	["Multiple Sounds"] = true,
	["If checked, you will be allowed to specify up to 5 sound files, the one played will be chosen at random."] = true,
	["Quantity"] = true,
	["Select how many sound files to choose from at random"] = true,
	["Sound file"] = true,
	["If fired, this trigger will play the sound file you enter here."] = true,
} end)
LAAlerts:RegisterTranslations("deDE", function() return {
	["Audio Alerts"] = true,
	["Allows triggers to play a sound file."] = true,
	["Settings"] = true,
	["Enable"] = "Aktivieren",
	["Enable this trigger to play a sound file when fired."] = "Aktiviert die Ton-Benachrichtigung f\195\188r diesen Ausl\195\182ser",
	["Multiple Sounds"] = true,
	["If checked, you will be allowed to specify up to 5 sound files, the one played will be chosen at random."] = true,
	["Quantity"] = true,
	["Select how many sound files to choose from at random"] = true,
	["Sound file"] = "Ausl\195\182ser: Ton",
	["If fired, this trigger will play the sound file you enter here."] = true,
} end)

TextSpy.componentList["audioAlerts"] = {
	name = LAAlerts["Audio Alerts"],
	desc = LAAlerts["Allows triggers to play a sound file."],
	audioDir = "Interface\\AddOns\\TextSpy\\media\\audio\\",
	triggerDefaults = {
		enabled = false,
		multiSound = false,
		numberSounds = 2, -- Minimum for use with multiSound, not checked if multiSound == false.
		soundfile = "",
		soundFileTwo = "", -- These should really go into an array, but doing so would make users enter the values all over again.
		soundFileThree = "",
		soundFileFour = "",
		soundFileFive = "",
	},
	functions = {
		fire = function(data)
			soundToPlay = ""
			if TextSpy.db.profile.triggers[data.index]["audioAlerts"].multiSound then
				randomSound = math.random(1, TextSpy.db.profile.triggers[data.index]["audioAlerts"].numberSounds)
				if randomSound == 1 then
					soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundfile
				elseif randomSound == 2 then
					soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundFileTwo
				elseif randomSound == 3 then
					soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundFileThree
				elseif randomSound == 4 then
					soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundFileFour
				elseif randomSound == 5 then
					soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundFileFive
				end
			else
				soundToPlay = TextSpy.db.profile.triggers[data.index]["audioAlerts"].soundfile
			end
			PlaySoundFile(TextSpy.componentList["audioAlerts"].audioDir..soundToPlay)
		end,
		postFire = function(data)
		end,
	},
	triggerMenu = function(index)
		local triggerData
		if index == 0 then
			triggerData = TextSpy.db.profile.global["audioAlerts"]
		else
			triggerData = TextSpy.db.profile.triggers[index]["audioAlerts"]
		end
		menuTable = {
			type = 'group',
			name = LAAlerts["Audio Alerts"],
			desc = LAAlerts["Settings"],
			hidden = function()
				return not TextSpy.db.profile.components["audioAlerts"].enabled
			end,
			args = {
				enable = {
					type = 'toggle',
					name = LAAlerts["Enable"],
					desc = LAAlerts["Enable this trigger to play a sound file when fired."],
					get = function()
						return triggerData.enabled
					end,
					set = function()
						triggerData.enabled = not triggerData.enabled
					end,
					order = 5,
				},
				spacerOne = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled
					end,
					order = 10,
				},
				multiSound = {
					type = 'toggle',
					name = LAAlerts["Multiple Sounds"],
					desc = LAAlerts["If checked, you will be allowed to specify up to 5 sound files, the one played will be chosen at random."],
					get = function()
						return triggerData.multiSound
					end,
					set = function()
						triggerData.multiSound = not triggerData.multiSound
					end,
					order = 15,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				numberSounds = {
					type = 'range',
					name = LAAlerts["Quantity"],
					desc = LAAlerts["Select how many sound files to choose from at random"],
					step = 1.0,
					min = 2,
					max = 5,
					get = function()
						return triggerData.numberSounds
					end,
					set = function(newNumber)
						triggerData.numberSounds = newNumber
					end,
					order = 20,
					hidden = function()
						return (not triggerData.enabled) or (not triggerData.multiSound)
					end,
				},
				spacerTwo = {
					type = 'header',
					name = " ",
					hidden = function()
						return not triggerData.enabled
					end,
					order = 25,
				},
				sound = {
					type = 'text',
					name = LAAlerts["Sound file"],
					desc = LAAlerts["If fired, this trigger will play the sound file you enter here."],
					usage = "mysound.mp3",
					get = function()
						return triggerData.soundfile
					end,
					set = function(newSound)
						triggerData.soundfile = newSound
					end,
					order = 30,
					hidden = function()
						return not triggerData.enabled
					end,
				},
				soundTwo = {
					type = 'text',
					name = LAAlerts["Sound file"].." 2",
					desc = LAAlerts["If fired, this trigger will play the sound file you enter here."],
					usage = "mysound.mp3",
					get = function()
						return triggerData.soundFileTwo
					end,
					set = function(newSound)
						triggerData.soundFileTwo = newSound
					end,
					order = 35,
					hidden = function()
						return (not triggerData.enabled) or (not((triggerData.multiSound) and (triggerData.numberSounds > 1)))
					end,
				},
				soundThree = {
					type = 'text',
					name = LAAlerts["Sound file"].." 3",
					desc = LAAlerts["If fired, this trigger will play the sound file you enter here."],
					usage = "mysound.mp3",
					get = function()
						return triggerData.soundFileThree
					end,
					set = function(newSound)
						triggerData.soundFileThree = newSound
					end,
					order = 40,
					hidden = function()
						return (not triggerData.enabled) or (not((triggerData.multiSound) and (triggerData.numberSounds > 2)))
					end,
				},
				soundFour = {
					type = 'text',
					name = LAAlerts["Sound file"].." 4",
					desc = LAAlerts["If fired, this trigger will play the sound file you enter here."],
					usage = "mysound.mp3",
					get = function()
						return triggerData.soundFileFour
					end,
					set = function(newSound)
						triggerData.soundFileFour = newSound
					end,
					order = 45,
					hidden = function()
						return (not triggerData.enabled) or (not((triggerData.multiSound) and (triggerData.numberSounds > 3)))
					end,
				},
				soundFive = {
					type = 'text',
					name = LAAlerts["Sound file"].." 5",
					desc = LAAlerts["If fired, this trigger will play the sound file you enter here."],
					usage = "mysound.mp3",
					get = function()
						return triggerData.soundFileFive
					end,
					set = function(newSound)
						triggerData.soundFileFive = newSound
					end,
					order = 50,
					hidden = function()
						return (not triggerData.enabled) or (not((triggerData.multiSound) and (triggerData.numberSounds > 4)))
					end,
				},
			},
		}
	return menuTable
	end
}