local TBS_trans = LibStub("LibBabble-Spell-3.0"):GetLookupTable();
TBSrules={};
TargetBuffSort_Config={};
TBS_BuffData={}
TBS_DebuffData={}

function TBS_translate_table(bf)
	if TBS_trans then
		for si,sv in ipairs(bf) do
			bf[si]=TBS_trans:GetTranslation(sv);
		end
	end
end


function TBS_translate(bf)
	if TBS_trans then
		return TBS_trans:GetTranslation(bf);
	else
		return bf;
	end

end

function TBS_findbuff(index,buffname,icon)
	TBSScanningTooltip:ClearLines()
	TBSScanningTooltip:SetUnitBuff("target",index)
	local bufftype=TBSScanningTooltipTextRight1:GetText()
	local buffdescribe=TBSScanningTooltipTextLeft2:GetText()
	local bi,bv;
	for bi,bv in ipairs(TBS_BuffData) do
		if (not bv.isfriend) or (bv.isfriend==1 and UnitIsFriend("player","target")) or (bv.isfriend==0 and not UnitIsFriend("player","target")) then

			if bv.all then
				return bi
			end
			if bv.bufftype then
				for i,v in ipairs(bv.bufftype) do
					if bufftype==v then
						return bi
					end
				end
			end

			if bv.string then
				for i,v in ipairs(bv.string) do
					if buffname==v then
						return bi
					end
				end
			end
			if bv.stringpattern then
				for i,v in ipairs(bv.stringpattern) do
					if string.find(buffname,v) then
						return bi
					end
				end
			end
			if bv.describe then
				for i,v in ipairs(bv.describe) do
					if string.find(buffdescribe,v) then
						return bi
					end
				end
			end
			if icon and bv.texture then
				for i,v in ipairs(bv.texture) do
					if string.match(icon,v) then
						return bi
					end
				end
			end
		end
	end
	return table.maxn(TBS_BuffData)
end

function TBS_finddebuff(index,buffname,icon)
	TBSScanningTooltip:ClearLines()
	TBSScanningTooltip:SetUnitDebuff("target",index)
	local bufftype=TBSScanningTooltipTextRight1:GetText()
	local buffdescribe=TBSScanningTooltipTextLeft2:GetText()
	local bi,bv;
	for bi,bv in ipairs(TBS_DebuffData) do
		if (not bv.isfriend) or (bv.isfriend==1 and UnitIsFriend("player","target")) or (bv.isfriend==0 and not UnitIsFriend("player","target")) then

			if bv.all then
				return bi
			end
			if bv.bufftype then
				for i,v in ipairs(bv.bufftype) do
					if bufftype==bv.bufftype then
						return bi
					end
				end
			end
			if bv.stringpattern then
				for i,v in ipairs(bv.stringpattern) do
					if string.find(buffname,v) then
						return bi
					end
				end
			end
			if bv.string then
				for i,v in ipairs(bv.string) do
					if buffname==v then
						return bi
					end
				end
			end
			if icon and bv.texture then
				for i,v in ipairs(bv.texture) do
					if string.match(icon,v) then
						return bi
					end
				end
			end
			if bv.describe then
				for i,v in ipairs(bv.describe) do
					if string.find(buffdescribe,v) then
						return bi
					end
				end
			end

		end
	end
	return table.maxn(TBS_DebuffData)
end

function TBS_buff_type(unit)
	TBSScanningTooltip:ClearLines()
	TBSScanningTooltip:SetUnitDebuff(unit)
	return TBSScanningTooltipTextRight1:GetText()
end

function TBSrules_AddBuff(nm,bf)
	if not TBSbuffrules then
		TBSbuffrules={}
	end
	for i,v in ipairs(TBSrules) do
		if v.name==nm then
			return
		end
	end

	table.insert(TBSbuffrules,{name=nm,string=bf})
end

function TBSrules_AddDebuff(nm,bf)
	if not TBSdebuffrules then
		TBSdebuffrules={}
	end
	for i,v in ipairs(TBSdebuffrules) do
		if v.name==nm then
			return
		end
	end

	table.insert(TBSdebuffrules,{name=nm,string=bf})
end

function TBSrules_Remove(nm)
	if not TBSrules then
		TBSrules={}
		return
	end
	for i,v in ipairs(TBSrules) do
		if v.name==nm then
			table.remove(TBSrules,i)
		end
	end
end


-- BuffCooldownDisplay
local function BuffCooldownDisplay(self)
	local t = GetTime()
	if (t > self.endTime - 1) then
		self.countdown:SetText(strsub(format("%.1f", max(0, self.endTime - t)), 2, 10))
		self.countdown:Show()
	elseif (t > self.endTime - 59) then
		self.countdown:SetText(max(0, floor(self.endTime - t)))
		self.countdown:Show()
	elseif (t > self.endTime - 590) then
		self.countdown:SetText(max(0, floor((self.endTime - t)/60)).."m")
		self.countdown:Show()
	else
		self.countdown:Hide()
	end
end

function TBS_CooldownFrame_SetTimer(self, start, duration, enable)
	if ( start > 0 and duration > 0 and enable > 0) then
		self:SetCooldown(start, duration)
		self.endTime = start + duration

		if (TargetBuffSort_Config.countdown) then
			self:SetScript("OnUpdate", BuffCooldownDisplay)
		else
			self:SetScript("OnUpdate", nil)
			self.countdown:Hide()
		end

		self:Show()
	else
		self:Hide()
	end
end


