local bs_text_max=20;
local TBS_PLAYER_CLASS;
local TBS_hook_Target_Spellbar_AdjustPosition=Target_Spellbar_AdjustPosition
TBS_MAX_TARGET_DEBUFFS=40
TBS_MAX_TARGET_BUFFS=40

function TBS_Target_Spellbar_AdjustPosition()
	TargetFrameSpellBar:ClearAllPoints();
	TargetFrameSpellBar:SetPoint("TOPLEFT", "TargetBuffSort", "BOTTOMLEFT", 10, -5);
end

function TBS_alpha()
	TargetBuffSort:SetAlpha(TargetBuffSort_Config.alpha)
end

function TBS_enablemouse(tf)
		for i=1, TBS_MAX_TARGET_BUFFS do
			button = getglobal("TargetBuffSortBuff"..i);
			button:EnableMouse(tf)
		end
		for i=1, TBS_MAX_TARGET_DEBUFFS do
			button = getglobal("TargetBuffSortDebuff"..i);
			button:EnableMouse(tf)
		end
	end
function  TBS_setanchor()
	if TargetBuffSort_Config.anchor_targetframe then
		TargetBuffSort:ClearAllPoints();
		TargetBuffSort:SetPoint("TOPLEFT", TargetFrame, "BOTTOMLEFT",TargetFrame.buffStartX-20, TargetFrame.buffStartY);
		Target_Spellbar_AdjustPosition=TBS_Target_Spellbar_AdjustPosition
	--	TargetBuffSort:SetPoint("TOPLEFT", TargetFrameSpellBar, "BOTTOMLEFT",0,0);
		TargetBuffSortClickArea:Hide();
	else
	--	TargetBuffSort:ClearAllPoints();
		TargetBuffSortClickArea:Show()
		Target_Spellbar_AdjustPosition=TBS_hook_Target_Spellbar_AdjustPosition

	end
	if TargetBuffSort_Config.hideblz then
		for i=1, MAX_TARGET_DEBUFFS do
			button = getglobal("TargetFrameDebuff"..i);
			if button then
				button:SetAlpha(0);
			end
		end
		for i=1,MAX_TARGET_BUFFS do
			button = getglobal("TargetFrameBuff"..i);
			if button then
				button:SetAlpha(0);
			end
		end
		MAX_TARGET_DEBUFFS=0;
		MAX_TARGET_BUFFS=0;
	else
		MAX_TARGET_DEBUFFS=16;
		MAX_TARGET_BUFFS=32;
		for i=1, MAX_TARGET_DEBUFFS do
			button = getglobal("TargetFrameDebuff"..i);
			if button then
				button:SetAlpha(1);
			end
		end
		for i=1, MAX_TARGET_BUFFS do
			button = getglobal("TargetFrameBuff"..i);
			if button then
				button:SetAlpha(1);
			end
		end
	end

	if TargetBuffSort_Config.lockwindow then 
 		TargetBuffSortClickArea:Hide();
		TargetBuffSort:SetMovable(false);

	else
 		TargetBuffSortClickArea:Show();
		TargetBuffSort:SetMovable(true);
	end
	if TargetBuffSort_Config.enablemouse then
		TBS_enablemouse(true);
	else
		TBS_enablemouse(false);
	end

end


function TBS_slashcmd(msg)
	if msg=='lock' then
		if TargetBuffSort_Config.lockwindow then 
			SELECTED_CHAT_FRAME:AddMessage("TBS: Unlocked", 0.0, 0.9, 0.9)
			TargetBuffSortClickArea:Show();
			TargetBuffSort_Config.lockwindow=nil;
		else
			SELECTED_CHAT_FRAME:AddMessage("TBS: Locked", 0.0, 0.9, 0.9)
			TargetBuffSortClickArea:Hide();
			TargetBuffSort_Config.lockwindow=1;
		end
	else
		getglobal("TargetBuffSortOptions"):Show();
	end
end

function TBS_maketable()
	TBS_BuffData={}
	TBS_DebuffData={}
	local player_class
	_,player_class=UnitClass("player")
	local buffentry=getglobal(TBSbuffrules[TargetBuffSort_Config.buffrule].string);
	local debuffentry=getglobal(TBSdebuffrules[TargetBuffSort_Config.debuffrule].string)
	if TargetBuffSort_Config.sortdispelabledebuff then
		if player_class=="PRIEST" then
			table.insert(TBS_DebuffData,TBS_Magic)
			table.insert(TBS_DebuffData,TBS_Disease)
		end
		if player_class=="PALADIN" then
			table.insert(TBS_DebuffData,TBS_Magic)
			table.insert(TBS_DebuffData,TBS_Disease)
			table.insert(TBS_DebuffData,TBS_Poison)
		end
		if player_class=="DRUID" then
			table.insert(TBS_DebuffData,TBS_Poison)
			table.insert(TBS_DebuffData,TBS_Curse)
		end
		if player_class=="SHAMAN" then
			table.insert(TBS_DebuffData,TBS_Poison)
			table.insert(TBS_DebuffData,TBS_Disease)
		end
		if player_class=="MAGE" then
			table.insert(TBS_DebuffData,TBS_Curse)
		end
	end
	if TargetBuffSort_Config.sortdispelablebuff then
		if player_class=="PRIEST" or player_class=="SHAMAN" or player_class=="MAGE" or player_class=="WARLOCK" then
			table.insert(TBS_BuffData,TBS_Dispel)
		end
	end


	for i,v in ipairs(buffentry) do
		table.insert(TBS_BuffData,v)
	end
	table.insert(TBS_BuffData,TBS_OtherBuff)

	for i,v in ipairs(debuffentry) do
		table.insert(TBS_DebuffData,v)
	end
	table.insert(TBS_DebuffData,TBS_OtherDebuff)

	TBS_resizetitle();
end

function TBS_resizetitle()
	for i=1,60 do
		local text = getglobal("TargetBuffSortText"..i);
		if text then
			text:Hide()
		else
			break
		end
	end
	for i=1,60 do
		local text = getglobal("TargetBuffSortText"..i.."d");
		if text then
			text:Hide()
		else
			break
		end
	end
	TargetBuffSortTextMine:SetHeight(TargetBuffSort_Config.iconsize*1.5)


	if TargetBuffSort_Config.compacttitle then
		TargetBuffSortTextMine:SetText("@");
		TargetBuffSortTextMine:SetWidth(14);
	else
		TargetBuffSortTextMine:SetText("Mine");
		TargetBuffSortTextMine:SetWidth(40);
	end

	for i,v in ipairs(TBS_BuffData) do
		local text = getglobal("TargetBuffSortText"..i);
		if ( not text ) then
			text = TargetBuffSort:CreateFontString("TargetBuffSortText"..i, "ARTWORK", "GameFontNormal");
			text:SetJustifyH("CENTER");
		end
		text:SetHeight(TargetBuffSort_Config.iconsize);
		if TargetBuffSort_Config.compacttitle then
			text:SetText(string.sub(v.class,1,1));
			text:SetWidth(14);
		else
			text:SetText(v.class);
			text:SetWidth(40);
		end
		text:SetTextColor(0,1,0)
	end
	for i,v in ipairs(TBS_DebuffData) do
		local text = getglobal("TargetBuffSortText"..i.."d");
		if ( not text ) then
			text = TargetBuffSort:CreateFontString("TargetBuffSortText"..i.."d", "ARTWORK", "GameFontNormal");
			text:SetJustifyH("CENTER");
		end
		text:SetHeight(TargetBuffSort_Config.iconsize);
		if TargetBuffSort_Config.compacttitle then
			text:SetText(string.sub(v.class,1,1));
			text:SetWidth(14);
		else
			text:SetText(v.class);
			text:SetWidth(40);
		end
		text:SetTextColor(1,0,0)
	end

end


function TargetBuffSort_OnLoad()

	local previous_text=getglobal("TargetBuffSortTextMine");
	--	TBS_loaddata();
	TargetBuffSort_CreateHighlight();
	SLASH_TARGETBUFFSORT1 = "/tbs";
	SLASH_TARGETBUFFSORT2 = "/targetbuffsort";

	SlashCmdList["TARGETBUFFSORT"] = TBS_slashcmd;

	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("UNIT_AURA");
end
function TargetBuffSort_Update()
	-- This check is here so the frame will hide when the target goes away
	-- even if some of the functions below are hooked by addons.
	if ( not UnitExists("target") ) then
		this:Hide();
	else
		this:Show();

		TargetBuffSort_real_Update();
	end
end

function TargetBuffSort_OnEvent(event)
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		if not TargetBuffSort_Config.buffrule then
			TargetBuffSort_Config.buffrule=1
		end
		if not TargetBuffSort_Config.debuffrule then
			TargetBuffSort_Config.debuffrule=1
		end
		if not TargetBuffSort_Config.highlight then
			TargetBuffSort_Config.highlight=""
		end
		if not TargetBuffSort_Config.iconsize then
			TargetBuffSort_Config.iconsize=20
		end
		if not TargetBuffSort_Config.alpha then
			TargetBuffSort_Config.alpha=1
		end
		if not TargetBuffSort_Config.enablemouse then
			TargetBuffSort_Config.enablemouse=1
		end

		for i=1, TBS_MAX_TARGET_BUFFS do
			button = getglobal("TargetBuffSortBuff"..i);
			if ( not button ) then
				button = CreateFrame("Button", "TargetBuffSortBuff"..i, TargetBuffSort, "TBS_BuffButtonTemplate");
				button:SetFrameStrata("MEDIUM")
				button.id=i;
			end
		end
		for i=1, TBS_MAX_TARGET_DEBUFFS do
			button = getglobal("TargetBuffSortDebuff"..i);
			if ( not button ) then
				button = CreateFrame("Button", "TargetBuffSortDebuff"..i, TargetBuffSort, "TBS_DebuffButtonTemplate");
				button:SetFrameStrata("MEDIUM")
				button.id=i;
			end
		end
		TBS_alpha();
		TBS_setanchor();
		TBS_maketable();
		TargetBuffSort_Update();

	elseif ( event == "PLAYER_TARGET_CHANGED" ) then
		TargetBuffSort_Update();
	elseif ( event == "UNIT_AURA" ) then
		if ( arg1 == "target" ) then
			TargetBuffSort_real_Update();
		end
	end
end

function TargetBuffSort_real_Update()
	local button;
	local name, rank, icon, count, duration, timeLeft;
	local buffCount;
	local numBuffs = 0;
	local playerIsTarget = UnitIsUnit("player", "target");
	local cooldown, startCooldownTime;

	local debuffType, color;
	local debuffCount;
	local numDebuffs = 0;

	CECB_scan={};     --scan CECB
	TBS_CECB_scan(UnitName("target"),CECB_scan);

	for i,v in ipairs(TBS_BuffData) do
		v.anchor=nil
		v.numbuff=0
	end
	for i,v in ipairs(TBS_DebuffData) do
		v.anchor=nil
		v.numbuff=0
	end
	local mine_anchor=nil;
	local mine_numbuff=0;
	for i=1, TBS_MAX_TARGET_BUFFS do
		name, rank, icon, count, duration, timeLeft = UnitBuff("target", i);
		button = getglobal("TargetBuffSortBuff"..i);
		if ( not button ) then
			if ( not icon ) then
				break;
			else
				button = CreateFrame("Button", "TargetBuffSortBuff"..i, TargetBuffSort, "TBS_BuffButtonTemplate");
				button:SetFrameStrata("MEDIUM")
				button.id=i;
			end
		end

		if ( icon ) then
			getglobal("TargetBuffSortBuff"..i.."Icon"):SetTexture(icon);
			buffCount = getglobal("TargetBuffSortBuff"..i.."Count");
			if ( count > 1 ) then
				buffCount:SetText(count);
				buffCount:Show();
			else
				buffCount:Hide();
			end

			-- Handle cooldowns
			cooldown = getglobal("TargetBuffSortBuff"..i.."Cooldown");
			if ( duration ) then
				if ( duration > 0 ) and (not playerIsTarget) then
					cooldown:Show();
					startCooldownTime = GetTime()-(duration-timeLeft);
					TBS_CooldownFrame_SetTimer(cooldown, startCooldownTime, duration, 1);
				else
					cooldown:Hide();
					cooldown.countdown:Hide();
				end

				-- Set the buff to be big if the buff is cast by the player and the target is not the player
			else
				local CECB_find=false;
				for ci,cv in ipairs(CECB_scan) do
					if cv.spell==name then
						cv.spell="xxxxx"
						cooldown:Show();
						TBS_CooldownFrame_SetTimer(cooldown, cv.starttime, (cv.endtime-cv.starttime), 1);
						CECB_find=true;
						break
					end
				end
				if not CECB_find then
					cooldown:Hide();
					cooldown.countdown:Hide();
				end
			end
			button:Show()
			button:ClearAllPoints();

			--  find the name
			if TargetBuffSort_Config.sortmybuff and duration and not playerIsTarget then
				if not (mine_anchor) then
					button:SetPoint("BOTTOMLEFT", "TargetBuffSortTextMine", "BOTTOMRIGHT", 0, 0);
					mine_anchor=button
				else
					button:SetPoint("BOTTOMLEFT",mine_anchor,"BOTTOMRIGHT",0,0)
					mine_anchor=button
				end
				mine_numbuff=mine_numbuff+1;
				TargetBuffSort_resizebutton(button,TargetBuffSort_Config.iconsize*1.5)
			else

				local bufffind=TBS_findbuff(i,name,icon);
				if not (TBS_BuffData[bufffind].anchor) then
					getglobal("TargetBuffSortText"..bufffind):ClearAllPoints();
					button:SetPoint("BOTTOMLEFT", "TargetBuffSortText"..bufffind, "BOTTOMRIGHT", 0, 0);
					TBS_BuffData[bufffind].anchor=button
				else
					button:SetPoint("BOTTOMLEFT",TBS_BuffData[bufffind].anchor,"BOTTOMRIGHT",0,0)
					TBS_BuffData[bufffind].anchor=button
				end
				TBS_BuffData[bufffind].numbuff=TBS_BuffData[bufffind].numbuff+1
				TargetBuffSort_resizebutton(button,TargetBuffSort_Config.iconsize)
				--Highlight

			end
			if string.find(TargetBuffSort_Config.highlight,name) then
				TargetBuffSort_StartHighlight(icon,button);
			end
		else
			button:Hide();
		end
	end




	for i=1, TBS_MAX_TARGET_DEBUFFS do
		local debuffBorder = getglobal("TargetBuffSortDebuff"..i.."Border");
		name, rank, icon, count, debuffType, duration, timeLeft = UnitDebuff("target", i);
		button = getglobal("TargetBuffSortDebuff"..i);
		if ( not button ) then
			if ( not icon ) then
				break;
			else
				button = CreateFrame("Button", "TargetBuffSortDebuff"..i, TargetBuffSort, "TBS_DebuffButtonTemplate");
				button:SetFrameStrata("MEDIUM")
				button.id=i;
				debuffBorder = getglobal("TargetBuffSortDebuff"..i.."Border");
			end
		end
		if ( icon ) then
			getglobal("TargetBuffSortDebuff"..i.."Icon"):SetTexture(icon);
			debuffCount = getglobal("TargetBuffSortDebuff"..i.."Count");
			if ( debuffType ) then
				color = DebuffTypeColor[debuffType];
			else
				color = DebuffTypeColor["none"];
			end
			if ( count > 1 ) then
				debuffCount:SetText(count);
				debuffCount:Show();
			else
				debuffCount:Hide();
			end

			-- Handle cooldowns
			cooldown = getglobal("TargetBuffSortDebuff"..i.."Cooldown");
			if TargetBuffSort_Config.sortmydebuff and ( duration  ) then
				if ( duration > 0 ) then
					cooldown:Show();
					startCooldownTime = GetTime()-(duration-timeLeft);
					TBS_CooldownFrame_SetTimer(cooldown, startCooldownTime, duration, 1);
				else
					cooldown:Hide();
					cooldown.countdown:Hide()
				end
				-- Set the buff to be big if the buff is cast by the player
			else
				local CECB_find=false;
				for ci,cv in ipairs(CECB_scan) do
					if cv.spell==name then
						cv.spell="xxxxx"
						cooldown:Show();
						CooldownFrame_SetTimer(cooldown, cv.starttime, (cv.endtime-cv.starttime), 1);
						CECB_find=true;
						break
					end
				end
				if not CECB_find then
					cooldown:Hide();
					cooldown.countdown:Hide()
				end
			end
			debuffBorder:SetVertexColor(color.r, color.g, color.b);
			button:Show();
			button:ClearAllPoints();
			if duration and not playerIsTarget then
				if not (mine_anchor) then
					button:SetPoint("BOTTOMLEFT", "TargetBuffSortTextMine", "BOTTOMRIGHT", 0, 0);
					mine_anchor=button
				else
					button:SetPoint("BOTTOMLEFT",mine_anchor,"BOTTOMRIGHT",0,0)
					mine_anchor=button
				end
				mine_numbuff=mine_numbuff+1
				TargetBuffSort_resizebutton(button,TargetBuffSort_Config.iconsize*1.5)
			else

				local bufffind=TBS_finddebuff(i,name,icon);
				if not (TBS_DebuffData[bufffind].anchor) then
					getglobal("TargetBuffSortText"..bufffind.."d"):ClearAllPoints();
					button:SetPoint("BOTTOMLEFT", "TargetBuffSortText"..bufffind.."d", "BOTTOMRIGHT", 0, 0);
					TBS_DebuffData[bufffind].anchor=button
				else
					button:SetPoint("BOTTOMLEFT",TBS_DebuffData[bufffind].anchor,"BOTTOMRIGHT",0,0)
					TBS_DebuffData[bufffind].anchor=button
				end
				TBS_DebuffData[bufffind].numbuff=TBS_DebuffData[bufffind].numbuff+1
				TargetBuffSort_resizebutton(button,TargetBuffSort_Config.iconsize)	
				--Highlight

			end
			if string.find(TargetBuffSort_Config.highlight,name) then
				TargetBuffSort_StartHighlight(icon,button);
			end
		else
			button:Hide();
		end

	end


	--positioning  --lzh	
	local frameheight=0;
	local previous_text=getglobal("TargetBuffSortClickArea");
	local previous_button=nil;
	local linewidth=0;

	if not mine_anchor then
		TargetBuffSortTextMine:Hide();
	else
		TargetBuffSortTextMine:Show();
		TBS_stacklines(TargetBuffSortTextMine,previous_text);
		previous_text=getglobal("TargetBuffSortTextMine")
		frameheight=frameheight+TargetBuffSort_Config.iconsize*1.5
	end

	function show_buff()
	previous_button=nil;
	for i,v in ipairs(TBS_BuffData) do
		title_str=getglobal("TargetBuffSortText"..i)
		title_str:ClearAllPoints();
		if v.anchor then
			local blocklength=v.numbuff*TargetBuffSort_Config.iconsize+14
			if TargetBuffSort_Config.compacttitle and ((linewidth+blocklength)<=160) and previous_button then
				--merge line
				title_str:SetPoint("BOTTOMLEFT",previous_button,"BOTTOMRIGHT",0,0)
				linewidth=linewidth+blocklength
				previous_button=v.anchor;

			else
				--newline
				TBS_stacklines(title_str,previous_text)
				previous_text=title_str
				previous_button=v.anchor
				linewidth=blocklength
				frameheight=frameheight+TargetBuffSort_Config.iconsize
			end

			title_str:Show()

		else
			title_str:Hide()
		end
	end
	end
	
	function show_debuff()
	previous_button=nil;
	for i,v in ipairs(TBS_DebuffData) do
		title_str=getglobal("TargetBuffSortText"..i.."d")
		title_str:ClearAllPoints();
		if v.anchor then
			local blocklength=v.numbuff*TargetBuffSort_Config.iconsize+14
			if TargetBuffSort_Config.compacttitle and ((linewidth+blocklength)<=160) and previous_button then
				--merge line
				title_str:SetPoint("BOTTOMLEFT",previous_button,"BOTTOMRIGHT",0,0)
				linewidth=linewidth+blocklength
				previous_button=v.anchor;

			else
				--newline
				TBS_stacklines(title_str,previous_text)
				previous_text=title_str
				previous_button=v.anchor
				linewidth=blocklength
				frameheight=frameheight+TargetBuffSort_Config.iconsize
			end

			title_str:Show()
		else
			title_str:Hide()
		end
	end
	end

	if UnitIsEnemy("player","target") then
		show_debuff();
		show_buff();
	else
		show_buff();
		show_debuff();
	end

	TargetBuffSort:SetHeight(frameheight+2)

end

function TargetBuffSort_resizebutton(buff,buffSize)
	buff:SetWidth(buffSize);
	buff:SetHeight(buffSize);
	local debuffFrame = getglobal(buff:GetName().."Border");
	if debuffFrame then
		debuffFrame:SetWidth(buffSize+2);
		debuffFrame:SetHeight(buffSize+2);
	end
end

function TBS_CECB_scan(mobname,database)
	for i=1,20 do
		local button = getglobal("Carni_ECB_"..i);
		if (button and button:IsVisible()) then
			if button.mob==mobname then
				table.insert(database,{spell=button.spell;starttime=button.startTime;endtime=button.endTime;});
			end
		end
	end
end


function TBS_stacklines(title1,title2)
	title1:ClearAllPoints();
	if TargetBuffSort_Config.invert then
		title1:SetPoint("BOTTOMLEFT",title2,"TOPLEFT",0,0)
	else
		title1:SetPoint("TOPLEFT",title2,"BOTTOMLEFT",0,0)
	end
end
