--[[
	Threat module for warriors
	
	I took all threat values from ThreatLib-2.0 and http://www.wowwiki.com/Threat
--]]
local _, myClass = UnitClass("player")
if myClass ~= "WARRIOR" then return; end 

TtpsWarrior = AceLibrary("AceOO-2.0").Class(TtpsClass);

local instance = TtpsWarrior:new();

TtpsCombatEvents:RegisterModule(instance);
TtpsCombatEvents:RegisterCombatSourceSelf(instance, {'DAMAGE', 'DAMAGE_SHIELD', 'ENERGIZE', 'HEAL', 'MISSED', 'DAMAGE_SHIELD_MISSED', 'CAST_SUCCESS'});
TtpsCombatEvents:RegisterCombatDestinationSelf(instance, {'AURA_APPLIED', 'AURA_REMOVED'});


local sunderFactor 			= 301 / 67
local shieldBashFactor 		= 230 / 64
local revengeFactor 		= 201 / 70
local heroicStrikeFactor 	= 220 / 70
local shieldSlamFactor 		= 307 / 70
local cleaveFactor 			= 130 / 68
local hamstringFactor 		= 181 / 67
local mockingBlowFactor 	= 290 / 65
local battleShoutFactor 	= 1
local demoShoutFactor 		= 56 / 70

local sunderName = GetSpellInfo(7386)

local msbtMod = 1.0; -- changes in ScanTalents
local defianceMod = 1; -- changes in ScanTalents
local zerkerStanceMod = 0; -- changes in ScanTalents

-- ------------------------------------------------------------
local msbtThreatModFunc = 	{set = function(self, enable)
								end,
							get = function(self, spellId, school, prefix)
									if (TtpsWarrior.prototype.VolatileThreatModifiers["warriStances"].stanceId == 3) then
										return msbtMod;
									else
										return 1;
									end
								end,
							modifier = 1};

local function devastateThreatFunc(prefix)
	local rank, count = instance:GetTargetDebuff(sunderName);

	if (count == nil or count == 0) then count = 1; end

	return 106+(14*count);
end

-- sunder armor is a "transaction" starting with SPELL_CAST_SUCCESS and followed by SPELL_AURA_APPLIED, SPELL_AURA_APPLIED_DOSE  or SPELL_MISSED, all without source guid
local transSunderArm = {GetEvents = function(self)
							return {'AURA_APPLIED', 'AURA_APPLIED_DOSE', 'MISSED'};
						end,
						IsSpell = function(self, p1)
							return (p1 == 7386 or p1 == 7405 or p1 == 8380 or p1 == 11596 or p1 == 11597 or p1 == 25225);
						end,
						AURA_APPLIED = function(self, sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
							if (self:IsSpell(p1)) then
								local threatC = 0;
								local v = instance.FixedThreatValues[p1];
								if (v) then
									if (type(v) == 'function') then
										threatC = v(prefix);
									else
										threatC = v;
									end
								end

								local modifierC = instance:GetModifierC(1, p1, p3, prefix);
								
								local threat = threatC * modifierC;
								
								TtpsData:AddData(tGUID, tName, timestamp, threat, p1);
								
								if (instance.debugMode) then
									TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), instance.debugColor);
								end
								TtpsCombatEvents:UnregisterCombatSource(self);
							end
						end,
						AURA_APPLIED_DOSE = function(self, sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
							if (self:IsSpell(p1)) then
								self:AURA_APPLIED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
							end
						end,
						MISSED = function(self, sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
							if (self:IsSpell(p1)) then
								instance:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
								TtpsCombatEvents:UnregisterCombatSource(self);
							end
						end,
};
-- ------------------------------------------------------------

-- global threat modifiers
instance:JoinTables(instance.VolatileThreatModifiers, {
	-- stances
	["warriStances"] =
				{set = function(self, enable, stanceId)
							if (enable) then
								if (stanceId == 2) then -- defensive stance
									self.modifier = 1.3 * defianceMod
									self.stanceId = stanceId;
								elseif (stanceId == 3) then -- berserker stance
									self.modifier = 0.8 * (1 - zerkerStanceMod);
									self.stanceId = stanceId;
								else -- other
									self.modifier = 0.8;
									self.stanceId = 1;
								end
							else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1,
				stanceId = 1},
});				

-- ability modifiers
instance:JoinTables(instance.AbilityModifiers, {
	-- thunderclap
	[6343] = 1.75,
	[8198] = 1.75,
	[8204] = 1.75,
	[8205] = 1.75,
	[11580] = 1.75,
	[11581] = 1.75,
	[25264] = 1.75,

	-- execute
	[5308] = 1.25,
	[20658] = 1.25,
	[20660] = 1.25,
	[20661] = 1.25,
	[20662] = 1.25,
	[25234] = 1.25,
	[25236] = 1.25,
	
	-- Mortal Strike
	[12294] = msbtThreatModFunc,
	[21551] = msbtThreatModFunc,
	[21552] = msbtThreatModFunc,
	[21553] = msbtThreatModFunc,
	[25248] = msbtThreatModFunc,
	[30330] = msbtThreatModFunc,
		
	-- Bloodthirst
	[23881] = msbtThreatModFunc,
	[23892] = msbtThreatModFunc,
	[23893] = msbtThreatModFunc,
	[23894] = msbtThreatModFunc,
	[25251] = msbtThreatModFunc,
	[30335] = msbtThreatModFunc,
});

instance:JoinTables(instance.FixedThreatValues, {
	-- sunder
	[7386] = sunderFactor * 10,
	[7405] = sunderFactor * 22, 
	[8380] = sunderFactor * 34,
	[11596] = sunderFactor * 46, 
	[11597] = sunderFactor * 58,
	[25225] = 301,

	-- shieldBash
	[72] = shieldBashFactor * 12,
	[1671] = shieldBashFactor * 32,
	[1672] = shieldBashFactor * 52,
	[29704] = 230,

	-- revenge
	[6572] = revengeFactor * 14,
	[6574] = revengeFactor * 24,
	[7379] = revengeFactor * 34,
	[11600] = revengeFactor * 44,
	[11601] = revengeFactor * 54,
	[25288] = revengeFactor * 60,
	[25269] = revengeFactor * 63,
	[30357] = 201,

	-- heroicStrike
	[78] = heroicStrikeFactor * 1,
	[284] = heroicStrikeFactor * 8,
	[285] = heroicStrikeFactor * 16,
	[1608] = heroicStrikeFactor * 24,
	[11564] = heroicStrikeFactor * 32,
	[11565] = heroicStrikeFactor * 40,
	[11566] = heroicStrikeFactor * 48,
	[11567] = 145,
	[25286] = 173,
	[29707] = 196,
	[30324] = 220,

	-- shieldSlam
	[23922] = shieldSlamFactor * 40,
	[23923] = shieldSlamFactor * 48,
	[23924] = shieldSlamFactor * 54,
	[23925] = 250,
	[25258] = 286,
	[30356] = 307,

	--cleave
	[845] = cleaveFactor * 20,
	[7369] = cleaveFactor * 30,
	[11608] = cleaveFactor * 40,
	[11609] = cleaveFactor * 50,
	[20569] = 100,
	[25231] = 130,

	-- hamstring
	[1715] = hamstringFactor * 8,
	[7372] = hamstringFactor * 32,
	[7373] = hamstringFactor * 54,
	[25212] = 181,

	-- mockingBlow
	[694] = mockingBlowFactor * 16,
	[7400] = mockingBlowFactor * 26,
	[7402] = mockingBlowFactor * 36,
	[20559] = mockingBlowFactor * 46,
	[20560] = mockingBlowFactor * 56,
	[25266] = 290,

	-- battleShout
	[6673] = battleShoutFactor * 1,
	[5242] = battleShoutFactor * 12,
	[6192] = battleShoutFactor * 22,
	[11549] = battleShoutFactor * 32,
	[11550] = battleShoutFactor * 42,
	[11551] = battleShoutFactor * 52,
	[25289] = battleShoutFactor * 60,
	[2048] = 69,
		
	-- demoShout
	[1160] = demoShoutFactor * 14,
	[6190] = demoShoutFactor * 24,
	[11554] = demoShoutFactor * 34,
	[11555] = demoShoutFactor * 44,
	[11556] = demoShoutFactor * 54,
	[25202] = demoShoutFactor * 62,
	[25203] = 56,

	-- commandingShout
	[469] = 58,

	-- disarm
	[676] = 104,
	
	-- devastate
	[20243] = devastateThreatFunc,
	[30016] = devastateThreatFunc,
	[30022] = devastateThreatFunc,
});

instance:JoinTables(instance.TransactionHandlers, {
	-- on sunder
	[7386] = transSunderArm,
	[7405] = transSunderArm,
	[8380] = transSunderArm,
	[11596] = transSunderArm,
	[11597] = transSunderArm,
	[25225] = transSunderArm,
	
	-- on devastate
	[20243] = transSunderArm,
	[30016] = transSunderArm,
	[30022] = transSunderArm,
});

-- --------------------------------------------------------------------------------------

function TtpsWarrior.prototype:ScanTalents()
	-- defiance
	local rank = _G.select(5, GetTalentInfo(3, 9))
	defianceMod = 1 + (0.05 * rank)

	-- tactical mastery
	local rank = _G.select(5, GetTalentInfo(3, 2))
	msbtMod = 1 + (0.21 * rank)
	
	-- improved berserker stance
	local rank = _G.select(5, GetTalentInfo(2, 20))
	zerkerStanceMod = 0.02 * rank	
end
	
function TtpsWarrior.prototype:StanceChanged()
	self.VolatileThreatModifiers["warriStances"]:set(true, GetShapeshiftForm());
end

function TtpsWarrior.prototype:EquipChanged()
	TtpsWarrior.super.prototype:EquipChanged();
	
	local entry = nil;
	local item, itemString, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId;
	
	--[[
	-- Battlegear of Might
	local mightCnt = 0;
	local mapping = {HeadSlot=16866, ShoulderSlot=16868, ChestSlot=16865, HandsSlot=16863,
					WristSlot=16861, WaistSlot=16864, LegsSlot=16867, FeetSlot=16862};

			
	for k,v in pairs(mapping) do
		item = GetInventoryItemLink("player", GetInventorySlotInfo(k));
		if (item) then
			_, itemString = GetItemInfo(item);
			_, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", itemString)
			if (itemId == v) then mightCnt = mightCnt+1; end
		end
	end
	
	entry = devSaModFunc;
	if (mightCnt ==8) then entry:set(true); else entry:set(false); end
	--]]
end

-- --------------------------------------------------------------------------------------
	
--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your attacks
--]]
function TtpsWarrior.prototype:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end
	
	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	
	if (not s1) then return; end
			
	local threatX = s1; 
	local threatC = 0;
	local v = self.FixedThreatValues[p1];
	if (v) then
		if (type(v) == 'function') then
			threatC = v(prefix);
		else
			threatC = v;
		end
	end
	
	local modifierX = self:GetModifierX(1, p1, p3, prefix);
	local modifierC = self:GetModifierC(1, p1, p3, prefix);
		
	local threat = threatX * modifierX + threatC * modifierC;
		
	TtpsData:AddData(tGUID, tName, timestamp, threat, p1);
	TtpsData:AddHitInfo(tGUID, tName, timestamp, s1, s3, s4, s5, s6, s7, s8, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), self.debugColor);
	end
end

function TtpsWarrior.prototype:DAMAGE_SHIELD(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your healing spells and PoM, SoL ,...
--]]
function TtpsWarrior.prototype:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	if (not s1) then return; end
	
	-- heals while mindcontrolled, Illidans Draw Soul, ...
	if (tFlags and
		(bit.band(tFlags, COMBATLOG_OBJECT_REACTION_MASK) == COMBATLOG_OBJECT_REACTION_HOSTILE)) then
		return;
	end
	
	--local threatC = 0; -- no fixed threat values
	local threatX = s1;

	local modifierX = self:GetModifierX(0.5, p1, p3, prefix);
	--local modifierC = self:GetModifierC(1, p1, p3, prefix);
	
	local threat = threatX * modifierX;
		
	TtpsData:AddDataGlobal(timestamp, threat, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), self.debugColor);
	end
end

function TtpsWarrior.prototype:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)	
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end

	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	if (s1) then 
		TtpsData:AddMiss(tGUID, tName, timestamp, s1, p1);
	end
	
	if (self.debugMode) then
		TtpsDebug:Out("missed! "..(p2 or "").." ("..(p1 or "")..") "..(s1 or ""), self.debugColor);
	end
end

function TtpsWarrior.prototype:DAMAGE_SHIELD_MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end
