
TtpsScienceLab = AceLibrary("AceAddon-2.0"):new("Metrognome-2.0");

local scienceFrame;

local guidP1 = nil;
local guidP2 = nil;
local guidMob = nil;
local guidFocus = nil;

local status = nil;
local STATUS_START = 1;
local STATUS_STOP = 0;

function TtpsScienceLab:OnInitialize()
	self:RegisterMetro(self.name .. "_science", self.Tick, 0.1, self);
end

function TtpsScienceLab:Show()
	if (not scienceFrame) then
		scienceFrame = TtpsScienceLab:CreateScienceWindow();
		
		DEFAULT_CHAT_FRAME:AddMessage("This is a simple tool to help gaining threat infos");
		DEFAULT_CHAT_FRAME:AddMessage("1)Select Player A and B and a mob. Those will be filtered out of the combat log.");
		DEFAULT_CHAT_FRAME:AddMessage("2)If you make the mob to your focus target, this tool can recognize target changes");
		DEFAULT_CHAT_FRAME:AddMessage("3)Press start/stop ;)");
	end
	scienceFrame:Show();
end

function TtpsScienceLab:Out(line, color)
	if (not scienceFrame) then
		scienceFrame = TtpsScienceLab:CreateScienceWindow();
	end
	
	if (line) then
		if (color) then
			color = string.format("|cff".."%02x%02x%02x", color[1]*255, color[2]*255, color[3]*255);
		else
			color = "|cffffffff";
		end

		scienceFrame.Box:Insert(color..line.."|r\n");
	end
end

function TtpsScienceLab:CreateScienceWindow()
	local win = CreateFrame("Frame", "TankadinTpsScienceFrame",UIParent);
	
	win:SetWidth(300);
	win:SetHeight(200);
	win:SetBackdrop({bgFile = "Interface/DialogFrame/UI-DialogBox-Background", 
                          edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                          tile = true, tileSize = 16, edgeSize = 16, 
                          insets = { left = 4, right = 4, top = 4, bottom = 4 }
						 });

	win:SetMovable(true);
	win:EnableMouse(true);
	win:SetPoint("CENTER", UIParent, "CENTER")
	win:SetScript("OnMouseDown", function() this:StartMoving(); end)
	win:SetScript("OnMouseUp", function() this:StopMovingOrSizing(); end)
	
	local closeBtn = CreateFrame("Button", nil, win, "UIPanelCloseButton");
	closeBtn:SetPoint("TOPRIGHT", win, "TOPRIGHT", 0, 0);
	
	
	local setBtn1 = CreateFrame("Button", "$parentP1Btn", win, "UIPanelButtonTemplate2");
	setBtn1:SetPoint("TOPLEFT", win, "BOTTOMLEFT", 5, 0);
	setBtn1:SetText("Player A");
	setBtn1:SetWidth(80);
	setBtn1.Text = setBtn1:CreateFontString(nil,"OVERLAY","GameFontNormal");
	if (not guidP1) then setBtn1.Text:SetText("<no target selected>"); end
	setBtn1.Text:SetPoint("LEFT",setBtn1,"RIGHT",8,0);
	setBtn1:SetScript("OnClick", function() local u = UnitName("target");
									if (u) then
										setBtn1.Text:SetText(u);
										guidP1 = UnitGUID("target");
									else
										setBtn1.Text:SetText("<no target selected>");
										guidP1 = nil;
									end
								end);
	
	
	local setBtn2 = CreateFrame("Button", "$parentP2Btn", win, "UIPanelButtonTemplate2");
	setBtn2:SetPoint("TOPLEFT", setBtn1, "BOTTOMLEFT", 0, 0);
	setBtn2:SetText("Player B");
	setBtn2:SetWidth(80);
	setBtn2.Text = setBtn2:CreateFontString(nil,"OVERLAY","GameFontNormal");
	if (not guidP2) then setBtn2.Text:SetText("<no target selected>"); end
	setBtn2.Text:SetPoint("LEFT",setBtn2,"RIGHT",8,0);
	setBtn2:SetScript("OnClick", function() local u = UnitName("target");
									if (u) then
										setBtn2.Text:SetText(u);
										guidP2 = UnitGUID("target");
									else
										setBtn2.Text:SetText("<no target selected>");
										guidP2 = nil;
									end
								end);
	
	local setBtn3 = CreateFrame("Button", "$parentMobBtn", win, "UIPanelButtonTemplate2");
	setBtn3:SetPoint("TOPLEFT", setBtn2, "BOTTOMLEFT", 0, 0);
	setBtn3:SetText("mob");
	setBtn3:SetWidth(80);
	
	setBtn3.Text = setBtn3:CreateFontString(nil,"OVERLAY","GameFontNormal");
	if (not guidMob) then setBtn3.Text:SetText("<no target selected>"); end
	setBtn3.Text:SetPoint("LEFT",setBtn3,"RIGHT",8,0);

	setBtn3:SetScript("OnClick", function() local u = UnitName("target");
									if (u) then
										setBtn3.Text:SetText(u);
										guidMob = UnitGUID("target");
									else
										setBtn3.Text:SetText("<no target selected>");
										guidMob = nil;
									end
								end);

	local stastoBtn = CreateFrame("Button", "$parentStaStoBtn", win, "UIPanelButtonTemplate2");
	stastoBtn:SetPoint("TOPLEFT", win, "TOPRIGHT", 2, -5);
	stastoBtn:SetText("start/stop");
	stastoBtn:SetWidth(80);
	stastoBtn:SetScript("OnClick", function() if (status == STATUS_START) then TtpsScienceLab:Stop() else TtpsScienceLab:Start() end end);
	
	local focusBtn = CreateFrame("Button", "$parentFocusBtn", win, "UIPanelButtonTemplate2, SecureActionButtonTemplate");
	focusBtn:SetPoint("TOPLEFT", stastoBtn, "BOTTOMLEFT", 0, 0);
	focusBtn:SetText("/focus");
	focusBtn:SetWidth(80);
	focusBtn:SetAttribute("unit", "target");
	focusBtn:SetAttribute("type1", "focus");
	


	local scroll = CreateFrame("ScrollFrame", "TtpsScienceScrollFrame", win, "UIPanelScrollFrameTemplate");

	scroll:SetPoint("TOPLEFT",win,"TOPLEFT",10,-30)
	scroll:SetPoint("BOTTOMRIGHT",win,"BOTTOMRIGHT",-30,5)

	win.Box = CreateFrame("EditBox",nil,scroll);
	win.Box:SetScript("OnEscapePressed", function() this:ClearFocus(); end);
	win.Box:SetScript("OnEditFocusLost", function() this:HighlightText(0, 0); end);
	win.Box:SetScript("OnEditFocusGained", function() this:HighlightText(); end);
	win.Box:SetFontObject("ChatFontNormal");
	win.Box:SetMultiLine(true);
	win.Box:SetWidth(450);
	win.Box:SetHeight(300);

	win.Box:SetAutoFocus(false)
	
	scroll:SetScrollChild(win.Box);
	
	win:Hide();
	return win;
end

function TtpsScienceLab:Start()
	if (guidP1 and guidP2 and guidMob) then
	
		if (status == nil) then
			TtpsCombatEvents:RegisterCombatNoGuidFilter(TtpsScienceLab, {'DAMAGE', 'DAMAGE_SHIELD', 'ENERGIZE', 'HEAL', 'AURA_APPLIED', 'AURA_REMOVED'});
		end

		self:Out("source;value;(skill, school);target;timestamp;");
		self:StartMetro(self.name .. "_science");
		status = STATUS_START;
	else
		DEFAULT_CHAT_FRAME:AddMessage("please select player A,B and a mob");
	end
end

function TtpsScienceLab:Stop()
	status = STATUS_STOP;
	self:StopMetro(self.name .. "_science");
	self:Out("--------------------------");
end

function TtpsScienceLab:Tick(difference)
	if (UnitGUID("focus") == guidMob) then
		local fg = UnitGUID("focustarget");
		
		if (not (fg == guidFocus)) then
			self:Out("target switched to: "..(UnitName("focustarget") or "<no target>"), {1,0,0});
			guidFocus = fg;
		end
	end
end

function TtpsScienceLab:IsInGuidList(guid)
	return guid == guidP1 or guid == guidP2 or guid == guidMob;
end

function TtpsScienceLab:GetGuidColor(guid)
	if (guid == guidP1) then return {1.0,0.4980,0.0} end;
	if (guid == guidP2) then return {0,1,0} end;
	if (guid == guidMob) then return {1,0,0} end;
end

-- --------------------------------------------------------------

function TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	if (status == STATUS_START and (self:IsInGuidList(sGUID) or self:IsInGuidList(tGUID))) then
		if (prefix == 'SWING') then
			s1 = p1; -- p1 .. p3 are skipped by WoW -.-
			p1 = "auto-hit";
		end
		local n = GetSpellInfo(p1);
		self:Out((sName or "") .. ";" .. (s1 or "") .. ";(" .. (n or "auto-hit") .. "," .. (p3 or "") .. ");" .. (tName or "") .. ";" .. (timestamp or "") ..";", self:GetGuidColor(sGUID));
	end
end

function TtpsScienceLab:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

function TtpsScienceLab:DAMAGE_SHIELD(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

function TtpsScienceLab:ENERGIZE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

function TtpsScienceLab:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

function TtpsScienceLab:AURA_APPLIED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

function TtpsScienceLab:AURA_REMOVED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsScienceLab:CombatEvent(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

