--[[
	Threat module for paladins
--]]
local _, myClass = UnitClass("player")
if myClass ~= "PALADIN" then return; end 

TtpsPaladin = AceLibrary("AceOO-2.0").Class(TtpsClass);

local instance = TtpsPaladin:new();

TtpsCombatEvents:RegisterModule(instance);
TtpsCombatEvents:RegisterCombatSourceSelf(instance, {'DAMAGE', 'DAMAGE_SHIELD', 'ENERGIZE', 'HEAL', 'MISSED', 'DAMAGE_SHIELD_MISSED'});
TtpsCombatEvents:RegisterCombatDestinationSelf(instance, {'AURA_APPLIED', 'AURA_REMOVED'});

local impRFmod = 0; -- changes in ScanTalents()

-- global threat modifiers
instance:JoinTables(instance.VolatileThreatModifiers, {
	-- Righteous Fury
	[25780] =
				{set = function(self, enable)
							if (enable) then
								self.modifier = (1.6 + (0.6 * impRFmod));
							else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							if (school == 0x02) then return self.modifier; else return 1; end
						end,
				modifier = 1},
});



-- ability modifiers
instance:JoinTables(instance.AbilityModifiers, {
	-- Holy Shield 1 - 4
	[20925] = 1.35,
	[20927] = 1.35,
	[20928] = 1.35,
	[27179] = 1.35,
	
	-- Holy Light
	[635] = 0.5,
	[639] = 0.5,
	[647] = 0.5,
	[1026] = 0.5,
	[1042] = 0.5,
	[3472] = 0.5,
	[10328] = 0.5,
	[10329] = 0.5,
	[25292] = 0.5,
	[27135] = 0.5,
	[27136] = 0.5,
		
	-- Holy Shock
	[25912] = 0.5,
	[25911] = 0.5,
	[25902] = 0.5,
	[27175] = 0.5,
	[33073] = 0.5,
		
	-- Lay on Hands
	[633] = 0.5,
	[2800] = 0.5,
	[10310] = 0.5,
	[27154] = 0.5,
		
	-- Seal of Light
	[20167] = 0.5,
	[20333] = 0.5,
	[20334] = 0.5,
	[20340] = 0.5,
	[27161] = 0.5,
		
	-- Flash of Light
	[19750] = 0.5,
	[19939] = 0.5,
	[19940] = 0.5,
	[19941] = 0.5,
	[19942] = 0.5,
	[19943] = 0.5,
	[27137] = 0.5,
});

-- --------------------------------------------------------------------------------------
function TtpsPaladin.prototype:ScanTalents()
	-- improved rf
	local irfRanks = {0, 0.16, 0.33, 0.5};
	impRFmod = irfRanks[select(5, GetTalentInfo(2, 7))+1];
end


-- --------------------------------------------------------------------------------------

--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your attacks
--]]
function TtpsPaladin.prototype:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end
	
	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	
	if (not s1) then return; end
	
	local threatX = s1;
	--local threatC = 0; -- no fixed threat values

	local modifierX = self:GetModifierX(1, p1, p3, prefix);
	--local modifierC = self:GetModifierC(1, p1, p3, prefix);
	
	local threat = threatX * modifierX;
		
	TtpsData:AddData(tGUID, tName, timestamp, threat, p1);
	TtpsData:AddHitInfo(tGUID, tName, timestamp, s1, s3, s4, s5, s6, s7, s8, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or ""), self.debugColor);
	end
end

function TtpsPaladin.prototype:DAMAGE_SHIELD(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end


--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your healing spells and PoM, SoL ,...
--]]
function TtpsPaladin.prototype:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	if (not s1) then return; end
	
	-- heals while mindcontrolled, Illidans Draw Soul, ...
	if (tFlags and
		(bit.band(tFlags, COMBATLOG_OBJECT_REACTION_MASK) == COMBATLOG_OBJECT_REACTION_HOSTILE)) then
		return;
	end
	
	--local threatC = 0; -- no fixed threat values
	local threatX = s1;

	local modifierX = self:GetModifierX(0.5, p1, p3, prefix);
	--local modifierC = self:GetModifierC(1, p1, p3, prefix);
	
	local threat = threatX * modifierX;
		
	TtpsData:AddDataGlobal(timestamp, threat, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or ""), self.debugColor);
	end
end

function TtpsPaladin.prototype:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end

	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	if (s1) then 
		TtpsData:AddMiss(tGUID, tName, timestamp, s1, p1);
	end
	
	if (self.debugMode) then
		TtpsDebug:Out("missed! "..(p2 or "").." ("..(p1 or "")..") "..(s1 or ""), self.debugColor);
	end
end

function TtpsPaladin.prototype:DAMAGE_SHIELD_MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end
