--[[
	Threat module for druids
	
	I took all threat values from ThreatLib-2.0 and http://www.wowwiki.com/Threat
--]]
local _, myClass = UnitClass("player")
if myClass ~= "DRUID" then return; end 

TtpsDruid = AceLibrary("AceOO-2.0").Class(TtpsClass);

local instance = TtpsDruid:new();

TtpsCombatEvents:RegisterModule(instance);
TtpsCombatEvents:RegisterCombatSourceSelf(instance, {'DAMAGE', 'DAMAGE_SHIELD', 'ENERGIZE', 'HEAL', 'MISSED', 'DAMAGE_SHIELD_MISSED', 'CAST_SUCCESS'});
TtpsCombatEvents:RegisterCombatDestinationSelf(instance, {'AURA_APPLIED', 'AURA_REMOVED'});


local faerieFireFactor = 127 / 66
local maulFactor = 322 / 67

local feralinstinctMod = 1; -- changes in ScanTalents()

local mangleModFunc =	{set = function(self, enable) -- 1.3 * 1.15, if you wear T6 setbonus
									if (enable) then self.modifier = 1.3 * 1.15; else self.modifier = 1.3; end
									end,
						get = function(self, spellId, school, prefix)
									return self.modifier;
								end,
						modifier = 1.3};

local lacerateModFunc =	{set = function(self, enable)
									if (enable) then self.modifier = 0.2; else self.modifier = 0.2; end
									end,
						get = function(self, spellId, school, prefix)
									if (prefix == 'SPELL_PERIODIC') then
										return 1;
									else
										return self.modifier;
									end
								end,
						modifier = 0.2};
						
local function lacerateFixFunc(prefix)
	if (prefix == 'SPELL_PERIODIC') then
		return 0;
	else
		return 285;
	end
end

-- faerie fire is a "transaction" starting with SPELL_CAST_SUCCESS and followed by SPELL_AURA_APPLIED or SPELL_MISSED, both without source guid
local transFaerieFire = {	GetEvents = function(self)
								return {'AURA_APPLIED', 'MISSED'};
							end,
							IsSpell = function(self, p1)
								return (p1 == 770 or p1 == 16857 or p1 == 778 or p1 == 17390 or p1 == 9749 or p1 == 17391 or p1 == 9907 or p1 == 17392 or p1 == 26993 or p1 == 27011);
							end,
							AURA_APPLIED = function(self, sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
								if (self:IsSpell(p1)) then
									local threatC = 0;
									local v = instance.FixedThreatValues[p1];
									if (v) then
										if (type(v) == 'function') then
											threatC = v(prefix);
										else
											threatC = v;
										end
									end

									local modifierC = instance:GetModifierC(1, p1, p3, prefix);
									
									local threat = threatC * modifierC;
									
									TtpsData:AddData(tGUID, tName, timestamp, threat, p1);
									
									if (instance.debugMode) then
										TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), instance.debugColor);
									end
									TtpsCombatEvents:UnregisterCombatSource(self);
								end
							end,
							MISSED = function(self, sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
								if (self:IsSpell(p1)) then
									instance:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
									TtpsCombatEvents:UnregisterCombatSource(self);
								end
							end,
						};

-- global threat modifiers
	
instance:JoinTables(instance.VolatileThreatModifiers, {
	-- Bear
	[5487] =
				{set = function(self, enable)
							if (enable) then
								self.modifier = 1.3 + feralinstinctMod;
							else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
	-- Dire Bear
	[9634] =
				{set = function(self, enable)
							if (enable) then
								self.modifier = 1.3 + feralinstinctMod;
							else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
	-- Cat
	[768] =
				{set = function(self, enable)
							if (enable) then
								self.modifier = 0.71;
							else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
});
				

-- ability modifiers
instance:JoinTables(instance.AbilityModifiers, {
	-- mangle
	[33878] = mangleModFunc,
	[33986] = mangleModFunc, 
	[33987] = mangleModFunc,
	
	--lacerate initial: damage*0.2 +285, dot: damage
	[33745] = lacerateModFunc,
});

instance:JoinTables(instance.FixedThreatValues, {
	--faerieFire
	-- Rank 1, normal and feral
	[770] = faerieFireFactor * 18,			-- Just a guess, need to validate
	[16857] = faerieFireFactor * 30,		-- Just a guess, need to validate
	
	[778] = faerieFireFactor * 30,			-- Just a guess, need to validate
	[17390] = faerieFireFactor * 30,		-- Just a guess, need to validate
	
	[9749] = faerieFireFactor * 42,			-- Just a guess, need to validate
	[17391] = faerieFireFactor * 42,		-- Just a guess, need to validate
	
	[9907] = 108,
	[17392] = 108,
	
	[26993] = 127,
	[27011] = 127,

	-- maul
	[6807] = maulFactor * 10,		-- Just a guess
	[6808] = maulFactor * 18,		-- Just a guess
	[6809] = maulFactor * 26,		-- Just a guess
	[8972] = maulFactor * 34,		-- Just a guess
	[9745] = maulFactor * 42,		-- Just a guess
	[9880] = maulFactor * 50,		-- Just a guess
	[9881] = 207,
	[26996] = 322,

	-- lacerate initial: damage*0.2 +285, dot: damage
	[33745] = lacerateFixFunc,
	
	-- cyclone
	[33786] = 180,
	
	-- demoralizing roar
	[99] = 42,
	[1735] = 42,
	[9490] = 42,
	[9747] = 42,
	[9898] = 42,
	[26998] = 42,
});

instance:JoinTables(instance.TransactionHandlers, {
	--faerieFire
	-- Rank 1, normal and feral
	[770] = transFaerieFire,
	[16857] = transFaerieFire,
	[778] = transFaerieFire,
	[17390] = transFaerieFire,
	[9749] = transFaerieFire,
	[17391] = transFaerieFire,
	[9907] = transFaerieFire,
	[17392] = transFaerieFire,
	[26993] = transFaerieFire,
	[27011] = transFaerieFire,
});

-- --------------------------------------------------------------------------------------
function TtpsDruid.prototype:ScanTalents()
	-- feral instinct
	feralinstinctMod = 0.05 * select(5, GetTalentInfo(2, 3));
end

function TtpsDruid.prototype:EquipChanged()
	TtpsDruid.super.prototype:EquipChanged();
	
	local entry = nil;
	local item, itemString, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId;
	
	-- thunderheart
	local thunderCnt = 0;
	local mapping = {HeadSlot=31039, ShoulderSlot=31048, ChestSlot=31042, HandsSlot=31034,
					WristSlot=34444, WaistSlot=34556, LegsSlot=31044, FeetSlot=34573};
			
	for k,v in pairs(mapping) do
		item = GetInventoryItemLink("player", GetInventorySlotInfo(k));
		if (item) then
			_, itemString = GetItemInfo(item);
			_, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":",  (itemString or ""))
			if (itemId == v) then thunderCnt = thunderCnt+1; end
		end
	end
	
	entry = mangleModFunc;
	if (thunderCnt >=2) then entry:set(true); else entry:set(false); end

end

-- --------------------------------------------------------------------------------------
	
--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your attacks
--]]
function TtpsDruid.prototype:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end
	
	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	
	if (not s1) then return; end
			
	local threatX = s1; 
	local threatC = 0;
	local v = self.FixedThreatValues[p1];
	if (v) then
		if (type(v) == 'function') then
			threatC = v(prefix);
		else
			threatC = v;
		end
	end
	
	local modifierX = self:GetModifierX(1, p1, p3, prefix);
	local modifierC = self:GetModifierC(1, p1, p3, prefix);
		
	local threat = threatX * modifierX + threatC * modifierC;
		
	TtpsData:AddData(tGUID, tName, timestamp, threat, p1);
	TtpsData:AddHitInfo(tGUID, tName, timestamp, s1, s3, s4, s5, s6, s7, s8, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), self.debugColor);
	end
end

function TtpsDruid.prototype:DAMAGE_SHIELD(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end

--[[
	Registered by RegisterCombatSourceSelf()
	Gets the threat of your healing spells and PoM, SoL ,...
--]]
function TtpsDruid.prototype:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	if (not s1) then return; end
	
	-- heals while mindcontrolled, Illidans Draw Soul, ...
	if (tFlags and
		(bit.band(tFlags, COMBATLOG_OBJECT_REACTION_MASK) == COMBATLOG_OBJECT_REACTION_HOSTILE)) then
		return;
	end
	
	--local threatC = 0; -- no fixed threat values
	local threatX = s1;

	local modifierX = self:GetModifierX(0.5, p1, p3, prefix);
	--local modifierC = self:GetModifierC(1, p1, p3, prefix);
	
	local threat = threatX * modifierX;
		
	TtpsData:AddDataGlobal(timestamp, threat, p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(threat.." threat by:"..(p2 or "").."(id="..(p1 or "").."), amountX="..(s1 or "")..", modifierX="..(modifierX or "")..", threatC="..(threatC or "")..", modifierC="..(modifierC or ""), self.debugColor);
	end
end


function TtpsDruid.prototype:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)	
	-- don't tank players & pets
	if (tFlags and 
		bit.band(tFlags, COMBATLOG_OBJECT_CONTROL_MASK) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
		return;
	end

	if (prefix == 'SWING') then
		-- p1 .. p3 are skipped by WoW -.-
		p1,p2,p3,s1,s2,s3,s4,s5,s6,s7,s8 = nil,nil,nil,p1,p2,p3,s1,s2,s3,s4,s5;
	end
	if (s1) then 
		TtpsData:AddMiss(tGUID, tName, timestamp, s1, p1);
	end
	
	if (self.debugMode) then
		TtpsDebug:Out("missed! "..(p2 or "").." ("..(p1 or "")..") "..(s1 or ""), self.debugColor);
	end
end

function TtpsDruid.prototype:DAMAGE_SHIELD_MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	self:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
end
