
TtpsDebug = {};

local debugFrame;

function TtpsDebug:Show()
	if (not debugFrame) then
		debugFrame = TtpsDebug:CreateDebugWindow();
	end
	debugFrame:Show();
end

function TtpsDebug:CreateDebugWindow()

	local reportWin = CreateFrame("Frame", "TankadinTpsDebugFrame",UIParent);

	reportWin:SetWidth(500);
	reportWin:SetHeight(350);
	reportWin:SetBackdrop({bgFile = "Interface/DialogFrame/UI-DialogBox-Background", 
                          edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                          tile = true, tileSize = 16, edgeSize = 16, 
                          insets = { left = 4, right = 4, top = 4, bottom = 4 }
						 });

	reportWin:SetMovable(true);
	reportWin:EnableMouse(true);
	reportWin:SetPoint("CENTER", UIParent, "CENTER")
	reportWin:SetScript("OnMouseDown", function() this:StartMoving(); end)
	reportWin:SetScript("OnMouseUp", function() this:StopMovingOrSizing(); end)
	
	local closeBtn = CreateFrame("Button", nil, TankadinTpsDebugFrame, "UIPanelCloseButton");
	closeBtn:SetPoint("TOPRIGHT", TankadinTpsDebugFrame, "TOPRIGHT", 0, 0);
	
	local debugBtn = CreateFrame("CheckButton", nil, reportWin, "UICheckButtonTemplate");
	debugBtn:SetPoint("BOTTOMLEFT", TankadinTpsDebugFrame, "BOTTOMLEFT", 5, 25);
	debugBtn:SetScale(0.7);
	debugBtn.Text = debugBtn:CreateFontString(nil,"OVERLAY","GameFontNormal");
	debugBtn.Text:SetText("TtpsCombatEvents");
	debugBtn.Text:SetPoint("LEFT",debugBtn,"RIGHT",8,0);
	debugBtn:SetChecked(TtpsCombatEvents.debugMode);
	debugBtn:SetScript("OnClick", function() TtpsCombatEvents.debugMode = this:GetChecked(); end);
	
	debugBtn = CreateFrame("CheckButton", nil, reportWin, "UICheckButtonTemplate");
	debugBtn:SetPoint("BOTTOMLEFT", TankadinTpsDebugFrame, "BOTTOMLEFT", 5, 0);
	debugBtn:SetScale(0.7);
	debugBtn.Text = debugBtn:CreateFontString(nil,"OVERLAY","GameFontNormal");
	debugBtn.Text:SetText("TtpsClass");
	debugBtn.Text:SetPoint("LEFT",debugBtn,"RIGHT",8,0);
	debugBtn:SetChecked(TtpsClass.prototype.debugMode);
	debugBtn:SetScript("OnClick", function() TtpsClass.prototype.debugMode = this:GetChecked(); end);
	
	debugBtn = CreateFrame("CheckButton", nil, reportWin, "UICheckButtonTemplate");
	debugBtn:SetPoint("BOTTOMLEFT", TankadinTpsDebugFrame, "BOTTOMLEFT", 150, 25);
	debugBtn:SetScale(0.7);
	debugBtn.Text = debugBtn:CreateFontString(nil,"OVERLAY","GameFontNormal");
	debugBtn.Text:SetText("TtpsData");
	debugBtn.Text:SetPoint("LEFT",debugBtn,"RIGHT",8,0);
	debugBtn:SetChecked(TtpsData.debugMode);
	debugBtn:SetScript("OnClick", function() TtpsData.debugMode = this:GetChecked(); end);

	local scroll = CreateFrame("ScrollFrame", "TtpsDebugScrollFrame", reportWin, "UIPanelScrollFrameTemplate");

	scroll:SetPoint("TOPLEFT",reportWin,"TOPLEFT",10,-30)
	scroll:SetPoint("BOTTOMRIGHT",reportWin,"BOTTOMRIGHT",-30,50)

	reportWin.Box = CreateFrame("EditBox",nil,scroll);
	reportWin.Box:SetScript("OnEscapePressed", function() this:ClearFocus(); end);
	reportWin.Box:SetScript("OnEditFocusLost", function() this:HighlightText(0, 0); end);
	reportWin.Box:SetScript("OnEditFocusGained", function() this:HighlightText(); end);
	reportWin.Box:SetFontObject("ChatFontNormal");
	reportWin.Box:SetMultiLine(true);
	reportWin.Box:SetWidth(450);
	reportWin.Box:SetHeight(300);

	reportWin.Box:SetAutoFocus(false)
	
	scroll:SetScrollChild(reportWin.Box);
	
	reportWin:Hide();
	return reportWin;
end

function TtpsDebug:Out(line, color)
	if (not debugFrame) then
		debugFrame = TtpsDebug:CreateDebugWindow();
	end
	
	if (line) then
		if (color) then
			color = string.format("|cff".."%02x%02x%02x", color[1]*255, color[2]*255, color[3]*255);
		else
			color = "|cffffffff";
		end

		debugFrame.Box:Insert(color..line.."|r\n");
	end
end

--[[

--]]
function TtpsDebug:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
end

function TtpsDebug:ENERGIZE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
end

function TtpsDebug:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
end

function TtpsDebug:AURA_APPLIED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
end

function TtpsDebug:AURA_REMOVED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
end

