
TtpsCommunication = AceLibrary("AceAddon-2.0"):new("AceComm-2.0");

local AceComm = AceLibrary("AceComm-2.0");

function TtpsCommunication:OnEnable()
	self.commPrefix = "TtpsComm";
	
    self:RegisterComm(self.commPrefix, "WHISPER", "OnCommReceive");
	self:RegisterComm(self.commPrefix, "GUILD", "OnCommReceive");
	self:RegisterComm(self.commPrefix, "RAID", "OnCommReceive");
		
	self:SetCommPrefix(self.commPrefix);
	self:SetDefaultCommPriority("BULK");
end

function TtpsCommunication:QueryVersion(channel, player)
	if (not channel) then
		if (TtpsCommunication:SendData("PING:?", "RAID")) then
		end
		
		if (TtpsCommunication:SendData("PING:?", "GUILD")) then
		end
	else
		TtpsCommunication:SendData("PING:?", channel, player);
	end
end

function TtpsCommunication:OnCommReceive(prefix, sender, distribution, data)
	if (type(data) == 'table') then
		TtpsData:Import(data);
	elseif (type(data) == 'string') then
		local startPos, endPos = string.find(data, ':');
		local cmd = string.sub(data, 1, startPos -1);
		local arg = string.sub(data, endPos+1);

		if (self[cmd]) then self[cmd](self, arg, distribution, sender); end
	end
end

function TtpsCommunication:PING(version, channel, player)
	if (version == '?') then -- incoming query
		self:SendData("PING:"..tostring((TankadinTps.version or 0)), channel, player);
	else -- incoming response
		DEFAULT_CHAT_FRAME:AddMessage((channel or "")..": "..(player or "").." ("..(version or "")..")");
	end
end


function TtpsCommunication:SendData(data, channel, player)
	if (not data) then return; end
	
	if (channel == "WHISPER") then
		if (player) then
			return self:SendCommMessage("WHISPER", player, data);
		end
	else
		return self:SendCommMessage(channel, data);
	end
end
