
TtpsCombatEvents = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "Metrognome-2.0");
TtpsCombatEvents.debugMode = false;

local debugColor = {0,1,0};

local registryModules = {};
local registryCombatSourceGuid = {};
local registryCombatDestinationGuid = {};
local registryCombatNoGuidFilter = {};

local selfGUID = "";

function TtpsCombatEvents:OnInitialize()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	self:RegisterEvent("UNIT_INVENTORY_CHANGED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_TARGET_CHANGED");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORM");
	
	self:RegisterEvent("PLAYER_ALIVE");
	self:RegisterEvent("PLAYER_UNGHOST");
	self:RegisterEvent("PLAYER_DEAD");
	
	self:RegisterMetro(self.name .. "_cev", self.Tick, 0.5, self);
end


function TtpsCombatEvents:OnEnable()		
	selfGUID = UnitGUID('player');
	
	for k,v in pairs(registryCombatSourceGuid) do
		if (not v.guid) then
			v.guid = selfGUID;
		end
	end
	for k,v in pairs(registryCombatDestinationGuid) do
		if (not v.guid) then
			v.guid = selfGUID;
		end
	end
end

function TtpsCombatEvents:EnterCombat()
	self:StartMetro(self.name .. "_cev")
end

function TtpsCombatEvents:LeaveCombat()
	self:StopMetro(self.name .. "_cev");
end

local function removeRegisteredClass(tbl, class)
	-- find key
	local key;
	for i=1,#tbl do
		if (tbl[i].class == class) then
			key = i;
			break;
		end
	end
	-- remove
	table.remove(tbl, key);
end

--[[
----------------------------------------------------------------
"plug-in" interface
----------------------------------------------------------------
--]]
function TtpsCombatEvents:RegisterModule(class)
	table.insert(registryModules, class);
end

function TtpsCombatEvents:RegisterCombatSourceSelf(class, events)	
	self:RegisterCombatSource(nil, class, events); -- guid will be set in self.OnEnable()
end

function TtpsCombatEvents:RegisterCombatDestinationSelf(class, events)
	self:RegisterCombatDestination(nil, class, events); -- guid will be set in self.OnEnable()
end

function TtpsCombatEvents:RegisterCombatSource(guid, class, events)	
	table.insert(registryCombatSourceGuid, {guid = guid, class = class, events = events});
end

function TtpsCombatEvents:UnregisterCombatSource(class, events)
	removeRegisteredClass(registryCombatSourceGuid, class);
end

function TtpsCombatEvents:RegisterCombatDestination(guid, class, events)
	table.insert(registryCombatDestinationGuid, {guid = guid, class = class, events = events});
end

function TtpsCombatEvents:UnregisterCombatDestination(class, events)
	removeRegisteredClass(registryCombatDestinationGuid, class);		
end

function TtpsCombatEvents:RegisterCombatNoGuidFilter(class, events)
	table.insert(registryCombatNoGuidFilter, {class = class, events = events});
end

function TtpsCombatEvents:UnregisterCombatNoGuidFilter(class, events)
	removeRegisteredClass(registryCombatNoGuidFilter, class);
end

--[[
----------------------------------------------------------------
 registered events 
----------------------------------------------------------------
--]]

function TtpsCombatEvents:Tick(difference)
	TtpsData:CheckPause();
end

function TtpsCombatEvents:PLAYER_ENTERING_WORLD()
	for k,v in pairs(registryModules) do
		v:PlayerEnteringWorld();
	end
end

function TtpsCombatEvents:UNIT_INVENTORY_CHANGED(unit)
	if (unit ~= "player") then return; end
	
	for k,v in pairs(registryModules) do
		v:EquipChanged();
	end
end

function TtpsCombatEvents:PLAYER_REGEN_ENABLED()
	self:LeaveCombat();
	
	TtpsData:LeaveCombat(time());
	
	for k,v in pairs(registryModules) do
		v.LeaveCombat();
	end
	
	TankadinTps:LeaveCombat();
end

function TtpsCombatEvents:PLAYER_REGEN_DISABLED()
	self:EnterCombat();
	
	TtpsData:EnterCombat(time());
	
	for k,v in pairs(registryModules) do
		v:EnterCombat();
	end
	
	TankadinTps:EnterCombat();
end

function TtpsCombatEvents:PLAYER_TARGET_CHANGED(unit)
	for k,v in pairs(registryModules) do
		v:TargetChanged(unit);
	end
end

function TtpsCombatEvents:PLAYER_ALIVE()
	TtpsData:SetDead(false);
end

function TtpsCombatEvents:PLAYER_UNGHOST()
	TtpsData:SetDead(false);
end

function TtpsCombatEvents:PLAYER_DEAD()
	TtpsData:SetDead(true);
end

function TtpsCombatEvents:UPDATE_SHAPESHIFT_FORM()
	for k,v in pairs(registryModules) do
		v:StanceChanged();
	end
end


function TtpsCombatEvents:COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)

	local prefixes = {'SWING', 'RANGE', 'SPELL_PERIODIC', 'SPELL', 'ENVIRONMENTAL'};

	-- find prefix & suffix
	local prefix = "";
	local suffix = event;
	for k,v in pairs(prefixes) do
		local startPos, endPos = string.find(event, v);

		if (startPos) then
			prefix = v;
			
			if (string.len(event) > endPos+2) then --"_" berspringen
				suffix = string.sub(event, endPos+2)
			end
			break;
		end
	end
	
	for k,v in pairs(registryCombatSourceGuid) do
		if (sourceGUID == v.guid) then
			for k2, e in pairs(v.events) do
				if (suffix == e) then
					v.class[e](v.class, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
					break;
				end
			end
		end
	end

	for k,v in pairs(registryCombatDestinationGuid) do
		if (destGUID == v.guid) then
			for k2, e in pairs(v.events) do
				if (suffix == e) then
					v.class[e](v.class, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
					break;
				end
			end
		end
	end

	for k,v in pairs(registryCombatNoGuidFilter) do
		for k2, e in pairs(v.events) do
			if (suffix == e) then
				v.class[e](v.class, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8);
				break;
			end
		end
	end
	
	
	if (event == "UNIT_DIED") then
		if (selfGUID == destGUID) then
			TtpsCombatEvents:LeaveCombat();
			TtpsData:SetDead(true);
		else
			TtpsData:UnitDied(destGUID, timestamp);
		end
	end
	
	if (TtpsCombatEvents.debugMode) then
		if (selfGUID == sourceGUID or selfGUID == destGUID) then
			TtpsDebug:Out(
				"sG:"..(sourceGUID or "")..
				"; sN:"..(sourceName or "")..
				"; sF:"..(sourceFlags or "")..
				"; tG:"..(destGUID or "")..
				"; tN:"..(destName or "")..
				"; tF:"..(destFlags or "")..
				"; ts:"..(timestamp or "")..
				"; ev:"..(event or "")..
				"; px:"..(prefix or "")..
				"; p1:"..(p1 or "")..
				"; p2:"..(p2 or "")..
				"; p3:"..(p3 or "")..
				"; s1:"..(s1 or "")..
				"; s2:"..(s2 or "")..
				"; s3:"..(s3 or "")..
				"; s4:"..(s4 or "")..
				"; s5:"..(s5 or "")..
				"; s6:"..(s6 or "")..
				"; s7:"..(s7 or "")..
				"; s8:"..(s8 or "")
			, debugColor);
		end
	end
end
