
--[[
	super-class for all modules
--]]
TtpsClass = AceLibrary("AceOO-2.0").Class();
TtpsClass.virtual = true; -- this means that it cannot be instantiated. (cannot call :new())

TtpsClass.prototype.debugMode = false;
TtpsClass.prototype.debugColor = {1.0,0.4980,0.0};

TtpsClass.prototype.MAXBUFFS = 40;

-- global threat modifiers
TtpsClass.prototype.VolatileThreatModifiers = {
	-- Tranquil Air
	[25909] = 	{set = function(self, enable)
							if (enable) then self.modifier = 0.8; else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
	-- Blessing of Salvation
	[1038]	= 	{set = function(self, enable)
							if (enable) then self.modifier = 0.7; else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
	-- Greater Blessing of Salvation
	[25895]	= 	{set = function(self, enable)
							if (enable) then self.modifier = 0.7; else self.modifier = 1; end
						end,
				get = function(self, spellId, school)
							return self.modifier;
						end,
				modifier = 1},
};

-- permanent modifiers (enchants, gems, items ...)
TtpsClass.prototype.PermanentThreadModifiers = {
	-- +2% threat on gloves
	['threatGloves']	= 	{set = function(self, enable)
										if (enable) then self.modifier = 1.02; else self.modifier = 1; end
										end,
							get = function(self, spellId, school)
										return self.modifier;
									end,
							modifier = 1},
							
	-- -2% threat on cloak
	['threatCloak']	= 	{set = function(self, enable)
									if (enable) then self.modifier = 0.98; else self.modifier = 1; end
									end,
						get = function(self, spellId, school)
									return self.modifier;
								end,
						modifier = 1},
};

TtpsClass.prototype.AbilityModifiers = {
	-- LOTP
	[34299] = 0,
	
	-- life bloom
	[33778] = 0,
};
TtpsClass.prototype.FixedThreatValues = {};

TtpsClass.prototype.TransactionHandlers = {};

-- --------------------------------------------------------------------------------------
function TtpsClass.prototype:JoinTables(destTbl, srcTbl)
	
	for k,v in pairs(srcTbl) do
		if (not destTbl[k]) then
			destTbl[k] = v;
		else
			DEFAULT_CHAT_FRAME:AddMessage("key:"..(k or "").." already used");
		end
	end
	
end

-- --------------------------------------------------------------------------------------

function TtpsClass.prototype:ResetVolatileMods()
	for k,v in pairs(self.VolatileThreatModifiers) do
		v:set(false);
	end
end

function TtpsClass.prototype:CheckVolatileMods()
	self:ResetVolatileMods();
	
	local bName, bRank, bIcon, sName, sRank, sIcon;
	
	for i=1,self.MAXBUFFS do
		bName, bRank, bIcon = UnitBuff('player', i);
		
		if (not bName) then break; end
		
		for k,v in pairs(self.VolatileThreatModifiers) do
			sName, sRank, sIcon = GetSpellInfo(k);

			if (sName and sRank and sIcon) then			
				if (bName..'#'..bRank..'#'..bIcon..'#' == sName..'#'..sRank..'#'..sIcon..'#') then
					v:set(true);
				end
			end
		end
	end
	
	self:StanceChanged();
end

function TtpsClass.prototype:EnterCombat()
	self:CheckVolatileMods();
end

function TtpsClass.prototype:LeaveCombat()

end

function TtpsClass.prototype:TargetChanged(unit)

end

function TtpsClass.prototype:PlayerEnteringWorld()
	self:CheckVolatileMods();
	self:EquipChanged();
	self:ScanTalents();
end

function TtpsClass.prototype:ScanTalents()

end

function TtpsClass.prototype:StanceChanged()

end

function TtpsClass.prototype:EquipChanged()
	local entry = nil;
	local item, itemString, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId;

	-- +2% threat enchant
	item = GetInventoryItemLink("player", GetInventorySlotInfo("HandsSlot"));
	if (item) then
		_, itemString = GetItemInfo(item);
		_, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", (itemString or ""))
	
		entry = self.PermanentThreadModifiers['threatGloves'];
		if (enchantId == '2613') then entry:set(true); else entry:set(false); end
	end
	
	-- -2% threat enchant
	item = GetInventoryItemLink("player", GetInventorySlotInfo("BackSlot"));
	if (item) then
		_, itemString = GetItemInfo(item);
		_, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", (itemString or ""))
		
		entry = self.PermanentThreadModifiers['threatCloak'];
		if (enchantId == '2621') then entry:set(true); else entry:set(false); end
	end
end

-- --------------------------------------------------------------------------------------
function TtpsClass.prototype:GetModifierX(modifier, spell, school, prefix)

	for k,v in pairs(self.VolatileThreatModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	for k,v in pairs(self.PermanentThreadModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	local v = self.AbilityModifiers[spell];
	if (v) then
		if (type(v) == 'table') then
			modifier = modifier * v:get(spell, school, prefix);
		elseif (type(v) == 'function') then
			modifier = modifier*v();
		else
			modifier = modifier*v;
		end
	end
	
	return modifier;
end

function TtpsClass.prototype:GetModifierC(modifier, spell, school, prefix)

	for k,v in pairs(self.VolatileThreatModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	for k,v in pairs(self.PermanentThreadModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	local v = self.AbilityModifiers[spell];
	if (v) then
		if (type(v) == 'table') then
			modifier = modifier * v:get(spell, school, prefix);
		elseif (type(v) == 'function') then
			modifier = modifier*v();
		else
			modifier = modifier*v;
		end
	end
	
	return modifier;
end

function TtpsClass.prototype:GetModifierGlobal(modifier)

	for k,v in pairs(self.VolatileThreatModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	for k,v in pairs(self.PermanentThreadModifiers) do
		modifier = modifier * v:get(spell, school);
	end
	
	return modifier;
end
	
-- --------------------------------------------------------------------------------------

function TtpsClass.prototype:GetTargetDebuff(debuffName)
	for i = 1, self.MAXBUFFS do
		local name, rank, texture, count, debuffType, duration, timeLeft = UnitDebuff("target", i)
		if (not name) then break; end
		
		if (name == debuffName and timeLeft) then
			return rank, count;
		end
	end
	
	return nil;
end
-- --------------------------------------------------------------------------------------

function TtpsClass.prototype:DAMAGE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:DAMAGE_SHIELD(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:ENERGIZE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	if (not s1) then return; end
	
	local maxgain = UnitManaMax("player") - UnitMana("player");
	local amount = math.min(maxgain, s1);
	
	local modifier = 0;
	
	if s2 == 0 then
		modifier = 0.5; -- mana
	elseif s2 == 1 then
		modifier = 5; -- rage
	end
	
	modifier = self:GetModifierX(modifier, p1, p3, prefix);
	
	TtpsData:AddDataGlobal(timestamp, (amount * modifier), p1);
	
	if (self.debugMode) then
		TtpsDebug:Out(((amount or 0) * modifier).." threat by:"..(p2 or "").."(id="..(p1 or "").."), amount="..(amount or "")..", modifier="..modifier, self.debugColor);
	end
end

function TtpsClass.prototype:HEAL(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:DAMAGE_SHIELD_MISSED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:CAST_SUCCESS(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	local trans = self.TransactionHandlers[p1];
	
	if (trans) then
		TtpsCombatEvents:RegisterCombatSource('0x0000000000000000', trans, trans:GetEvents());
	end
	
	if (self.debugMode and trans) then
		TtpsDebug:Out("transaction started: "..(p2 or "").." ("..(p1 or "")..")");
	end
end

function TtpsClass.prototype:AURA_APPLIED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	local buffMod = self.VolatileThreatModifiers[p1];
	if (buffMod) then
		buffMod:set(true);
	end
	
	if (self.debugMode and buffMod) then
		TtpsDebug:Out("threat relevant aura applied: "..(p2 or "").." ("..(p1 or "")..")", self.debugColor);
	end
end

function TtpsClass.prototype:AURA_APPLIED_DOSE(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	
end

function TtpsClass.prototype:AURA_REMOVED(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	local buffMod = self.VolatileThreatModifiers[p1];
	if (buffMod) then
		buffMod:set(false);
	end
	
	if (self.debugMode and buffMod) then
		TtpsDebug:Out("threat relevant aura removed: "..(p2 or "").." ("..(p1 or "")..")", self.debugColor);
	end
end

function TtpsClass.prototype:CombatEventOut(sGUID, sName, sFlags, tGUID, tName, tFlags, timestamp, prefix, p1, p2, p3, s1, s2, s3, s4, s5, s6, s7, s8)
	TtpsDebug:Out(
		"sG:"..(sGUID or "")..
		"; sN:"..(sName or "")..
		"; sF:"..(sFlags or "")..
		"; tG:"..(tGUID or "")..
		"; tN:"..(tName or "")..
		"; tF:"..(tFlags or "")..
		"; ts:"..(timestamp or "")..
		"; px:"..(prefix or "")..
		"; p1:"..(p1 or "")..
		"; p2:"..(p2 or "")..
		"; p3:"..(p3 or "")..
		"; s1:"..(s1 or "")..
		"; s2:"..(s2 or "")..
		"; s3:"..(s3 or "")..
		"; s4:"..(s4 or "")..
		"; s5:"..(s5 or "")..
		"; s6:"..(s6 or "")..
		"; s7:"..(s7 or "")..
		"; s8:"..(s8 or "")
	, self.debugColor);
end

--[[
test & debug stuff
--]]
function TtpsClass:TestGlobalModifier(id, school)
	local out = DEFAULT_CHAT_FRAME;
	out:AddMessage("modifier status:");
	
	local modifier = 1;
	for k,v in pairs(self.prototype.VolatileThreatModifiers) do
		modifier = modifier * v.get(v, id, school);
		out:AddMessage(k ..": "..v.get(v, id, school));
	end
	
	for k,v in pairs(self.prototype.PermanentThreadModifiers) do
		modifier = modifier * v.get(v, id, school);
		out:AddMessage(k ..": "..v.get(v, id, school));
	end
	out:AddMessage("modifier = "..modifier);
end

function TtpsClass:TestSpellIds()
	local out = DEFAULT_CHAT_FRAME;
	out:AddMessage("spell id test:");
	
	local name, rank;
	for k,v in pairs(self.prototype.VolatileThreatModifiers) do
		name, rank = GetSpellInfo(k);
		out:AddMessage(k .. ": "..(name or "-") .. " "..(rank or "-"));
	end
	
	for k,v in pairs(self.prototype.AbilityModifiers) do
		name, rank = GetSpellInfo(k);
		out:AddMessage(k .. ": "..(name or "-") .. " "..(rank or "-"));
	end
	
	for k,v in pairs(self.prototype.FixedThreatValues) do
		name, rank = GetSpellInfo(k);
		out:AddMessage(k .. ": "..(name or "-") .. " "..(rank or "-"));
	end
	
	for k,v in pairs(self.prototype.TransactionHandlers) do
		name, rank = GetSpellInfo(k);
		out:AddMessage(k .. ": "..(name or "-") .. " "..(rank or "-"));
	end
end
