
TankadinTps = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "FuBarPlugin-2.0", "AceConsole-2.0", "Metrognome-2.0");

TankadinTps.debugMode = false;
TankadinTps.options = nil
TankadinTps.name = "TankadinTps";
--[[
{
		type = "group",
		name = "Test",
		desc = "opens a funny dialog",
		order = 100,
		args = {
		}
};
--]]

local L = AceLibrary("AceLocale-2.2"):new("TankadinTps");
local tablet = AceLibrary("Tablet-2.0");
TankadinTps:RegisterDB("TankadinTpsDB");


local debugColor = {0,1,1};

local fuBarTooltip_lastCat = true;
local fuBarTooltip_saveCat = false;
local fuBarTooltip_importCat = false;

local colStrPause = "007fff";
local colStrTps = "ff7f00";
local colStrNormal = "ffd100";

StaticPopupDialogs["CONFIRM_TTPS_RESETDATA"] = {
	text = L["guiResetDataConfirm"],
	button1 = ACCEPT,
	button2 = CANCEL,
	OnAccept = function() TtpsData:ResetData(); end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

function TankadinTps:OnInitialize()
	
	self:RegisterChatCommand("/TankadinTps", self.options, "TANKADINTPS");
	
	self:RegisterMetro(self.name .."_fubar", self.Tick, 1, self);
	
	-- FuBar stuff
	self.cannotDetachTooltip = true;
	self.clickableTooltip = true;
	self.defaultMinimapPosition = 210;
	self.hasIcon = false;
	
	TtpsData:Load();
end

function TankadinTps:OnEnable()		
	
end

--[[
----------------------------------------------------------------
FuBar stuff
----------------------------------------------------------------
--]]

function TankadinTps:GetTitle()
	return "|cfff48cbaTankadin|r|cffffffffTps|r";
end

function TankadinTps:GetIcon()
	return "Interface\\Icons\\Spell_Holy_DevotionAura";
end
 
-- using an AceOptions data table
TankadinTps.OnMenuRequest = {
   type = 'group',
   args = {
		pauseAllStart = {
			type = "execute",
			name = L["fuBarPauseStart"],
			desc = L["fuBarPauseDesc"],
			order = 40,
			func = function(v) TankadinTps:Pause(); end,
		},
		pauseAllStop = {
			type = "execute",
			name = L["fuBarPauseStop"],
			desc = L["fuBarPauseDesc"],
			order = 41,
			func = function(v) TankadinTps:Record(); end,
		},
		
		spacer1 = {
			type = "header",
			name = " ",
			order = 42,
		},
		
       resetDetails = {
           type = "execute",
           name = L["guiResetDetailWin"],
           desc = L["guiResetDetailWinDesc"],
		   order = 70,
           func = function() if (TankadinTpsDetailsFrame) then TankadinTpsDetailsFrame:ClearAllPoints(); TankadinTpsDetailsFrame:SetPoint("CENTER", UIParent, "CENTER"); end end,
       },
		deleteData = {
           type = "execute",
           name = L["guiResetData"],
           desc = L["guiResetDataDesc"],
		   order = 75,
           func = function()  StaticPopup_Show("CONFIRM_TTPS_RESETDATA"); end,
       },

		spacer2 = {
			type = "header",
			name = " ",
			order = 99,
		},
		
	   tools = {
			type = "group",
			name = L["guiTools"],
			desc = L["guiTools"],
			order = 100,
			args = {
		       openDebug = {
		           type = "execute",
		           name = L["guiShowDebugWin"],
		           desc = L["guiShowDebugWinDesc"],
		           func = function() TtpsDebug:Show(); end,
		       },
		       openScience = {
		           type = "execute",
		           name = L["guiShowScienceWin"],
		           desc = L["guiShowScienceWinDesc"],
		           func = function() TtpsScienceLab:Show(); end,
		       },
			   ping = {
					type = "execute",
					name = L["guiPing"],
					desc = L["guiPingDesc"],
					func = function() TtpsCommunication:QueryVersion(); end,
			   }
			}
	   },
   },
 }
 

 function TankadinTps:OnTextUpdate()
	local tps = 0;
	local threat = 0;
	local col = colStrNormal;
 
	local guid = UnitGUID("target");
	if (guid) then
		local data = TtpsData:GetDataInCombat(guid);
		
		if (data) then
			col = colStrTps;
			local cTime = time();
			local pTime = 0;
			
			
			if (data.pauseData.start > 0) then 
				pTime = cTime - data.pauseData.start;
				col = colStrPause;
			end
			
			local dTime = cTime - data.timeStart - data.timePaused - pTime;
			if (dTime > 0) then
				tps = data.sumSkills/dTime;
			end

			threat = data.sumSkills/1000;
		end
	else
		if (TtpsData:GetPause()) then
			col = colStrPause;
		end
	end
	
	self:SetText(string.format("|cff"..col.."%.1f "..L["oTps"].." (%.1fk)|r", tps, threat));
 end
 
 
 function TankadinTps:OnTooltipUpdate()
 
 	local cat = tablet:AddCategory('columns',1)
	
	cat = tablet:AddCategory('id','data',
		'columns',1,
		'text',L["guiCatRecent"],
		'showWithoutChildren',true,
		'checked',true,
		'hasCheck',true,
		'checkIcon',fuBarTooltip_lastCat and "Interface\\Buttons\\UI-MinusButton-Up" or "Interface\\Buttons\\UI-PlusButton-Up",
		'func',function() fuBarTooltip_lastCat = not fuBarTooltip_lastCat end);
		
	local line = "";
	local lineData = {};
	if (fuBarTooltip_lastCat) then
		-- in combat data
		for k,v in pairs(TtpsData:GetDataInCombat()) do
		
			local timeEnd, dTime, pTime;
			local tps = 0;
			local col;
			
			timeEnd = time();
			
			if (v.pauseData.start > 0) then 
				pTime = timeEnd - v.pauseData.start;
				col = colStrPause;
			else
				pTime = 0;
				col = colStrTps;
			end
			
			dTime = timeEnd - v.timeStart - v.timePaused - pTime;
			if (dTime > 0) then
				tps = v.sumSkills/dTime;
			end
			
			line = string.format("|cff"..col.."%s : \195\152 %.1f "..L["tps"].." (%.1fk)".."|r", v.name, tps, (v.sumSkills / 1000))
			table.insert(lineData, {line, k, v.timeStart});
		end
		
		table.sort(lineData, function(a,b) if (a[3] and b[3]) then return a[3] > b[3]; else return false; end end);
		
		for k,v in pairs(lineData) do
			cat:AddLine("text",v[1]);
		end
		
		-- out of combat data
		line = "";
		lineData = {};
		for k,v in pairs(TtpsData:GetDataOutOfCombat()) do
		
			local dTime;
			local tps = 0;
					
			dTime = v.timeEnd - v.timeStart - v.timePaused;
			if (dTime > 0) then
				tps = v.sumSkills/dTime;
			end
			line = string.format("%s : \195\152 %.1f "..L["tps"].." (%.1fk)", v.name, tps, (v.sumSkills / 1000))
			table.insert(lineData, {line, k, v.timeStart});
		end
		
		table.sort(lineData, function(a,b) if (a[3] and b[3]) then return a[3] > b[3]; else return false; end end);
		
		for k,v in pairs(lineData) do
			cat:AddLine("text",v[1],"func",function() TtpsFrames:OpenDetails(v[2], "data"); end);
		end
	end
	
	-- imported data
	if (#TtpsData:GetImportedData() >0) then
		cat = tablet:AddCategory('id','importedData',
			'columns',1,
			'text',L["guiCatImported"],
			'showWithoutChildren',true,
			'checked',true,
			'hasCheck',true,
			'checkIcon',fuBarTooltip_importCat and "Interface\\Buttons\\UI-MinusButton-Up" or "Interface\\Buttons\\UI-PlusButton-Up",
			'func',function() fuBarTooltip_importCat = not fuBarTooltip_importCat end);
		
		line = "";
		lineData = {};
		if (fuBarTooltip_importCat) then
			for k,v in pairs(TtpsData:GetImportedData()) do
				local timeEnd, dTime;
				local tps = 0;
				
				timeEnd = v.timeEnd;		
				dTime = timeEnd - v.timeStart - v.timePaused;
				if (dTime > 0) then
					tps = v.sumSkills/dTime;
				end
				line = string.format("%s : \195\152 %.1f "..L["tps"].." (%.1fk) [%s]", v.name, tps, (v.sumSkills / 1000), v.playerName)
				table.insert(lineData, {line, k, v.timeStart});
			end
			
			table.sort(lineData, function(a,b) if (a[3] and b[3]) then return a[3] > b[3]; else return false; end end);
			
			for k,v in pairs(lineData) do
				cat:AddLine("text",v[1],"func",function() TtpsFrames:OpenDetails(v[2], "imported"); end);
			end
		end
	end
	
	
	-- saved data
	cat = tablet:AddCategory('id','savedData',
		'columns',1,
		'text',L["guiCatSaved"],
		'showWithoutChildren',true,
		'checked',true,
		'hasCheck',true,
		'checkIcon',fuBarTooltip_saveCat and "Interface\\Buttons\\UI-MinusButton-Up" or "Interface\\Buttons\\UI-PlusButton-Up",
		'func',function() fuBarTooltip_saveCat = not fuBarTooltip_saveCat end);
	
	line = "";
	lineData = {};
	if (fuBarTooltip_saveCat) then
		for k,v in pairs(TtpsData:GetSavedData()) do
			local timeEnd, dTime;
			local tps = 0;
			
			timeEnd = v.timeEnd;		
			dTime = timeEnd - v.timeStart - v.timePaused;
			if (dTime > 0) then
				tps = v.sumSkills/dTime;
			end
			line = string.format("%s : \195\152 %.1f "..L["tps"].." (%.1fk)", v.name, tps, (v.sumSkills / 1000))
			table.insert(lineData, {line, k, v.timeStart});
		end
		
		table.sort(lineData, function(a,b) if (a[3] and b[3]) then return a[3] > b[3]; else return false; end end);
		
		for k,v in pairs(lineData) do
			cat:AddLine("text",v[1],"func",function() TtpsFrames:OpenDetails(v[2], "saved"); end);
		end
	end
  
   tablet:SetHint(L["guiHint"]);
 end
 
function TankadinTps:OnClick()
	if (TtpsData:GetPause()) then
		self:Record();
	else
		self:Pause();
	end
end
 
  
function TankadinTps:Clear()
	
end

function TankadinTps:Out(line, color)
	DEFAULT_CHAT_FRAME:AddMessage(line);
end

function TankadinTps:Record()
	TtpsData:SetPause(false);
	self:Out(L["record"]);
	self:Update();
end

function TankadinTps:Pause()
	TtpsData:SetPause(true);
	self:Out(L["pause"]);
	self:Update();
end

--[[
----------------------------------------------------------------
 registered events 
----------------------------------------------------------------
--]]

function TankadinTps:EnterCombat()
	self:StartMetro(self.name .."_fubar");
end

function TankadinTps:LeaveCombat()
	self:StopMetro(self.name .."_fubar");
end

function TankadinTps:Tick(difference)
	self:Update();
end



