
local function round(num, idp)
	local mult = 10 ^ (idp or 0);
	return math.floor(num * mult + 0.5) / mult;
end

function Tankadin_Options_Toggle()
	if ( Tankadin_Options_TabContainerFrame:IsShown() ) then
		Tankadin_Options_TabContainerFrame:Hide();
	else
		Tankadin_Options_TabContainerFrame:Show();
	end
end

function Tankadin_SetupSlider(self, text, myMin, myMax, step)
	getglobal(self:GetName().."Text"):SetText(text);
	getglobal(self:GetName().."Low"):SetText(myMin);
	getglobal(self:GetName().."High"):SetText(myMax);
	self:SetMinMaxValues(myMin, myMax);
	self:SetValueStep(step);
end

function Tankadin_OpenColorPicker(button)
	-- Debug Function -->Tankadin_Message(button);
	local colors = getglobal(button.."NormalTexture"):GetVertexColor();
	local button_name = "";
	if (button == "Tankadin_Options_TabContainerFrame_TabPage3_BGColor") then
		button_name = "BGColor";
		button_r = Tankadin_Options.BGColor[1];
		button_g = Tankadin_Options.BGColor[2];
		button_b = Tankadin_Options.BGColor[3];
		button_a = Tankadin_Options.BGColor[4];
	elseif (button == "Tankadin_Options_TabContainerFrame_TabPage3_FrameColor") then
		button_name = "FrameColor";
		button_r = Tankadin_Options.frameColor[1];
		button_g = Tankadin_Options.frameColor[2];
		button_b = Tankadin_Options.frameColor[3];
		button_a = Tankadin_Options.frameColor[4];
	elseif (button == "Tankadin_Options_TabContainerFrame_TabPage3_TextColor") then
		button_name = "TextColor";
		button_r = Tankadin_Options.TextColor[1];
		button_g = Tankadin_Options.TextColor[2];
		button_b = Tankadin_Options.TextColor[3];
		button_a = Tankadin_Options.TextColor[4];
	elseif (button == "Tankadin_Options_TabContainerFrame_TabPage3_WarnColor") then
		button_name = "WarnColor";
		button_r = Tankadin_Options.WarnColor[1];
		button_g = Tankadin_Options.WarnColor[2];
		button_b = Tankadin_Options.WarnColor[3];
		button_a = Tankadin_Options.WarnColor[4];
	end
	-- Debug Function -->Tankadin_Message(button_name);
	Tankadin_CurrentSwatch = button;
	ColorPickerFrame.hasOpacity = true;
	ColorPickerFrame.opacityFunc = function() Tankadin_ColorPickerChanged(); end;
	ColorPickerFrame.func = function() Tankadin_ColorPickerChanged(); end;
	ColorPickerFrame.opacity = button_a;
	ColorPickerFrame:SetColorRGB(button_r, button_g, button_b);
	ColorPickerFrame.previousValues = {button_r, button_g, button_b,button_a};
	ColorPickerFrame.cancelFunc = Tankadin_ColorPickerCanceled({button_r, button_g, button_b,button_a});
	ColorPickerFrame:ClearAllPoints();
	if (Tankadin_Options_TabContainerFrame:GetRight() < UIParent:GetWidth() / 2) then
		ColorPickerFrame:SetPoint("LEFT", "Tankadin_Options_TabContainerFrame", "RIGHT", 10, 0);
	else
		ColorPickerFrame:SetPoint("RIGHT", "Tankadin_Options_TabContainerFrame", "LEFT", -10, 0);
	end
	ColorPickerFrame:Show();
end

function Tankadin_ColorPickerChanged()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	local a = OpacitySliderFrame:GetValue();
	Tankadin_UpdateSwatchColor(r,g,b,a);
end

function Tankadin_ColorPickerCanceled(prevvals)
	local r,g,b,a = unpack(prevvals)
	Tankadin_UpdateSwatchColor(r,g,b,a);
end


function Tankadin_UpdateSwatchColor(r,g,b,a)
	if(Tankadin_CurrentSwatch == "Tankadin_Options_TabContainerFrame_TabPage3_BGColor") then
		Tankadin_Options.BGColor[1] = r;
		Tankadin_Options.BGColor[2] = g;
		Tankadin_Options.BGColor[3] = b;
		Tankadin_Options.BGColor[4] = a;
	elseif(Tankadin_CurrentSwatch == "Tankadin_Options_TabContainerFrame_TabPage3_FrameColor") then
		Tankadin_Options.frameColor[1] = r;
		Tankadin_Options.frameColor[2] = g;
		Tankadin_Options.frameColor[3] = b;
		Tankadin_Options.frameColor[4] = a;
	elseif(Tankadin_CurrentSwatch == "Tankadin_Options_TabContainerFrame_TabPage3_TextColor") then
		Tankadin_Options.TextColor[1] = r;
		Tankadin_Options.TextColor[2] = g;
		Tankadin_Options.TextColor[3] = b;
		Tankadin_Options.TextColor[4] = a;
	elseif(Tankadin_CurrentSwatch == "Tankadin_Options_TabContainerFrame_TabPage3_WarnColor") then
		Tankadin_Options.WarnColor[1] = r;
		Tankadin_Options.WarnColor[2] = g;
		Tankadin_Options.WarnColor[3] = b;
		Tankadin_Options.WarnColor[4] = a;
	end


	getglobal(Tankadin_CurrentSwatch.."NormalTexture"):SetVertexColor(r,g,b);
	Tankadin_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_AD_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_AD_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_Info_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_Info_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_RF_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_RF_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_UpdateTextColors();
end

function Tankadin_UpdateTextColors()
	Tankadin_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_AD_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_Info_Frame_Name_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_Info_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
end

function Tankadin_Options_Init()
	Tankadin_Options_TabContainerFrame_TabPage1_ShowBox:SetChecked(Tankadin_Options.show);
	Tankadin_Options_TabContainerFrame_TabPage1_MiniBox:SetChecked(Tankadin_Options.mini);
	Tankadin_Options_TabContainerFrame_TabPage1_BasicButton:SetChecked(Tankadin_Options.tbasic);
	Tankadin_Options_TabContainerFrame_TabPage1_AdvButton:SetChecked(Tankadin_Options.tadv);
	Tankadin_Options_TabContainerFrame_TabPage2_AnnounceBox:SetChecked(Tankadin_Options.announce);
	Tankadin_Options_TabContainerFrame_TabPage1_LockBox:SetChecked(Tankadin_Options.lock);
	Tankadin_Options_TabContainerFrame_TabPage1_GrowUpBox:SetChecked(Tankadin_Options.growup);
	Tankadin_Options_TabContainerFrame_TabPage2_DeathAvoidAnn:SetChecked(Tankadin_Options.DeathAvoidAnn);
	Tankadin_Options_TabContainerFrame_TabPage3_BGColorNormalTexture:SetVertexColor(Tankadin_Options.BGColor[1], Tankadin_Options.BGColor[2], Tankadin_Options.BGColor[3]);
	Tankadin_Options_TabContainerFrame_TabPage3_FrameColorNormalTexture:SetVertexColor(Tankadin_Options.frameColor[1], Tankadin_Options.frameColor[2], Tankadin_Options.frameColor[3]);
	Tankadin_Options_TabContainerFrame_TabPage3_TextColorNormalTexture:SetVertexColor(Tankadin_Options.TextColor[1], Tankadin_Options.TextColor[2], Tankadin_Options.TextColor[3]);
	Tankadin_Options_TabContainerFrame_TabPage3_WarnColorNormalTexture:SetVertexColor(Tankadin_Options.WarnColor[1], Tankadin_Options.WarnColor[2], Tankadin_Options.WarnColor[3]);
	Tankadin_Options_TabContainerFrame_TabPage3_AlphaSlider:SetValue(Tankadin_Options.alpha);
	Tankadin_Options_TabContainerFrame_TabPage3_ScaleSlider:SetValue(Tankadin_Options.scale);
	Tankadin_Options_TabContainerFrame_TabPage1_WarnBox:SetChecked(Tankadin_Options.warn);
	Tankadin_Options_TabContainerFrame_TabPage1_RFOnceButton:SetChecked(not Tankadin_Options.RFConstant);
	Tankadin_Options_TabContainerFrame_TabPage1_RFAlwaysButton:SetChecked(Tankadin_Options.RFConstant);
	Tankadin_Options_TabContainerFrame_TabPage5_TauntBox:SetChecked(Tankadin_Options.taunt);
	Tankadin_Options_TabContainerFrame_TabPage5_NoImmuneBox:SetChecked(Tankadin_Options.NoImmune);
	Tankadin_Options_TabContainerFrame_TabPage2_ADClearBox:SetChecked(Tankadin_Options.ADClear);
	Tankadin_Options_TabContainerFrame_TabPage4_DetachAD:SetChecked(Tankadin_Options.Tankadin_AD_Frame.detach);
	Tankadin_Options_TabContainerFrame_TabPage4_HideAD:SetChecked(Tankadin_Options.Tankadin_AD_Frame.hide);
	Tankadin_Options_TabContainerFrame_TabPage4_DetachRF:SetChecked(Tankadin_Options.Tankadin_RF_Frame.detach);
	Tankadin_Options_TabContainerFrame_TabPage4_HideRF:SetChecked(Tankadin_Options.Tankadin_RF_Frame.hide);
	Tankadin_Options_TabContainerFrame_TabPage4_DetachInfo:SetChecked(Tankadin_Options.Tankadin_Info_Frame.detach);
	Tankadin_Options_TabContainerFrame_TabPage4_HideInfo:SetChecked(Tankadin_Options.Tankadin_Info_Frame.hide);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton1:SetChecked(nil);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton2:SetChecked(nil);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton3:SetChecked(nil);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton4:SetChecked(nil);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton5:SetChecked(nil);
	Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton6:SetChecked(nil);
	if(Tankadin_Options.WarnFrameType == 1) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton1:SetChecked(true);
	elseif(Tankadin_Options.WarnFrameType == 2) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton2:SetChecked(true);
	elseif(Tankadin_Options.WarnFrameType == 3) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton3:SetChecked(true);
	elseif(Tankadin_Options.WarnFrameType == 4) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton4:SetChecked(true);
	elseif(Tankadin_Options.WarnFrameType == 5) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton5:SetChecked(true);
	elseif(Tankadin_Options.WarnFrameType == 6) then
		Tankadin_Options_TabContainerFrame_TabPage3_WarningFrameButton6:SetChecked(true);
	end
	Tankadin_UpdateTextColors();
	Tankadin_ListPlugins();
end

Tankadin_Output = {};

function TankadinReportData(info)

if (GetNumRaidMembers() > 0) then
	channel = "RAID";
elseif (GetNumPartyMembers() > 0) then
	channel = "PARTY";
else
	channel = "SAY";
end

if (Tankadin_RChan2:GetChecked()) then
	channel = "GUILD";
end

if (Tankadin_RChan3:GetChecked()) then
	channel = "WHISPER";
	index = UnitName("target");
end

if (Tankadin_RChan4:GetChecked()) then
	channel = "CHANNEL";
	index = TankadinRChan_InputBox:GetText();
end

if (channel == nil) then
	Tankadin_Message("Unkown Channel or Target");
	info = "None";
end

if (info == "AD") then

Tankadin_Output = {};

	Tankadin_Message(TANKADIN_OPTIONS_RAD_S..channel);
	
	Tankadin_Output = {};
	hplimit = round(UnitHealthMax("player") * 0.35, 0);
	table.insert(Tankadin_Output,"AD Tracking Stats for: "..UnitName("player"));
	table.insert(Tankadin_Output,TANKADIN_DATA_DT_LONG..": "..round(Tankadin_ADInfo.DamageTaken, 0));
	table.insert(Tankadin_Output,TANKADIN_DATA_DM_LONG..": "..round(Tankadin_ADInfo.DamageADMitigated, 0));
	table.insert(Tankadin_Output,TANKADIN_DATA_PERCENT..": "..Tankadin_ADInfo.percentageReduced.."%");
	table.insert(Tankadin_Output,TANKADIN_DATA_DA_LONG..": "..Tankadin_ADInfo.DeathsAverted);
	table.insert(Tankadin_Output,TANKADIN_AD_HP_ACTIVE.." "..hplimit.." "..TANKADIN_AD_HP_ABBR);
	
elseif (info == "Info_Short") then
	Tankadin_Message(TANKADIN_OPTIONS_RISHORT_S..channel);
	
	Tankadin_Output = {};
	
	Tankadin_UpdateInfo();
		
	table.insert(Tankadin_Output,"Attack Table Information for: "..UnitName("player"));
	table.insert(Tankadin_Output,TANKADIN_AD_HP_ABBR..": "..UnitHealthMax("player"));
	table.insert(Tankadin_Output,TANKADIN_TOTAL..": "..Tankadin_Info.total.."%");
	table.insert(Tankadin_Output,TANKADIN_BLOCK..": "..Tankadin_Info.block.."%");
	table.insert(Tankadin_Output,TANKADIN_UPDOWN..": "..Tankadin_Info.updown);
	table.insert(Tankadin_Output,TANKADIN_BVALUE..": "..Tankadin_Info.blockValue);
	table.insert(Tankadin_Output,TANKADIN_DEFENSE..": "..Tankadin_Info.defense);
	table.insert(Tankadin_Output,TANKADIN_HSD..": "..Tankadin_Info.HDamage);
		
elseif (info == "Info_Long") then
	Tankadin_Message(TANKADIN_OPTIONS_RILONG_S..channel);
	
	Tankadin_Output = {};
	
	Tankadin_UpdateInfo();
	
	local base, effectiveArmor, armor, posBuff, negBuff = UnitArmor("player");
	EH = round((UnitHealthMax("player")*(armor+11960))/((1-(Tankadin_GetImpRF()*0.02))*11960), 2);
	EH_Blocking_Min = round((3000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*3000 - GetShieldBlock()*(armor+11960)), 2);
	EH_Blocking_Max = round((10000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*10000 - GetShieldBlock()*(armor+11960)), 2);
	EH_TDR = round(1 - (((1-(Tankadin_Info.total/100))*(1-Tankadin_GetImpRF()*.02)*11960)/(armor+11960)), 4);
		
	table.insert(Tankadin_Output,"Attack Table Information for: "..UnitName("player"));
	table.insert(Tankadin_Output,TANKADIN_AD_HP_ABBR..": "..UnitHealthMax("player"));
	table.insert(Tankadin_Output,TANKADIN_MISS..": "..Tankadin_Info.miss.."%");
	table.insert(Tankadin_Output,TANKADIN_DODGE..": "..Tankadin_Info.dodge.."%");
	table.insert(Tankadin_Output,TANKADIN_PARRY..": "..Tankadin_Info.parry.."%");
	table.insert(Tankadin_Output,TANKADIN_TOTAL..": "..Tankadin_Info.total.."%");
	table.insert(Tankadin_Output,TANKADIN_BLOCK..": "..Tankadin_Info.block.."%");
	table.insert(Tankadin_Output,TANKADIN_UPDOWN..": "..Tankadin_Info.updown);
	table.insert(Tankadin_Output,TANKADIN_BVALUE..": "..Tankadin_Info.blockValue);
	table.insert(Tankadin_Output,TANKADIN_DEFENSE..": "..Tankadin_Info.defense);
	table.insert(Tankadin_Output,TANKADIN_HSD..": "..Tankadin_Info.HDamage);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_BASE..": "..EH);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_MAX..": "..EH_Blocking_Max);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_MIN..": "..EH_Blocking_Min);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_TDR..": "..(EH_TDR * 100).."%");
	
elseif (info == "EH") then
	Tankadin_Message(TANKADIN_OPTIONS_REH_S..channel);
	
	Tankadin_Output = {};
	
	local base, effectiveArmor, armor, posBuff, negBuff = UnitArmor("player");
	EH = round((UnitHealthMax("player")*(armor+11960))/((1-(Tankadin_GetImpRF()*0.02))*11960), 2);
	EH_Blocking_Min = round((3000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*3000 - GetShieldBlock()*(armor+11960)), 2);
	EH_Blocking_Max = round((10000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*10000 - GetShieldBlock()*(armor+11960)), 2);
	EH_TDR = round(1 - (((1-(Tankadin_Info.total/100))*(1-Tankadin_GetImpRF()*.02)*11960)/(armor+11960)), 4);

	table.insert(Tankadin_Output,TANKADIN_INFO_EH_BASE..": "..EH);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_MAX..": "..EH_Blocking_Max);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_MIN..": "..EH_Blocking_Min);
	table.insert(Tankadin_Output,TANKADIN_INFO_EH_TDR..": "..(EH_TDR * 100).."%");	

else
	Tankadin_Message(TANKADIN_OPTIONS_UNKOWN_S);
end

for k,v in pairs(Tankadin_Output) do
	SendChatMessage(v, channel, nil, index);
end

--Output data here
--SendChatMessage(UnitName("player").." -!!- "..TANKADIN_IMMUNE_MESSAGE, "RAID");
end

Tankadin_Options_CurFrame = Tankadin_Options_TabContainerFrame_TabPage1;

function Tankadin_Options_ChangeFrame(newframe, tab)

Tankadin_Options_CurFrame:Hide();
Tankadin_Options_CurFrame = newframe;
Tankadin_Options_CurFrame:Show();
if (tab ~= nil) then
	PanelTemplates_SetTab(Tankadin_Options_TabContainerFrame, tab);
end

end

function Tankadin_ListPlugins()
	Tankadin_ListString = "";
	for k,v in pairs(Tankadin_Plugins) do
		Tankadin_ListString = Tankadin_ListString..k..": "..v.."\n";
	end
	if (Tankadin_ListString == "") then
		Tankadin_ListString = "-~-~-~-~-~-~-~-~-~-";
	end
	Tankadin_Options_PluginList_Text:SetText(Tankadin_ListString);
end

