Tankadin_Options = {
	show = true,
	lock = false,
	mini = false,
	tbasic = true,
	tadv = false,
	announce = true,
	warn = true,
	taunt = true,
	ADClear = false,
	growup = false,
	DeathAvoidAnn = true,
	NoImmune = false,
	RFConstant = false,
	alpha = 1,
	scale = 1,
	frameColor = {1, 0.8, 0, 0.8},
	BGColor = {0, 0, 0, 0.4},
	TextColor = {1, 0.82, 0, 1},
	WarnColor = {1, 1, 0, .5},
	WarnFrameType = 1,
	Tankadin_AD_Frame = {
		detach = false,
		hidden = false,
		coords = {"CENTER", "CENTER", 0, 0},
	},
	Tankadin_RF_Frame = {
		detach = false,
		hidden = false,
		coords = {"CENTER", "CENTER", 0, 0},
	},
	Tankadin_Info_Frame = {
		detach = false,
		hidden = false,
		coords = {"CENTER", "CENTER", 0, 0},
	}
};

Tankadin_ADInfo = {
		DamageADMitigated = 0,
		DamageTaken = 0,
		DeathsAverted = 0,
		percentageReduced =0,
		TalentInfo = {
			curRank = 0,
			maxRank = 0,
			percent = 0
			}
};

Tankadin_Info = {
	miss = 0,
	dodge = 0,
	parry = 0,
	block = 0,
	blockValue = 0,
	total = 0,
	updown = 0,
	updownColor = 0,
	baseDefense = 0, 
	armorDefense = 0,
	defense = 0,
	resil = 0,
	HDamage = 0
};

function Tankadin_OnLoad(self)
	SLASH_TANKADIN1 = "/tankadin";
	SlashCmdList["TANKADIN"] = Tankadin_SlashCommand;
	--CrushTable Info
	self:RegisterEvent("UNIT_INVENTORY_CHANGED");
	self:RegisterEvent("UNIT_AURA");
	self:RegisterEvent("ADDON_LOADED");
	-- catch the real "enter combat" message to start logging.
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	-- catch the real "leave combat" message to stop logging.
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	-- catch us being hurt or healed.
	self:RegisterEvent("COMBAT_TEXT_UPDATE");
	--Initailize the display
	self:RegisterEvent("VARIABLES_LOADED");
	--Taunt Warn / Avenger Shield/ RF Warning
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	--AD Tracker upgrades
	self:RegisterEvent("CHARACTER_POINTS_CHANGED");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
end

function Tankadin_SlashCommand(msg)
	Tankadin_Options_Toggle();
end

function Tankadin_Message(msg)
	if msg == nil then
		msg = "nil";
	end
	DEFAULT_CHAT_FRAME:AddMessage("-[Tankadin]- "..msg);
end

function Tankadin_Toggle()
	if ( Tankadin_Frame:IsShown() ) then
		Tankadin_Frame:Hide();
		Tankadin_Options.show = false;
	else 
		Tankadin_Frame:Show();
		Tankadin_Options.show = true;
	end
end

function Tankadin_Info_Toggle()
	if ( Tankadin_RF_Frame:IsShown() ) then
		Tankadin_RF_Frame:Hide();
		Tankadin_AD_Frame:Hide();
		Tankadin_Info_Frame:Hide();
		Tankadin_Options.mini = true;
	else
		Tankadin_RF_Frame:Show();
		Tankadin_AD_Frame:Show();
		Tankadin_Info_Frame:Show();
		Tankadin_Options.mini = false;
	end
end	

local function round(num, idp)
	local mult = 10 ^ (idp or 0);
	return math.floor(num * mult + 0.5) / mult;
end

function TankadinUnitHasBuffAdv(spellname, unit, info)
	for i=0, 31 do
		local buffName, rank, iconTexture, count, duration, timeLeft = UnitBuff(unit, i);
		if (spellname == buffName) then
			if (info == "rank") then
				return rank;
			elseif (info == "iconTexture") then
				return iconTexture;
			elseif (info == "count") then
				return count;
			elseif (info == "duration") then
				return durationl;
			elseif (info == "timeLeft") then
				return timeLeft;
			else
			Tankadin_Message("TankadinUnitHasBuffAdv has been called using an invalid sequence.");
			return 0;
			end
		end
	end

	return 0;
end

function Tankadin_GetImpRF()
	nameTalent, icon, tier, column, currRank, maxRank = GetTalentInfo(2,7);
	return currRank;
end

function TankadinRefreshADTalentInfo()
	nameTalent, icon, tier, column, currRank, maxRank = GetTalentInfo(2,20);
    Tankadin_ADInfo.TalentInfo.curRank = currRank;
	Tankadin_ADInfo.TalentInfo.maxRank = maxRank;
	if (currRank == 0) then
		Tankadin_ADInfo.TalentInfo.percent = 0;
	elseif (currRank == 1) then
		Tankadin_ADInfo.TalentInfo.percent = 6;
	elseif (currRank == 2) then
		Tankadin_ADInfo.TalentInfo.percent = 12;
	elseif (currRank == 3) then
		Tankadin_ADInfo.TalentInfo.percent = 18;
	elseif (currRank == 4) then
		Tankadin_ADInfo.TalentInfo.percent = 24;
	elseif (currRank == 5) then
		Tankadin_ADInfo.TalentInfo.percent = 30;
	else
		Tankadin_ADInfo.TalentInfo.percent = 0;
	end

end

function Tankadin_InitDisplay()
	if ( not Tankadin_Options.show ) then
		Tankadin_Frame:Hide();
		Tankadin_RF_Frame:Hide();
		Tankadin_AD_Frame:Hide();
		Tankadin_Info_Frame:Hide();
	end
	
	Tankadin_Frame:SetAlpha(Tankadin_Options.alpha);
	Tankadin_Frame:SetScale(Tankadin_Options.scale);
	Tankadin_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_AD_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_AD_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_Info_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_Info_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_RF_Frame:SetBackdropColor(Tankadin_Options.BGColor[1],Tankadin_Options.BGColor[2],Tankadin_Options.BGColor[3],Tankadin_Options.BGColor[4]);
	Tankadin_RF_Frame:SetBackdropBorderColor(Tankadin_Options.frameColor[1],Tankadin_Options.frameColor[2],Tankadin_Options.frameColor[3],Tankadin_Options.frameColor[4]);
	Tankadin_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_AD_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_Info_Frame_Name_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	Tankadin_Info_Frame_Text:SetTextColor(Tankadin_Options.TextColor[1],Tankadin_Options.TextColor[2],Tankadin_Options.TextColor[3],Tankadin_Options.TextColor[4]);
	if ( Tankadin_Options.growup ) then
		Tankadin_RF_Frame:ClearAllPoints();
		Tankadin_RF_Frame:SetParent("Tankadin_Frame");
		Tankadin_RF_Frame:SetPoint("BOTTOMLEFT", "Tankadin_Frame", "TOPLEFT", 0, 0);
		Tankadin_AD_Frame:ClearAllPoints();
		Tankadin_AD_Frame:SetParent("Tankadin_Frame");
		Tankadin_AD_Frame:SetPoint("BOTTOMLEFT", "Tankadin_Frame", "BOTTOMLEFT", 0, 60);
		Tankadin_Info_Frame:ClearAllPoints();
		Tankadin_Info_Frame:SetParent("Tankadin_Frame");
		Tankadin_Info_Frame:SetPoint("BOTTOMRIGHT", "Tankadin_Frame", "TOPRIGHT", 0, 0);
	end
	if ( not Tankadin_Options.growup ) then
		Tankadin_RF_Frame:ClearAllPoints();
		Tankadin_RF_Frame:SetParent("Tankadin_Frame");
		Tankadin_RF_Frame:SetPoint("TOPLEFT", "Tankadin_Frame", "BOTTOMLEFT", 0, 0);
		Tankadin_AD_Frame:ClearAllPoints();
		Tankadin_AD_Frame:SetParent("Tankadin_Frame");
		Tankadin_AD_Frame:SetPoint("TOPLEFT", "Tankadin_Frame", "BOTTOMLEFT", 0, -40);
		Tankadin_Info_Frame:ClearAllPoints();
		Tankadin_Info_Frame:SetParent("Tankadin_Frame");
		Tankadin_Info_Frame:SetPoint("TOPRIGHT", "Tankadin_Frame", "BOTTOMRIGHT", 0, 0);
	end
	if(Tankadin_Options.WarnFrameType == 1) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\warn1");
	elseif(Tankadin_Options.WarnFrameType == 2) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\warn2");
	elseif(Tankadin_Options.WarnFrameType == 3) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\warn3");
	elseif(Tankadin_Options.WarnFrameType == 4) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\warn4");
	elseif(Tankadin_Options.WarnFrameType == 5) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\warn5");
	elseif(Tankadin_Options.WarnFrameType == 6) then
		Tankadin_RF_Warn_Frame_Texture:SetTexture("Interface\\AddOns\\Tankadin\\Images\\custom");
	end
	
	-- AD FRAME INTI
	if (Tankadin_Options.Tankadin_AD_Frame.detach) then
		Tankadin_AD_Frame:ClearAllPoints();
		Tankadin_AD_Frame:SetParent("UIParent");
		Tankadin_AD_Frame:SetPoint("CENTER", "UIParent");
		Tankadin_AD_Frame:SetMovable(true);
		Tankadin_AD_Frame:ClearAllPoints();
		Tankadin_AD_Frame:SetPoint(Tankadin_Options.Tankadin_AD_Frame.coords[1], nil, Tankadin_Options.Tankadin_AD_Frame.coords[2], Tankadin_Options.Tankadin_AD_Frame.coords[3], Tankadin_Options.Tankadin_AD_Frame.coords[4]);
	end
	if (Tankadin_Options.Tankadin_AD_Frame.hide) then
		Tankadin_AD_Frame:Hide();
	else
		Tankadin_AD_Frame:Show();
	end
	--RF Frame INTI
	if (Tankadin_Options.Tankadin_RF_Frame.detach) then
		Tankadin_RF_Frame:ClearAllPoints();
		Tankadin_RF_Frame:SetParent("UIParent");
		Tankadin_RF_Frame:SetPoint("CENTER", "UIParent");
		Tankadin_RF_Frame:SetMovable(true);
		Tankadin_RF_Frame:ClearAllPoints();
		Tankadin_RF_Frame:SetPoint(Tankadin_Options.Tankadin_RF_Frame.coords[1], nil, Tankadin_Options.Tankadin_RF_Frame.coords[2], Tankadin_Options.Tankadin_RF_Frame.coords[3], Tankadin_Options.Tankadin_RF_Frame.coords[4]);
	end
	if (Tankadin_Options.Tankadin_RF_Frame.hide) then
		Tankadin_RF_Frame:Hide();
	else
		Tankadin_RF_Frame:Show();
	end
	--INFO FRAME INIT
	if (Tankadin_Options.Tankadin_Info_Frame.detach) then
		Tankadin_Info_Frame:ClearAllPoints();
		Tankadin_Info_Frame:SetParent("UIParent");
		Tankadin_Info_Frame:SetPoint("CENTER", "UIParent");
		Tankadin_Info_Frame:SetMovable(true);
		Tankadin_Info_Frame:ClearAllPoints();
		Tankadin_Info_Frame:SetPoint(Tankadin_Options.Tankadin_Info_Frame.coords[1], nil, Tankadin_Options.Tankadin_Info_Frame.coords[2], Tankadin_Options.Tankadin_Info_Frame.coords[3], Tankadin_Options.Tankadin_Info_Frame.coords[4]);
	end
	if (Tankadin_Options.Tankadin_Info_Frame.hide) then
		Tankadin_Info_Frame:Hide();
	else
		Tankadin_Info_Frame:Show();
	end
	if ( Tankadin_Options.mini ) then
		Tankadin_RF_Frame:Hide();
		Tankadin_AD_Frame:Hide();
		Tankadin_Info_Frame:Hide();
	end
end

function Tankadin_UpdateInfo()
	Tankadin_Info.miss = round(GetDodgeBlockParryChanceFromDefense() + 5, 2);
	Tankadin_Info.dodge = round(GetDodgeChance(), 2);
	Tankadin_Info.parry = round(GetParryChance(), 2);
	Tankadin_Info.block = round(GetBlockChance(), 2);
	Tankadin_Info.blockValue = round(GetShieldBlock(), 2);
	Tankadin_Info.total = round((Tankadin_Info.miss + Tankadin_Info.dodge + Tankadin_Info.parry), 2);
	Tankadin_Info.updown = round(((Tankadin_Info.total + Tankadin_Info.block) - 102.4), 2);
	Tankadin_Info.baseDefense, Tankadin_Info.armorDefense = UnitDefense("player");
	Tankadin_Info.defense = Tankadin_Info.armorDefense + Tankadin_Info.baseDefense;
	Tankadin_Info.resil = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE);
	Tankadin_Info.updownColor = "|cffff0000"..Tankadin_Info.updown.."%|r\n";
	if (GetDodgeBlockParryChanceFromDefense() + Tankadin_Info.resil) >= 5.6 then
		Tankadin_Info.updownColor = "|cffff8000"..Tankadin_Info.updown.."%|r\n";
	end
	if Tankadin_Info.updown >= 0 then
		Tankadin_Info.updownColor = "|cff00ff00"..Tankadin_Info.updown.."%|r\n";
	end
	Tankadin_Info.HDamage = GetSpellBonusDamage(2);
end

function Tankadin_ResetDefaults()
	Tankadin_Options = {
		version = TANKADIN_VERSION,
		show = true,
		lock = false,
		mini = false,
		tbasic = true,
		tadv = false,
		announce = true,
		warn = true,
		taunt = true,
		ADClear = false,
		growup = false,
		DeathAvoidAnn = true,
		NoImmune = false,
		RFConstant = false,
		alpha = 1,
		scale = 1,
		frameColor = {1, 0.8, 0, 0.8},
		BGColor = {0, 0, 0, 0.4},
		TextColor = {1, 0.82, 0, 1},
		WarnColor = {1, 1, 0, .5},
		WarnFrameType = 1,
		Tankadin_AD_Frame = {
			detach = false,
			hidden = false,
			coords = {"CENTER", "CENTER", 0, 0},
		},
		Tankadin_RF_Frame = {
			detach = false,
			hidden = false,
			coords = {"CENTER", "CENTER", 0, 0},
		},
		Tankadin_Info_Frame = {
			detach = false,
			hidden = false,
			coords = {"CENTER", "CENTER", 0, 0},
		}
	};
	Tankadin_ADInfo = {
		DamageADMitigated = 0,
		DamageTaken = 0,
		DeathsAverted = 0,
		percentageReduced =0,
		TalentInfo = {
			curRank = 0,
			maxRank = 0,
			percent = 0
			}
	};

end

function Tankadin_VersionCheck(ver)
	if (Tankadin_Options.version ~= ver) then
		Tankadin_ResetDefaults();
		TankadinRefreshADTalentInfo();
		Tankadin_Message(TANKADIN_VERSION_UPDATE);
	end
end

function Tankadin_OnEvent(self, event, ...)

	--Local Functions
	local band = bit.band;
	local floor = math.floor;

	-- Grab Variables
	local PlayerName           = UnitName("player");
	local PlayerGUID           = UnitGUID("player");
	local NumRaid              = GetNumRaidMembers();
	local NumParty             = GetNumPartyMembers();
	local RaidLeader           = IsRaidLeader();
	local RaidOfficer          = IsRaidOfficer();
	local PlayerHP             = UnitHealth("player");
	local PlayerHP_MAX         = UnitHealthMax("player");
	local adThreshold          = floor(PlayerHP_MAX * 0.35);
	local OnTaxi               = UnitOnTaxi("player");
	local Resting              = IsResting();
	local TankadinEventMessage = "";
	
	--Assemble Combt Messge to monitor
	local Tankadin_ADCOMBAT_EVENTS = {
		SWING_DAMAGE = true,
		RANGE_DAMAGE = true,
		SPELL_DAMAGE = true,
		SPELL_PERIODIC_DAMAGE = true,
		DAMAGE_SHIELD = true,
		DAMAGE_SPLIT = true
	}

	-- Version Check
	if ( event == "VARIABLES_LOADED" ) then
		Tankadin_VersionCheck(TANKADIN_VERSION);
		Tankadin_InitDisplay();
		
	local class = select(2,UnitClass("player"))
		if (class ~= "PALADIN") then
			Tankadin_Message(TANKADIN_ADDON_DISABLED);
			DisableAddOn("Tankadin");
			Tankadin_Frame:Hide();
			self:UnregisterAllEvents();
			return
		end
	end

	-- RF Warning
	local RF_TimeRemain = TankadinUnitHasBuffAdv(TANKADIN_RF, "player", "timeLeft");
	
	--fixes a wierd bug
	if (RF_TimeRemain == nil) then
		RF_TimeRemain = 0;
	end
	
	if (RF_TimeRemain > 0) then
		if (RF_TimeRemain <= 30 and Tankadin_Options.warn and Resting == nil and OnTaxi ~= 1 ) then
			Tankadin_RF_Warn_Frame_Texture:SetVertexColor(Tankadin_Options.WarnColor[1], Tankadin_Options.WarnColor[2], Tankadin_Options.WarnColor[3], Tankadin_Options.WarnColor[4]);
			UIFrameFlash(Tankadin_RF_Warn_Frame, 1, 1, 3.5, false, 1, 0.5);
		else
			Tankadin_RF_FrameRFuryButtonMainTexture:SetVertexColor(1, 1, 1);
		end
	else
		Tankadin_RF_FrameRFuryButtonMainTexture:SetVertexColor(1, 0.2, 0.2);
		if (Tankadin_Options.RFConstant and not UnitIsDeadOrGhost("player") and Resting == nil and OnTaxi ~= 1 )  then
			Tankadin_RF_Warn_Frame_Texture:SetVertexColor(Tankadin_Options.WarnColor[1], Tankadin_Options.WarnColor[2], Tankadin_Options.WarnColor[3], Tankadin_Options.WarnColor[4]);
			UIFrameFlash(Tankadin_RF_Warn_Frame, 1, 1, 3.5, false, 1, 0.5);
		end
	end
	-- New Event Handler
	if (event == "COMBAT_LOG_EVENT_UNFILTERED" )then
		local timestamp, eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, prefix1, prefix2, prefix3, suffix1, suffix2, suffix3, suffix4, suffix5, suffix6, suffix7, suffix8 = ...;
		--local timestamp, eventType, srcGUID,    srcName,    srcFlags,    dstGUID,  dstName,  dstFlags,  spellId, spellName,spellSchool,amount
	
	-- Start Events
	
	--RF Fade
		if( eventType == "SPELL_AURA_REMOVED" and destGUID == PlayerGUID and prefix1 == 25780 and Tankadin_Options.warn and Resting == nil )then
			Tankadin_RF_Warn_Frame_Texture:SetVertexColor(Tankadin_Options.WarnColor[1], Tankadin_Options.WarnColor[2], Tankadin_Options.WarnColor[3], Tankadin_Options.WarnColor[4]);
			UIFrameFlash(Tankadin_RF_Warn_Frame, 1, 1, 3.5, false, 1, 0.5); 
		end
		
	--AS Miss
		if( eventType == "SPELL_MISSED" and sourceGUID == PlayerGUID and prefix1 == 32700 and Tankadin_Options.taunt == true )then
			TankadinEventMessage = TANKADIN_MISS_MESSAGE;
		end
	
	--RD Resist
		if( eventType == "SPELL_MISSED" and sourceGUID == PlayerGUID and prefix1 == 31790 and Tankadin_Options.taunt == true and suffix1 == "RESIST")then
			TankadinEventMessage = TANKADIN_RESIST_MESSAGE;
		end
		
	--RD Immune
		if( eventType == "SPELL_MISSED" and sourceGUID == PlayerGUID and prefix1 == 31790 and Tankadin_Options.taunt == true and suffix1 == "IMMUNE" and not Tankadin_Options.NoImmune)then
			TankadinEventMessage = TANKADIN_IMMUNE_MESSAGE;
		end
		
	-- End Events
	
	--Start AD Tracking
	--OnCombatLog(event, timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, amount)
		if( not Tankadin_ADCOMBAT_EVENTS[eventType] or (band(destFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) == 0)) then 
		
		else
	
	--Reassign Damage for physical attacks
			if eventType == "SWING_DAMAGE" then
				suffix1 = prefix1;
			end
	
	--Check for AD Range
			if (PlayerHP < adThreshold) then
				local OriginalDamage = floor(100 / (100 - Tankadin_ADInfo.TalentInfo.percent) * suffix1);
				Tankadin_ADInfo.DamageTaken = Tankadin_ADInfo.DamageTaken + OriginalDamage;
				Tankadin_ADInfo.DamageADMitigated = Tankadin_ADInfo.DamageADMitigated + (OriginalDamage - suffix1);
				if( PlayerHP <= OriginalDamage ) then
					Tankadin_ADInfo.DeathsAverted = Tankadin_ADInfo.DeathsAverted + 1;
					if (Tankadin_Options.DeathAvoidAnn and Tankadin_ADInfo.TalentInfo.curRank > 0) then
						TankadinEventMessage = TANKADIN_DEATHAVOID_MESSAGE;
					end
				end
			else
				Tankadin_ADInfo.DamageTaken = Tankadin_ADInfo.DamageTaken + suffix1;
			end
		end
	--End AD Tracking
	end
	
	--End New Event Handler
	
	--New AD tracking event, catches respecing
	if (event == "PLAYER_ENTERING_WORLD" or event == "CHARACTER_POINTS_CHANGED") then
		TankadinRefreshADTalentInfo();
	end
	
	-- Updates Data
	if (event == "UNIT_INVENTORY_CHANGED" or event == "UNIT_AURA" or event == "ADDON_LOADED") then
		Tankadin_UpdateInfo();
		TankadinRefreshADTalentInfo();

		local tankadin_infostring = "";

		tankadin_infostring = tankadin_infostring..Tankadin_Info.miss.."%\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.dodge.."%\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.parry.."%\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.total.."%\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.block.."%\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.updownColor;
		tankadin_infostring = tankadin_infostring..Tankadin_Info.blockValue.."\n";
		tankadin_infostring = tankadin_infostring..Tankadin_Info.HDamage.."\n";
						
		Tankadin_Info_Frame_Text:SetText(tankadin_infostring);
	end
	
	if (event == "PLAYER_REGEN_DISABLED" or event == "ADDON_LOADED") then
		-- Entered Combat. Clearing Variables If Requested
		if (Tankadin_Options.ADClear) then
			Tankadin_ADInfo.DamageTaken = 0;
			Tankadin_ADInfo.DamageADMitigated = 0;
			Tankadin_ADInfo.DeathsAverted = 0;
		end
	end
	
	if (event == "PLAYER_REGEN_ENABLED") then
		-- Left Combat, Adjust Damage Taken and Print Info if needed
		if (Tankadin_ADInfo.DamageTaken ~= 0) then
			Tankadin_ADInfo.percentageReduced = round(Tankadin_ADInfo.DamageADMitigated*100/Tankadin_ADInfo.DamageTaken);
		else
			Tankadin_ADInfo.percentageReduced = 0;
		end
		AdString = TANKADIN_SUM;
		if ( Tankadin_ADInfo.DamageTaken ~= 0 and Tankadin_Options.announce ) then
			DEFAULT_CHAT_FRAME:AddMessage(format(AdString, Tankadin_ADInfo.DamageADMitigated, Tankadin_ADInfo.DamageTaken, (Tankadin_ADInfo.percentageReduced), Tankadin_ADInfo.DeathsAverted));
		end
	end
		
	-- Broadcasts the TankadinEventMessage in the highest channel
	if (TankadinEventMessage ~= "") then
		if (NumRaid > 0 and RaidLeader == 1 or NumRaid > 0 and RaidOfficer == 1) then
			SendChatMessage(PlayerName.." -!!- "..TankadinEventMessage, "RAID_WARNING");
		elseif (NumRaid > 0 and RaidLeader == nil or NumRaid > 0 and RaidOfficer == nil) then
			SendChatMessage(PlayerName.." -!!- "..TankadinEventMessage, "RAID");
		elseif (NumParty > 0) then
			SendChatMessage(PlayerName.." -!!- "..TankadinEventMessage, "PARTY");
		end
	end
	
	-- Make the Percent Reduced
	if (Tankadin_ADInfo.DamageTaken ~= 0) then
		Tankadin_ADInfo.percentageReduced = round((Tankadin_ADInfo.DamageADMitigated*100/Tankadin_ADInfo.DamageTaken), 2);
	else
		Tankadin_ADInfo.percentageReduced = 0;
	end
	
	--Change AD Data on the Frame
	Tankadin_AD_Info_Disp();
end

function Tankadin_AD_Info_Disp()
	AD_Data = "";
	if (Tankadin_ADInfo.DamageTaken > 1000000) then
		AD_Data = AD_Data..TANKADIN_DATA_DT..": "..round((Tankadin_ADInfo.DamageTaken/1000000), 2).."m\n";
	elseif (Tankadin_ADInfo.DamageTaken > 10000) then
		AD_Data = AD_Data..TANKADIN_DATA_DT..": "..round((Tankadin_ADInfo.DamageTaken/1000), 1).."k\n";
	else
		AD_Data = AD_Data..TANKADIN_DATA_DT..": "..round(Tankadin_ADInfo.DamageTaken, 0).."\n";
	end
	AD_Data = AD_Data..TANKADIN_DATA_DM..": "..round(Tankadin_ADInfo.DamageADMitigated, 0).."\n";
	AD_Data = AD_Data.."%: "..Tankadin_ADInfo.percentageReduced.."\n";
	AD_Data = AD_Data..TANKADIN_DATA_DA..": "..Tankadin_ADInfo.DeathsAverted.."\n";
	Tankadin_AD_Frame_Text:SetText(AD_Data);
end

function Tankadin_AD_Info_Clear()
	Tankadin_ADInfo = {
		DamageADMitigated = 0,
		DamageTaken = 0,
		DeathsAverted = 0,
		percentageReduced =0,
		TalentInfo = {
			curRank = 0,
			maxRank = 0,
			percent = 0
			};
	};
	TankadinRefreshADTalentInfo();
	Tankadin_AD_Info_Disp();
end

function Tankadin_OnEnter(self)
if ( not Tankadin_Options.mini ) then
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	GameTooltip:SetText(TANKADIN_TOOLTIP_TITLE);
	GameTooltip:AddLine(TANKADIN_TOOLTIP_SUBTITLE);
	if ( Tankadin_Options.lock ) then
		GameTooltip:AddLine(TANKADIN_TOOLTIP_LOCKED);
	else
		GameTooltip:AddLine(TANKADIN_TOOLTIP_LEFTCLICK);
	end
	GameTooltip:AddLine(TANKADIN_TOOLTIP_MINMIZE);
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
	GameTooltipTextLeft2:SetTextColor(1, 1, 1);
end

if ( Tankadin_Options.mini and Tankadin_Options.tbasic ) then
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	
	Tankadin_UpdateInfo();
	
	GameTooltip:SetText(TANKADIN_TOOLTIP_TITLE);
	GameTooltip:AddDoubleLine(TANKADIN_TOTAL..": ",Tankadin_Info.total.."%");
	GameTooltip:AddDoubleLine(TANKADIN_BLOCK..": ",Tankadin_Info.block.."%");
	GameTooltip:AddDoubleLine(TANKADIN_UPDOWN..": ",Tankadin_Info.updownColor);
	GameTooltip:AddLine("--------------------------------------");
	GameTooltip:AddDoubleLine(TANKADIN_BVALUE..": ",Tankadin_Info.blockValue);
	GameTooltip:AddDoubleLine(TANKADIN_HSD..": ",Tankadin_Info.HDamage);
	
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
end
	
if ( Tankadin_Options.mini and Tankadin_Options.tadv ) then
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	
	Tankadin_UpdateInfo();
		
	GameTooltip:SetText(TANKADIN_TOOLTIP_TITLE);
	GameTooltip:AddDoubleLine(TANKADIN_MISS..": ",Tankadin_Info.miss.."%");
	GameTooltip:AddDoubleLine(TANKADIN_DODGE..": ",Tankadin_Info.dodge.."%");
	GameTooltip:AddDoubleLine(TANKADIN_PARRY..": ",Tankadin_Info.parry.."%");
	GameTooltip:AddDoubleLine(TANKADIN_TOTAL..": ",Tankadin_Info.total.."%")
	GameTooltip:AddDoubleLine(TANKADIN_BLOCK..": ",Tankadin_Info.block.."%");
	GameTooltip:AddDoubleLine(TANKADIN_UPDOWN..": ",Tankadin_Info.updownColor);
	GameTooltip:AddLine("--------------------------------------");
	GameTooltip:AddDoubleLine(TANKADIN_BVALUE..": ",Tankadin_Info.blockValue);
	GameTooltip:AddDoubleLine(TANKADIN_HSD..": ",Tankadin_Info.HDamage);
		
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
end
	
	GameTooltip:Show();
end

function Tankadin_Info_OnEnter(self)
	local base, effectiveArmor, armor, posBuff, negBuff = UnitArmor("player");
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	GameTooltip:SetText(TANKADIN_TOOLTIP_TITLE);
	-- Effective Health EQ
	EH = round((UnitHealthMax("player")*(armor+11960))/((1-(Tankadin_GetImpRF()*0.02))*11960), 2);
	EH_Blocking_Min = round((3000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*3000 - GetShieldBlock()*(armor+11960)), 2);
	EH_Blocking_Max = round((10000*UnitHealthMax("player")*(armor+11960))/(((1-(Tankadin_GetImpRF()*0.02))*11960)*10000 - GetShieldBlock()*(armor+11960)), 2);
	EH_TDR = round(1 - (((1-(Tankadin_Info.total/100))*(1-Tankadin_GetImpRF()*.02)*11960)/(armor+11960)), 4);
	GameTooltip:AddLine(TANKADIN_INFO_EH_BASE..": "..EH);
	GameTooltip:AddLine(TANKADIN_INFO_EH_MAX..": "..EH_Blocking_Max);
	GameTooltip:AddLine(TANKADIN_INFO_EH_MIN..": "..EH_Blocking_Min);
	GameTooltip:AddLine(TANKADIN_INFO_EH_TDR..": "..(EH_TDR * 100).."%");
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
	GameTooltip:Show();
end

function Tankadin_AD_OnEnter(self)
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	GameTooltip:SetText(TANKADIN_TOOLTIP_TITLE);
	hplimit = round(UnitHealthMax("player") * 0.35, 0);
	
	GameTooltip:AddDoubleLine(TANKADIN_AD..": ",Tankadin_ADInfo.TalentInfo.curRank.."/"..Tankadin_ADInfo.TalentInfo.maxRank.." = "..Tankadin_ADInfo.TalentInfo.percent.."%");
	GameTooltip:AddDoubleLine(TANKADIN_DATA_DT_LONG..": ", round(Tankadin_ADInfo.DamageTaken, 0));
	GameTooltip:AddDoubleLine(TANKADIN_DATA_DM_LONG..": ", round(Tankadin_ADInfo.DamageADMitigated, 0));
	GameTooltip:AddDoubleLine(TANKADIN_DATA_PERCENT..": ", Tankadin_ADInfo.percentageReduced.."%");
	GameTooltip:AddDoubleLine(TANKADIN_DATA_DA_LONG..": ", Tankadin_ADInfo.DeathsAverted);
	
	GameTooltip:AddLine(TANKADIN_AD_HP_ACTIVE.." "..hplimit.." "..TANKADIN_AD_HP_ABBR);
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
	GameTooltip:Show();
end

Tankadin_Plugins = {};

function Tankadin_Register_Plugin(name)
	table.insert(Tankadin_Plugins, name);
end

function Tankadin_NumberOfPlugins()
	return table.getn(Tankadin_Plugins);
end
