th = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "CandyBar-2.0","AceDB-2.0" )

function th:OnEnable()
	this:RegisterEvent("UNIT_AURA");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	th:UpdateStats();
end

function th:OnLoad()
	SLASH_TankHelper1 = "/tankhelper";
	SLASH_TankHelper2 = "/th";
	SlashCmdList["TankHelper"] = function(msg)
		th:SlashCommandHandler();
	end
	th:OnEnable();
end

--######################################
--#### mainfunction + int. settings ####
--######################################

function th:CalcStats()
	
	local TH_Version = "TankHelper V0.1 Alpha\n\n";
	local TH_lvl = UnitLevel("player");

	local Armorbase, Armoreff, Armorarmor, ArmorposBuff, ArmornegBuff = UnitArmor("player");
	
	local Defbase, Defarmor = UnitDefense("player");

	local dodge = GetDodgeChance();
	local parry = GetParryChance();
	local block = GetBlockChance();
	local totalavoid = dodge + parry + 5 + (Defbase+Defarmor-350) *0.04;
	local totalmitigation = totalavoid + block;
	
	
	local TH_moblvl = "moblvl:    "..TH_lvl.."     "..(TH_lvl+3);
	local TH_totalmitigation = "crushing:   "..100-math.floor(totalmitigation).."%   "..100-math.floor(totalmitigation-2.4).."%"
	local TH_totalavoid = "   avoid:      "..math.floor(totalavoid).."%   "..math.floor(totalavoid-1.8).."%";
	local TH_absorb = "     absorb:    "..(math.floor(Armoreff/(Armoreff+(467.5*TH_lvl-22167.5))*1000)/10).."%  "..(math.floor(Armoreff/(Armoreff+(467.5*(TH_lvl + 3)-22167.5))*1000)/10).."%";

	return(TH_Version..TH_moblvl.."\n"..TH_totalmitigation.."\n"..TH_totalavoid.."\n"..TH_absorb);
end

function th:UpdateStats()
	local frame = getglobal("TankHelper")
	if (frame) then
		if (frame:IsVisible()) then
			blaText:SetText(th:CalcStats());
		end
	end
end


function th:SlashCommandHandler()
	blaText:SetText(th:CalcStats());
 	th:Toggle();
end

function th:Toggle()
	local frame = getglobal("TankHelper")
	if (frame) then
		if (frame:IsVisible()) then
      			frame:Hide();
   		else
			frame:Show();
		end
	end
end
