--[[ TactikSOD v. 1.5 Тактика рейдов]]

-- SavedVariables
TactikSODPages = { "" } -- numerically-indexed table of pages
TactikSODSettings = {} -- Lock, Font, Chapter, Page
SODMMBSettings = {} -- hold minimap button settings

TactikSOD = {

	chapters = {
		"Hellfire Citadel",
                "Coilfang Reservoir",
                "Auchindoun",
                "Tempest Keep",
                "Karazan",
                "Grul Lair",
                "Zul'Aman",
--		"", финиш =)

	},

	-- tooltip info for controls
	controls = {
		{"SODDDMenuButton","Выберите инст","Выберите инст для которого хотите увидеть тактику на боссах."},
		{"TactikSODStart","Начало","В начало"},
		{"TactikSODLeft","Назад","Назад на обду страницу"},
		{"TactikSODRight","Далее","перейти на следующию страницу"},
		{"TactikSODEnd","Последняя страница","перейти на последнюю страницу"},
		{"TactikSODClose","Закрыть","Закрыть аддон"},
		{"TactikSODLock","Замок","Блокировать или Отблокировать окно"},
		{"TactikSODFont","Шрифт","переключение шрифтов"},
		{"TactikSODSearch","Опции","Поиск, смена шрифта или замок окна"},
		{"TactikSODSearchNext","Искать далее","Искать текст на следующей странице"},
		{"TactikSODSearchEditBox","критерии поиска","Введите текст для поиска"},
		{"TactikSODUndo","Откат","Возвратить страницу к последней записи текста"},
	},

	-- list of fonts to cycle through
	fonts = {
		{"Fonts\\FRIZQT__.TTF",10},
		{"Fonts\\FRIZQT__.TTF",12}, -- default
		{"Fonts\\FRIZQT__.TTF",16},
		{"Fonts\\ARIALN.TTF",12},
		{"Fonts\\ARIALN.TTF",16},
		{"Fonts\\ARIALN.TTF",20},
		{"Fonts\\MORPHEUS.ttf",16,"OUTLINE"},
		{"Fonts\\MORPHEUS.ttf",24,"OUTLINE"}
		-- add fonts here
	},

	current_page = 1, -- page currently viewed
	first_use = 1 -- whether this was used this session
}

-- constants
--[[ SOD_HEX_WHITE = "|cffffffff"; - normal
SOD_HEX_RED = "|cffff0000"; - important note
SOD_HEX_ORANGE = "|cffff7700"; - npc
SOD_HEX_YELLOW = "|cffffff00"; - quest
SOD_HEX_GREEN = "|cff00ff00"; - heading
SOD_HEX_GRAY = "|cff777777"; - item
SOD_HEX_LIGHTBLUE = "|cff77ccff"; - location ]]

BINDING_HEADER_TactikSOD = "Тактик SOD"
SLASH_COMMAND_MMB = "MINIMAP"
SLASH_COMMAND_MMB_HELP = "minimap [ON|OFF]"
SOD_NAME = "Tactik SOD"
SOD_ICON = "Interface\\Icons\\INV_Misc_Book_04.png";
SOD_TOC = 20300;

SOD_FUBAR_PREV_PAGE = "<< Предыдущий ";
SODSOD_FUBAR_NEXT_PAGE = "Следующий >>";

function TactikSOD.OnLoad()

	-- register events 
	this:RegisterEvent("VARIABLES_LOADED") -- create buttons anytime after VARIABLES_LOADED
	this:RegisterEvent("PLAYER_LOGIN") -- initialization

	-- set up frame
	this:SetMinResize(236,96)
	table.insert(UISpecialFrames,"TactikSODFrame")
	table.insert(UISpecialFrames,"TactikSODSearchFrame")

      -- set up slash handler
	SlashCmdList["TactikSODSLASH"] = TactikSOD.SlashHandler
	SLASH_TactikSODSLASH1 = "/SOD"
	SLASH_TactikSODSLASH2 = "/tactiksod"

	--- Check for FuBar
	if(IsAddOnLoaded("FuBar")) then
		TactikSOD:FuBar();
	end
	
end

function TactikSOD.OnEvent()

	local position
	if event=="PLAYER_LOGIN" then
		TactikSODSettings.Font = TactikSODSettings.Font or 2
		TactikSOD.UpdateFont()
		TactikSOD.UpdateLock()
		out("done with login")
	end
	if ((event=="VARIABLES_LOADED") and (not (IsAddOnLoaded("FuBar")))) then

		-- Set up minimap button
            out("setting up the button")
		local info = {
			icon = SOD_ICON,
			position = 30, -- default only. after first use, SavedVariables used
			drag = "CIRCLE", -- default only. after first use, SavedVariables used
			left = function() TactikSOD:Toggle() end,
			right = function() MyMinimapButton:SetEnable(SOD_NAME,0) end,
			tooltip = "Левый клик: Открывает/Закрывает окно\nПравый клик: Уберает иконку у мини карты, т.е. эту.\n (введите '/sod minimap on для востоновления)",
			enabled = 1 -- default only. after first use, SavedVariables used
		}
		out("calling create")
		      MyMinimapButton:Create(SOD_NAME, SODMMBSettings, info)
		out("button created")
	      
	end

end

-- /SOD ? will show help, 
-- /SOD minimap on|off will toggle the minimap button,
-- /SOD # will go to a page, 
-- /SOD alone toggles window
function TactikSOD.SlashHandler(msg)

	local mmb = strfind(msg, "\?")
	if mmb then  -- help request
		DEFAULT_CHAT_FRAME:AddMessage("Usage: /SOD [Pagenumber]|[Minimap ON|OFF]")
	else
		local uppermsg = strupper(msg)
		local mmb = strfind(uppermsg, SLASH_COMMAND_MMB)
		if mmb then 
			out("saw the minimap button command")
			out("mmb = " .. mmb)
			out("SLASH_COMMAND_MMB = " .. SLASH_COMMAND_MMB)
			out("tonumber(mmb) = " .. tonumber(mmb))
			out("len = " .. strlen(SLASH_COMMAND_MMB))
			local parmpos = tonumber(mmb)+strlen(SLASH_COMMAND_MMB)
			mmb = strfind(uppermsg, "ON", parmpos)
			if mmb then
				out("saw the minimap button 'ON' command")
				MyMinimapButton:SetEnable(SOD_NAME,1)
			else 
				mmb = strfind(uppermsg, "OFF", parmpos)
				if mmb then
					out("saw the minimap button 'OFF' command")
					MyMinimapButton:SetEnable(SOD_NAME,0)
				else
					DEFAULT_CHAT_FRAME:AddMessage("TactikSOD: Incorrect option for minimap button - must be 'ON' or 'OFF'")

				end 
			end
		else -- not the minimap button command
 			local _,_,page = strfind(msg or "","(%d+)")
			if page then   -- found the page number 
				page = tonumber(page)
				if TactikSODPages[page] then
					TactikSOD.current_page = page
					TactikSOD.ShowPage(true)
				else
					DEFAULT_CHAT_FRAME:AddMessage("TactikSOD: Page "..page.." doesn't exist.")
				end
			else -- no parms, just toggle the display
				TactikSOD.Toggle()
			end
		end 	
	end
end

-- toggles window on/off screen
function TactikSOD.Toggle()
	if TactikSODFrame:IsVisible() then
		TactikSODFrame:Hide()
	else
		TactikSODFrame:Show()
	end
end

-- window movement
function TactikSOD.StartMoving()
	if arg1=="LeftButton" and not TactikSODSettings.Lock then
		TactikSODFrame:StartMoving()
	end
end

function TactikSOD.StopMoving()
	if arg1=="LeftButton" then
		TactikSODFrame:StopMovingOrSizing()
	end
end

function TactikSOD.Tooltip()
	local which = this:GetName()
	for i in pairs(TactikSOD.controls) do
		if TactikSOD.controls[i][1]==which then
			GameTooltip_SetDefaultAnchor(GameTooltip,UIParent)
			GameTooltip:AddLine(TactikSOD.controls[i][2])
			GameTooltip:AddLine(TactikSOD.controls[i][3],.85,.85,.85,1)
			GameTooltip:Show()
			break
		end
	end
end

-- Titlebar button clicks
function TactikSOD.OnClick()
	local which = this:GetName()

	if which=="TactikSODUndo" then
		TactikSODEditBox:SetText(TactikSODPages[TactikSOD.current_page])
	end
	if which=="SODDDMenuButton" then
    		ToggleDropDownMenu(1, nil, SODDropDownMenu, SODDDMenuButton, 0, 0);
	elseif which=="TactikSODStart" then
		TactikSOD.ChangeIfNew(1, true)
	elseif which=="TactikSODLeft" then
		TactikSOD.GetPreviousPage(TactikSODPages, true)
	elseif which=="TactikSODRight" then
		TactikSOD.GetNextPage(TactikSODPages, true)
	elseif which=="TactikSODEnd" then
		TactikSOD.ChangeIfNew(table.getn(TactikSODPages), true)
	elseif which=="TactikSODClose" then
		TactikSODFrame:Hide()
	elseif which=="TactikSODLock" then
		TactikSODSettings.Lock = not TactikSODSettings.Lock
		TactikSOD.UpdateLock()
	elseif which=="TactikSODFont" then
		TactikSODSettings.Font = TactikSODSettings.Font+1
		TactikSOD.UpdateFont()
	elseif which=="TactikSODSearch" then
		if TactikSODSearchFrame:IsVisible() then
			TactikSODSearchFrame:Hide()
		else
			TactikSODSearchFrame:Show()
		end
	elseif which=="TactikSODSearchNext" then
		TactikSOD.DoSearch()
	end

end

-- disables/enables page movement buttons depending on page
function TactikSOD.ValidateButtons()

	-- nil for disabled, 1 for enabled
	local function set_state(button,enabled)
		if enabled then
			button:SetAlpha(1);
			button:Enable()
		else
			button:SetAlpha(.5);
			button:Disable()
		end
	end 
	
	set_state(TactikSODStart,1)
	set_state(TactikSODLeft,1)
	set_state(TactikSODRight,1)
	set_state(TactikSODEnd,1)

	if TactikSOD.current_page==1 then
		set_state(TactikSODStart)
		set_state(TactikSODLeft)
	end
	if TactikSOD.current_page==table.getn(TactikSODPages) then
		set_state(TactikSODRight)
		set_state(TactikSODEnd)
	end
end

function TactikSOD.GetNextPage(book, isShown)
	if not TactikSOD.current_page then
		TactikSOD.current_page = 0
	end		
	out("get next " .. math.min(TactikSOD.current_page+1,table.getn(book)))
	TactikSOD.ChangeIfNew(math.min(TactikSOD.current_page+1,table.getn(book)), isShown)
end

function TactikSOD.GetPreviousPage(book, isShown)
	if not TactikSOD.current_page then
		TactikSOD.current_page = 0
	end		
	TactikSOD.ChangeIfNew(math.max(TactikSOD.current_page-1,1), isShown)
end

function TactikSOD.ChangeIfNew(newpage, showpage)
	out("curr page =  " .. TactikSOD.current_page);
	out("newpage " .. newpage);
	if (newpage == TactikSOD.current_page) then
		-- nothing
	else
		out("showing page: " .. newpage)
		TactikSOD.current_page = newpage;
		TactikSOD.ShowPage(showpage)
	end
end

-- shows/updates the current page
function TactikSOD.ShowPage(isShown)
	if (isShown and not TactikSODFrame:IsVisible()) then
		TactikSODFrame:Show()
	end
	if TactikSODPages[TactikSOD.current_page] then
		TactikSODPageNum:SetText(TactikSOD.current_page)
		TactikSODEditBox:SetText(TactikSODPages[TactikSOD.current_page])
		TactikSOD.ValidateButtons()
	end
end

-- refreshes window when shown
function TactikSOD.OnShow()
	TactikSOD.FirstUseCheck()
	TactikSOD.ShowPage(true)
	TactikSODEditBox:SetWidth(TactikSODFrame:GetWidth()-50)
end

-- saves page when window hides
function TactikSOD.OnHide()
	TactikSODPages[TactikSOD.current_page] = TactikSODEditBox:GetText()
	TactikSODSettings.Page = TactikSOD.current_page
	TactikSODUndo:Disable()
	TactikSODEditBox:ClearFocus()
end

-- changes border and resize grip depending on lock status
function TactikSOD.UpdateLock()
	if TactikSODSettings.Lock then
		TactikSODFrame:SetBackdropBorderColor(0,0,0,1)
		TactikSODSearchFrame:SetBackdropBorderColor(0,0,0,1)
		TactikSODResizeGrip:Hide()
	else
		TactikSODFrame:SetBackdropBorderColor(1,1,1,1)
		TactikSODSearchFrame:SetBackdropBorderColor(1,1,1,1)
		TactikSODResizeGrip:Show()
	end
	TactikSOD.MakeESCable("TactikSODFrame",TactikSODSettings.Lock)
end

-- updates EditBox font to current settings
function TactikSOD.UpdateFont()
	if TactikSODSettings.Font > table.getn(TactikSOD.fonts) then
		TactikSODSettings.Font = 1
	end
	local font = TactikSODSettings.Font
	TactikSODEditBox:SetFont(TactikSOD.fonts[font][1],TactikSOD.fonts[font][2],TactikSOD.fonts[font][3])
end

-- adds frame to UISpecialFrames, removes frame if disable true
function TactikSOD.MakeESCable(frame,disable)
	local idx
	for i=1,table.getn(UISpecialFrames) do
		if UISpecialFrames[i]==frame then
			idx = i
			break
		end
	end
	if idx and disable then
		table.remove(UISpecialFrames,idx)
	elseif not idx and not disable then
		table.insert(UISpecialFrames,1,frame)
	end
end
	
-- when search summoned, remove ESCability of main window (only search cleared with ESC)
function TactikSOD.SearchOnShow()
	TactikSOD.MakeESCable("TactikSODFrame","disable")
end

-- when search dismissed, restore ESCability to main window and reset search elements
function TactikSOD.SearchOnHide()
	if not TactikSODSettings.Lock then
		TactikSOD.MakeESCable("TactikSODFrame")
	end
	TactikSODSearchResults:SetText("Поиск:")
	TactikSODSearchEditBox:ClearFocus()
end

-- does a count
function TactikSOD.SearchEditBoxOnChange()
	local search = string.lower(TactikSODSearchEditBox:GetText() or "")
	if string.len(search)<1 then
		TactikSODSearchResults:SetText("Поиск:")
	else
		local count = 0
		for i=1,table.getn(TactikSODPages) do
			count = count + (string.find(string.lower(TactikSODPages[i]),search,1,1) and 1 or 0)
		end
		TactikSODSearchResults:SetText(count.." найдено")
	end
end

-- performs a search for the text in the search box
function TactikSOD.DoSearch()
	local search = string.lower(TactikSODSearchEditBox:GetText() or "")
	if string.len(search)<1 then
		return
	end
	local page = TactikSOD.current_page
	for i=1,table.getn(TactikSODPages) do
		page = page + 1
		if page > table.getn(TactikSODPages) then
			page = 1
		end
		if string.find(string.lower(TactikSODPages[page]),search,1,1) then
			TactikSODPages[TactikSOD.current_page] = TactikSODEditBox:GetText()
			TactikSOD.current_page = page
			TactikSOD.ShowPage(true)
			return
		end
	end
end

function TactikSOD.OnTextChanged()
	local scrollBar = getglobal(this:GetParent():GetName().."ScrollBar")
	this:GetParent():UpdateScrollChildRect()
	local min, max = scrollBar:GetMinMaxValues()
	if ( max > 0 and (this.max ~= max) ) then
		this.max = max
		scrollBar:SetValue(min)
	end
	if this:GetText()~=TactikSODPages[TactikSOD.current_page] then
		TactikSODUndo:Enable()
	else
		TactikSODUndo:Disable()
	end
end

function TactikSOD.LoadChapterForFrame()

        local selectedItem = this.value
	out("Запрос загрузки для " .. selectedItem)
	TactikSODSettings.LastChapter = selectedItem
	out("Последний " .. TactikSODSettings.LastChapter)
	TactikSOD.LoadChapter(true)		

end

function TactikSOD.LoadChapter(showIt)

	-- Load up this chapter
	out("Загрузка: " .. TactikSODSettings.LastChapter)
	TactikSODPages = SODChapters[TactikSODSettings.LastChapter] 
	TactikSOD.current_page = 1
	TactikSOD.ShowPage(showIt)

end

function SODDropDownMenu_OnLoad()

	local currentChapter = TactikSODSettings.LastChapter;
	local info = UIDropDownMenu_CreateInfo(); 

	for i in pairs(TactikSOD.chapters) do
		info.text = TactikSOD.chapters[i];
		info.value = i-1;
       		info.func  = TactikSOD.LoadChapterForFrame;
		info.owner = this:GetParent();
	 	info.checked = (currentChapter == (i-1));
	        UIDropDownMenu_AddButton(info);
	end 	
end

function TactikSOD.FirstUseCheck()

	if TactikSOD.first_use then
		-- only when the pad is first shown 
		TactikSOD.current_page = 1
		if TactikSODSettings.Page then
			-- use saved page value if available 
			TactikSOD.current_page = TactikSODSettings.Page 
		end
	end 
	TactikSOD.first_use = nil
end

function out(text)
  -- DEFAULT_CHAT_FRAME:AddMessage(text)
  -- UIErrorsFrame:AddMessage(text, 1.0, 1.0, 0, 1, 10) 
end

--- FuBar Support
function TactikSOD:FuBar()

	local tablet = AceLibrary("Tablet-2.0")
	TactikSODFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "FuBarPlugin-2.0")
	TactikSODFu.hasIcon = SOD_ICON
	TactikSODFu.name = SOD_NAME
	TactikSODFu.title = SOD_NAME
	-- TactikSODFu.version = METAHUD_VERSION
	TactikSODFu.category = "Miscellaneous"
 	TactikSODFu.clickableTooltip = true

	TactikSODFu.OnMenuRequest = {
		type = 'group',
		args = {
			chapter = {
				type = 'text',
				name = 'Select',
				desc = 'Current display in Tooltip',
				validate = TactikSOD.chapters,
				get = function() return TactikSOD.chapters[TactikSODSettings.LastChapter+1] end,
				set = function(v) 
						TactikSODFu:GetIndexFromChapterText(v) 
					end,
				order=10,
			},
			tipwidth = {
				type = 'range',
			        name = 'Tooltip Width',
			    	desc = "Set tooltip width",
			    	get = function() return TactikSODFu:GetTooltipWidth() end,
			    	set = function(v) TactikSODFu:SetTooltipWidth(v) end,
			    	min = 50,
			    	max = 400, 
			    	step = 1, 
				order=20,
			},
			textsize = {
			    	type = 'range',
		          	name = 'Text Size',
			    	desc = "Set Font Size for text",
			    	get = function() return TactikSODFu:GetTextFontSize() end,
			    	set = function(v) TactikSODFu:SetTextFontSize(v) end,
			    	min = 8,
			    	max = 20, 
			    	step = 1, 
				order=30,
			},
		}
	} 

	TactikSODFu:RegisterDB("TactikSODFuDB")


	function TactikSODFu:OnInitialize()
		-- if we're FuBar'ing, we turn off built-in minimap support
		MyMinimapButton:SetEnable(SOD_NAME,0);
	end

	function TactikSODFu:SetTooltipWidth(var)
	    TactikSODFuDB.TooltipWidth = var;
	    out("SetTooltipWidth: tooltip width now = " .. TactikSODFuDB.TooltipWidth);
        end


	function TactikSODFu:GetTextFontSize()
	    local var = TactikSODFuDB.TextFontSize; 
            if not var then
		var = 12;
            end
            return var
	end

	function TactikSODFu:SetTextFontSize(var)
	    TactikSODFuDB.TextFontSize= var;
	    out("TextFontSize: font size now = " .. TactikSODFuDB.TextFontSize);
        end


	function TactikSODFu:GetTooltipWidth()
	    local var = TactikSODFuDB.TooltipWidth; 
            if not var then
		var = 100;
            end
            return var
	end

	function TactikSODFu:OnClick(button)
		if(button == "LeftButton") then
			TactikSOD:Toggle()
		end
	end

	function TactikSODFu:OnTooltipUpdate()

		TactikSOD.FirstUseCheck()
		
		local prevBlue = 1
		if TactikSOD.current_page == 1 then
			prevBlue = 0
		end
		local nextBlue = 1
		if TactikSOD.current_page == table.getn(TactikSODPages) then
			nextBlue = 0
		end

		cat = tablet:AddCategory(
			"text", "Controls",
			"hideBlankLine", true,
			"size", 12,
			"columns", 1
		)
		cat:AddLine("text", SOD_FUBAR_PREV_PAGE,
				"textR", 0,
				"textG", 0,
				"textB", prevBlue,
				"size", 10,
		  	    	"func", function() TactikSOD.GetPreviousPage(TactikSODPages, false) end);
		cat:AddLine("text", SOD_FUBAR_NEXT_PAGE,
				"textR", 0,
				"textG", 0,
				"textB", nextBlue, 
				"size", 10,
		  	    "func", function() TactikSOD.GetNextPage(TactikSODPages, false) end);

		if not TactikSODSettings.LastChapter then
			TactikSODSettings.LastChapter = 0
		end		
		local chapterName = TactikSOD.chapters[TactikSODSettings.LastChapter+1];

		cat = tablet:AddCategory(
			"text", chapterName,
			"hideBlankLine", true,
			"columns", 1,
			"textR", 0,
			"textG", 1,
			"textB", 0,
			"size", 14,
			"child_size" , TactikSODFuDB.TextFontSize,
			"child_textR", 1,
			"child_textG", 1,
			"child_textB", 1
		)

		out("OnTooltipUpdate: tooltip width now = " .. TactikSODFu:GetTooltipWidth());
		-- Hack to set width until I can find a better way
		cat:AddLine("text", TactikSODPages[TactikSOD.current_page],
				"wrap", true)

		local spacer = string.rep(" ", TactikSODFu:GetTooltipWidth()-1)
		cat:AddLine("text", spacer .. ".")
		tablet:SetHint("Левый клик для переключения вида")

		-- Save last shown page
		TactikSODSettings.Page = TactikSOD.current_page

	end

	function TactikSODFu:GetIndexFromChapterText(chapterTitle)

		out("looking for text = " .. chapterTitle) 
		local currentChapter = TactikSODSettings.LastChapter;
		
		for i in pairs(TactikSOD.chapters) do
			out("comparing to " .. TactikSOD.chapters[i]) 
			if (TactikSOD.chapters[i] == chapterTitle) then
				out("found");
				currentChapter = i-1;
				break
			end
		end
		out("setting TactikSODSettings.LastChapter to " .. currentChapter) 
		TactikSODSettings.LastChapter = currentChapter ;
		TactikSOD.LoadChapter(false)
	end
end
