--[[

Tactics edited by Belleboom@Earthen Ring.
There is a template below. The format is:
name:		List of actual mob names that the description can be applied to. This is used when you bind a key to 
		report tactics on the currently selected target, so the name has to be exactly correct
shortName:	List of shorthand tags for the description. For use with the /tactics <mobname> and /tactics all commands
instance:	Shorthand tag for the name of the instance that the mob occurs in
description:	The text that will be output in chat.
Notes:		Don't add color, it causes disconnects; don't use double quotes within the text; each separate line sent to chat must be 255 characters or less.

-- TEMPLATE
	{ 
	name = { "BossName", "Name" },
	shortName = { "name" },
	instance = "instance",
	description = {
		"Line1",
		"Line2",
		"Line3"
		}
	},

-- EXAMPLE
	{ 
	name = { "Hogger", "Hog" },
	shortName = { "hogger", "hog" },
	instance = "world",
	description = {
		"Hogger:", 
		"Hogger is a lvl 11 elite who is much tougher than he looks. Take a raid group of 40 nekkid level 1 trolls."
		}
	}, -- this comma is not necessary for the very last description in the list

]]--


moblist = {

-- AQ
	{ 
	name = { "Buru" },
	shortName = { "buru" },
	instance = "aq",
	description = {
		"Buru: DPS gear should be worn for this fight as there is no true tanking involved. Buru starts off by targeting one random person in the raid and chases them (we'll call them the ÃÂRabbit'). The rabbit should not lose aggro (no ice block or fade)",
		"but instead run around with Buru chasing (he's rather slow). The trick is to stay out of the deep water. Shaman can target the rabbit with a water walking or priests can use levitate to help with that. The MT will target an egg and DPS it down,",
		"but don't destroy it (no DoTs). When told the rabbit will run to the egg. When Buru is standing over the egg destroy it and it will explode doing damage to Buru (it also does AoE nature damage so use max range when destroying the egg",
		"if you can). Two mobs will spawn and an assigned group will need to kill them while the raid targets a new egg. Also, Buru will pick a new rabbit so watch to see if it's you. When Buru reaches 20% his shell will explode and taint the raid",
		"with a debuff that will kill everyone within 30 sec. Two powerful adds will join the fight at this point and should be chained feared (watch for your assignment). The rest of the raid needs collapse to melee range on Buru's position so melee",
		"doesn't have to chase him around (just like the lava surgers in MC). We will try one of two strategies at this point: priests will be put in DPS groups to spam prayer of healing or all priests will DPS also and do no healing." 
		}
	},

	{ 
	name = { "General Rajaxx", "Rajaxx" },
	shortName = { "rajaxx" },
	instance = "aq",
	description = {
		"General Rajaxx: This is an 8 wave fight that begins when someone talks to the NPCs. The general idea is to keep them clumped together in the center for AoE. The raid will form up immediately behind the NPCs at the beginning",
		"and before the beginning of each wave so that the tanks and NPCs can pull aggro off the rest. Note that while the flyers are alive their cleave will turn this area into a killing ground. Using Limited Invulnerability potions",
		"will usually keep you alive long enough for aggro to be transferred. Focus DPS on the OT target. Everyone must switch to PvP (/pvp) & be friendly with Cenarion Circle to receive Lieutenant Andorov's heals. Healers will be assigned",
		"to keep him alive (macro /target lieu helps find him in the mayhem). Amplify Magic will be cast on the raid to enhance the Lieu's healing. MT always focus on the mini-bosses of each wave.",
		"First Boss uses fear, tremor totems and other fear inhibiting abilities help. Second Boss ÃÂtargets' one person in the raid for death. Run to the OT to transfer aggro. Third Boss has AoE storm that causes nature damage,",
		"get out of the center quickly as possible. MT should move the boss out from under it. Fourth Boss has AoE shockwave that causes nature damage & knockdown. Seventh Boss has a dispellable self-buff.",
		"Rajaxx has an AoE knockback that sheds all aggro. To counter the knockback put your back to the wall to the left of where the mobs enter so the MT can chase down and regain aggro quickly.",
		"The AoE always does one-half your current health in NR damage. A high NR will help resist it." 
		}
	},

-- Arcatraz

	{ 
	name = { "Arcatraz (Heroic)" },
	shortName = { "arcatrazheroic" },
	instance = "arcatraz",
	description = {
		"**Arcatraz (Heroic)** Basically, the mobs are exactly the same as Normal mode, but hit 3 times harder. Resists: Arcane resist gear is useful for robot mobs, Fire Resist for melee helps with Soccothrates."
		}
	},

	{
	name = { "Akkiris Lightning-Waker", "Akkiris" },
	shortName = { "akkiris" },
	instance = "arcatraz",
	description = {
		"**Akkiris Lightning-Waker** has a Nature AoE for (~1100 dmg), a single-target curse that doubles damage taken, and a magic self-buff that halves damage taken. Mages can Spellsteal this last. Notably, this boss is resistant to Nature damage."
		}
	},

	{
	name = { "Blackwing Drakonaar", "Blackwing" },
	shortName = { "blackwing" },
	instance = "arcatraz",
	description = {
		"**Blackwing Drakonaar** does a powerful blastwave that will hit for 7K-10K HP and knock players back. Only the tank should be taking damage from this, as other melee DPSers should wait until after the first blastwave to engage...",
		"...and then disengage after 15 seconds or so until the next one. The blastwave's radius is extremely large - cast from max range. He also has mortal strike that hits for 1500 dmg and lasts ~6sec. This mob is immune to fire damage."
		}
	},

	{
	name = { "Dalliah the Doomsayer", "Dalliah" },
	shortName = { "dalliah" },
	instance = "arcatraz",
	description = {
		"**Dalliah the Doomsayer** Clear the room of invisible demons before you pull. She does Whirlwind, heals, and is immune to silence and stun effects. She will also cast a debuff that heals her when the person she is aggroed on is healed...",
		"...so try to keep the tank topped off and stop healing when that happens. HoT ticks are included and will heal her as well. When the debuff hits the person with the most aggro it will look similar to the Shadow Protection buff, but with a red box.",
		"When Dalliah Whirlwinds all melee INCLUDING the MT should leave melee range. After the Whirlwind she will cast a 2-second heal on herself, which needs to be interrupted. She is also immune to taunt so watch DPS aggro.",
		"HEROIC: Similar to Normal, but Dalliah has one added ability - Shadowwave, which hits for 2.5k on a random target, and leaves a debuff that makes the Waves hit 50% harder next time."
		}
	},

	{
	name = { "Warden Mellichar", "Mellichar" },
	shortName = { "mellichar" },
	instance = "arcatraz",
	description = {
		"**Warden Mellichar** doesn't fight himself. He bubbles and spawns 4 bosses, 1 at a time, and they have a time limit so kill them quickly. If you kill them quickly enough you should have time to drink. A friendly NPC will also spawn to help.",
		"A number of possible bosses can spawn. 1st Wave: Blazing Trickster or Warp Stalker; 2nd Wave: Sulfuron Magma-Thrower or Akkiris Lightning-Waker; 3rd Wave: Blackwing Drakonaar or Twilight Drakonaar; 4th Wave: Harbinger Skyriss."
		}
	},

	{
	name = { "Harbinger Skyriss", "Skyriss" },
	shortName = { "skyriss" },
	instance = "arcatraz",
	description = {
		"**Harbinger Skyriss** randomly Mind Rends a target, stunning them and ticking for 1800, 3 times. He melees moderately hard, and will Mind Control a random member of your party or the NPC aiding you, Millhouse Manastorm.",
		"The MC is a magic debuff and is dispellable. He also fears one member of the party. He will make a clone of himself at 66% and 33% health...",
		"...the clone has few HP and does half the melee damage of the original (easily tanked by a rogue/DPS shaman) but retains all the original's abilities. Put a raid icon on the original when he first appears, when he spawns a clone it will be un-marked.",
		"HEROIC: Everything hits harder. The pre-boss adds aren't any different except for that, but be sure to keep Millhouse alive because he does a lot of damage, and can survive Mind Rends (plus you'll want him alive to finish the Trial of the Naaru).",
		"The biggest problem is still his Mind Rend so use totems, pets, etc., so he targets them instead of you. Mages can Blink out of Mind Rend too. Fire Elemental totems work well (immune to Mind Rend)."
		}
	},

	{
	name = { "Wrath-Scryer Soccothrates", "Soccothrates" },
	shortName = { "soccothrates" },
	instance = "arcatraz",
	description = {
		"**Wrath-Scryer Soccothrates** Clear the room of invisible demons before you pull. He does Flame Shock, fire damage, and a knockback. Fire resist will help melee, and Flame Shock should be cleansed.",
		"Stand in a half-circle around him, avoid the fire from his charge, and spread out. Shortly before the Knockback-Charge-Flame Wave comes he gets a buff called Knock Away. Knockback and Charge do not drop aggro.",
		"HEROIC: Actually easier than Normal. After Soccothrates does his knockback, he stands still and then charges someone.. or at least, the place where someone WAS. Keep moving around and this boss is easy."
		}
	},

	{
	name = { "Warp Stalker" },
	shortName = { "stalker" },
	instance = "arcatraz",
	description = {
		"**Warp Stalker** is fairly simple, except he has a Blink that randomly moves him across the map; the tank has to be on his toes about grabbing aggro back, especially if the Warp Stalker gets to a healer."
		}
	},

	{
	name = { "Sulfuron Magma-Thrower", "Sulfuron" },
	shortName = { "sulfuron" },
	instance = "arcatraz",
	description = {
		"**Sulfuron Magma-Thrower** will not do a great deal of melee damage against plate but has a Rain of Fire spell that he likes to use often which needs to be avoided if possible."
		}
	},

	{
	name = { "Blazing Trickster", "Trickster" },
	shortName = { "trickster" },
	instance = "arcatraz",
	description = {
		"**Blazing Trickster** is a level 70 elite imp which shoots Firebolts at random party members and occasionally use the Weakened Soul debuff. The damage isn't great and he doesn't have a lot of HP so should be nuked down fairly quickly."
		}
	},

	{
	name = { "Twilight Drakonaar", "Twilight" },
	shortName = { "twilight" },
	instance = "arcatraz",
	description = {
		"**Twilight Drakonaar** does a time lapse that incapacitates the tank for a few seconds. He also does random brood powers like spell casting time slowed or a fire damage DOT upon color change."
		}
	},

	{
	name = { "Zereketh the Unbound", "Zereketh" },
	shortName = { "zereketh" },
	instance = "arcatraz",
	description = {
		"**Zereketh the Unbound** First clear the room of mobs/corpses. The fight is simple, stay away from the Void Zones, watch knockback, and if you get the Seed of Corruption move away from the rest of the group to avoid damage to party members.",
		"DPS can avoid his Shadow Nova (~34 yards range [Heroic: 45]) by being at max range. It is imperative that you get out of the Void Zones as quickly as possible because as soon as they spawn it is instant damage for 1200-1300 every second.",
		"The MT should tank with his back to a wall and just move up or down the wall as the void zones appear. This keeps him in heal range during knockbacks.",
		"HEROIC: Void zones can be avoided by putting a lot of totems and pets around the room, as he then will waste the zones on them. Bring a lot of Shadow Resistance gear, as even his melee is Shadow; also the mage Slow spell works on him."
		}
	},

-- Auchenai Crypts

	{ 
	name = { "Auchenai Crypts (Heroic)" },
	shortName = { "auchenaiheroic" },
	instance = "auchenai",
	description = {
		"**Auchenai Crypts (Heroic)** Like in normal mode, many NPCs summon adds. CC mobs when possible, and focus fire on the non-elite adds first, and then go for the elite guys. Kill Auchenai Possessors first if they spawn - they'll MC a party member.",
		"Watch out for the Auchenai Monks (not CC'able). At the elite skeletons, use paladin-fear or priest-shackle and nuke them down one by one. One last note: if you fall off the bridge of souls, you're dead."			}
	},

-- Black Morass

	{ 
	name = { "Aeonus" },
	shortName = { "aeonus" },
	instance = "blackmorass",
	description = {
		"**Aeonus** does a Time Stop AoE: stuns all players for 4 seconds; Sand Breath: deals 3000 nature dmg in a frontal cone; Frenzy: increases boss attack speed. Aeonus spawns alone and immediately heads to attack Medivh.",
		"If Medivh's shield is in ok condition rest up before the battle. Aeonus hits hard; this is made worse by the Time Stop stun when Aeonus keeps attacking the highest aggro target. Keep healing at maximum, and use any remaining Chrono-beacons."
		}
	},

	{ 
	name = { "Chrono Lord Deja", "Deja" },
	shortName = { "deja" },
	instance = "blackmorass",
	description = {
		"**Chrono Lord Deja** has a chain lightning that hits for 1000-2000 damage and a magic AoE debuff that slows attacks and movement speeds."
		}
	},

	{ 
	name = { "Black Morass", "Morass" },
	shortName = { "morass" },
	instance = "blackmorass",
	description = {
		"**The Black Morass** is a multi-part/boss event. First pick up a Chrono-beacon from Sa'at just inside the entrance. Clear a path through the mobs south towards and around Medivh. Once a player enters the area ~10 meters from Medivh, the event will start.",
		"[Basics]: First Medivh calls for help and a portal opens in one of four zones. The portals spawn a total of 18 waves of dragonkin. Once a portal has been shut or enough time passes, another portal will open in a different zone.",
		"Once started, the event is timed. At waves 6, 12, and 18 there is a boss. If the mobs drain Medivh's shield and kill him you fail.",
		"[1-5]: The first five waves contain one Elite (a Rift Lord or Rift Keeper) that is tethered to the portal, and a stream of non-elites. Once the portal opens, every 20-30 secs a group of three Infinite Whelps or one of five trash mobs spawn.",
		"The spawning mobs head directly to attack Medivh and must be killed. The non-elites can be killed by any class, AoE is not required. Have one player focus on the non-elite spawns. Kill the elite and then any remaining spawns and rest whenever possible.",
		"[6]: *Chrono Lord Deja* has an arcane blast/chain lightning that hits for 1000-2000 damage and a magic AoE debuff that slows attacks and movement speeds.",
		"[7-11]: Same as the first five waves.",
		"[12]: *Temporus* does an undispellable Mortal Strike debuff that decreases healing on target by 10% and stacks up to 10 times. The debuff is applied every 6 seconds and lasts 12 seconds.",
		"He also has a dispellable Haste buff, Knockback AoE, and is untauntable. Use a Chrono-beacon for the adds, have all five members defeat the boss quickly before the debuff stacks to 10, then kill the remaining non-elites afterward.",
		"[13-17]: Waves spawn at a faster rate, with as little as 1 min between portals. If the designated add-dealer is overwhelmed you can ignore Riftlords after wave 15 or 16 and have the whole group defending Medivh. Adds stop spawning before the final boss.",
		"Drop a Chrono-beacon on the 17th wave spawns for pre-boss crowd control assistance.",
		"[18]: *Aeonus* does a Time Stop AoE: stuns all players for 4 seconds; Sand Breath: deals 3000 nature dmg in a frontal cone; Frenzy: increases boss attack speed. Aeonus spawns alone and immediately heads to attack Medivh.",
		"If Medivh's shield is in ok condition rest up before the battle. Aeonus hits hard; this is made worse by the Time Stop stun when Aeonus keeps attacking the highest aggro target. Keep healing at maximum, and use any remaining Chrono-beacons."
		}
	},

	{ 
	name = { "Temporus" },
	shortName = { "temporus" },
	instance = "blackmorass",
	description = {
		"**Temporus** does an undispellable Mortal Strike debuff that decreases healing on target by 10% and stacks up to 10 times. The debuff is applied every 6 seconds and lasts 12 seconds."
		}
	},


-- Black Temple
	{
	name = { "Shade of Akama", "Akama" },
	shortName = { "akama" },
	instance = "blacktemple", 
	description = {
		"**Shade of Akama** Phase 1, Shade of Akama Banished: The Channeler Group is responsible for killing the Ashtongue Channelers and Ashtongue Sorcerers (all Melee DPS + one Warlock).",
		"All other players will be assigned to Add Team 1 or 2, one tank for each team.",
		"Kill order is Ashtongue Elementalists > Ashtongue Rogues > Ashtongue Spiritbinders (sheeped)",
		"Assign one tank to Ashtongue Defenders. These are generally ignored by DPS. This tank will need dedicated healing as the fight progresses.",
		"Phase 2 (Shade of Akama Unbanished): ALL DPS on the Shade of Akama. You have ~1 min to kill him before he kills Akama.",
		"CC adds that you can before starting DPS; blow all cooldowns in this phase."
		}
	},

	{
	name = { "Gurtogg Bloodboil", "Bloodboil" },
	shortName = { "bloodboil" },
	instance = "blacktemple", 
	description = {
		"**Gurtogg Bloodboil** Phase 1, Bloodboil (60 secs): Ranged DPS/Healers will be separated into three groups to cycle Bloodboil debuffs.",
		"Watch threat; do not go above all 3 tanks! Be conservative for the first 60 secs. After the last bloodboil (50 sec mark) spread out at least 5 yds away from each other.",
		"Phase 2, Fel Rage (30 secs): Healer priority is the player with Fel Rage. Stay away from the player with Fel Rage due to Arcing Smash and Fel Acid.",
		"Blow cooldowns if you have the insignificance debuff! (It's resistable, so be sure to check.) Leave a path back to the tanks to avoid Arcing Smash when he returns to Phase 1."
		}
	},

	{
	name = { "Illidari Council" },
	shortName = { "council" },
	instance = "blacktemple", 
	description = {
		"**Illidari Council** Everyone must have more than 11k HP. This fight will last up to 15 mins and is a survival fight (the Olympics of not standing in stuff). All 4 mobs share HP and go down in life together.",
		"Warlock Imp or Mage Water Elemental starts the pull. Magetank picks up Zervos, others get picked up or misdirected to other tanks.",
		"Magetank with a dedicated healer stand on the stage and keep Zervos busy with a mana-conservative DPS rotation while spellstealing Dampen Magic to survive. High-stamina gear recommended.",
		"Casts Blizzard and Flamestrike on random players - move out immediately (4k-5k dmg/tick). Ranged can do light DPS on him if convenient, but do not pass magetank on threat. Do not come closer than 10 yds (bad arcane explosion).",
		"Gathios is tanked on right side by the MT alternating between 3 spots to avoid Consecration (2250/tick). Heavy healing required.",
		"Melee DPSing Gathios be very careful never to attack him from the front to avoid parries killing the MT. MT spell-reflects Judgment of Command for extra threat (won't show up on Omen).",
		"Druid-tank Veras. He vanishes for 30 secs every minute and poisons and/or Envenoms random players for 5k. Must be picked up fast after coming out of Vanish.",
		"Lady Malande is the group's healer; keep 2 physical and 2 magical interrupters on her to interrupt Divine Wrath (5k dmg + 2.5k dmg/tick) and Circle of Healing.",
		"Smite should not be interrupted. She can get protected by: Reflective Shield (stop DPS), Blessing of Protection (magic DPS and interrupts only) and Blessing of Spell Warding (physical damage and interrupts only)." 
		}
	},

	{
	name = { "Teron Gorefiend", "Teron", "Gorefiend" },
	shortName = { "gorefiend" },
	instance = "blacktemple", 
	description = {
		"**Teron Gorefiend** hits hard on the tank; healers be aware! This is a DPS race (between losing too many players as well as having too many Doom Blossoms).",
		"If you get Shadow of Death, run out to the designated death spot when 20 secs remain.",
		"Dedicated cleansers will cleanse Incinerate debuffs. When you die from Shadow of Death, kill your constructs! After that kill constructs in the raid, hit Gorefiend with Spirit Strike and toss a Spirit Shield on a healer."
		}
	},

	{
	name = { "Illidan Stormrage", "Illidan" },
	shortName = { "illidan" },
	instance = "blacktemple", 
	description = {
		"**Illidan Stormrage** has 5 phases, 2nd phase is the hardest one. If Phase 2 is done and combat rezzes can get enough people up, it is a kill.",
		"Phase 1, 3 and 5: Illidan is tanked North facing away from the raid. Run to a mage (East or West) if you get a Parasite. Mages will freeze and kill them.",
		"At 65%, Phase 2: Illidan takes off and summons two flames. Everyone is on the grill in 5 very tight groups arranged in a cross. Do not clump up too much (Fireball AoE dmg).",
		"Do not spread out - everyone MUST stay within 25yds of at least one Flame. FR tanks will pull Flames to North tip of the grill and move them slowly in a semi-circle one on each side. Focus-fire one Flame.",
		"East and West groups must fall-in to center if Eye beam is coming to their side or if the Flame on their side dies.",
		"Phase 3 and 4: alternates between the phases every 40-55 secs. Spread out in phase 3 to avoid chaining Agonizing Flames.",
		"Phase 4: warlock tanks shadowbolts. Stand 20yds away from the warlock. Use Frost Traps and Earthbind Totems between Illidan and raid; spread out to avoid chaining Flame Burst.",
		"Illidan summons 4 Shadow Daemons that must be killed before they reach their targets. AoE while Daemons are close to Illidan then finish them off. Daemons going to warlock tank and/or MT are primary targets.",
		"If Illidan is close to 30% stop DPS. At 30% (hopefully in Phase 3) Illidan monologues, then goes to a Phase 5 and 4 rotation every 60 secs.",
		"Phase 5 is the same as Phase 3 (and 1), but Illidan will enrage for the last 20 secs, forcing MT to use Shield Wall and then Last Stand + trinkets. Must kill him before 40th sec of the third Phase 5 or he will kill the MT.",
		"Maiev's traps can be used to stop his enrage, but that will mess up positions. If MT has to move Illidan, be very sure to never be in front of him or he might heal, a lot." 
		}
	},

	{
	name = {"High Warlord Naj'entus"},
	shortName = { "najentus" },
	instance = "blacktemple", 
	description = {
		"**High Warlord Naj'entus** Spread out (6+ ft) from each other to avoid AoE from Needle Spine. Rouges/Warriors keep up the healing debuffs (Wound Poison, Mortal Strike).",
		"Impaling Spine is thrown every 10 secs and must be removed immediately by the closest player. Every 60 secs, he casts Tidal Shield.",
		"Once everyone is topped off, an impaling spine is thrown at him to break the shield. 8500 frost dmg to everyone when the shield is broken. Major Frost Protection Potions can help. (Frost Resistance can also help, but don't gimp yourself.)",
		"Everyone must have at least 10k HP fully buffed."
		}
	},

	{
	name = { "Reliquary of Souls" },
	shortName = { "ros" },
	instance = "blacktemple", 
	description = {
		"**Reliquary of Souls** Phase 1, Essence of Suffering: Every 5 secs, the fixate target will change to the person that closest to EoS.",
		"The currently fixated target should move to the edge of the red target selection circle.",
		"Every minute, EoS enrages for 15 secs (3 fixates). Prot warriors & feral druids should take these fixates; the rest of the raid moves just outside of the selection circle. If you don't have enough HP to take a fixate, stay outside the selection circle.",
		"Everyone do all-out DPS. (No healing due to the Aura of Suffering.) Dispel Soul Drain.",
		"Phase 2, Essence of Desire: Aura of Desire + Deaden can two-shot a caster... DPS watch aggro! Deaden must not be interrupted and must be spell reflected by the tank.",
		"Always interrupt Spirit Shock, 1 sec cast every 5 secs. Spellsteal Rune Shield. Devour it with FelHunter when mana is gone. It's a DPS race due to decreasing mana pool.",
		"Phase 3, Essence of Anger: Keep Soul Scream off the raid. NO DPS for first 20 secs.",
		"DPS race due to stacking damage from Aura of Anger. Use Healthstones/Potions when the aura ticks between 2k-3k to help the healers."
		}
	},

	{
	name = { "Mother Shahraz", "Mother" },
	shortName = { "shahraz" },
	instance = "blacktemple", 
	description = {
		"**Mother Shahraz** requires max SR gear for everyone EXCEPT the main tank. (Polaris uses the single ranged group method by the left wall.)",
		"Based on the BigWigs/DBM announcement, players teleported from Fatal Attraction should move toward the stage (forward), toward the door (backward) or toward a side wall. If only 1 player is teleported, they can go back to their normal position.",
		"1st player listed move towards the stage.",
		"2nd player listed move towards the door.",
		"3rd player listed move towards the right wall.",
		"Three tanks stand on top of each other due to Saber Lash.",
		"Casters pay attention to the Prismatic Auras to benefit from the damage bonus. Healers conserve mana whenever possible and drink many potions due to mana drains."
		}
	},

	{
	name = { "Supremus" },
	shortName = { "supremus" },
	instance = "blacktemple", 
	description = {
		"**Supremus** Phase 1 (60 secs): Hateful strike occurs every five secs to the person with the highest HP in melee range. Move out of the Molten Fire!",
		"Phase 2 (~50 secs, 5 players Gazed): Will gaze random players for 10 secs... run away! Melee should be at least 20 yds away when the gaze is about to switch. Stay FAR away from the Volcanic Geysers.",
		"Watch DoTs on the transition; aggro is reset. (Hunter misdirect on tank and reposition if possible.)"
		}
	},


-- Blood Furnace
	{ 
	name = { "Blood Furnace (Heroic)" },
	shortName = { "bloodfurnaceheroic" },
	instance = "bloodfurnace",
	description = {
		"**Blood Furnace (Heroic)** The trash is manageable, but there are rogues around the instance which always seem to show up at a bad time. There are melee adds, specifically in Broggok's room and in the Maker's room, which do nasty cleaves.",
		"Also, the Technicians drop mines (AoE dmg, rogues can disarm). And unless you like repair bills, bring a warlock for the Felguards before Keli'dan's room. They hit very hard, and also tend to aggro other people at random."
		}
	},

	{ 
	name = { "Broggok" },
	shortName = { "broggok" },
	instance = "bloodfurnace",
	description = {
		"**Broggok** floats through the air behind a gate with a lever in front of it. The encounter starts when the lever is pulled, releasing four increasingly difficult waves of Fel Orcs. Once each wave is killed (or ~2 mins since the last wave was released)...",
		"...the next wave comes. First wave: three non-elite Fel Orcs; Second: three non-elites and one elite Nascent Fel Orc; Third: two elites and two non-elites; and Fourth and final wave: three elites and two non-elite Fel Orcs.",
		"CC as many elites as possible, kill asap. After the fourth wave is killed the gate opens and Broggok engages. (Sheep one orc on the last wave and keep resheeping if you need time to mana up/heal.)",
		"Fight: Broggok drops rings of poison on the ground beneath him that slowly expand outward; the tank needs to move him to avoid taking damage. He also does an AoE poison bolt with a DoT that needs to be dispelled.",
		"HEROIC: The boss itself is similar to normal mode, but the groups before him are much harder. On the 3rd and 4th waves there are 4 mobs in each group."
		}
	},

	{ 
	name = { "Keli'dan the Breaker", "Keli'dan" },
	shortName = { "keli'dan" },
	instance = "bloodfurnace",
	description = {
		"**Keli'dan the Breaker** First kill his 5 Warlock companions (they cast Shadow Bolts [~1000 dmg], and Mark of Shadow [magic debuff, all shadow dmg taken increased by 1100, lasts 2 min, dispellable].) When the last warlock is dead, Keli'dan engages.",
		"Tank him facing away from the rest of the group. Keli'dan will occasionally yell, 'Closer! Come closer! And burn!', stand in place, immune to all damage for a few secs, then blast Burning Nova (AoE fire dmg to a large radius).",
		"The tank and any melee DPS can run out when he begins his yell to avoid this damage.",
		"HEROIC: All party members more than ~10yds away are pulled in just before the Nova; turn and run out asap. It is also possible to get a nice buff from the blue cracks around the room, lasts 30secs."
		}
	},

	{ 
	name = { "The Maker", "Maker" },
	shortName = { "maker" },
	instance = "bloodfurnace",
	description = {
		"**The Maker** Don't thank this Maker, he has a melee knockback attack which hits everyone in melee range and reduces threat to boot. Also casts Domination (MCs a target, increasing their dmg and healing by 100%, not dispellable)...",
		"Acid Spray (AoE spray of acid, melee range); and Throw Beaker (deals 1000-1200 nature dmg and knockback to a random target)."
		}
	},


-- Botanica

	{ 
	name = { "Botanica (Heroic)" },
	shortName = { "botanicaheroic" },
	instance = "botanica",
	description = {
		"**Botanica (Heroic)** Mobs to watch out for - Tempest Peacekeepers (hit for ~7k Arcane dmg plus added spells). A stunlocking rogue helps for these, and Arcane resistance gear is useful. At the falcons and their keepers, CC/kill the keepers first.",
		"After Thorngrin, kill/CC the Gene-Splicers first, as they do a ranged AoE that hurts a lot in Heroic mode. Other Resists: Fire resist gear for meleers in the Thorngrin fight is useful here."
		}
	},

	{ 
	name = { "High Botanist Freywinn", "Freywinn" },
	shortName = { "freywinn" },
	instance = "botanica",
	description = {
		"**High Botanist Freywinn** spawns seedlings every few seconds. The seedlings have low health (~750) but need to be killed in order to avoid their special abilities, which vary based on color: freeze (white), damage (red), root (green).",
		"One DPS has to deal with them. Every 30 secs he changes into a treant, spawns three lashers, and channels Tranquility, which heals him and the lashers. Until all the lashers are killed, Freywinn is invulnerable and will keep channeling Tranquility.",
		"Tank Freywinn on the bridge. Fear the lashers when they spawn and kill them fast, out of range of the boss and your healer.",
		"HEROIC: Same as Normal, except that adds now cast a snare as well as their old abilities. Stay closer to the glass barrier."
		}
	},

	{ 
	name = { "Laj" },
	shortName = { "laj" },
	instance = "botanica",
	description = {
		"**Laj** casts a curable +dmg disease on the tank, periodically spawns two Thorn Lashers, and changes color (when he does this he is resistant to certain types of magic). Assign one DPS to kill each add when it spawns and target the boss in between.",
		"HEROIC: No noticable changes from Normal mode."
		}
	},

	{ 
	name = { "Commander Sarannis", "Sarannis" },
	shortName = { "sarannis" },
	instance = "botanica",
	description = {
		"**Commander Sarannis** has a magic debuff that increases arcane damage taken by 1200, stacks twice, then uses an arcane damage blast. It can be dispelled. First pull the entourage in groups of three when the Commander is at the far side of the bridge.",
		"At 30-50% health Sarannis spawns four adds, 1 elite healer and 3 non-elites. Fear when the adds first appear and then keep the healer out of range and feared/sheeped until the non-elites and the Commander are dead.",
		"HEROIC: She's the same as Normal, except that she hits harder and summons adds (one Mender and three normal adds) at 50% AND 25%. Fear or CC then kill them, then refocus on Sarannis. Arcane Resist helps."
		}
	},

	{ 
	name = { "Thorngrin the Tender", "Thorngrin" },
	shortName = { "thorngrin" },
	instance = "botanica",
	description = {
		"**Thorngrin the Tender** will sacrifice a random party-member, draining their health to heal himself. He casts a Hellfire that affects everyone in melee range, use fire resist potions or gear.",
		"Clear the room and the hallway to the south first; there are two groups of two stealthed satyr that can add to the boss fight. Tank in the middle of the room.",
		"The main healer should place himself so that he can see the tank and heal him, but is out of the boss's line-of-sight to avoid the sacrifice. Thorngrin also drops aggro after casting sacrifice.",
		"HEROIC: His flame AOE now hits for ~2.5k. Melee is in more danger than ever."
		}
	},

	{ 
	name = { "Warp Splinter", "Splinter" },
	shortName = { "warpsplinter" },
	instance = "botanica",
	description = {
		"**Warp Splinter** spawns 6+ treants (~3000hp) near his starting point which slowly move towards the boss. They despawn after ~20 seconds and heal the boss for their total remaining health.",
		"Tank him halfway towards the bridge where you entered (he resets if he gets to the bridge). Everyone else should be at max range closer to his starting point. Once the tank has aggro do full DPS on the boss until the adds spawn.",
		"Kill the spawns starting with those closest to the boss. Once they are dead refocus on the boss. Rinse and repeat.",
		"HEROIC: This boss's arcane volley hits the number of enemies minus 4, so you do NOT want pets or even totems out. With only 5 enemies (the party), only the MT will get hurt.",
		"If you really want totems or pets, stand underneath him - the stomp hurts less than the volley. Depending on DPS, you can burn down the adds or ignore them."
		}
	},

-- The Eye

	{ 
	name = { "Void Reaver" },
	shortName = { "voidreaver" },
	instance = "eye",
	description = {
		"**Void Reaver** Melee (3-4K dmg on tanks); Pounding (AoE, 3-sec channeled 1300-2250 arcane dmg/sec, 18yd range); Arcane Orb (random ball thrown at player,~6k arcane dmg w/20-yd radius, 6 sec. silence, target should run);",
		"Knock Away (knockback targets highest on aggro list, aggro reduction, 30sec cooldown); enrages after 10 mins and wipes raid.",
		"Fight: Tank in the middle of the room. Use hunter Misdirection on the MT to start the fight. Tanks (4) keep Reaver in middle, ranged DPS/healers in circle at max range. Melee DPS behind Reaver at max range, backing out during Pounding.",
		"When MT loses aggro from Knock Away, OTs pick him up. Non-melee watch for Arcane Orbs and run away to avoid dmg and silence. Not tauntable."
		}
	},

-- Gruul's Lair

	{ 
	name = { "Gruul the Dragonkiller", "Gruul" },
	shortName = { "gruul" },
	instance = "gruul's lair",
	description = {
		"**Gruul The Dragonkiller** does Growth (+15% dmg, stacks); Hurtful Strike (~12k dmg to 2nd on aggro list); Reverberation (zone-wide silence for 3 secs, not dispellable); Cave In: (Random AoE which causes ~3000 dmg every 3 secs in the area...",
		"(melee dmg, occurs more in later stages; Growth also affects Cave In); Ground Slam: (Zone-wide knockback in a random direction, then triggers the Grasp), Gronn Lord's Grasp (reduced movement speed by 20%/sec. After 5 secs causes Stoned);",
		"Stoned, Shatter (after being Stoned, Gruul Shatters everyone, with more dmg if players are closer to each other; dmg penetrates immunity shields and ranges from 1100 at ~15 yds to 6k if very close). Use Amplify Magic and Concentration Aura on healers.",
		"Fight: Everyone run in together as the doors close at the start. Tanks must be 1st and 2nd on the aggro list at all times. Healers, stack HoTs on the tanks before the silence.",
		"Staying alive: Cave-Ins become increasingly deadly, but only tick after 3 secs; run to avoid dmg. Shatter is the main killer. Positioning is vital. When hit, look down for a clear spot to run to. When you land you have ~3 secs to get away from others.",
		"Note: Three players landing near each other usually means they all die. Rogues should Cloak, and druids Barkskin. The knockback needs LoS so you can run behind a boulder. Another trick is to drink a Dreamless Sleep potion in mid-air.",
		"At 16+ Growths, Hurtful Strike can one shot your OT. You have ~8 minutes to defeat Gruul.  Good Luck!"
		}
	},

-- Hellfire Ramparts

	{ 
	name = { "Hellfire Ramparts (Heroic)" },
	shortName = { "hellfireheroic" },
	instance = "hellfire",
	description = {
		"**Hellfire Ramparts (Heroic)** The most problematic mobs are the Raveners (can one-shot cloth and two-shot leather), who often come with wolves (CC those). Try to disarm them, this decreases their dmg a lot.",
		"Another challenging group is the four casters with a meleeer in the middle. The casters fear a lot, but only when you come close; if you can, keep your distance.",
		"There is also a Beastmaster near the start. If he isn't killed asap he will summon two wolves which aggro everything in their path. Kill him quickly!",
		"Also, Beastmasters and Rippers cannot be CC'd."
		}
	},

	{ 
	name = { "Watchkeeper Gargolmar", "Gargolmar" },
	shortName = { "gargolmar" },
	instance = "hellfire",
	description = {
		"**Watchkeeper Gargolmar** patrols back and forth with two healing adds (Watchers, cast Shadow Word: Pain). Gargolmar will occasionally charge the furthest person from him during the fight, hitting cloth pretty hard.",
		"First clear the groups near the end of his patrol path closest to you. Tank Gargolmar while DPS kills the two Watchers; they aren't tough, but CCing one while you fight the other will help. They heal themselves and the boss...",
		"...(usually Gargolmar shouts 'Heal me, quickly!' before a heal is cast). Be ready to interrupt/fear/resheep. If you have 2 CCers, CC the Watchers, kill Gargolmar and then finish them off.",
		"HEROIC: Gargolmar does an AoE knockback surge on all players instead of charging."
		}
	},

	{ 
	name = { "Omor the Unscarred", "Omor" },
	shortName = { "omor" },
	instance = "hellfire",
	description = {
		"**Omor the Unscarred** First clear the two guards in front of him (they are not linked to Omor and can be pulled without chaining the boss). During the fight he spawns felhounds that cast Drain Life and heal the boss, but die fast (HP <2K, can be feared).",
		"When he has less than 20% hp he starts periodically reflecting spells. During the fight, Omor casts Treacherous Aura (curse, dispellable) on a random target that has no effect on the cursed character but does dmg around them (~400 shadow dmg/tick).",
		"Finally, Omor can pick someone up and toss them around in the air with a Shadow Whip. The character will be lifted into the air and attacked, possibly stunning them; once the person is released, they fall and take damage.",
		"HEROIC: Omor's curse is not dispellable and does 10x more dmg, and teh Felhounds have significantly more HP. Spread out to avoid dmg and protect the healers from mana burn and aggro."
		}
	},

	{ 
	name = { "Vazruden the Herald", "Vazruden" },
	shortName = { "vazruden" },
	instance = "hellfire",
	description = {
		"**Vazruden** Begin the fight by killing the two guards at the bottom of the ramp. When they die Vazruden lands and fights. Phase One: Tank-and-spank Vazruden, taking him down fast. His mount Nazan fires AoE fireballs from above (they DoT when they land).",
		"If one hits you, move out of the fire fast. Phase Two begins when Vazruden is close to death: Nazan lands, generally heading straight for your healer. Keep them at the back of the group, and taunt Nazan fast.",
		"Place Nazan in the middle of the ring and slowly rotate him around to avoid his DoTs. Fire resist gear (particularly your tank) or potions are useful."
		}
	},

-- Karazhan
	
	{
	name = { "Shade of Aran", "Aran" },
	shortName = { "aran" },
	instance = "karazhan",
	description = {
		"**Shade of Aran** is a mage with Chains of Ice (10sec root, dispel/Vanish); Slow (cast before Arcane Explosion, dispel/shapeshift); Flame Wreath (don't move!), Mass Polymorph (Tree of Life druids immune); Mass Pyroblast, Summon Elementals, also...",
		"Blizzard: moves around the room. A blue shard falls from the sky at the starting point a second before it starts. The exact center of the room is safe from the Blizzard.",
		"Arcane Explosion: He summons everyone to him, casts Slow, and begins casting. You have 10 secs to run to the edge of the room. This is a good point to bandage.",
		"Flame Wreath: When it is cast, DO NOT MOVE. You may attack but not bandage. If you move, the whole raid takes 4k dmg.",
		"Fight: Aran cannot be tanked, so go all out DPS. Casters stay ~10yds away to avoid Counterspell. When he is down to 20% mana he Polymorphs everyone, regains all mana, and Pyroblasts the raid for 7k+.",
		"Rogues can Vanish, Druids can shapeshift out of it to top everyone off before the Pyroblast. Interrupt Fireballs and Frostbolts to preserve his mana (Arcane Missiles cost him more mana). At 40% HP he summons 4 water elementals with 13k HP.",
		"Banish/fear two, kill the other two asap. Elementals disappear after 90 secs. Separate Elementals and Polymorph: If he is near 40% HP and low on mana, stop all DPS, wait for the Mass Polymorph, then resume DPS, (elementals + polymorph = lots of damage).",
		"Note: He is immune to Curse of Tongues. Also, the fight is timed; at ~15 minutes he will call Shadows of Aran which wipe the raid."
		}
	},

	{ 
	name = { "Attumen the Huntsman", "Attumen", "Midnight" },
	shortName = { "attumen" },
	instance = "karazhan",
	description = {
		"**Attumen the Huntsman** and Midnight. First kill trash mobs in the room (you have 25 minutes to engage Midnight before they respawn). Start with the Main Tank aggroing Midnight. The Off Tank should stand near Midnight, but between him and the healers.",
		"After a few seconds Attumen will spawn at Midnight's starting point; the OT must pick him up *immediately*.",
		"[Phase 1]: The OT should drag Attumen to the far side of the corral, disarming as often as possible (reduces damage by ~75%). NO DPS on Attumen, everybody should be on the horse.",
		"Tank Midnight away from the raid, near the center of the corral. When Midnight is down to ~25% Phase 2 starts and all aggro will be wiped - stop all DPS!",
		"[Phase 2]: Attumen mounts up, wipes aggro, and is healed up to Midnight's HP%. The MT must pick up Attumen immediately to keep clothies from being one-shotted. MT use Shield Wall, hunters use Misdirect. Healers need to keep everyone's health topped off.",
		"Attumen randomly charges and hits for 6,000+ on cloth. Keep Attumen facing away from the group. Once the MT has solid aggro, start DPS. OT keep disarming, mages/druids decurse -50% hit rate debuff.",
		"Notes: This is a very aggro sensitive fight, watch your aggro! One healer should be enough on the OT, all others on the MT. Attumen and Midnight must be kept in LoS of one another.",
		"You don't need to kill the 5 humans near the quest giver (the friendly <Blacksmith>). Standing outside of the range of Attumen's cleave but still within melee range may help avoid charges."
		}
	},

	{ 
	name = { "The Curator", "Curator" },
	shortName = { "curator" },
	instance = "karazhan",
	description = {
		"**The Curator** summons an add every 10 secs (~12kHP) with Chain Lightning (10yd range, 675-825 Arcane dmg). Spread out to avoid this damage. They do Arcane melee dmg and are not tauntable.",
		"The Curator also shoots Hateful Bolts (4k-5,500 Arcane dmg) at the person with #2 aggro and the most health. At low mana the boss Evocates, during which time he stops attacking and summoning, and takes 200% dmg (use Shadow Fiends, DoTs and Bloodlust).",
		"His aggro list for Hateful Bolts also resets. At 15% he Enrages, increasing his melee DPS and Hateful Bolt rate, and he cannot summon adds or be Weakened.",
		"Tank The Curator toward the entrance end of the room. Spread out to avoid the adds' chain lightning, ~12-15yds apart. The OT needs to keep steady DPS on the boss and to stay #2 on the aggro list. Melee/Ranged DPS need to kill the adds asap...",
		"...and DPS The Curator when possible. 200+ Arcane Resist is recommended. The boss is immune to arcane dmg, and the fight has a time limit; after 12 mins he goes Berserk and wipes the raid."
		}
	},

	{ 
	name = { "Terestian Illhoof", "Illhoof", "Kil'Rek"},
	shortName = { "illhoof" },
	instance = "karazhan",
	description = {
		"**Terestian Illhoof** is an optional boss who does Shadow Bolts (at top aggro target); Sacrifice (random, 1500 shadow dmg/sec until chains are dead, boss heals); Summon Imps (can be feared); Kil'Rek does Amplify Flames (+500 fire dmg to top aggro target).",
		"Fight: tank near the circle where the Sacrifice happens and stay bunched close to him. Ten secs in, two portals open at the back of the room and a steady stream of non-elite imps appear. These should be continually AoE'd (warlock preferred).",
		"Sacrifice shackles one player with demon chains and teleports them to the middle of the glyph on the floor. That player will take ~1000 dmg/sec, and heal Illhoof. Mortal Strike/wound poison on the boss minimize healing.",
		"Focus all DPS except Imp AoE on Illhoof until someone is Sacrificed; then kill the chains immediately! Use a '/target Demon Chains' macro for this. A paladin tank with Consecration and fire resist helps immensely, as does Seed of Corruption.",
		"Illhoof's minion, Kil'rek, should be ignored. Off-tank or kite him. He will eventually die from the AoE, then respawn after 30 secs. During those 30 secs, Illhoof will gain Broken Pact and take an extra 25% dmg.",
		"Note: The event is timed; after 10 mins he goes Berserk and spams 7k shadow bolt volleys on the entire raid. Shadow potions don't work on Sacrifice."
		}
	},
	
	{ 
	name = { "Maiden of Virtue" },
	shortName = { "maiden" },
	instance = "karazhan",
	description = {
		"**Maiden of Virtue** does mostly holy/physical dmg. Holy Ground also silences. Holy Wrath: chained AoE. Holy Fire: fire dmg, its DoT needs to be cleansed asap. She's immune to Taunt but not bleeds. Don't use pets except for Imps with Phase Shift.",
		"She also casts Repentance at random intervals, no more than 25 secs apart. It deals 1500-2000 holy dmg and stuns everyone for up to 10 secs. Any damage wakes the target. Stack HoTs on the tank.",
		"Any Paladins should keep Blessing of Sacrifice on the MT so the Paladin wakes up when the tank is hit. Warriors can use Berserker Rage to resist or break Repentance. Dampen Magic on melee DPS reduces the Holy Ground dmg to 150-200.",
		"Fight: Cast PW:Shield/Prayer of Mending on the MT pre-fight. Use Misdirect on pull to give MT more aggro. Tank her where she stands; as the MT runs in all ranged move into a circle around her, backs against pillars. Healers to the N, S, E, & W, ranged...",
		"...DPS stand in-between healers to avoid chaining/LoS issues. Only one melee DPS should be on the boss at once. When the melee DPS on the Maiden gets below 50% HP, they should run out and use a Lightwell or bandage, and another should take their place."
		}
	},
	
	{
	name = { "Prince Malchezaar"},
	shortName = { "malchezaar" },
	instance = "karazhan",
	description = {
	"**Prince Malchezaar** has ~1 million HP. Does Burning Abyssal (summons add every 45 secs, casts fire AoE, 30yd range, ~7k dmg/tick); Enfeeble (every ~30 secs, brings 5 players to 1HP, no healing effects for 7 secs, get to 30+ yds in <4 secs to avoid Nova);",
	"Shadow Nova (knockback, resistible, rogues can cloak); Shadow Word Pain (dispellable); Sunder Armor; Thrash (extra attacks); Summons Axes (axes become adds).",
	"Fight: Tank him with your back against a wall, away from any corners. This minimizes the chance of getting boxed in by Abyssals, prevents knockback, and still gives room to move. Dispel all debuffs.",
	"Every 45 secs an Abyssal will fall from the sky and land in a random spot. It never moves and cannot be killed so it must be avoided; dies after 3 minutes. One person with Detect Demons can call out where Abyssals will land and where to move.",
	"At 60% HP he summons two axes (~7k+ dmg to the tank). Burn through this phase asap. At 30% HP he no longer Enfeebles but the Abyssals come faster, and the axes attack random party members.",
	"Note: The highest aggro target cannot be Enfeebled, so make sure that the MT is Always on the top of the aggro list!"
		}
	},
	
	{ 
	name = { "Moroes" },
	shortName = { "moroes" },
	instance = "karazhan",
	description = {
		"**Moroes** Vanishes; after reappearing he Garrotes a random target, dealing 1000 dmg/3 secs for *5 mins*; also Blinds the second-highest aggro (dispellable); Gouges the highest aggro, then attacks the second-highest aggro.",
		"Adds are immune to Bleed but Moroes is not. Equip Rune/Seal of the Dawn if available.",
		"Adds: CC as many as possible, warriors first. Kill priest(s) while interrupting all heals and mana burns. Re-CC asap when it breaks; many can one-shot clothies or heal Moroes. Reshackle every ~5-7 secs. If an add breaks...",
		"...a tank can taunt it but not attack; hunters can also use Distracting Shot on shackled adds to keep them off priests. Dropping an Earthbind Totem between shackled mobs and the priest also helps. Don't use Shadowfiend unless no CC is active.",
		"Fight: Begin with the MT and OT pulling Moroes off his platform. CC quickly to keep adds off tanks, kill any loose adds. Once adds are CCd/killed, focus on Moroes. Tanks must keep boss aggro at all times.",
		"When a tank is Blinded (poison) it needs to be removed immediately. If no one can remove poison the MT should turn his back to Moroes to avoid being Gouged. After Moroes Vanishes then Garrotes, he returns to the player with the highest pre-Vanish aggro.",
		"Garrote can be removed by Divine Shield/Blessing of Protection and Ice Block, all others have to heal through it. Save BoP for the priests who are shackling adds.",
		"When Moroes Enrages at 30% HP, it is vital to burn him down asap. Once he is dead, deal with any remaining adds."
		}
	},
	
	{ 
	name = { "Netherspite" },
	shortName = { "netherspite" },
	instance = "karazhan",
	description = {
		"**Netherspite** does Nether Burn, Void Zone Consumption, Empowerment, Enrage, Netherbreath, Nether exhaustion. Nether Burn is a continuous aura around the boss that does 1200 shadow dmg/5 secs. He also randomly drops Void Zones at player's feet. Move asap.",
		"There are two phases to the fight: Banish (30 secs) and Portal (60 secs). In Banish phase, Netherspite is stationary and shoots netherbolts (cone AoE) for ~6000 dmg with knockback. Tank on one side of the room with everyone else to the other side.",
		"Portal phase is the real challenge. Three portals appear around the room and shoot beams at Netherspite. Each color beam gives a certain stackable buff.", 
		"Green: increases healing done and received/energy but reduces maximum mana; Blue: increases dmg done and received; Red: increases max health the first use, then slowly reduces max health, also causes instant aggro.",
		"Players must stand in the beams to keep Netherspite from buffing (and receive the buffs themselves). After the beams stop or a player leaves the beam, you cannot get the same buff for ~90 secs. Establish a rotation for beam interruption.",
		"Use two tanks, one tanking in the Red beam and the other in the Green beam. Healers/rogues should rotate through the Green beam when tanks do not need it, and all DPSers through the Blue beam. Use caution with your HP/mana when stacking multiple buffs.",
		"The fight is constrained: you have five Banish phases to kill him. After the 5th phase (~9 min) he will enrage and wipe the raid."
		}
	},

	{ 
	name = { "Nightbane" },
	shortName = { "nightbane" },
	instance = "karazhan",
	description = {
		"**Nightbane** is a summonable undead dragon. Abilities (Ground): Smoldering Breath (~4k fire dmg+DoT, frontal), Distracting Ash (dispellable), Tail Swipe (fire dmg+DoT), Cleave (frontal, 6-11k dmg), Charred Earth (random AoE 20k+ dmg over 30 secs), fear;",
		"(Air): Rain of Bones (400 physical dmg and summoned adds), Smoking Blast (2k physical and 3k fire DoT [dispellable], targets top healer from Air phase), Searing Cinders. Stay in range or he will blast you with fireballs.",
		"He has two phases: Ground and Air. Ground Phase: A tank with fear ward should face him towards the edge, all others stay to his side at max range to avoid fear. (Behind him and he will tail swipe, near his front half and he will cleave and breathe fire.)",
		"Air Phase: Happens at 25%, 50% and 75% HP. He flies up and casts Rain of Bones on a random player, summoning skeletons and casting Searing Cinders on that spot. Move out of the Cinders and kill the skeletons asap. A second tank helps.",
		"When Nightbane lands, he wipes aggro and usually targets a healer, so the tank must be ready. Do not chase any skeletons that run near Nightbane, or you will get cleaved. Bring lots of potions."
		}
	},

	{ 
	name = { "Opera Event" },
	shortName = { "opera" },
	instance = "karazhan",
	description = {
		"**The Opera Event** is one of three random encounters that begin when you talk to Barney outside the stage door. The three bosses are Big Bad Wolf, Romulo and Julianne, and the Wizard of Oz. Moroes must be killed for the Opera event to be activated."
		}
	},

	{ 
	name = { "Wizard of Oz" },
	shortName = { "oz" },
	instance = "karazhan",
	description = {
		"**Wizard of Oz** includes Roar (fears), Tito (silences), Dorothee (Frost bolts, random target; fears), Strawman (susceptible to fire dmg), Tinhead (cleaves; slows as he rusts), and the Crone (Cyclone and chain lightning).",
		"Fight: Dorothee attacks first, summons Tito. Roar is next (keep him feared away from the raid, warlock preferred). Strawman comes after (DPS with fire spells/totems/imps), followed by Tinhead (tank must pick up fast).",
		"Kill order: One tank on Roar and taunting Tito; the other on Tinman until Rust slows him enough to be kited. Mage/Warlock focus fire dmg on Strawman. The rest burn down Dorothee; once she is dead, finish off Strawman, then Tito, Roar, then Tinman.",
		"When these four are dead the Crone spawns. The Crone must be picked up immediately. Keep moving to avoid Cyclones (interrupt casts); HoTs and instant spells still work if you are caught in one."
		}
	},

	{ 
	name = { "Romulo and Julianne", "Romulo", "Julianne" },
	shortName = { "romulo" },
	instance = "karazhan",
	description = {
		"**Romulo and Julianne** Julianne appears first; has a dispellable dmg buff, does Powerful Attraction (6 sec stun), Blinding Passion (6k holy dmg/4 secs), Devotion (holy spell dmg/haste), Eternal Affection (heals for 50%, interruptible.",
		"Kill Julianne. When Julianne is dead Romulo appears. Romulo does melee dmg, knockback, and Poisoned Thrust (dispellable, 8x stacking poison that reduces stats by 10%). Dispel his buffs and kill.",
		"Once dead, they both reappear. DPS target Romulo, melee target Julianne. They must die within 10 secs of each other, so OT Romulo, get Julianne to ~10%, then stop all DPS. Kill Romulo then finish off Julianne."
		}
	},

	{ 
	name = { "Big Bad Wolf" },
	shortName = { "wolf" },
	instance = "karazhan",
	description = {
		"**Big Bad Wolf** fears (3 secs, cast every 25-35 secs), and turns a random player into Little Red Riding Hood (victim loses all armor and resistances, is silenced, run speed +50%, Wolf may chase you; lasts 20 secs).",
		"Tank along one wall a medium distance away from other players. MT must keep aggro during others' Little Red transformations. Run in a square around the room. If you do it right the wolf will run into pillars and stage props.",
		"Notes: Hunters can feign and rogues vanish during the Little Red debuff. Amplify Magic helps healing. Tremor totems and Thunderclaps also help."
		}
	},
	
-- Magister's Terrace

	{ 
	name = { "Selin Fireheart", "Fireheart" },
	shortName = { "fireheart" },
	instance = "magistersterrace",
	description = {
		"**Selin Fireheart** siphons mana from nearby Fel Crystal, continues until the crystal is destroyed or his mana is full. After each crystal drain casts Fel Explosion (AoE fire dmg) until out of mana. Casts Drain Life on random targets...",
		"...deals shadow dmg and heals Selin; interrupt or dispel (pally cleanse). (Heroic only: Casts Drain Mana on random target.) Everyone has to be in the room when he aggros, which appears to be after the pull in front of him.",
		"He will start to drain energy from the crystals on his platform, gaining size/dmg. As he drains energy from the crystals his mana bar begins to fill up. These must be broken ASAP or he will detonate them.",
		"Even if you break the crystal before he finishes draining it he will cast Fel Explosion until he is completely out of mana."
		}
	},

	{ 
	name = { "Vexallus" },
	shortName = { "vexallus" },
	instance = "magistersterrace",
	description = {
		"**Vexallus** is immune to Taunt, casts Chain Lightning (random target, ~2k nature dmg, jumps to nearby players); spawns adds (low HP, do 1500-3000 dmg). Does stacking Arcane Debuff (300 dmg/sec, increases dmg dealt by 50% per stack).",
		"At ~10-20% HP he chain-casts Overload (arcane AoE, stacking debuff, unlimited range), He must be burned down rapidly once he begins this attack. Dmg starts at ~1k dmg/cast (in normal) and increases Arcane dmg by 10% each cast.",
		"Like Curator, he spawns adds that must be dealt with, and enrages at low HP. When an add is killed it debuffs the player who killed it (300 Arcane dmg/sec but increases dmg dealt by 50%). Too many debuffs will kill you so spread them out among the DPSers.",
		"The fight is a race between the healer's mana pool and maximum HPS. As more and more debuffs pile up, it becomes harder and harder to keep everyone alive (like Garottes with Moroes). In order to kill Vexallus fast enough when he enrages...",
		"...you need the debuffs to increase your DPS. All damage by Vexallus and the adds is Arcane (including his melee attack); resist gear/pots will help immensely.",
		"HEROIC: Vexallus spawns two adds instead of one. If you chain-pull the eels in front of Vexallus, it is possible to start this fight with a substantial dmg buff for the first 10-15 secs."
		}
	},

	{ 
	name = { "Priestess Delrissa", "Delrissa" },
	shortName = { "delrissa" },
	instance = "magistersterrace",
	description = {
		"**Priestess Delrissa** has 4 random NPCs (like Moroes), all CCable but immune to taunt. Keep as many targets as possible CCd while you deal with each one individually. All forms of CC help. Traps and scatter shot work on Delrissa, but Polymorph does not.",
		"Pull and CC immediately, then kill them one at a time. There is no hard kill order, but killing the Priestess (or one of the healer mini-bosses) first seems to be best, as they heal. The Priestess hits for about 500 to 700 on cloth.",
		"If you have a mage, Spellsteal the Priestess constantly to remove her healing factors. Priests, shamans and hunters can also dispel/purge/arcane shot her to achieve a similar effect. The mobs will not despawn and all need to be killed."
		}
	},

	{ 
	name = { "Kael'thas Sunstrider", "Sunstrider", "Kael'thas" },
	shortName = { "kaelthas" },
	instance = "magistersterrace",
	description = {
		"**Kael'thas Sunstrider** does Fireball (~1.5k-2k; ~6k dmg in Heroic), Summon Phoenix (does AoE fire dmg then explodes with knockback, kite with ranged class; leaves an egg which must be killed before respawn); Gravity Lapse; Flamestrike (avoid AoE).",
		"All spells can be interrupted/reflected. Kael'thas has two phases. Phase 1: mostly melee, occasional Fireballs on a random target. Summons Phoenix which should be kited and DPSd by 2+ people. Be sure to kill the egg it leaves when killed.",
		"Phase 2: at 50% HP he casts Gravity Lapse (30 secs), throws the party in the air (you move as if you were swimming) and does 400 dmg/sec. He also starts channeling arcane magic to the entire party (~350 dmg/tick). A healer with an AoE heal is good here.",
		"He also spawns arcane orbs (2k dmg). Swim to avoid the orbs and DPS boss. When Gravity Lapse ends he will be Exhausted; you have a few seconds to heal and DPS before he casts Gravity Lapse again. Stay alive and continue to DPS until dead.",
		"HEROIC: Fireball/Flamestrike dmg is higher and he uses Shock Barrier (blocks spell interrupts, needs to be nuked down asap). He will start casting Pyroblast under the Barrier; if not interrupted will do 48k dmg to the tank. Also summons Phoenix more."
		}
	},

-- Mana Tombs

	{ 
	name = { "Mana Tombs (Heroic)" },
	shortName = { "manatombsheroic" },
	instance = "manatombs",
	description = {
		"**Mana Tombs (Heroic)** Mobs to watch out for: Ethereal Sorcerers (cast arcane missiles and summon arcane elementals; CC and/or kill these guys first, they hit hard).",
		"Kill Sorcerers, Darkcasters (can easily wipe a mana-based party with mana burns, interruptible), then Priests. Also note Nexus Terrors (void-walker-like mobs which have a fear, so watch where you tank them)."
		}
	},
	
	{ 
	name = { "Pandemonius" },
	shortName = { "pandemonius" },
	instance = "manatombs",
	description = {
		"**Pandemonius** does all shadow dmg; Void Blast (~1.5k Shadow dmg + knockback per sec within ~30 yd radius for 5 sec, not avoidable through LoS); Shadow Shield (reflects all spells and deals 800-1000 dmg to melee attackers...",
		"...he glows green and DPS melee must stop attacking or be hit for ~750/tick, Hunters' ranged dmg is not reflected). Fight: The MT should tank in the center of the room, back to the big hunk of stone in the middle to avoid knockback.",
		"All players should stand with backs to a wall to avoid knockback. Use Grounding Totems as much as possible (it eats the shadow bolts). This is an EXTREMELY mana-intensive fight. Resists: Shadow resist items/pots/buffs help.",
		"HEROIC: He does not gain any new abilities on Heroic difficulty, but he melees for up to 5.6k shadow dmg, and the shield reflects ~1500-1700/swing against melee. Shadow resistance items/pots/buffs are critical."
		}
	},	

	{ 
	name = { "Nexus-Prince Shaffar", "Shaffar" },
	shortName = { "shaffar" },
	instance = "manatombs",
	description = {
		"**Nexus-Prince Shaffar** melees (~350-450 dmg); does Frostbolt/Fireball (~1k-1200 dmg); spawns Ethereal Beacons (casts one every ~10 secs); Caster Spawn (Ethereal Beacons spawn a caster if they are not taken down promptly).",
		"Shaffar starts with three Ethereal Beacons - kill these fast. The hardest part of the encounter is the start because if not killed fast enough, the Beacons will wipe you. He does a lot of Elemental Damage (Fire, Frost, Shadow, Arcane).",
		"Fight: This fight is about controlling the Ethereal Beacons, while still killing Shaffar. This is a long fight. Start with DPS killing the first three beacons (assign targets to kill asap) while the main tank gets aggro, then focus on the boss.",
		"If a caster is spawned, sheep for the fight or DPS. They have low health but do a lot of dmg. He likes to frost nova the tank and then port away. Once the frost nova breaks, the MT should just run and grab him. Spell Reflection also works.",
		"HEROIC: A much harder fight than Normal. A~9000 HP and spells hit for ~1000-1500 dmg. The beacons will probably spawn faster than you can deal with them. The best strategy is probably to all-out DPS the boss and ignore/fear the adds.",
		"Killing one of the starting beacons, well timed & effective fears, and not pulling aggro from the tank while squeezing every last bit of DPS out are key."
		}
	},	
	
	{ 
	name = { "Tavarok" },
	shortName = { "tavarok" },
	instance = "manatombs",
	description = {
		"**Tavarok** melees (250-400/hit); does Earthquake (hits for ~750-950 and stuns, ~30 yd range); Crystal Prison (random target, target frozen/can't cast, dmgs for 10% of your life/sec for 5 secs). Fight: With enough healing this is a basic tank and spank.",
		"Healers keep everyone above 50% HP. DPS should stand at max range to avoid Earthquake, teh MT should focus on keeping aggro to maintain positioning.",
		"HEROIC: Similar to Normal, but he hits for quite a bit harder. His Arcing Smash does 125% weapon dmg and hits a warrior for 6-7k."
		}
	},	
	
	{ 
	name = { "Yor" },
	shortName = { "yor" },
	instance = "manatombs",
	description = {
		"**Yor** the Void Hound of Shaffar is a Heroic-only boss summonable after completing 'The Mark of the Nexus-King' quest and reaching Exalted-Consortium. The Mark of Haramed lets you open the Stasis Chamber in front of the Nexus-Prince Shaffar.",
		"A summoned felhound boss named Yor will appear. The fight is a simple tank and spank; Yor's only special ability is a breath attack."
		}
	},	
	
-- Molten Core

	{ 
	name = { "Firelord" },
	shortName = { "firelord" },
	instance = "mc",
	description = {
		"FIRELORD: They spawn little guys - we must kill these first or they will in turn spawn more little ones. OT tank little ones close so Mages can use AOE to hit both at the same time." 
		}
	},

	{ 
	name = { "Garr" },
	shortName = { "garr" },
	instance = "mc",
	description = {
		"GARR: He has 8 firesworn buddies. We will assign people to target specific firesworn, when you have target do not lose it. First hunter/warlock pairs are assigned to targets. Then OTs are assigned to remaining targets. MT on Garr.",
		"Tanks go in at same time, and hunters peel firesworn off to warlocks. Garr tanked away from the rest of the raid. He has AOE magic dispel that will remove buffs. He also has an AOE magic debuff that slows movement.",
		"Warlocks will CoS then chain-banish their target, and have VW tank it in between banishes. Use health funnel to keep VW at full hp while banished, and stone/pot/bandage self. Raid will kill OTs firesworn one at a time (assist MA).",
		"Melee dps (except the OT) need to move away from firesworn before they die - they explode for 1-2k dmg. After all OT firesworn are dead, kill Garr who also explodes on death! Stand back!",
		"After Garr is dead, kill the warlocks' remaining firesworn one at a time." 
		}
	},

	{ 
	name = { "GDRL Loot" },
	shortName = { "gdrlloot" },
	instance = "mc",
	description = {
		"LOOT: GDRL uses Suicide Kings. You will be put on two lists, a general raid list and a class-specific list. When we roll on an item, the loot master will ask for certain classes to whisper 'me' to suicide.",
		"If anyone suicides, the person highest on the list wins the item, and then goes to the bottom of the list, bumping everyone under them up a slot. People moving up slots jump over anyone in the list who is not present in the raid currently.",
		"People who suicide but do not win go up the list, they do not go to the bottom. If no one suicides, we ask for /random's for NEED. If no one needs, secondary classes may get a need suicide/roll. It eventually falls to greed rolls.",
		"Cores and Leather: the first drop of each type on a run will be kept by GDRL officers for the purposes of crafting armor for the tanks, so we can eventually fight Ragnaros. The rest of the drops will be rolled for at a safe place or the end of the raid.",
		"Patterns: GDRL officers will be keeping the first copy of any pattern that drops that we don't already have. After we have one copy, further drops will be rolled for as normal. GDRL officers promise to craft anything from the patterns we get for any GDRL member who has the mats, free of charge." 
		}
	},

	{ 
	name = { "Baron Geddon", "Geddon" },
	shortName = { "geddon" },
	instance = "mc",
	description = {
		"BARON GEDDON: The party will spread out in a circle around Garr's room. The Baron is pulled into Garr's room. Baron will do a PBAoE Inferno that pulses 9 times, each for more damage. Melee must move away during this, and DPS STOP.",
		"Baron will put a MAGIC DoT on us that drains 400 mana and does 400 damage per tick, for 5 min. This MUST be dispelled by priests from everyone but warriors and rogues. Baron will place a debuff called LIVING BOMB on random people.",
		"CTRA will notify you if you are the bomb. If you are the bomb, you MUST RUN AWAY FROM EVERYONE ELSE. In 10 seconds you will explode and take 3200 damage, and deal that damage to anyone near you. RUN BACK TO THE WALLS. Bomb also shoots you in the air.",
		"If you get near the wall, you can use it to take less falling damage. Ice block can dispel The Bomb. Slowfall effects can help with falling. Finally, at 2% hp the Baron will emote something.. we then have *5 SECONDS* to kill him or we die." 
		}
	},

	{ 
	name = { "Gehannas" },
	shortName = { "gehannas" },
	instance = "mc",
	description = {
		"GEHENNAS: The raid will be split into two groups. OT groups will be to the E of the boss, MT group fights at boss start area. MT will pull the boss to the middle of the big area, hunters IMMEDIATELY peel the guards off to the OT group.",
		"Boss has AOE CURSE for -75% healing. We assign a decurser dedicated to keeping it off the MT. Other decursers clear the rest of raid. Boss throws shadowbolts for 2k dmg at random people, and AOE rain of fire, which you must run out of.",
		"Guards must be tanked apart from each other due to cleave-stun attack. Guards tanked out of Boss' AOE range. After pull, we kill marked guard first. Next, RANGED dps will move to attack Boss. MELEE dps will stay to kill second guard." 
		}
	},

	{ 
	name = { "Golemagg" },
	shortName = { "golemagg" },
	instance = "mc",
	description = {
		"GOLEMAGG: He has two Core Rager dogs. These must be pulled by hunters FAR away from the boss, otherwise he buffs them. The dogs CANNOT be killed while Golemagg lives, so we just OT them away from boss and kill boss first.",
		"MTs must have good fire resist. Boss casts stacking fire damage and armor reducing DoTs. We will need two MTs assigned to the boss so they can switch out if one gets into too much trouble, and needs to back out to recover from DoTs.",
		"Boss shoots 2000 dmg pyroblasts at random targets. We need two healers on the MT at least, and more in rotation. Other healers for OTs and some healing the dmg from the pyroblast, which puts on a DoT that can easily kill casters if not healed quick.",
		"When Boss is at 10% HP he attacks faster and casts an earthquake AOE. Possibly melee can back out at this point and finish him with ranged only. He also debuffs everyone but the OTs to have +aggro to the dogs. Kill boss quick, the dogs die with him." 
		}
	},

	{ 
	name = { "Ancient Core Hound", "Hound" },
	shortName = { "hound" },
	instance = "mc",
	description = {
		"HOUND PACKS: We assign one tank to each dog. Tanks must keep the dogs together in a tight group. ALL DOGS MUST DIE AT THE SAME TIME. Use AOE if you have it, otherwise switch targets constantly so you're hitting the highest HP target to keep them even.",
		"If one gets too low we will call 'STOP AOE'. In that case, target the high ones with individual attacks to bring them back in line. If one breaks free of the group -- DRAG IT BACK if you have aggro." 
		}
	},

	{ 
	name = { "Lava Packs" },
	shortName = { "lavapacks" },
	instance = "mc",
	description = {
		"LAVA PACKS: Groups of 4 mobs. 1 Flameguard, 1 Firewalker, and 2 stone elementals. The MT will tank the Flameguard, FACE IT AWAY from the group. OT on Firewalker, which we must kill first. Tank them apart so their AoE doesn't overlap.",
		"Warlocks must banish the two stone elementals. Firewalker is VERY DANGEROUS and so dies first, followed by the Flameguard, then one banished then the other. All mobs should be tanked away from the group due to cleaves and stuns." 
		}
	},

	{ 
	name = { "Magmadar" },
	shortName = { "magmadar" },
	instance = "mc",
	description = {

	"MAGMADAR: The biggest problem here is FEAR. After the first fear, CTRA will warn 5 seconds before the fear cooldown is up. Tanks need to count to 2 after the warning, then switch to berzerk, count to 2, then use rage to avoid the fear.",
		"All non-melee should be able to stay at max range and avoid fears as long as Mag is held in place. There should be a priest staying out of range who can run in to dispel fears from tanks and other healers.",
		"Healers will be assigned to MTs, to melee groups, and to HUNTERS. Hunters need to use TRANQ SHOT when Mag enrages. Set up a rotation order for who shoots when, and set up macros to announce that you're shooting and announce if you miss!",
		"This is a LONG fight. Healer rotation is important. Stay out of the fire-globs on the floor! Stay at max range as much as you can. Use potions early so you can use more when they cooldown." 
		}
	},

	{ 
	name = { "Majordomo Executus", "Majordomo" },
	shortName = { "majordomo" },
	instance = "mc",
	description = {
		"Majordomo Executus: This mob consists of 4 priests, 4 elites, and Domo. Once the priests and elites are defeated Domo will surrender. Hunter pets will be sent in first to activate Domo. The priests will be sheeped by mages at the beginning.",
		"A Main Assist Tank will provide targeting for DPS. MA will target an elite followed by 3 priests that he will unsheep. When there are 4 priest/elites left the sheeps will break. Kill the last priest then the last 3 elites.",
		"A tank & healer/s will be assigned to each elite. A tank & 1 or 2 hunters & healers will be assigned to Domo to keep him from running amok. Shadow resist will help with the shadow bolts Domo fires randomly." 
		}
	},

	{ 
	name = { "Molten Core" },
	shortName = { "mc" },
	instance = "mc",
	description = {
		"MOLTEN CORE: if you are new to MC: it is very different than other dungeons. It's important for you to listen to /raid for instructions and to perform the role we ask you to, which may be different from what you're used to.",
		"For example: it's often more important to decurse instead of do damage. Also, *DO NOT STEAL AGGRO*! It's better for you to do less damage than to drag a mob into the middle of the group. Give at least 10 seconds time for tanks to gain aggro.",
		"Keep chatter out of /raid. Do /join gdrlchat for fun talk. STAY FOCUSED. After the first bridge we will be on the clock and keeping a quick pace. Res/buff/heal between fights ASAP. Get plenty of drink from your friendly neighborhood mages!" 
		}
	},

	{ 
	name = { "Shazzrah" },
	shortName = { "shazzrah" },
	instance = "mc",
	description = {
		"SHAZZRAH: Has AOE arcane explosion. Has AOE CURSE that doubles damage from magic. Has a self-buff that decreases his magic damage taken by half. Has AOE counterspell.",
		"We will split the raid into 4 groups. Each group will have an OT, and a decurser. We pull Shazzrah to Garr's room to have extra space, and the 4 groups take up places evenly spaced around the boss.",
		"ONLY THE MT WILL BE IN MELEE due to the AOE. All others must used ranged attacks. One decurser will be assigned to decurse the MT solely. One person will be dedicated to keeping the self-buff off of the boss. (We need detect up at all times on boss).",
		"The final trick is that the boss will occasionally teleport and attack another target, clearing aggro. ALL DPS MUST STOP upon teleport. Boss will go toward one of the 4 groups. The OT in that group will grab aggro and pull the boss ASAP to MT." 
		}
	},

	{ 
	name = { "Sulfuron" },
	shortName = { "sulfuron" },
	instance = "mc",
	description = {
		"SULFURON: Has 4 priest guards. One tank assigned to each guard. We will separate out one guard at a time to die, pulling him away from the others so they cannot heal him. Rogues and tanks should interrupt the target guard from healing himself.",
		"One or two priests will be assigned to dispel the DoTs from the guards. Boss buffs himself, increasing attack speed and damage. This needs to be dispelled/purged also (might not be possible as of last patch?).",
		"We split off and kill one guard at a time until they are all dead. Then boss dies. Boss does a demoralizing shout, and a 10 yard AOE knockdown." 
		}
	},

-- Mechanar

	{ 
	name = { "Mechanar (Heroic)" },
	shortName = { "mechanarheroic" },
	instance = "mechanar",
	description = {
		"**Mechanar (Heroic)** Mobs have the same abilities as Normal mode, just hit harder. A lot harder. Resists: Arcane resist gear is useful for several fights here."
				}
	},

	{
	name = { "Mechano-Lord Capacitus", "Capacitus" },
	shortName = { "capacitus" },
	instance = "mechanar",
	description = {
		"**Mechano-Lord Capacitus** spawns a trail of bombs. The bombs spawn and then move around slightly before pulsing two or three times then exploding. First clear the whole bottom floor of the instance.",
		"Have the tank pull and slowly kite the boss in a circle up one stairway, into the entrance chamber and down the opposite stairway. The key is to keep all melee and casters behind the tank and in front of the boss...",
		"...essentially keeping the whole group moving as the tank keeps him moving. The bombs will mostly stay behind the boss. When the boss dies, the bombs will all explode... they do NOT despawn!",
		"HEROIC: Tank him at the edge of his area. Mines still appear, but he casts Polarity Shift and gives everyone a + or - debuff. If players with the same charge stand together they get a damage buff, but when opposite charges are close, they both take dmg.",
		"The fight is timed. At 3 mins he one-shots everyone, so kill asap. Watch your party's debuffs. Resists: bring Arcane resist gear."
		}
	},

	{
	name = { "Gatewatcher Gyro-Kill", "Gyro-Kill" },
	shortName = { "gyro" },
	instance = "mechanar",
	description = {
		"**Gatewatcher Gyro-Kill** enrages (100% attack speed increase), throws a sawblade at random targets (1500 dmg and 500/tick), and he does a frontal cone poison that reduces attack speed and armor by 35%.",
		"Kill both Gatewatchers, use their key fragments to loot the Cache by the elevator and profit!"
		}
	},

	{
	name = { "Gatewatcher Iron-Hand", "Iron-Hand" },
	shortName = { "ironhand" },
	instance = "mechanar",
	description = {
		"**Gatewatcher Iron-Hand** enrages (100% attack speed increase), does an AoE centered on himself hitting for ~1000-1500 around 8 times in a short time, all back out for this, and he does a frontal cone poison that reduces attack speed and armor by 35%.",
		"Kill both Gatewatchers, use their key fragments to loot the Cache by the elevator and profit!"
		}
	},

	{
	name = { "Pathaleon the Calculator", "Pathaleon" },
	shortName = { "pathaleon" },
	instance = "mechanar",
	description = {
		"**Pathaleon the Calculator** To get to the boss you go through 6 waves of adds (blood elves and robots). Three waves come at a time, allowing the group to break - the last 3 waves will not aggro until the group moves further down the bridge.",
		"Once the last mob in the 6th wave is killed, Pathaleon will spawn and engage the group. Run into the room and fight him there. If you wipe, the waves do not respawn.",
		"He spawns 3 arcane elementals every 30-45 secs. They have fairly high HP but can be AoE'd with help. He also mind controls at random for about 8-10 secs. Note: Mages can spellsteal the Astromage's Fire Shield from the last wave to help with the fight.",
		"HEROIC: Casts Arcane Explosion every 10 secs (2 sec cast, crowd to avoid this). Adds are harder now, fear them and focus on the boss, DPS asap. Also watch out for the boss's Mind Control - be ready to freeze/CC/dispel, or have the MC'd person OT'd."
		}
	},

	{
	name = { "Nethermancer Sepethrea", "Sepethrea" },
	shortName = { "sepethrea" },
	instance = "mechanar",
	description = {
		"**Nethermancer Sepethrea** spawns two Fire Elementals as soon as you aggro her, which cannot be banished or feared. The adds have random aggro and a lot of life, but are slow. They also leave a trail of fire.",
		"When the elementals change target, they stand still and pulse so be prepared to arrange for those targets to kite. They can also aggro onto hunter pets. First clear the entire room. For the initial pull, spread out...",
		"...as far as they can go and send the MT in to tank her on the spot. You will know which party members have aggro from the Elementals. The person with aggro should kite the add across the room, away from the rest of the party.",
		"If you have a warlock you can clear the room then return down the elevator and enslave the last demon Driller. Use the Driller as a tank; the Driller has a 20% armor debuff that stacks up to 5 times.",
		"HEROIC: She spawns 3 elementals (not 2). She also does Dragon's Breath which can make the elementals catch up with you and kill you. Often considered not worth the trouble in Heroic."
		}
	},

-- Old Hillsbrad

	{ 
	name = { "Old Hillsbrad Foothills (Heroic)" },
	shortName = { "oldhillsbradheroic" },
	instance = "oldhillsbrad",
	description = {
		"**Old Hillsbrad Foothills (Heroic)** Basically, bring a rogue. Seeing as you need to place the bombs in the keep, and the non-CC'able patrols summon two non-CCable elites, hit HARD, and spawn within 5 mins, you'll want a rogue to solo this part.",
		"Mark all the patrols so you can see them coming, then have the rogue put down all the bombs while the group enjoys Hillsbrad FM. After the bombs trigger the scary patrols despawn and the inside groups come outside, making for easy pulls.",
		"If you don't have a rogue, be really careful with the groups, pull them to a safe spot, kite and CC as necessary. When you get to Thrall, be sure to let him tank one or two mobs, as he can take quite a few hits. CC the Mages before they CC you."
		}
	},

-- Sethekk Halls

	{ 
	name = { "Sethekk Halls (Heroic)" },
	shortName = { "sethekkheroic" },
	instance = "sethekk",
	description = {
		"**Sethekk Halls (Heroic)** Few changes from Normal; mobs hit harder. Mobs of concern: Sethekk Guards and Ravenguards come in pairs and are not CC'able! (Tank to one side of the hall, have all but MT/OT stand at the other side of the hall and DPS asap).",
		"Time-Lost Controllers drop totems that MC a random player, and the Prophets (mages can often spellsteal a nice buff from these) spawn ghosts when they die (avoid these). Resists: bring Arcane resist gear for Ikiss."
		}
	},

	{ 
	name = { "Talon King Ikiss", "Ikiss" },
	shortName = { "ikiss" },
	instance = "sethekk",
	description = {
		"**Talon King Ikiss** does polymorphs, arcane blasts, and arcane explosions. Start the fight with all but the tank near one of the pillars around the room. Watch your chat log for when the boss emotes 'Gathering Arcane Energy' which means...",
		"...he is about to AOE (does 6k damage, range 30yds). He will blink in front of a random party member and start casting. You have ~5 secs to get out of LOS and avoid damage. Have your tank be the first one to re-engage as he will have wiped aggro.",
		"Right after the explosion he will release arcane bolts at all party members (infinite range) that hit for about 1500-2000 (he also does this attack during the fight).",
		"Wait until this is done and then heal. Rinse and repeat until dead. Note: his casting speed can be decreased with Mind-Numbing Poison, but not Slow.",
		"HEROIC: Similar to Normal, but he now has an AoE Slow, increased Arcane Volley and Explosion dmg. Stay close to one pillar; when he starts casting Explosion all but the MT move to the other side of the pillar. This is harder due to the Slow, don't delay!"
		}
	},

	{ 
	name = { "Darkweaver Syth", "Syth" },
	shortName = { "syth" },
	instance = "sethekk",
	description = {
		"**Darkweaver Syth** summons 3 waves of 4 Elementals during the fight. DPS the boss until he summons the first wave of elementals. Kill the voidwalker first, then the rest of the elementals (they are immune to their own school of magic).",
		"DPS Syth until he summons the second wave of elementals. Kill the second wave, and go back to Syth. If a third wave comes, fear it and kill off the boss.",
		"HEROIC: As in Normal mode the boss isn't hard himself, but he summons 3 waves of adds which do stacking damage. Kill the first two waves, and fear the third, killing the boss asap in between."
		}
	},

-- Shadow Labyrinth

	{ 
	name = { "Shadow Labyrinth (Heroic)" },
	shortName = { "shadowlabheroic" },
	instance = "shadowlab",
	description = {
		"**Shadow Labyrinth (Heroic)** Annoying trash, not so different from Normal but it hits harder. The Cabal Ritualists can dispel most CC, so either CC one far away from the other(s) or don't bother. Also, the single mobs are the hardest...",
		"...especially the Fel Overseers (wipe aggro when they fear and do a Mortal Strike that hits for ~6-8k). The best approach is to stay close so that the whole party gets feared. Also, Malicious Instructors can now Disarm the MT."
		}
	},

	{ 
	name = { "Ambassador Hellmaw", "Hellmaw" },
	shortName = { "hellmaw" },
	instance = "shadowlab",
	description = {
		"**Ambassador Hellmaw** has an AoE fear (dispellable), Acid Spray, charge and 3-sec stun, and does high melee damage. He fears often; fight him in the tunnel to avoid out-of-range issues or getting stuck in the environment.",
		"If the tank is feared Hellmaw will target the next-highest aggro person who is not feared. The tank should face him away from the raid to minimize Acid damage.",
		"HEROIC: Similar to Normal, except that this is now a timed encounter. If you don't kill him within 3 mins, he enrages and one-shots all of your merry band. Watch his fear and bring as much DPS as possible to the party."
		}
	},

	{ 
	name = { "Blackheart the Inciter", "Inciter" },
	shortName = { "inciter" },
	instance = "shadowlab",
	description = {
		"**Blackheart the Inciter** has mass mind control, AoE knockback, and a random charge with stun. First kill all of the trash mobs in the room or they will aggro. Periodically, the whole party will be MCd and attack each other.",
		"Use all dangerous and/or expensive abilities at the very beginning of the fight, so they aren't available during the MC.",
		"Mages and warlocks should drain all mana early. Hunters set Freezing Traps, casters replace +dmg gear with +regen gear, because endurance is critical. Note: A well-timed Vanish or Dreamless Sleep potion can allow you to avoid the MC.",
		"HEROIC: Similar to Normal, although the boss now hits for 5-7k. Be sure to let the tank re-establish aggro after the MC, or clothies will meet with some smashes. Hard smashes."
		}
	},

	{ 
	name = { "Murmur" },
	shortName = { "murmur" },
	instance = "shadowlab",
	description = {
		"**Murmur** starts with 40% health (64k total). He does not move and has an aggro range of 10-15 yards. The main tank will run in and get aggro while the rest of the group spreads out at maximum range.",
		"Ranged DPS cannot draw aggro so blast away, but stay outside the stone circle. He does a 'Sonic Boom' AoE; when it starts to cast, all but the tank need to run outside the stone circle...",
		"...or they will be hit for 70%-85% of total health plus 12% over 6secs and applies a debuff that reduces movement speed by 90%. The tank needs to be healed extensively to live through this, but if everyone leaves aggro range...",
		"Murmur does a very nasty debuff that will wipe the whole party. He also does a 'Touch of Murmur' which puts an undispellable debuff on a random target. It explodes after 10 seconds, causing ~4000 nature damage in a 10-yard radius and...",
		"...knocks you in the air. Everyone hit will be silenced. When initially hit with this debuff immediately run into the 'magic tent' at the right side of the hall. You will explode inside but hit the roof, not die, and not kill anyone else.",
		"Murmur will occasionally pull a ranged player towards him. Just run back into position.",
		"HEROIC: In addition to his Sonic Boom (hits inside the circle) Murmur now does a damage ability that hits everyone OUTSIDE the circle. That means you'll need to constantly run in and out, while still watching for the Touch of Murmur debuff."
		}
	},

	{ 
	name = { "Grandmaster Vorpil", "Vorpil" },
	shortName = { "vorpil" },
	instance = "shadowlab",
	description = {
		"**Grandmaster Vorpil** summons Voidwalkers from the runes around him. The VWs move slowly to Vorpil and have ~2500 health. When they reach Vorpil they explode for ~1500 damage (~10yd radius) and heal Vorpil for 4% of his health.",
		"He also teleports all players up on the pedestal and casts Rain of Fire (~900 damage/tick). One player should be assigned to kill the first wave of VWs before they reach the boss. Start by DPSing the boss while killing VWs.",
		"After the first teleport, everyone move *South*. Kite Vorpil down the South hallway, away from any VWs. When he teleports everyone the 2nd time, kite him up the *North* hallway. Keep him away from VWs and DPS as much as possible.",
		"Rinse and repeat while alternating directions, but more than three teleports is probably a wipe.",
		"HEROIC: Similar to Normal; the big difference is that Vorpil now also Banishes players, and when they are banished, they aren't teleported. Take the oppotunity to heal or kill some voidwalkers."
		}
	},

-- Shattered Halls

	{ 
	name = { "Shattered Halls (Heroic)" },
	shortName = { "shatteredhallsheroic" },
	instance = "shatteredhalls",
	description = {
		"**Shattered Halls (Heroic)** In Heroic mode there is an added boss after the Gauntlet of Fire event, and there is a 55-min timer which starts with the archer event; when it's over, Warchief Kargath kills his prisoners.",
		"Mobs of note are the Gladiators, which can basically one-shot Anyone, and must be carefully kited. As in normal mode, Legionnaires summon back mobs whenever someone of their teammates are killed, so kill them first."
		}
	},

	{ 
	name = { "Warchief Kargath Bladefist", "Kargath", "Bladefist" },
	shortName = { "bladefist" },
	instance = "shatteredhalls",
	description = {
		"**Kargath Bladefist** does a Blade Dance every 30 seconds, timed from when first engaged, and resetting when each Blade Dance ends. At the start of the fight, elite assassins spawn in the hallway near the stairs, but will not aggro...",
		"...unless you walk all the way down the stairs. Cloth stay in corners to avoid the Whirlwind. Tank him in the middle of the cage to stay within range while avoiding Cleave. During the fight, he ping-pongs around the cage...",
		"...doing 1000-1500 dmg to cloth wearers. During the fight non-elites spawn down the entrance hallway and attack; kill quickly. Adds can also be feared."
		}
	},

	{
	name = { "Grand Warlock Nethekurse", "Nethekurse" },
	shortName = { "nethekurse" },
	instance = "shatteredhalls",
	description = {
		"**Grand Warlock Nethekurse** Kill the 4 non-elite Fel Converts in front of the boss. When the last is dead Nethekurse will aggro. (If the group takes too long on the last one, Nethekurse will kill it himself and aggro the party.)",
		"He puts down Void Zones that do 1000 Shadow dmg/sec; everyone avoid those. He also Death Coils random people, doing 2000 Shadow dmg to the target, fearing them for 4 secs, and heals Nethekurse. At ~20% HP, Nethekurse engages his Dark Spin ability...",
		"...hitting anyone close to him for 2000 physical dmg and shooting Shadowbolts at random. The Shadowbolts hit for ~1500 Shadow dmg, so kill him ASAP. He will not move while enraged, so everyone can back out and DPS from range...",
		"...including the healer and tank if possible. Rogues should save Cloak of Shadows and Evasion until this attack. Shadow Protection buffs, gear and potions help with this fight."
		}
	},

	{ 
	name = { "Warbringer O'mrogg", "O'mrogg" },
	shortName = { "omrogg" },
	instance = "shatteredhalls",
	description = {
		"**Warbringer O'mrogg** is immune to taunt/growl, has an AoE fear, nature dmg Thunderclap, Burning Weapon followed by two Blast Waves, and an aggro list for each head. Tank him in the middle of the arena where he starts.",
		"Be careful of the guards in the nearby hallway, and the possible assassin near the far edge of the arena (clear this assassin from the outer edge, prior to engaging O'mrogg).",
		"When his weapon glows red, it hits for up to 1000 fire dmg. Right after that, he does one/two AoE Blast Waves for up to 3200 fire dmg each. Fire protection potions, totem, or gear are all helpful."
		}
	},

-- Slave Pens

	{ 
	name = { "Slave Pens (Heroic)" },
	shortName = { "slavepensheroic" },
	instance = "slavepens",
	description = {
		"**Slave Pens (Heroic)** A few mobs of note: the Bogstrok packs are Humanoid, and can be sapped/sheeped. They hit quite hard and you get a lot of them.",
		"Second, the Defenders hit like trucks (4-6k/hit), have a spell reflect shield, and aren't CC'able (kiting works best). If they come with mobs, be sure to CC them quickly. Resists: Nature resist gear is useful here."
		}
	},

	{ 
	name = { "Mennu the Betrayer", "Mennu" },
	shortName = { "mennu" },
	instance = "slavepens",
	description = {
		"**Mennu the Betrayer** First clear the mobs in the room at the base of the boss' ramp. Mennu has 60,000 HP and healing abilities, but doesn't put out a lot of damage. It is, however, critical that his totems be killed quickly.",
		"Assign one person to kill the totems ASAP. If totem control is a problem have the tank walk backwards in a large circle while keeping aggro on Mennu; this keeps him out of range of his totems most of the time.",
		"HEROIC: Similar to Normal, except that he hits whoever has aggro for ~3-4,000 nature dmg. Uninterruptible.)"
		}
	},

	{ 
	name = { "Quagmirran" },
	shortName = { "quagmirran" },
	instance = "slavepens",
	description = {
		"**Quagmirran** does an Acid Geyser (cone AoE nature dmg at a random target; reduces aggro). Also does a Poison Bolt volley (AoE, 2.5k nature dmg with added dispellable DoT). First free Naturalist Bite from his cage in the room.",
		"When you free him, mobs will spawn. Kill the mobs and talk to the NPC, he gives a Mark of the Bite buff (+110 Nature Resist and +5% on all stats). Pull Quagmirran and tank him facing away from the rest of the group and taunt during the Acid Geyser.",
		"Healers concentrate on the tank and cleansing the Poison DoT. Nature resist totems/auras/potions help and stack with Mark of the Bite."
		}
	},

	{ 
	name = { "Rokmar the Crackler", "Rokmar" },
	shortName = { "rokmar" },
	instance = "slavepens",
	description = {
		"**Rokmar the Crackler** does a Grievous Wound bleed debuff (900 physical dmg/2 secs until the player has been healed to full health for ~1 sec; Divine Shield and Stoneform also work); also Water Spit AoE (1600-1800 frost dmg to target...",
		"...claws glow before cast); Entangling Moss (increases casting time by 50%, range ~30 yds); and frost bolts. When Rokmar enrages all classes with heals should watch the tank, he hits hard. Silence, Shocks (Flame Shock, Earth Shock, etc)...",
		"...Stomps and Shield Bash do not work. Do not pull aggro from the MT! Keep the MT's health topped up, range classes and casters stay back and do your DPS, and get out of the 41 yd AoE radius to bandage. Frost resist helps."
		}
	},

-- The Steamvault

	{ 
	name = { "Steamvault (Heroic)" },
	shortName = { "steamvaultheroic" },
	instance = "steamvault",
	description = {
		"**Steamvault (Heroic)** Watch out for the Bog Lords (high melee dmg). Other than that, the mobs are the same as normal mode, just hit a little harder. They're CC'able but not MC'able.",
		"It is also possible to do a last-boss only run by having on person pull the first and second bosses while someone else pulls the switch behind them."
		}
	},

	{ 
	name = { "Warlord Kalithresh", "Kalithresh" },
	shortName = { "kalithresh" },
	instance = "steamvault",
	description = {
		"**Warlord Kalithresh** has a large amount of health, periodically reflects magic (white shield), and a randomly targeted Impale which stacks. He will also shout and start channeling a spell to the closest container.",
		"At this point, the container will be targetable and must be destroyed before he finishes channeling (10 secs). If he finishes the spell he enrages, increasing attack speed by 100% and damage by 75%. This ability stacks.",
		"Choose a container and kite the boss near it, toward the middle of the room so it takes him a few steps to get to the tank. Once the channeling starts, DPS must kill the container fast (they have ~10,000 hitpoints).",
		"When the container is dead move Kalithresh to the next container."
		}
	},

	{ 
	name = { "Mekgineer Steamrigger", "Steamrigger" },
	shortName = { "steamrigger" },
	instance = "steamvault",
	description = {
		"**Mekgineer Steamrigger** summons three Steamrigger Mechanics at 75%, 50% and 25% health. These are non-elite, should be killed quickly as they heal the boss. He also casts Sawblades at a random target.",
		"Any damage to the mechanics forces them to attack you and not heal the boss. The tank should spam Thunder Clap AoE's to disrupt the heals."
		}
	},

	{ 
	name = { "Hydromancer Thespia", "Thespia" },
	shortName = { "thespia" },
	instance = "steamvault",
	description = {
		" **Hydromancer Thespia** has two water elemental adds and casts a Lightning Cloud which deals a large amount of nature dmg/sec. If you're under the cloud for more than 2 or 3 seconds you will die.",
		"Stay spread out to avoid the cloud. She also casts Enveloping Winds, which stun you and can be deadly when caught beneath a Lightning Cloud. Warrior fear should be used when first engaging the mobs.",
		"Kill the adds one at a time, then concentrate on the boss. The tank should kite her to one side of the platform and quickly move to the other side when lightning strikes. She also casts a very damaging Lung Burst which can be magic dispelled."
		}
	},

-- Underbog

	{ 
	name = { "Underbog (Heroic)" },
	shortName = { "underbogheroic" },
	instance = "underbog",
	description = {
		"**Underbog (Heroic)** There are some awkward pulls at the start, CC whatever you can. Other than that, the trash remains fairly normal."
		}
	},

	{ 
	name = { "Hungarfen" },
	shortName = { "hungarfen" },
	instance = "underbog",
	description = {
		"**Hungarfen** randomly spawns Underbog Mushrooms which explode and release a Spore Cloud that lasts 20 secs. The cloud does 360 nature dmg/2 secs and stacks up to 5 times. Move away! At 20% HP he roots himself...",
		"...and projects Foul Spores (AoE poison cloud, 400-600 dmg/sec, 15yd radius), and heals for 4x the damage done.",
		"The MT must keep Hungarfen moving to avoid the Mushrooms. At 20% HP ALL party members (MT included) move away from Hungarfen so no one takes damage, and he doesn't heal himself. Burn him down with DPS. At ~10% HP he unroots; the MT should pick him up.",
		"HEROIC: he hits for ~2,200 melee dmg. Mushrooms spawn at an increased rate in bursts, sometimes at a rate of 1 per sec for ~15 secs, then slow down to the normal spawn rate. Turn on enemy nameplates to spot them before they become visible.",
		"NOTE: The two Bog Giants aren't linked to the boss, but are linked together."
		}
	},

	{ 
	name = { "Ghaz'an" },
	shortName = { "ghaz'an" },
	instance = "underbog",
	description = {
		"**Ghaz'an** does Acid Spit (180ÃÂ° frontal, 2k nature dmg); Acid Breath (155 nature dmg 3/secs, stacks up to 10x); Tail Whip (500 dmg behind Ghaz'an).",
		"The boss walks onto the center platform when you enter the area. There is a wall of vertical pipes to the right and many tanks place their backs against this. The tank doesn't move during the fight so the rest of the group can stand to Ghaz'an's sides...",
		"...to avoid his front/back attacks. (If you are hit off the platform swim to the ramp and run back up, but you will be out of the fight for ~45-60 secs.) Use Nature Resist totems or Aspect of the Wild.",
		"HEROIC: Ghaz'an hits between 1700-2600 on moderately-geared tanks, and can sometimes get a string of up to 3 attacks in a row. The only other significant change appears to be a moderate increase to the Acid Breath damage."
		}
	},

	{ 
	name = { "Swamplord Musel'ek", "Musel'ek" },
	shortName = { "musel'ek" },
	instance = "underbog",
	description = {
		"**Swamplord Musel'ek** and his pet, Claw, have multiple attacks: the boss uses Aimed Shot (2k+ dmg) if nobody is in melee range; also Auto Shot; AoE Freeze Trap; Multi-Shot (multiple targets, 2k+ dmg)...",
		"...Claw's Shout (reduces party armor by 75%, avoid by tanking away from the group); and Claw's Charge (random target, charges multiple times with knockback in Heroic mode).",
		"Start with the MT attacking Claw to build up aggro, then switch to Musel'ek. Once the tank has aggro, all attack Musel'ek. Musel'ek periodically freezes the group and backs off to shoot. The tank must get back into his melee range asap.",
		"Once the boss is dead focus on Claw; at 20% HP he turns friendly. It is also possible to use an off tank to tank the bear around the corner, keeping the bear's armor reducing ability from reaching the MT."
		}
	},

	{ 
	name = { "The Black Stalker", "Black Stalker" },
	shortName = { "blackstalker" },
	instance = "underbog",
	description = {
		"**The Black Stalker** does a Static Charge (750 nature dmg/sec for 10 secs, not dispellable, spread out to reduce dmg); Chain Lightning (2000 dmg on 1st target, halved down the chain)...",
		"...Levitate (suspends player for ~20 secs, dispellable, can still use ranged attacks, usually 2nd player on aggro list).",
		"Fight: Tank her in the center of the room with the rest of party at max range. Turn her left or right so melee can stand behind her to avoid the Chain Lightning and still be in heal range. She hits hard; keep the tank near full health.",
		"Melee: watch the casting bar and run out of range before the Chain Lightning cast. HEROIC: During the fight, the boss spawns sets of three adds (~5000 HP) every 10-15 secs; they cast 1000 nature dmg lightning bolts."
		}
	},


-- World

	{ 
	name = { "Icons", },
	shortName = { "icons" },
	instance = "world",
	description = {
		"Icons and Kill Order: Sheep the star, Sap the blue square, Sleep/freeze trap purple diamond. Kill Skull first, then X, Moon, Square, Diamond, and Star. If an MC kill is used it will be marked with a green Triangle. Sheep is always killed last."
		}
	},

	{ 
	name = { "Levixus the Soul Caller", "Levixus" },
	shortName = { "levixus" },
	instance = "world",
	description = {
		"**Levixus the Soul Caller** spawns at 40,71 on the south of the upper ring of Auchindoun. He summons 2 infernals which die after ~2 mins but he'll recast them while he's alive. He also casts Cripple."
		}
	},

	{ 
	name = { "Silithus Lords", "Lords" },
	shortName = { "silithuslords" },
	instance = "world",
	description = {
		"All SILITHUS LORDS are immune to Taunt. Lord Skwol (Water Elemental) Most difficult of the bosses. Immune to Frost Damage. Venom Spit - Stackable DoT poison - Cleanse quickly. Sunder Armor- Stacks 5x to reduce armor by 5000, rotate tanks if possible.",
		"Prince Skaldrenox (Fire Elemental) Immune to Fire Damage. Keep an eye out to dispell/decurse mark that increase fire damage. Blast Wave - get your FR gear on quickly if this one pops, 1500 fire dam. every 30 sec.",
		"Baron Kazum (Earth Elemental) Immune to Nature Damage. Has rend effect that reduces healing, dispel/decurse if possible. AOE Knockdown & Disarm. Tremor - spell interrupt. Strategy - MT w/weapon chain if available. Healers/Ranged DPS at max range.",
		"High Marshal Whirlaxis (Air Elemental) Immune to Nature Damage. Most attacks do nature dam. Use NR potions. Does knockback. Shaman may be able to purge the lightning shield." 
		}
	},

-- Zul'Gurub

	{ 
	name = { "Arlokk" },
	shortName = { "arlokk" },
	instance = "zg",
	description = {
		"ARLOKK: Group stands opposite gong, cloth along walls. One tank in each cage will try to hit each panther as they spawn in the cages, then use Demo Shout and any aoe type items they have to hold their aggro. Two shaman healing cage tanks.", 
		"Shaman rings gong. MT grabs boss. DPS opens up after one sunder, keeping steady heavy DPS on the boss at all times she's visible (without stealing aggro). Boss will mark targets for panther aggro, these must be healed.", 
		"Arlokk will vanish. DPS/AOE any escape panthers during this time, but DO NOT EVER GO NEAR THE GONG SIDE OF THE ROOM. When the boss appears, MT must grab quickly and pull to the middle, to avoid her cleaving cloth to death.", 
		"The secret of this fight is HEAVY DPS on the BOSS at all times that she's visible. IGNORE/FEAR any panthers if the boss is out, and keep DPS on boss. Only attack panthers when the boss is gone, and never go near the cage tanks." 
		}
	},

	{ 
	name = { "Hakkar" },
	shortName = { "hakkar" },
	instance = "zg",
	description = {
		"HAKKAR must die in 10 minutes else he enrages killing everyone. Tanks: at least 2 tanks on him 3 is better, when one is MCd we sheep them. Tanks should burn their fears whenever they're up so they can't be used while MCd. The MC lasts",
		"10-15 seconds and the tank should be un-sheeped (by priests) when the MC ends to get back to fighting. Hakkar is not tauntable so we need multiple tanks in and gaining aggro throughout. Face Hakkar away from the raid,",
		"he has a frontal-cleave attack. DPS: spread out. DPS on Hakkar after 4-5 sunders. Occasionally you will have to collapse into the middle to get poisoned (see below). Do not steal aggro, use your un-aggro moves when you can. Healers:",
		"At least 3 on the MT. You will need to swap targets since Hakkar MCs the tank with aggro and then switches (hopefully) to the next tank. Other healers on spot healing, but don't heal anyone unless they're below 50% hp.",
		"People should be bandaging to help. Drain Life: every 1.5 minutes Hakkar does an AoE life drain to the entire raid. This is bad. We will post a hunter at the top of each ramp. They will alternate pulling a Son of Hakkar to the raid,",
		"and a mage will sheep it. 15 seconds before the life drain, we stop DPS on Hakkar, nuke the sheep, when it dies it emits a poison cloud. Everyone except the tanks need to jump into the cloud to get poisoned then spread out again.",
		"When he lifedrains you while you're poisoned, it actually damages him instead of heals him. Obviously, do not cure the poisons. Bandage after this if you aren't a tank to help the healers out (and give tanks time to gain more hate).",
		"The tank that has aggro should not run to the poison cloud. Everyone else should. If most of the raid is poisoned during the life drain, he will take damage instead of heal damage. Hakkar does a splash-hit shadow damage attack/DoT.",
		"Due to this we'll want to spread out - but you must remember to run into the poison clouds when a son is killed!" 
		}
	},

	{ 
	name = { "High Priestess Jeklik", "Jeklik" },
	shortName = { "jeklik" },
	instance = "zg",
	description = {
		"JEKLIK: Starts as a bat. Group starts next to the tree to the left of where she starts. MT pulls her back toward other tree. Group fills in between her start and MT.",
		"Like: (start) OT/Mages DPS MT/Jeklik (tree)",
		"Rogues run in, stabstab, run out, bandage. Mages throw a DoT or two on boss but mostly conserve mana and wait for batswarms. Locks and Hunters drain mana on boss.",
		"Stay spread out to avoid silence charges. OTs immediately grab batswarms, followed quickly by mage frost nova to root them and mage AOE. Followed quickly by all other AOE. All AOEers get in a clump close in to bats and AOE on themselves.",
		"DO NOT PULL BATS OUT OF AOE!! At 50% health boss turns into a troll. HER HEALS MUST BE INTERRUPTED BY ALL WHO CAN! Stay spread out to avoid firebombs. Keep mana sting on her at all times." 
		}
	},

	{ 
	name = { "Bloodlord Mandokir", "Mandokir" },
	shortName = { "mandokir" },
	instance = "zg",
	description = {
		"MANDOKIR: The group stands on the Wall just south of the staircase. MT is down on the ground to the east of the wall. OT and a hunter are to west of wall. Hunter puts down explosive trap at north end of wall.",
		"MT pulls boss to east of wall, but keeps him close to the wall. Raptor usually should go west of wall, hitting the trap and aggroing the hunter. Hunter pulls raptor to OT, OT takes aggro.",
		"Group kills boss first. Throughout the fight it is important to stay on the wall near the boss, and keep the boss near the wall, to prevent him charging at people who are too far.",
		"Slow and steady DPS on the boss. Count to 3 in between spells/attacks. DO NOT STEAL AGGRO. Boss will do a spin attack, melee sidestep out of range. Tranq shot can cancel this.",
		"If the boss starts WATCHING YOU, YOU MUST STOP ALL ATTACKS. Un-target the boss and turn around if you have to. THIS MEANS NO DOTS, NO THORNS, NO PETS. If you are attacking after the 10s debuff counts down, he will kill you.",
		"If MT is watched, OT should take over briefly. DO NOT DIE. Non-MT-melee back off and bandage if needed (not too far). Too many deaths levels him. If you die, a spirit will res you -- accept it and keep fighting." 
		}
	},

	{ 
	name = { "Marli" },
	shortName = { "marli" },
	instance = "zg",
	description = {
		"MARLI: MT will tank her close to where she starts. All else get in a clump at 30-35 yards away, with OT slightly in front of clump. Kill spider adds fast with AOE. Kill Speaker.", 
		"DRAIN HER MANA with HUNTER STINGS AT ALL TIMES. Rogues can do the run in/stab/run out/bandage attacks. In SPIDER FORM: she will WEB the MT, and charge the clump - ALL STOP DPS, except on adds. OT should grab boss and drag her back to start point.", 
		"MT moves up to guard clump for next web. In TROLL FORM: she will DRAIN LIFE (green beam). THIS MUST BE INTERRUPTED/DISPELLED. Use nature resist aspect, and poison cleansing totems. KEEP WATCH for spider adds. Kill them FAST." 
		}
	},

	{ 
	name = { "Thekal" },
	shortName = { "thekal" },
	instance = "zg",
	description = {
		"THEKAL: First kill 2 tigers. One tank on Thekal in the hut where he starts. Two tanks on Zath, pulled back and way left. One tank on Lor'khan, pulled back and way right. 3 healers on MT, 2 on left, 1 on right.", 
		"FIRST: we DPS Thekal to 30%. Watch silence. MT use disarm when he Mortal Strikes you to cut his damage. SECOND: DPS Zath (left) to 30%. Zath gouges, which is why we have 2 tanks on him. THIRD: DPS Lor'khan to 25%. INTERRUPT HIS HEALS.", 
		"Then we bring them all together in the middle and AOE them to death. They all must die within 10 seconds of each other. Thekal rezzes as a tiger, starting PHASE 2. Tiger adds spawn throughout phase 2 -- OTs grab them, everyone who can help kill them (wands at least)", 
		"Tank the boss in the narrow tunnel area, MT's back to a wall to avoid knockback problems. Healers can stand backs to the opposite wall to stay in range. Keep DPS up on the boss, make sure tiger spawns don't run amok, heal/bandage up between force-punches." 
		}
	},

	{ 
	name = { "High Priest Venoxis", "Venoxis" },
	shortName = { "venoxis" },
	instance = "zg",
	description = {
		"VENOXIS: At first, ONLY THE MT can go near the boss. MT will tank boss on top step, and stand one step down from him.",
		"OT pulls snakes down to group with ranged attack, extras are CCd. OT tanks snakes one at a time, switching through as fast as possible",
		"After snakes are dead, all attack boss FROM RANGE. Use purge to stop his renews as needed (they will be announced). At 50% health, boss turns into snake.",
		"Melee moves in. Boss will spew poison clouds. The MT *MUST* keep moving the boss out of the clouds, or healers will not be able to keep MT alive. NO ONE GO OUT THE ENTRANCE or the boss will reset." 
		}
	}


}