--[[
Tactics, by Titch of Turalyon
Updated by Belleboom@Earthen Ring: Changed default chat channel to PARTY from RAID, added a "/tactics all" function to list all mobs, and reduced OnLoad spam
Don't edit this file, add your own tactics to descriptions.lua
]]--


tacticsChannel = "RAID";
tacticsOutputBuffer = {};
outputDelay = .25; --delay to avoid WoW disconnecting you for spammage
lastOutputTime = GetTime();
BINDING_HEADER_TACTICSGD = "Tactics (GD)";

function Tactics_Report(mobname)
	if (mobname == nil or mobname == "" ) then mobname = UnitName("target"); end;
	if (mobname == nil) then mobname = ""; end;

	for mob in pairs(moblist) do
		for nameidx in pairs(moblist[mob].name) do
			if (moblist[mob].name[nameidx]==mobname) then
				Tactics_Describe(moblist[mob]);
				return;
			end
		end
		for nameidx in pairs(moblist[mob].shortName) do
			if (moblist[mob].shortName[nameidx]==mobname) then
				Tactics_Describe(moblist[mob]);
				return;
			end
		end
	end
	-- No known tactics for this mob
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_NONE_KNOWN);
end

function Tactics_Describe(mob)
	for line in pairs(mob.description) do
		Tactics_SendMsg(mob.description[line]);
		-- do this too quickly and you will disconnect.
		-- stupid blizzard doesn't provide a wait() function

	end
end

function Tactics_ListMobsInInstance(instance)
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_MOBS_KNOWN_INSTANCE..instance.."' :");
	for mob in pairs(moblist) do
		if (moblist[mob].instance==instance) then
			for idx in pairs(moblist[mob].shortName) do
				DEFAULT_CHAT_FRAME:AddMessage(moblist[mob].shortName[idx]);
			end
		end
	end
end

-- function to list all mobs by instance
function Tactics_ListAllMobs()
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_MOBS_KNOWN);
	for mob in pairs(moblist) do
		if (moblist[mob]) then
			for idx in pairs(moblist[mob].shortName) do
				DEFAULT_CHAT_FRAME:AddMessage((moblist[mob].instance).. ": " ..(moblist[mob].shortName[idx]));
			end
		end
	end
end


function Tactics_ListInstances() -- lists all known instances
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_INSTANCES_KNOWN);
	local il={};
	for mob in pairs(moblist) do
		local already=false;
		for in_il in pairs(il) do
			if (il[in_il]==moblist[mob].instance) then
				already=true;
			end
		end
		if (not already) then
			table.insert(il,moblist[mob].instance);
		end
	end

	for mob in pairs(il) do
		DEFAULT_CHAT_FRAME:AddMessage(il[mob]);
	end
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_INTRO);

end



function Tactics_OnLoad() -- messsages to show on load
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_ON_LOAD1);
-- slash commands
	SLASH_TACTICS_DISPLAY1 = "/tactics";
	SLASH_TACTICS_DISPLAY2 = "/tactic";
	SLASH_TACTICS_DISPLAY3 = "/tc";
	SlashCmdList["TACTICS_DISPLAY"] = TacticsSlash_Parse;

end
 -- following functions set channel to specified destination and reports it to chat
function Tactics_SetChannel(chnl)
	chnl=strupper(chnl);
	if (chnl=="PARTY" or chnl=="RAID" or chnl=="SAY" or chnl=="SELF" or chnl=="GUILD") then
		tacticsChannel = chnl;
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_SET..tacticsChannel);
		elseif (chnl=="RW") then
		tacticsChannel = "RAID_WARNING";
		tacticsChannelTarget = nil
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_SET..tacticsChannel);

	elseif (strlen(chnl) > 7 and strsub(chnl, 1, 7) == "WHISPER") then
		tacticsChannel = "WHISPER";
		tacticsChannelTarget = strsub(chnl, 9);
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_WHISPER..tacticsChannelTarget);

	elseif (strlen(chnl) > 6 and strsub(chnl, 1, 6) == "CUSTOM") then
		tacticsChannel = "CHANNEL";
		tacticsChannelTarget = strsub(chnl, 8);
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_CUSTOM..tacticsChannelTarget);

	end
end

function Tactics_SendMsg(message_text)
	if (tacticsChannel=="SELF") then
		if ( DEFAULT_CHAT_FRAME ) then
			DEFAULT_CHAT_FRAME:AddMessage(message_text);
		end;
	else
		table.insert(tacticsOutputBuffer,message_text);
		TacticsFrame:Show();
	end
end

function Tactics_OnUpdate()
	if (table.getn(tacticsOutputBuffer)>0) then
		if (lastOutputTime+outputDelay < GetTime()) then
			local message_text=tacticsOutputBuffer
			if (tacticsChannel=="RAID" or tacticsChannel=="PARTY" or tacticsChannel=="SAY" or tacticsChannel=="GUILD" or tacticsChannel=="RAID_WARNING") then
				SendChatMessage(tacticsOutputBuffer[1], tacticsChannel);
			else
				SendChatMessage(tacticsOutputBuffer[1], tacticsChannel, nil, tacticsChannelTarget);
			end
			table.remove(tacticsOutputBuffer, 1);
			lastOutputTime=GetTime();
		end
	else
		TacticsFrame:Hide()
	end
end

function MyAddon_OnUpdate()
	if (table.getn(myOutputBuffer)>0) then
		if (lastOutputTime+outputDelay < GetTime()) then
			local message_text=OutputBuffer
			if (myChannel =="RAID" or myChannel=="PARTY"  or myChannel=="SAY" or tacticsChannel=="GUILD" or tacticsChannel=="RAID_WARNING") then
				SendChatMessage(myOutputBuffer[1], myChannel);
			else
				SendChatMessage(myOutputBuffer[1], myChannel, nil, myChannelTarget);
			end
			table.remove(OutputBuffer, 1);
			lastOutputTime=GetTime();
		end
	else
		myFrame:Hide()
	end
end

function TacticsSlash_Parse(msg) -- parses slash command text
	if (string.lower(msg) == "help") then
		Tactics_Help();
	elseif (string.lower(msg) == "instances") then
		Tactics_ListInstances();
	elseif (string.lower(msg) == "all") then
		Tactics_ListAllMobs();
	elseif (strlen(msg) > 4 and strsub(msg, 1, 4) == "list") then
		local instance = strsub(msg, 6);
		Tactics_ListMobsInInstance(instance);
	elseif (strsub(msg, 1, 7) == "channel") then
		if(strlen(msg)>7) then
			local chnl = strsub(msg, 9);
			Tactics_SetChannel(chnl);
		else
			if(tacticsChannelTarget) then
				DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_REPORT..tacticsChannel.." "..tacticsChannelTarget);
			else
				DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_REPORT..tacticsChannel);
			end
		end
	else
		Tactics_Report(msg);
	end
	return
end

function Tactics_Help() -- /tc help text
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND1);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND2);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND3);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND4);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND5);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND6);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND7);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND8);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND9);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND10);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND11);
	DEFAULT_CHAT_FRAME:AddMessage(TACTICS_HELP_COMMAND12);
	if(tacticsChannelTarget) then
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_REPORT..tacticsChannel.." "..tacticsChannelTarget);
	else
		DEFAULT_CHAT_FRAME:AddMessage(TACTICS_CHANNEL_REPORT..tacticsChannel);
	end
end