--[[
    Default english localizations for Tabard by LordFarlander
    $Revision: 33 $
]]--

--[[
Copyright (c) 2008, LordFarlander
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]--

local L = LibStub( "AceLocale-3.0" ):NewLocale( "Tabard", "enUS", true );

if( L ) then
    --Localised variable names
    L["Tabard"] = true;
    L["%s requires %s"] = true;

    --Slash commands
    L["tabard"] = true;
    L["tbd"] = true;

    --Slash sub commands
    L["gui"] = true;
    L["autoCreateSets"] = true;
    --Favorites commands
    L["list"] = true;
    --Groups
    L["options"] = true;
    L["profile"] = true;
    L["favorites"] = true;

    --Option names
    L["Auto create sets"] = true;
    L["Open GUI configurator"] = true;
    --Zone and favorites options
    L["Frequency"] = true;
    L["List all favorite tabards"] = true;

    --Tab titles
    L["Profile"] = true;
    L["Favorites"] = true;

    --Values
    L["yes"] = true;
    L["no"] = true;

    --Option descriptions
    L["Toggles if sets/outfits should be created automatically for tabards if you have a suppored outfit addon installed (ItemRack, Outfitter, or ClosetGnome)."] = true;
    --Zone and favorites descriptions
    L["Tabards that should be picked more often if you have them."] = true;
    L["Set how often the tabard gets picked.  2 is twice as often and 0 is never."] = true;
    L["Show a list with all of your favorite tabards."] = true;
    --Groups
    L["Addon options."] = true;

    L["Added set: %s."] = true;
    
    L["List of your favorite tabards:"] = true;
    L["default"] = true;
    L["never"] = true;
    L["%.1f times as often"] = true;
end--if
