
TMrecruit = LibStub("AceAddon-3.0"):NewAddon("TMrecruit", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0", "AceComm-3.0")
name = ""

local L = LibStub("AceLocale-3.0"):GetLocale("TMrecruit")
local MINOR_VERSION = tonumber(("$Revision: 73193 $"):match("%d+"))
local PlayerName = UnitName("player")
TMrecruit.version = '1.6.5'
TMrecruit.MINOR_VERSION = MINOR_VERSION

local options = { 
    name = "TMrecruit",
    handler = TMrecruit,
    type="group",
	
    args = {
		message = {
		order = 1,
            type = "input",
            name = L["Guild Message"],
            desc = L["Welcome in Guild chat"],
            usage = L["<Your message>"],
            get = "GetMessage",
            set = "SetMessage",
			
			width = "full";
	
        },
		noteinguild = {
		order = 2,
			type = "toggle",
			name = L["Send message in guild chat"],
			desc = L["turn off if you don\'t want this to happen"],
			get = "Getnoteinguild",
			set = "Setnoteinguild",
			
		},	
		omsg = {
		order = 3,
			type = "input",
			name = L["Officer Message"],
			desc = L["Message to officer chat"],
			usage = L["<Your message>"],
			get = "GetOmsg",
			set = "SetOmsg",
			width = "full",
			
		},
		noteinofficer = {
		order = 4,
			type = "toggle",
			name = L["Send message in officer chat"],
			desc = L["turn off if you don\'t want this to happen"],
			get = "Getnoteinofficer",
			set = "Setnoteinofficer",
			
		},	
		rank = {
		order = 9,
			type = "range",
			name = L["Auto Rank"],
			desc = L["Number of ranks to move new recruit up"],
			--usage = L["<number of ranks to jump>"],
			min = 0,
			max = 10,
			step = 1,
			get = "Getrank",
			set = "Setrank",
		},		
				stamp = {
		order = 6,
			type = "input",
			name = L["Stamp Message"],
			desc = L["Stamp in officer note"],
			usage = L["<#O# is you - #D# is date>"],
			get = "Getstamp",
			set = "Setstamp",
			width = "full",
			
		},
				stampinofficer = {
		order = 7,
			type = "toggle",
			name = L["Stamp officer note"],
			desc = L["turn off if you don\'t want this to happen"],
			get = "Getstampinofficer",
			set = "Setstampinofficer",
			
		},	
						stampinpublic = {
		order = 8,
			type = "toggle",
			name = L["Stamp public note"],
			desc = L["turn off if you don\'t want this to happen"],
			get = "Getstampinpublic",
			set = "Setstampinpublic",
			
		},	
	
	},
}


local defaults = {
   profile = {
    message = "Welcome to trademarked #N#. You are now a recruit, please visit the forums at www.trademarkedguild.com and register and apply for full membership. You can also find your class officers and rules for the guild.",
    omsg = "I just invited a new member #N#, heads up say hello!",
	rank = 0,
	noteinofficer = true,
	noteinguild = true,
	stamp = "#O# added #D#",
	stampinofficer = true,
	stampinpublic = false,
},
}
local optionsFrame

function TMrecruit:OnInitialize()
  self.db = LibStub("AceDB-3.0"):New("TMrecruitDB", defaults, "Default")

    LibStub("AceConfig-3.0"):RegisterOptionsTable("TMrecruit", options)
	    self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("TMrecruit", "TMrecruit")

    self:RegisterChatCommand("tmsetup", "ChatCommand")
    self:RegisterChatCommand("gi", "Invite")
	self:RegisterChatCommand("ginvite", "Invite")
	self:RegisterChatCommand("tmversion", "sendversioncheck")
	self:RegisterChatCommand("git", "Watcht")
    TMrecruit.message = "TMrecruit"
	
	local version_frame = CreateFrame("Frame", nil, UIParent)
	version_frame:SetScript("OnEvent", function(_, _, msg)
    local checkme = string.match(arg2, "TMversion")
	    local checkmeout = string.match(arg1, "TMrecruitv")
	if checkme then
SendAddonMessage( "TMrecruitv", "Version: " .. TMrecruit.version .. " Minor: " .. TMrecruit.MINOR_VERSION , "GUILD" );

		--SendChatMessage("Version: " .. TMrecruit.version .. " Minor: " .. TMrecruit.MINOR_VERSION, "WHISPER", nil, arg4);
	end
		if checkmeout then
		
			  	  self:Print(arg4 .. " " .. arg2)

		end
end)
 version_frame:RegisterEvent("CHAT_MSG_ADDON")

 
end

function TMrecruit:OnEnable()
    self:Print("loaded use /tmsetup to setup and /gi toonname to invite new members")
	self:Print("loaded use /tmversion to check the rest of the guilds versions")

end

function TMrecruit:OnDisable()
        self:Print("Trademarked Recruiter OFF use /gisetup for options")
end

function TMrecruit:ChatCommand(input)
    if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToFrame(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(TMrecruit, "gisetup", "TMrecruit", options)
    end
end
function TMrecruit:GetMessage(info)
    return self.db.profile.message
end

function TMrecruit:SetMessage(info, newValue)
    self.db.profile.message = newValue
end

function TMrecruit:Getnoteinofficer(info)
    return self.db.profile.noteinofficer
end

function TMrecruit:Setnoteinofficer(info, newValue)
    self.db.profile.noteinofficer = newValue
end

function TMrecruit:Getnoteinguild(info)
    return self.db.profile.noteinguild
end

function TMrecruit:Setnoteinguild(info, newValue)
    self.db.profile.noteinguild = newValue
end

function TMrecruit:Getstampinofficer(info)
    return self.db.profile.stampinofficer
end

function TMrecruit:Setstampinofficer(info, newValue)
    self.db.profile.stampinofficer = newValue
end

function TMrecruit:Getstampinpublic(info)
    return self.db.profile.stampinpublic
end

function TMrecruit:Setstampinpublic(info, newValue)
    self.db.profile.stampinpublic = newValue
end

function TMrecruit:Getstamp(info)
    return self.db.profile.stamp
end

function TMrecruit:Setstamp(info, newValue)
    self.db.profile.stamp = newValue
end

function TMrecruit:GetOmsg(info)
    return self.db.profile.omsg
end

function TMrecruit:SetOmsg(info, v)
    self.db.profile.omsg = v
end
function TMrecruit:Getrank(info)
    return self.db.profile.rank
end

function TMrecruit:Setrank(info, v)
    self.db.profile.rank = v
end
function TMrecruit:sendversioncheck()
SendAddonMessage( "TMrecruit", "TMversion", "GUILD" );
		self:Print("Sending version check to guild")
end
function TMrecruit:receiveversions()
SendAddonMessage( "TMrecruit", "TMversion", "GUILD" );
		self:Print("Sending version check to guild")
end
addname = "";
t = 1
function TMrecruit:Invite(name)
		 	local bytes, pos = {string.byte(name,1,-1)}, 1
	while(bytes[pos+1] and bit.band(bytes[pos+1], 0xc0) == 0x80)do
		pos = pos + 1
	end
	name = string.upper(string.sub(name, 1, pos)) .. string.lower(string.sub(name, pos+1))
	     self:Print("Ok sit tight doing a who to make sure no guild for: " .. name)

 -- SetWhoToUI(1)
  SendWho("n-\"" .. name .. "\"")
 TMrecruit:ScheduleTimer("Invitenext", 8, name)
		  	     
  end
  
  function TMrecruit:Invitenext(name)

      local count = GetNumWhoResults();
	  	  --    self:Print("count " .. count)

      charname, guildname, level, race, class, zone, unknown = GetWhoInfo(1)
     
addname = name
	if guildname ~= "" then TMrecruit:inguild(name)
	else TMrecruit:Sendinvite(name)
	end
	end

function TMrecruit:inguild(name)
if t==1 then
			SendChatMessage("You are in a guild already do a /gquit so I can invite you", "WHISPER", nil, name);
			end
t = (t + 1)
		if t<4 then
		self:Print("User in a guild waiting 30 seconds and re-inviting: " .. name)
		 TMrecruit:ScheduleTimer("Invite", 30, name)

		else
	      self:Print("Tryed to invite 3 times TMrecruit aborting invite for: " .. name)
		  TMrecruit:Done(name)
		end

end

function TMrecruit:Sendinvite(name)
GuildInvite(name)
		 TMrecruit:ScheduleTimer("Watch", 1, name)
end

function TMrecruit:Watcht(name)
zz=0
self:Print("Waiting for " .. name .. " to join....... ")
	
local event_frame = CreateFrame("Frame", nil, UIParent)
event_frame:SetScript("OnEvent", function(_, _, msg)
    local namew = string.match(msg, "(.+) tt")
	if namew==name and zz==0 then
			 TMrecruit:ScheduleTimer("MemberAddedt", 3, name)
zz=zz+1
	end
end)
 event_frame:RegisterEvent("CHAT_MSG_CHANNEL")

end


function TMrecruit:Watch(name)
zz=0
self:Print("Waiting for " .. name .. " to join....... ")
local event_frame = CreateFrame("Frame", nil, UIParent)
event_frame:SetScript("OnEvent", function(_, _, msg)
    local namew = string.match(msg, "(.+) has joined the guild")
	if namew==name and zz==0 then
			 TMrecruit:ScheduleTimer("MemberAdded", 3, name)
zz=zz+1
	end
end)
 event_frame:RegisterEvent("CHAT_MSG_SYSTEM")

end


function TMrecruit:MemberAddedt(name)

self:Print("Sending welcome message")
	local newmessage = string.gsub(self.db.profile.message, "#N#", name)
	local omessage = string.gsub(self.db.profile.omsg, "#N#", name)

SendChatMessage(newmessage,"CHANNEL", nil, 7);
--SendChatMessage(omessage,"OFFICER");
self:Print("Pausing for datatable rebuild adding new member: " .. name)
			 TMrecruit:ScheduleTimer("Datestamp", 11, name)
end

function TMrecruit:MemberAdded(name)

self:Print("Sending welcome message")
	local newmessage = string.gsub(self.db.profile.message, "#N#", name)
	local omessage = string.gsub(self.db.profile.omsg, "#N#", name)

if self.db.profile.noteinguild then
SendChatMessage(newmessage,"GUILD");
end
if self.db.profile.noteinofficer then
SendChatMessage(omessage,"OFFICER");
end
self:Print("Pausing for datatable rebuild adding new member: " .. name)
			 TMrecruit:ScheduleTimer("Datestamp", 11, name)
end

function TMrecruit:Datestamp(name)
--self:Print("Adding date stamp for: " .. name)
TableData = {}
v = 1
for i=1, GetNumGuildMembers(true) do
namey, rank, rank_index, level, class, zone, note, officer_note, online, status = GetGuildRosterInfo(i);
TableData[v] = (namey .. rank_index .. class)
v = (v + 1)
if (name==namey) then
--self:Print("Index location: " .. namey .. i)

adate = date("%m/%d/%y");
	local estamp = string.gsub(self.db.profile.stamp, "#D#", adate)
		local astamp = string.gsub(estamp, "#O#", PlayerName)
if self.db.profile.stampinofficer==true then
self:Print("Set Officer note as " .. astamp)

GuildRosterSetOfficerNote(i, "" .. astamp)
end
if self.db.profile.stampinpublic==true then
self:Print("Set Public note as " .. astamp)

GuildRosterSetPublicNote(i, "" .. astamp)
end
end
end
local re = self.db.profile.rank

while re>0 do
self:Print("Ranking " .. namey .. " up by " .. re)
GuildPromote(name)
re = re-1 
end

PlaySound("ReadyCheck");
self:Print("Sound made-date added-DONE for: " .. name)
--zz=0

end


function TMrecruit:Done(name)
self:Print("Ok I am done trying for: " .. name)

end
