local TFScore = CreateFrame("Frame",nil,UIParent);

local tfinit = nil;

local function setfs(frame, font, size, att1, att2, x, y, just, t, ...)
	frame:SetFont(font, size);
	frame:SetPoint(att1, TFScore, att2, x, y);
	frame:SetJustifyH(just);
	if t then frame:SetText(t) end;
	frame:SetVertexColor(...);
end;

local psname = {};
local pstats = {};

local hclass = {};
local hnames = {};
local hkb = {};
local hdeaths = {};

local aclass = {};
local anames = {};
local akb = {};
local adeaths = {};

local textures = {};
local ti = {
{{0,0,0,0.4}, 700, 500, "CENTER", 0, 0},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tl", 16, 16, "TOPLEFT", 0, 16, 0, 0, 0, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tr", 16, 16, "TOPRIGHT", 0, 16, 0, 0, 0, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\bl", 16, 16, "BOTTOMLEFT", 0, -16, 0, 0, 0, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\br", 16, 16, "BOTTOMRIGHT", 0, -16, 0, 0, 0, 0.4},
{{0,0,0,0.4}, 668, 16, "TOP", 0, 16},
{{0,0,0,0.4}, 668, 16, "BOTTOM", 0, -16},
{{1, 0.25, 0.2, 0.4}, 340, 20, "TOPRIGHT", 0, 60},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tl", 16, 16, "TOPRIGHT", -324, 76, 1, 0.25, 0.2, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tr", 16, 16, "TOPRIGHT", 0, 76, 1, 0.25, 0.2, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\bl", 16, 16, "TOPRIGHT", -324, 40, 1, 0.25, 0.2, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\br", 16, 16, "TOPRIGHT", 0, 40, 1, 0.25, 0.2, 0.4},
{{1, 0.25, 0.2, 0.4}, 308, 16, "TOPRIGHT", -16, 76},
{{1, 0.25, 0.2, 0.4}, 308, 16, "TOPRIGHT", -16, 40},
{{0.62, 0.8, 0.98, 0.4}, 340, 20, "TOPLEFT", 0, 60},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tl", 16, 16, "TOPLEFT", 0, 76, 0.62, 0.8, 0.98, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\tr", 16, 16, "TOPLEFT", 324, 76, 0.62, 0.8, 0.98, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\bl", 16, 16, "TOPLEFT", 0, 40, 0.62, 0.8, 0.98, 0.4},
{"Interface\\AddOns\\TFScoreBoard\\tex\\br", 16, 16, "TOPLEFT", 324, 40, 0.62, 0.8, 0.98, 0.4},
{{0.62, 0.8, 0.98, 0.4}, 308, 16, "TOPLEFT", 16, 76},
{{0.62, 0.8, 0.98, 0.4}, 308, 16, "TOPLEFT", 16, 40},
{{0,0,0,1}, 2, 370, "CENTER", 0, 70},
{{1,1,1,0.5}, 320, 1, "TOPRIGHT", -20, -11},
{{1,1,1,0.5}, 320, 1, "TOPLEFT", 20, -11},
{{0,0,0,1}, 668, 100, "BOTTOMLEFT", 16, 0},
};

TFScore:SetFrameStrata("DIALOG");
TFScore:SetWidth(700);
TFScore:SetHeight(500);
TFScore:SetPoint("CENTER",0,0);
	
	for i=1, #ti do
		textures[i] = TFScore:CreateTexture(nil,"BACKGROUND");
		if type(ti[i][1]) == "string" then
		 textures[i]:SetTexture(ti[i][1]);
		 textures[i]:SetVertexColor(ti[i][7],ti[i][8],ti[i][9],ti[i][10]);
		else
		 textures[i]:SetTexture(ti[i][1][1],ti[i][1][2],ti[i][1][3],ti[i][1][4]);
		end;
		textures[i]:SetWidth(ti[i][2]);
		textures[i]:SetHeight(ti[i][3]);
		textures[i]:SetPoint(ti[i][4],ti[i][5],ti[i][6]);
		
	
	end;


	local sepstat = TFScore:CreateTexture(nil,"MEDIUM");
	sepstat:SetWidth(500);
    sepstat:SetHeight(2);
	sepstat:SetPoint("BOTTOMRIGHT" ,-32 ,70);
	sepstat:SetTexture(1, 0.25, 0.2);
	local pname = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(pname, "Interface\\AddOns\\TFScoreBoard\\font\\TF2.ttf", 30, "BOTTOMLEFT", "BOTTOMLEFT", 170, 70, "LEFT", 1, 0.25, 0.2);
	pname:SetText(UnitName("player"));
	
	if UnitFactionGroup("player") == "Horde" then
		sepstat:SetTexture(1, 0.25, 0.2);
		pname:SetVertexColor(1, 0.25, 0.2);
	else
		sepstat:SetTexture(0.62, 0.8, 0.98);
		pname:SetVertexColor(0.62, 0.8, 0.98);
	end
	local pmod = CreateFrame("PlayerModel" ,nil , TFScore);
	pmod:SetPoint("TOPLEFT", TFScore, "BOTTOMLEFT" ,16 ,150);
	pmod:SetPoint("BOTTOMRIGHT", TFScore, "BOTTOMLEFT",166 ,0);
	pmod:SetUnit("player");
	
	
local TFHordetext = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(TFHordetext, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 50, "BOTTOMRIGHT", "TOPRIGHT", -20, 30, "RIGHT", "Hurd", 0.93, 0.89, 0.78);
local numHordeText = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(numHordeText, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 16, "BOTTOMRIGHT", "TOPRIGHT", -120, 34, "RIGHT", "1 player", 0.93, 0.89, 0.78);
local hordeScoreText = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(hordeScoreText, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 40, "BOTTOM", "TOP", 60, 32, "RIGHT", nil, 0.93, 0.89, 0.78);
	
local TFAllitext = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(TFAllitext, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 50, "BOTTOMLEFT", "TOPLEFT", 20, 30, "RIGHT", "Alli", 0.93, 0.89, 0.78);
local numAllianceText = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(numAllianceText, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 16, "BOTTOMLEFT", "TOPLEFT", 95, 34, "LEFT", "1 player", 0.93, 0.89, 0.78);
local allianceScoreText = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(allianceScoreText, "Interface\\AddOns\\TFScoreBoard\\font\\TF2build.ttf", 40, "BOTTOM", "TOP", -60, 32, "LEFT", nil, 0.93, 0.89, 0.78);
	
local nameheader1 = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(nameheader1, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOPLEFT", "TOPLEFT", 45, 2, "LEFT", "Name", 1,1,1);
local killsheader1 = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(killsheader1, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOP", "TOP", -65, 2, "LEFT", "Kills", 1,1,1);
local deathsheader1 = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(deathsheader1, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOP", "TOP", -30, 2, "LEFT", "Deaths", 1,1,1);
	
local nameheader2 = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(nameheader2, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOP", "TOP", 55, 2, "LEFT", "Name", 1,1,1);
local killsheader2 = TFScore:CreateFontString(nil, "MEDIUM");
 setfs(killsheader2, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOPRIGHT", "TOPRIGHT", -65, 2, "LEFT", "Kills", 1,1,1);
local deathsheader2 = TFScore:CreateFontString(nil, "MEDIUM");
    setfs(deathsheader2, "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "TOPRIGHT", "TOPRIGHT", -22, 2, "LEFT", "Deaths", 1,1,1);

	--[[leaveButton = CreateFrame("button" , nil , TFScore);
	leaveButton:SetWidth(100)
	leaveButton:SetHeight(20)
	leaveButton:SetPoint("CENTER", 0, -135)
	leaveButton:RegisterForClicks("AnyDown")
	leaveButton:SetTextFontObject(GameFontHighlight)
	leaveButton:SetTextColor(1 ,1, 1, 0.6)
	leaveButton:SetHighlightTextColor(1, 1, 1, 1)
	leaveButton:SetText("leave")
	leaveButton:SetScript("OnClick", function(self)
		LeaveBattlefield()
		self:Hide()
	end)
	leaveButton:Hide()]]
	
	
playerIndicator = TFScore:CreateTexture(nil,"BACKGROUND")
playerIndicator:SetTexture(1, 1, 1, 0.2)
playerIndicator:SetWidth(320)
playerIndicator:SetHeight(20)
playerIndicator:SetPoint("CENTER")
playerIndicator:Hide()
	
local st = {"Kills:", "Deaths:", "Healing Done:", "Damage Done:", "Honorable Kills:", "Bonus Honor:", nil, nil, nil, nil, nil, nil};

for i=1, 12 do
	psname[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(psname[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "BOTTOMRIGHT", "BOTTOMRIGHT", ((208*floor((i-1)/4))-460), (52-(15*floor((i-1)%4))), "RIGHT", st[i], 1,1,1);
	pstats[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(pstats[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 14, "BOTTOMLEFT", "BOTTOMRIGHT", ((208*floor((i-1)/4))-460), (52-(15*floor((i-1)%4))), "LEFT", nil, 1,1,1);
	end
	
	
for i=1, 15 do
	hnames[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(hnames[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOPLEFT", "TOP", 40, -(i*22), "LEFT", nil, 1, 0.25, 0.2);
	hnames[i]:SetWidth(220);
	hkb[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(hkb[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOPRIGHT", "TOPRIGHT", -40, -(i*22), "LEFT", nil, 1, 0.25, 0.2);
	hkb[i]:SetWidth(40);
	hdeaths[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(hdeaths[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOPRIGHT", "TOPRIGHT", 0, -(i*22), "LEFT", nil, 1, 0.25, 0.2);
	hdeaths[i]:SetWidth(40);
	hclass[i] = TFScore:CreateTexture(nil,"MEDIUM");
	hclass[i]:SetWidth(16);
	hclass[i]:SetHeight(16);
	hclass[i]:SetPoint("TOPLEFT", TFScore, "TOP", 20, -(1+i*22));
	hclass[i]:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
	hclass[i]:SetTexCoord(1, 1, 1, 1);
	anames[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(anames[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOPLEFT", "TOPLEFT", 45, -(i*22), "LEFT", nil, 0.62, 0.8, 0.98);
	anames[i]:SetWidth(220);
	akb[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(akb[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOP", "TOP", -50, -(i*22), "LEFT", nil, 0.62, 0.8, 0.98);
	akb[i]:SetWidth(40);
	adeaths[i] = TFScore:CreateFontString(nil, "MEDIUM");
	setfs(adeaths[i], "Interface\\AddOns\\TFScoreBoard\\font\\list.ttf", 16, "TOP", "TOP", -10, -(i*22), "LEFT", nil, 0.62, 0.8, 0.98);
	adeaths[i]:SetWidth(40);
	aclass[i] = TFScore:CreateTexture(nil,"MEDIUM");
	aclass[i]:SetWidth(16);
	aclass[i]:SetHeight(16);
	aclass[i]:SetPoint("TOPLEFT", 25, -(1+i*22));
	aclass[i]:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
	aclass[i]:SetTexCoord(1, 1, 1, 1);
	end;
	
function hidetfs()
	TFScore:Hide();
end;
function toggletfs()
		
if TFScore:IsShown() then
		hidetfs();
	else
		showtfs();
	end;
end;
function showtfs()
	pmod:SetUnit("player");
	TFScore:Show();
	RequestBattlefieldScoreData();
	--[[if GetBattlefieldWinner() then
		leaveButton:Show();
	end;]]
end;
	
TFScore:Hide();
tfinit = 1;

local function updateHorde()
	playerIndicator:Hide();
	local k=1;
	local name, killingBlows, honorableKills, deaths, honorGained, faction, classToken, damageDone, healingDone, temp;
	for i=1, 15 do
		while k<81 do
			_, _, _, _, _, faction = GetBattlefieldScore(k);
			k=k+1;
			if faction==0 then break end
		end	
		name, killingBlows, honorableKills, deaths, honorGained, faction, _, _, _, classToken, damageDone, healingDone = GetBattlefieldScore(k-1);
			if ( name ) then
				hnames[i]:SetText(name);
				hkb[i]:SetText(killingBlows);
				hdeaths[i]:SetText(deaths);
				temp = RAID_CLASS_BUTTONS[classToken];
				hclass[i]:SetTexCoord(temp.coords[1], temp.coords[2], temp.coords[3], temp.coords[4]);
			else
				hnames[i]:SetText(nil);
				hkb[i]:SetText(nil);
				hdeaths[i]:SetText(nil);
				hclass[i]:SetTexCoord(1, 1, 1, 1);
			end
			if ( name==UnitName("player") ) then
				playerIndicator:Show();
				playerIndicator:ClearAllPoints();
				playerIndicator:SetPoint("TOPRIGHT", -20, 1-(22*i));
			end
	end
end

local function updateAlliance()
	local k=1
	local name, killingBlows, honorableKills, deaths, honorGained, faction, classToken, damageDone, healingDone, temp
	for i=1, 15 do
		while k<81 do
			_, _, _, _, _, faction = GetBattlefieldScore(k)
			k=k+1
			
			if faction==1 then break end
		end	
				
		name, killingBlows, honorableKills, deaths, honorGained, faction, _, _, _, classToken, damageDone, healingDone = GetBattlefieldScore(k-1)
		if ( name ) then
			anames[i]:SetText(name)
			akb[i]:SetText(killingBlows)
			adeaths[i]:SetText(deaths)
			temp = RAID_CLASS_BUTTONS[classToken];
			aclass[i]:SetTexCoord(temp.coords[1], temp.coords[2], temp.coords[3], temp.coords[4])
		else
			anames[i]:SetText(nil)
			akb[i]:SetText(nil)
			adeaths[i]:SetText(nil)
			aclass[i]:SetTexCoord(1, 1, 1, 1)
		end
		if ( name==UnitName("player") ) then
			playerIndicator:Show()
			playerIndicator:ClearAllPoints()
			playerIndicator:SetPoint("TOPLEFT", 20, 1-(22*i))
		end		
	end
end

local function updateMisc()
	
	local numHorde = 0
	local numAlliance = 0
	local temp
	for i=1, GetNumBattlefieldScores() do
		name, killingBlows, honorableKills, deaths, honorGained, faction, _, _, _, classToken, damageDone, healingDone = GetBattlefieldScore(i)
		if ( faction ) then
			if ( faction == 0 ) then
				numHorde = numHorde + 1
			else
				numAlliance = numAlliance + 1
			end
		end
		if ( name==UnitName("player") ) then
			pstats[1]:SetText(killingBlows)
			pstats[2]:SetText(deaths)
			pstats[3]:SetText(healingDone)
			pstats[4]:SetText(damageDone)
			pstats[5]:SetText(honorableKills)
			pstats[6]:SetText(honorGained)
			for k = 1, 6 do
				temp = GetBattlefieldStatInfo(k)
				if temp then
					psname[k+6]:SetText(temp ..":")
					temp = GetBattlefieldStatData(i,k)
					pstats[k+6]:SetText(temp)
				else
					psname[k+6]:SetText(nil)
					pstats[k+6]:SetText(nil)
				end
			end
		end
	end
	numAllianceText:SetText(numAlliance.." players")
	numHordeText:SetText(numHorde.." players")
	

	
end

local function updateScores()
	local index=1
	local status, pattern, temp
	for i = 1, MAX_BATTLEFIELD_QUEUES do
		status, temp = GetBattlefieldStatus(i)
		if ( status == "active" ) and ( temp == "Eye of the Storm" ) then
			index = 2
			pattern = "(%d+)/(.+)"
		elseif ( status == "active" ) and ( temp == "Alterac Valley" ) then
			pattern = ":(%d+)"
		else
			pattern = "(%d+)/(.+)"
		end
	end
	_, _, temp = GetWorldStateUIInfo(index)
	if temp then
		allianceScoreText:SetText(temp:match(pattern))
	else
			allianceScoreText:SetText(nil)
	end
	
		_, _, temp = GetWorldStateUIInfo(index+1)
	if temp then	
		hordeScoreText:SetText(temp:match(pattern))
	else
			hordeScoreText:SetText(nil)
	end
end
	
TFScore:SetScript("OnEvent", function()
	if(event=="UPDATE_BATTLEFIELD_SCORE") and tfinit then
		updateHorde()
		updateAlliance()
		updateMisc()
	end
	
	if(event=="UPDATE_WORLD_STATES") and tfinit then
		updateScores()	
	end
end)

TFScore:RegisterEvent"UPDATE_WORLD_STATES"
TFScore:RegisterEvent"UPDATE_BATTLEFIELD_SCORE"
TFScore:RegisterEvent"PLAYER_LOGIN"

BINDING_HEADER_TFKB = "TF Scoreboard"
BINDING_NAME_TFONDOWN = "show while held down"
BINDING_NAME_TFTOGGLE = "toggle"