---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Addon Constants and variables-------------
---------------------Addon Constants and variables-------------
---------------------Addon Constants and variables-------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



local SuperCursor_Version="1.0";


local SuperCursor_Events={
	"UNIT_SPELLCAST_SUCCEEDED",
	"UNIT_SPELLCAST_START",
	"UNIT_SPELLCAST_STOP",
};


SuperCursor_Options = {
	["enable"] = 1,

};


local SuperCursor_TimeSinceLastUpdate=0;
local SuperCursor_UpdateInterval=0.05;


local SuperCursor_Global_Cast=0;
local SuperCursor_Global_CD=1.5;


local SuperCursor_Level_Rating=0;
local SuperCursor_Haste_Base=10;


local SuperCursor_Instant=1;







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------On load and defaults----------------------
---------------------On load and defaults----------------------
---------------------On load and defaults----------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



function SuperCursor_OnLoad()

	SLASH_SuperCursor1 = "/supercursor";
	SlashCmdList["SuperCursor"] = SuperCursor_SlashHandler;

	SuperCursor_Frame:RegisterEvent("VARIABLES_LOADED");


	if (DEFAULT_CHAT_FRAME) then
		SuperCursor_Print("SuperCursor version "..SuperCursor_Version.." loaded. Developed by SuperCommander");
		SuperCursor_Print("/supercursor for options [on, off]");
	end

end


function SuperCursor_Reset()

	SuperCursor_Options = {
		["enable"] = 1,
	};

	SuperCursor_Print("Restoring default settings");
	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------Slashcommands and registering events----------
-----------------Slashcommands and registering events----------
-----------------Slashcommands and registering events----------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Slashcommands
function SuperCursor_SlashHandler(msg)

	if (string.lower(msg)=="off") then 
		SuperCursor_Print("SuperCursor is now disabled");
		SuperCursor_Unregister();
		SuperCursor_Options.enable=0;
		SuperCursor_Hide();

	elseif (string.lower(msg)=="on") then 
		SuperCursor_Print("SuperCursor is now enabled");
		SuperCursor_Register();
		SuperCursor_Options.enable=1;
		SuperCursor_OnEvent("VARIABLES_LOADED");

	elseif (string.lower(msg)=="reset") then 
		SuperCursor_Reset();

	else
		SuperCursor_Print("/supercursor on/off");
	end
end


--Register events(Enable mod)
function SuperCursor_Register()
	for index, value in pairs(SuperCursor_Events) do
		SuperCursor_Frame:RegisterEvent(value);
	end	
end


--Unregister events(Disable mod)
function SuperCursor_Unregister()
	for index, value in pairs(SuperCursor_Events) do
		SuperCursor_Frame:UnregisterEvent(value);
	end	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Report functions--------------------------
---------------------Report functions--------------------------
---------------------Report functions--------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Reporting messages
function SuperCursor_Print(msg)
	DEFAULT_CHAT_FRAME:AddMessage("[SuperCursor]: "..msg,0.59,0.59,0.59);
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Update functions--------------------------
---------------------Update functions--------------------------
---------------------Update functions--------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



function SuperCursor_Start_Timer()

	local SuperCursor_Val=0;
	local SuperCursor_X=190/2*(SuperCursor_Val-50)/50;

	SuperCursor_Global_Cast=GetTime();

	SuperCursor_Frame:Show();
	SuperCursor_Frame:SetAlpha(1);
	SuperCursor_Bar:SetValue(SuperCursor_Val);
	SuperCursor_Background:Show();
	SuperCursor_Spark:SetPoint("CENTER",SuperCursor_X,0);
	SuperCursor_Spark:Show();

	
end


--Updating the timers
function SuperCursor_Update(Elapsed)

	SuperCursor_TimeSinceLastUpdate = SuperCursor_TimeSinceLastUpdate+Elapsed;


	if (SuperCursor_TimeSinceLastUpdate>SuperCursor_UpdateInterval) then

		local x,y=GetCursorPosition();
		local scale=SuperCursor_Frame:GetEffectiveScale();

		SuperCursor_Frame:ClearAllPoints();
		SuperCursor_Frame:SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", x/scale, (y-30)/scale);

		local SuperCursor_Elapsed=GetTime()-SuperCursor_Global_Cast;
		
		local SuperCursor_Val=100*SuperCursor_Elapsed/SuperCursor_Global_CD;
		local SuperCursor_X=190/2*(SuperCursor_Val-50)/50;

		if (SuperCursor_Elapsed-SuperCursor_Global_CD>0) then
			SuperCursor_Frame:Hide();
		else
			SuperCursor_Bar:SetValue(SuperCursor_Val);
			SuperCursor_Spark:SetPoint("CENTER",SuperCursor_X,0);
		end	

		SuperCursor_TimeSinceLastUpdate=0;
	end
	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------------Main event handler----------------------
-----------------------Main event handler----------------------
-----------------------Main event handler----------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



function SuperCursor_OnEvent(event)

	if ( event == "VARIABLES_LOADED") then
			
		if (SuperCursor_Options.enable==1) then
			SuperCursor_Register();
			SuperCursor_Frame:Show();
			SuperCursor_Frame:SetScale(0.25);

			if UnitLevel("player")<10 then
				SuperCursor_Level_Rating=SuperCursor_Haste_Base/26;

			elseif UnitLevel("player")<60 then
				SuperCursor_Level_Rating=SuperCursor_Haste_Base*(UnitLevel("player")-8)/82;

			elseif UnitLevel("player")<70 then
				SuperCursor_Level_Rating=SuperCursor_Haste_Base*82/(262-3*UnitLevel("player"));

			else
				SuperCursor_Level_Rating=SuperCursor_Haste_Base*(UnitLevel("player")+12)/52;
			end

		else
			SuperCursor_Hide();
		end
		return;

	elseif (event=="UNIT_SPELLCAST_START") and (arg1=="player") then
		SuperCursor_Instant=0;
		return;
	
	elseif (event=="UNIT_SPELLCAST_STOP") and (arg1=="player") then
		SuperCursor_Instant=1;

	elseif (event=="UNIT_SPELLCAST_SUCCEEDED") and (arg1=="player") then
		if (SuperCursor_Instant==1) then
			SuperCursor_Global_CD=1.5/(1+GetCombatRating(20)/(100*SuperCursor_Level_Rating));
			SuperCursor_Start_Timer();
		end
	end
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------------Hide function---------------------------
-----------------------Hide function---------------------------
-----------------------Hide function---------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Hiding the window
function SuperCursor_Hide()
	SuperCursor_Frame:Hide();
end

