SunnArt = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0","FuBarPlugin-2.0")

local tablet = AceLibrary("Tablet-2.0")
local dropdowns = AceLibrary("Dewdrop-2.0")

SunnArt.hasIcon = true
SunnArt.cannotDetachTooltip=true
SunnArt.idependentProfile=true
SunnArt.defaultPosition="RIGHT"
SunnArt.hideWithoutStandby=true
SunnArt.hasNoColor = true

function SunnArt:OnInitialize()
	self.options = { 
		type="group",
		args = {
		    artwork = {
				name = "Artwork",
				type = "toggle",
				desc = "Enable or Disable artwork in the panels",
				get = function()
					return self.db.profile.artwork
				end,
				set = function(a)
					self:Disable()
					self.db.profile.artwork=a
					self:Enable()
				end,
				order = 1,
			},
			theme = {
				name = "Theme",
				type = "text",
				desc = "Graphical theme",
				get = function()
					return self.db.profile.Theme
				end,
				set = function(name)
					self:Disable()
					self.db.profile.Theme=name
					self:Enable()
				end,
				validate = {["SunnArt\\forsaken"] = "Forsaken", ["SunnArt\\tribal"] = "Tribal",["SunnArt\\royal"] = "Royal",["SunnArt\\rogue"] = "Rogue",["solid"] = "Solid colour"},
				order = 2,
			},
			colourselect = {
				type = "color",
				order = 3,
				name = "Solid colour",
				desc = "Colour of the Solid Colour theme",
				get = function()
					return self.db.profile.colourred,self.db.profile.colourgreen,self.db.profile.colourblue
				end,
				set = function(r,g,b)
					self:Disable()
					self.db.profile.colourred = r
					self.db.profile.colourgreen = g
					self.db.profile.colourblue = b
					self.db.profile.Theme = "solid"
					self:Enable()
				end,
			},
			globalspacer = {
				order = 4,
				type = "header",
				name = "Viewport Settings",
			},
			horizviewport = {
				name = "Horizontal Viewport",
				type = "toggle",
				desc = "Enable or Disable the viewport Horizontally",
				get = function()
					return (self.db.profile.leftviewport and self.db.profile.rightviewport)
				end,
				set = function(v)
					self.db.profile.leftviewport=v
					self.db.profile.rightviewport=v
					self:UpdateViewport()
				end,
				order = 5,
			},
			vertviewport = {
				name = "Vertical Viewport",
				type = "toggle",
				desc = "Enable or Disable the viewport Vertically",
				get = function()
					return (self.db.profile.topviewport and self.db.profile.bottomviewport)
				end,
				set = function(v)
					self.db.profile.topviewport=v
					self.db.profile.bottomviewport=v
					self:UpdateViewport()
				end,
				order=6,
			},
			spacer = {
				order = 9,
				type = "header",
				name = "Artwork Panels",
			},				
			top = {
				order = 10,
				type = "group",
				name = "Top panel",
				desc = "Top panel properties",
				args = {
					size = {
						order = 1,
						type = "range",
						name = "Top height",
						desc = "Change the height of the top area (percentage of screen)",
						min = 0,
						max = 100,
						step = 0.1,
						get = function()
							return self.db.profile.topbar
						end,
						set = function(v)
							self:Disable()
							self.db.profile.topbar=v
							self:Enable()
						end,
					},
					alpha = {
						order = 2,
						type = "range",
						name = "Top transparency",
						desc = "Change the transparency of the Top panel",
						min=0,
						max=1,
						step=0.02,
						get = function()
							return self.db.profile.topalpha
						end,
						set = function(v)
							self.db.profile.topalpha=v
							self:UpdateAlpha()
						end,
					},
					resize = {
						order = 4,
						name = "Overlay mode",
						type = "toggle",
						desc = "Toggle Overlay/Viewport mode for this bar",
						get = function()
							return (not self.db.profile.topviewport)
						end,
						set = function(v)
							self.db.profile.topviewport=(not v)
							self:UpdateViewport()
						end,
					},
					scale = {
						order = 3,
						type = "range",
						name = "Top artwork scale",
						desc = "Maximum scale of the artwork before stretching occurs",
						min = 0,
						max = 2,
						step = 0.02,
						get = function()
							return self.db.profile.topscale
						end,
						set = function(v)
							self:Disable()
							self.db.profile.topscale=v
							self:Enable()
						end,
					},
					reset = {
						order = 9,
						type = "execute",
						name = "Reset",
						desc = "Restore default values",
						func = function()
							self:Disable()
							-- LedMirage 9/28/2007 [ 1 of 3] Default Variable Tweak
							self.db.profile.topbar = 2.8
							self.db.profile.topalpha=0.9
							self.db.profile.topviewport = true
							-- LedMirage 9/28/2007 [ 2 of 3] Default Variable Tweak
							self.db.profile.topscale = 1.0
							self.db.profile.autostretchtop = true
							self:Enable()
						end,
					},
				},
			},
			bottom = {
				order = 11,
				type = "group",
				name = "Bottom panel",
				desc = "Bottom panel properties",
				args = {
					size = {
						order = 1,
						type = "range",
						name = "Bottom height",
						desc = "Change the height of the bottom area (percentage of screen)",
						min = 0,
						max = 100,
						step = 0.1,
						get = function()
							return self.db.profile.bottombar
						end,
						set = function(v)
							self:Disable()
							self.db.profile.bottombar=v
							self:Enable()
						end,
					},
					alpha = {
						order = 2,
						type = "range",
						name = "Bottom transparency",
						desc = "Change the transparency of the bottom panel",
						min=0,
						max=1,
						step=0.02,
						get = function()
							return self.db.profile.bottomalpha
						end,
						set = function(v)
							self.db.profile.bottomalpha=v
							self:UpdateAlpha()
						end,
					},
					resize = {
						order = 4,
						name = "Overlay mode",
						type = "toggle",
						desc = "Toggle Overlay/Viewport mode for this bar",
						get = function()
							return (not self.db.profile.bottomviewport)
						end,
						set = function(v)
							self.db.profile.bottomviewport=(not v)
							self:UpdateViewport()
						end,
					},
					scale = {
						order = 3,
						type = "range",
						name = "Bottom artwork scale",
						desc = "Maximum scale of the artwork before stretching occurs",
						min = 0,
						max = 2,
						step = 0.02,
						get = function()
							return self.db.profile.bottomscale
						end,
						set = function(v)
							self:Disable()
							self.db.profile.bottomscale=v
							self:Enable()
						end,
					},
					reset = {
						order = 9,
						type = "execute",
						name = "Reset",
						desc = "Restore default values",
						func = function()
							self:Disable()
							self.db.profile.bottombar = 20
							self.db.profile.bottomalpha=0.9
							self.db.profile.bottomviewport = true
							self.db.profile.bottomscale = 1
							self.db.profile.autostretchbottom = true
							self:Enable()
						end,
					},
				},
			},
			left = {
				order = 12,
				type = "group",
				name = "Left panel",
				desc = "Left panel properties",
				args = {
					size = {
						order = 1,
						type = "range",
						name = "Left width",
						desc = "Change the width of the left area (percentage of screen)",
						min = 0,
						max = 100,
						step = 0.1,
						get = function()
							return self.db.profile.leftbar
						end,
						set = function(v)
							self:Disable()
							self.db.profile.leftbar=v
							self:Enable()
						end,
					},
					alpha = {
						order = 2,
						type = "range",
						name = "Left transparency",
						desc = "Change the transparency of the left panel",
						min=0,
						max=1,
						step=0.02,
						get = function()
							return self.db.profile.leftalpha
						end,
						set = function(v)
							self.db.profile.leftalpha=v
							self:UpdateAlpha()
						end,
					},
					resize = {
						order = 4,
						name = "Overlay mode",
						type = "toggle",
						desc = "Toggle Overlay/Viewport mode for this bar",
						get = function()
							return (not self.db.profile.leftviewport)
						end,
						set = function(v)
							self.db.profile.leftviewport=(not v)
							self:UpdateViewport()
						end,
					},
					scale = {
						order = 3,
						type = "range",
						name = "Left artwork scale",
						desc = "Maximum scale of the artwork before stretching occurs",
						min = 0,
						max = 2,
						step = 0.02,
						get = function()
							return self.db.profile.leftscale
						end,
						set = function(v)
							self:Disable()
							self.db.profile.leftscale=v
							self:Enable()
						end,
					},
					reset = {
						order = 9,
						type = "execute",
						name = "Reset",
						desc = "Restore default values",
						func = function()
							self:Disable()
							self.db.profile.leftbar = 2.3
							self.db.profile.leftalpha=0.9
							self.db.profile.leftviewport = true
							self.db.profile.leftscale = 1
							self.db.profile.autostretchleft = true
							self:Enable()
						end,
					},
				},
			},
			right = {
				order = 13,
				type = "group",
				name = "Right panel",
				desc = "Right panel properties",
				args = {
					size = {
						order = 1,
						type = "range",
						name = "Right width",
						desc = "Change the width of the right area (percentage of screen)",
						min = 0,
						max = 100,
						step = 0.1,
						get = function()
							return self.db.profile.rightbar
						end,
						set = function(v)
							self:Disable()
							self.db.profile.rightbar=v
							self:Enable()
						end,
					},
					alpha = {
						order = 2,
						type = "range",
						name = "Right transparency",
						desc = "Change the transparency of the right panel",
						min=0,
						max=1,
						step=0.02,
						get = function()
							return self.db.profile.rightalpha
						end,
						set = function(v)
							self.db.profile.rightalpha=v
							self:UpdateAlpha()
						end,
					},
					resize = {
						order = 4,
						name = "Overlay mode",
						type = "toggle",
						desc = "Toggle Overlay/Viewport mode for this bar",
						get = function()
							return (not self.db.profile.rightviewport)
						end,
						set = function(v)
							self.db.profile.rightviewport=(not v)
							self:UpdateViewport()
						end,
					},
					scale = {
						order = 3,
						type = "range",
						name = "Right artwork scale",
						desc = "Maximum scale of the artwork before stretching occurs",
						min = 0,
						max = 2,
						step = 0.02,
						get = function()
							return self.db.profile.rightscale
						end,
						set = function(v)
							self:Disable()
							self.db.profile.rightscale=v
							self:Enable()
						end,
					},
					reset = {
						order = 9,
						type = "execute",
						name = "Reset",
						desc = "Restore default values",
						func = function()
							self:Disable()
							self.db.profile.rightbar = 2.3
							self.db.profile.rightalpha=0.9
							self.db.profile.rightviewport = true
							self.db.profile.rightscale = 1
							self.db.profile.autostretchright = true
							self:Enable()
						end,
					},
				},
			},
			autostretch = {
				order = 14,
				type = "group",
				name = "Auto-Stretch",
				desc = "Auto-Stretch textures to the side of the screen if the panel is too narrow",
				args = {
					top = {
						order = 1,
						name = "Top",
						type = "toggle",
						desc = "Toggle auto-stretch for this bar",
						get = function()
							return self.db.profile.autostretchtop
						end,
						set = function(v)
							self.db.profile.autostretchtop = v
							self:Enable()
						end,
					},
					bottom = {
						order = 2,
						name = "Bottom",
						type = "toggle",
						desc = "Toggle auto-stretch for this bar",
						get = function()
							return self.db.profile.autostretchbottom
						end,
						set = function(v)
							self.db.profile.autostretchbottom = v
							self:Enable()
						end,
					},
					left = {
						order = 3,
						name = "Left",
						type = "toggle",
						desc = "Toggle auto-stretch for this bar",
						get = function()
							return self.db.profile.autostretchleft
						end,
						set = function(v)
							self.db.profile.autostretchleft = v
							self:Enable()
						end,
					},
					right = {
						order = 4,
						name = "Right",
						type = "toggle",
						desc = "Toggle auto-stretch for this bar",
						get = function()
							return self.db.profile.autostretchright
						end,
						set = function(v)
							self.db.profile.autostretchright = v
							self:Enable()
						end,
					},
				},
			},				
		},
	}
	SunnArt_DEFAULTS = {
		topbar = 2.6,
		bottombar = 20,
		leftbar = 0,
		rightbar = 0,
		topalpha = 0.9,
		bottomalpha = 0.9,
		leftalpha = 0.9,
		rightalpha = 0.9,
		topscale = 0.58,
		bottomscale = 1,
		leftscale = 1,
		rightscale = 1,
		topviewport = true,
		bottomviewport = true,
		leftviewport = true,
		rightviewport = true,
		-- LedMirage 9/29/2007 [ 3 of 3 ] Default theme change
		-- Theme = "SunnArt\\royal",
		Theme = "MirageUI_SunnViewport_ArtPack\\MUI_DarkStone_A",
		
		artwork = true,
		colourred = 0,
		colourgreen = 0,
		colourblue = 0,
		autostretchtop = true,
		autostretchbottom = true,
		autostretchleft = true,
		autostretchright = true,
	}
    self:RegisterDB("SunnArtDB")
    self:RegisterDefaults("profile", SunnArt_DEFAULTS)
    self:RegisterDefaults("char", SunnArt_DEFAULTS)
    self:RegisterChatCommand({"/SunnArt", "/sa", "/sunn"},self.options)
    if (self:GetProfile()=="Default") then self:SetProfile("char") end
    BINDING_HEADER_SUNNART = "Sunn - Viewport Art"
    BINDING_NAME_SUNNARTUI = "Toggle UI"
	
	self:CreateFrames()
	self.OnMenuRequest = self.options
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFF0000FFSunnArt|r: Loaded")
end

function SunnArt:CreateFrames()
    if (not self.dummyframe) then
		self.dummyframe = CreateFrame("Frame", "SunnArtDummyFrame")
		self.dummyframe:SetFrameStrata("BACKGROUND")
		self.dummyframe:EnableMouse(false)
		self.dummyframe:SetMovable(false)
	end
	if (not self.frame1) then
		self.frame1 = CreateFrame("Frame", "SunnArtFrameBottom")
		self.frame1:SetFrameStrata("BACKGROUND")
		self.frame1:EnableMouse(false)
		self.frame1:SetMovable(false)
		self["art11"] = self.frame1:CreateTexture("$parentArt1","BACKGROUND")
		self["art12"] = self.frame1:CreateTexture("$parentArt2","BACKGROUND")
		self["art13"] = self.frame1:CreateTexture("$parentArt3","BACKGROUND")
	end
	if (not self.frame2) then
		self.frame2 = CreateFrame("Frame", "SunnArtFrameTop")
		self.frame2:SetFrameStrata("BACKGROUND")
		self.frame2:EnableMouse(false)
		self.frame2:SetMovable(false)
		self["art21"] = self.frame2:CreateTexture("$parentArt1","BACKGROUND")
		self["art22"] = self.frame2:CreateTexture("$parentArt2","BACKGROUND")
		self["art23"] = self.frame2:CreateTexture("$parentArt3","BACKGROUND")
	end
	if (not self.frame3) then
		self.frame3 = CreateFrame("Frame", "SunnArtFrameLeft")
		self.frame3:SetFrameStrata("BACKGROUND")
		self.frame3:EnableMouse(false)
		self.frame3:SetMovable(false)
		self["art31"] = self.frame3:CreateTexture("$parentArt1","BACKGROUND")
		self["art32"] = self.frame3:CreateTexture("$parentArt2","BACKGROUND")
		self["art33"] = self.frame3:CreateTexture("$parentArt3","BACKGROUND")
	end
	if (not self.frame4) then
		self.frame4 = CreateFrame("Frame", "SunnArtFrameRight")
		self.frame4:SetFrameStrata("BACKGROUND")
		self.frame4:EnableMouse(false)
		self.frame4:SetMovable(false)
		self["art41"] = self.frame4:CreateTexture("$parentArt1","BACKGROUND")
		self["art42"] = self.frame4:CreateTexture("$parentArt2","BACKGROUND")
		self["art43"] = self.frame4:CreateTexture("$parentArt3","BACKGROUND")
	end
end

function SunnArt:OnEnable()
	self:Enable()
end

function SunnArt:OnDisable()
    self:Disable()
end

function SunnArt:OnProfileDisable()
	self:Disable()
end

function SunnArt:OnProfileEnable()
	self:Enable()
end

function TextureMinHeight(Panelwidth,scale)
	local ret = 0
	ret=scale*Panelwidth/6
	return ret
end

function SunnArt:SetBars()
	local temp
	local texturepath
	
	self.frame1:ClearAllPoints()
	self.frame1:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", 0, 0)
	self.frame1:SetPoint("TOPRIGHT",UIParent,"BOTTOMRIGHT",0,self.db.profile.bottombar*7.68)
	
	self.frame2:ClearAllPoints()
	self.frame2:SetPoint("BOTTOMLEFT", UIParent, "TOPLEFT", 0, -self.db.profile.topbar*7.68)
	self.frame2:SetPoint("TOPRIGHT",UIParent,"TOPRIGHT",0,0)
	
	self.frame3:ClearAllPoints()
	self.frame3:SetPoint("BOTTOMLEFT", self.frame1, "TOPLEFT", 0, 0)
	self.frame3:SetPoint("TOPRIGHT",self.dummyframe,"TOPLEFT",0,0)
	
	self.frame4:ClearAllPoints()
	self.frame4:SetPoint("BOTTOMLEFT", self.dummyframe, "BOTTOMRIGHT", 0, 0)
	self.frame4:SetPoint("TOPRIGHT",self.frame2,"BOTTOMRIGHT",0,0)
  
	for i=1,3 do
		texturepath="Interface\\Addons\\"..self.db.profile.Theme..i
		
		self["art1"..i]:SetWidth(SunnArtFrameBottom:GetWidth()/3)
		self["art1"..i]:SetHeight(SunnArtFrameBottom:GetHeight())
		if (self.db.profile.Theme ~= "solid") then self["art1"..i]:SetTexture(texturepath) else self["art1"..i]:SetTexture(self.db.profile.colourred,self.db.profile.colourgreen,self.db.profile.colourblue) end
		self["art1"..i]:ClearAllPoints()
		
		self["art2"..i]:SetTexCoord(1,1,1,0,0,1,0,0)
		self["art2"..i]:SetWidth(SunnArtFrameTop:GetWidth()/3)
		self["art2"..i]:SetHeight(SunnArtFrameTop:GetHeight())
		if (self.db.profile.Theme ~= "solid") then self["art2"..i]:SetTexture(texturepath) else self["art2"..i]:SetTexture(self.db.profile.colourred,self.db.profile.colourgreen,self.db.profile.colourblue) end
		self["art2"..i]:ClearAllPoints()
		
		self["art3"..i]:SetTexCoord(0,1,1,1,0,0,1,0)
		self["art3"..i]:SetWidth(SunnArtFrameLeft:GetWidth())
		self["art3"..i]:SetHeight(SunnArtFrameLeft:GetHeight()/3)
		if (self.db.profile.Theme ~= "solid") then self["art3"..i]:SetTexture(texturepath) else self["art3"..i]:SetTexture(self.db.profile.colourred,self.db.profile.colourgreen,self.db.profile.colourblue) end
		self["art3"..i]:ClearAllPoints()
		
		self["art4"..i]:SetTexCoord(1,0,0,0,1,1,0,1)
		self["art4"..i]:SetWidth(SunnArtFrameRight:GetWidth())
		self["art4"..i]:SetHeight(SunnArtFrameRight:GetHeight()/3)
		if (self.db.profile.Theme ~= "solid") then self["art4"..i]:SetTexture(texturepath) else self["art4"..i]:SetTexture(self.db.profile.colourred,self.db.profile.colourgreen,self.db.profile.colourblue) end
		self["art4"..i]:ClearAllPoints()
		
		if i == 1 then
			self["art1"..i]:SetPoint("TOPLEFT", self.frame1, "TOPLEFT", 0, 0)
			self["art2"..i]:SetPoint("BOTTOMRIGHT", self.frame2, "BOTTOMRIGHT", 0, 0)
			self["art3"..i]:SetPoint("TOPRIGHT", self.frame3, "TOPRIGHT", 0, 0)
			self["art4"..i]:SetPoint("BOTTOMLEFT", self.frame4, "BOTTOMLEFT", 0, 0)
		else
			self["art1"..i]:SetPoint("TOPLEFT", self["art1"..i-1], "TOPRIGHT", 0, 0)
			self["art2"..i]:SetPoint("TOPRIGHT", self["art2"..i-1], "TOPLEFT", 0, 0)
			self["art3"..i]:SetPoint("TOPLEFT", self["art3"..i-1], "BOTTOMLEFT", 0, 0)
			self["art4"..i]:SetPoint("BOTTOMRIGHT", self["art4"..i-1], "TOPRIGHT", 0, 0)
		end
		
		temp=TextureMinHeight(SunnArtFrameBottom:GetWidth(),SunnArt.db.profile.bottomscale)
		if (SunnArtFrameBottom:GetHeight()<=temp or not self.db.profile.autostretchbottom) then self["art1"..i]:SetHeight(temp) end
		temp=TextureMinHeight(SunnArtFrameTop:GetWidth(),SunnArt.db.profile.topscale)
		if (SunnArtFrameTop:GetHeight()<=temp or not self.db.profile.autostretchtop) then self["art2"..i]:SetHeight(temp) end
		temp=TextureMinHeight(SunnArtFrameLeft:GetHeight(),SunnArt.db.profile.leftscale)
		if (SunnArtFrameLeft:GetWidth()<=temp or not self.db.profile.autostretchleft) then self["art3"..i]:SetWidth(temp) end
		temp=TextureMinHeight(SunnArtFrameRight:GetHeight(),SunnArt.db.profile.rightscale)
		if (SunnArtFrameRight:GetWidth()<=temp or not self.db.profile.autostretchright) then self["art4"..i]:SetWidth(temp) end
				
		if (SunnArtFrameBottom:GetHeight()~=0) then self["art1"..i]:Show() end
		if (SunnArtFrameTop:GetHeight()~=0) then self["art2"..i]:Show() end
		if (SunnArtFrameLeft:GetWidth()~=0) then self["art3"..i]:Show() end
		if (SunnArtFrameRight:GetWidth()~=0) then self["art4"..i]:Show() end
	end
	self.frame1:Hide()
	self.frame2:Hide()
	self.frame3:Hide()
	self.frame4:Hide()
	if (self.db.profile.artwork==true) then
		self.frame1:Show()
		self.frame2:Show()
		self.frame3:Show()
		self.frame4:Show()
	end
	self:UpdateAlpha()
end

function SunnArt:UpdateAlpha()
	SunnArtFrameBottom:SetAlpha(self.db.profile.bottomalpha)
	SunnArtFrameTop:SetAlpha(self.db.profile.topalpha)
	SunnArtFrameLeft:SetAlpha(self.db.profile.leftalpha)
	SunnArtFrameRight:SetAlpha(self.db.profile.rightalpha)
end

function SunnArt:SetViewport(topheight,bottomheight,leftwidth,rightwidth)
	if (topheight==nil) then topheight=0 end
	if (bottomheight==nil) then bottomheight=0 end
	if (leftwidth==nil) then leftwidth=0 end
	if (rightwidth==nil) then rightwidth=0 end
	
	topheight=-topheight*7.68
	bottomheight=bottomheight*7.68
    leftwidth=leftwidth*9.6
    rightwidth=-rightwidth*9.6

	self.dummyframe:ClearAllPoints()
	self.dummyframe:SetPoint("TOPLEFT", leftwidth, topheight)
	self.dummyframe:SetPoint("BOTTOMRIGHT", rightwidth, bottomheight)
end

function SunnArt:UpdateViewport()
	local ULx,ULy
	local LRx,LRy
	
	if (self.db.profile.leftviewport)  then ULx=0 else ULx=-SunnArtFrameLeft:GetWidth() end
	if (self.db.profile.rightviewport) then LRx=0 else LRx=SunnArtFrameRight:GetWidth() end
	if (self.db.profile.topviewport)   then ULy=0 else ULy=SunnArtFrameTop:GetHeight() end
	if (self.db.profile.bottomviewport) then LRy=0 else LRy=-SunnArtFrameBottom:GetHeight() end

	WorldFrame:ClearAllPoints()	
	WorldFrame:SetPoint("TOPLEFT", self.dummyframe, "TOPLEFT", ULx, ULy)
	WorldFrame:SetPoint("BOTTOMRIGHT", self.dummyframe, "BOTTOMRIGHT", LRx, LRy)
end

function SunnArt:DisableViewport()
	WorldFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 0, 0)
	WorldFrame:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMRIGHT",0,0)
end

function SunnArt:Enable()
	local temp
	if (not(self.dummyframe or self.frame1 or self.frame2 or self.frame3 or self.frame4)) then self:CreateFrames() end
	temp=self.dummyframe:GetTop()
	temp=self.dummyframe:GetBottom()
	temp=self.dummyframe:GetLeft()
	temp=self.dummyframe:GetRight()
	self:SetViewport(self.db.profile.topbar,self.db.profile.bottombar,self.db.profile.leftbar,self.db.profile.rightbar)
	temp=self.dummyframe:GetTop()
	temp=self.dummyframe:GetBottom()
	temp=self.dummyframe:GetLeft()
	temp=self.dummyframe:GetRight()
	self:SetBars()
	temp=self.dummyframe:GetTop()
	temp=self.dummyframe:GetBottom()
	temp=self.dummyframe:GetLeft()
	temp=self.dummyframe:GetRight()
	if (self.db.profile.artwork) then
		self.frame1:Show()
		self.frame2:Show()
		self.frame3:Show()
		self.frame4:Show()
	end
	temp=self.dummyframe:GetTop()
	temp=self.dummyframe:GetBottom()
	temp=self.dummyframe:GetLeft()
	temp=self.dummyframe:GetRight()
	self:UpdateViewport()
	temp=self.dummyframe:GetTop()
	temp=self.dummyframe:GetBottom()
	temp=self.dummyframe:GetLeft()
	temp=self.dummyframe:GetRight()
	SAVisible=true;
end

function SunnArt:Disable()
	if (self.frame1) then self.frame1:Hide() end
	if (self.frame2) then self.frame2:Hide() end
	if (self.frame3) then self.frame3:Hide() end
	if (self.frame4) then self.frame4:Hide() end
	
    if (self.db.profile.leftviewport or self.db.profile.rightviewport or self.db.profile.topviewport or self.db.profile.bottomviewport) then
		self:DisableViewport()
	end
	SAVisible=false;
end

function SunnArt:ToggleUI()
	if (UIParent:IsVisible()) then
		UIParent:Hide()
		SunnArt:Disable()
  	else
		UIParent:Show()
		SunnArt:Enable()
	end
end
