local Instances = {
	["Blackfathom Deeps"] = "BFD",
	["Blackrock Depths"] = "BRD",
	["Blackrock Spire"] = "BRS",
	["Blackrock Spire Upper"] = "UBRS",
	["Blackwing Lair"] = "BWL",
	["Dire Maul"] = "DM",
	["Dire Maul East"] = "DM",
	["Dire Maul North"] = "DM",
	["Dire Maul West"] = "DM",
	["Gnomeregan"] = "",
	["Maraudon"] = "MARA",
	["Molten Core"] = "MC",
	["Onyxia's Lair"] = "ONY",
	["Ragefire Chasm"] = "RFC",
	["Razorfen Downs"] = "RFD",
	["Razorfen Kraul"] = "RFK",
	["Scarlet Monastery"] ="SM",
	["Scholomance"] = "SCHOLO",
	["Shadowfang Keep"] = "SFK",
	["Stratholme"] = "STRAT",
	["The Deadmines"] = "VC",
	["The Stockade"] = "",
	["The Temple of Atal'Hakkar"] = "ST",
	["Uldaman"] = "ULDA",
	["Wailing Caverns"] = "WC",
	["Zul'Farrak"] = "ZF",
	["Zul'Gurub"] = "ZG",
	["Ahn'Qiraj"] = "AQ40",
	["Ruins of Ahn'Qiraj"] = "AQ20",
	["Naxxramas"] = "NAX",
	["The Blood Furnaces"] = "",
	["The Shattered Halls"] = "",
	["The Underbog"] = "",
	["The Steamvault"] = "",
	["The Slave Pens"] = "",
	["Magtheridons Lair"] = "",
	["Hellfire Rampart"] = "",
	["Mana-Tombs"] = "",	
	["Auchenai Crypts"] = "",
	["Sethekk Halls"] = "",
	["Shadow Labyrinth"] = "",
	["The Arcatraz"] = "",
	["The Botanica"] = "",
	["The Mechanar"] = "",
	["The Black Morass"] = "",
	["Old Hillsbrad Foothills"] = "",
	["Battle for Mount Hyjal"] = "",
	["Karazhan"] = "",
	["Gruul's Lair"] = "",
	["Serpentshrine Cavern"] = "",
	["The Eye of Storms"] = "",
};

SukiPrecision = 0;

function Round(num, idp)
  local mult = 10^(idp or 0);
  return (math.floor(num * mult + 0.5) / mult);
end

function MiniMapCoords_OnLoad()
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
end

function MiniMapCoords_OnEvent()
	if(event == "ZONE_CHANGED_NEW_AREA") then
		SetMapToCurrentZone();
	end
end

function MiniMapCoords_OnUpdate()
	if(WorldMapFrame:IsVisible()) then 
		return; 
	end
	local px, py = GetPlayerMapPosition("player");
	if(px == 0 and py == 0) then
		if(Instances[GetRealZoneText()]) then
			SukiMiniCoords:SetText("Instance");
		else
			SukiMiniCoords:SetText("--,--");
		end
	else
		if(SukiPrecision == 0) then
			SukiMiniCoords:SetText(Round(px * 100, SukiPrecision)..","..Round(py * 100, SukiPrecision));
		else
			local x = string.format("%.1f", Round(px * 100, SukiPrecision))
			local y = string.format("%.1f", Round(py * 100, SukiPrecision))
			SukiMiniCoords:SetText(x.."  "..y);
		end
	end
end


function MiniMapCoords_OnClick()
	if(ChatFrameEditBox:IsVisible()) then
		local msg = "My location: "..GetRealZoneText().." ("..SukiMiniCoords:GetText()..")";
		ChatFrameEditBox:Insert(msg);
	end
end


function MiniMapCoords_OnCtrl()
	if(SukiPrecision  == 0) then
		SukiPrecision = 1;
	else
		SukiPrecision = 0;
	end
end
