local StellarBars = CreateFrame("Frame", "StellarBars", UIParent)
local self = StellarBars
StellarBars:SetScript("OnEvent", function(this, event, ...)
	this[event](this, ...)
end)

-- LIBRARIES
local dew = AceLibrary("Dewdrop-2.0")
local smed = LibStub("LibSharedMedia-3.0")
local lbf = LibStub("LibButtonFacade", true)  -- optional

-- GLOBAL -> LOCAL
local _G = getfenv(0)
local main, multibl, multibr, multil, multir = MainMenuBar, MultiBarBottomLeft, MultiBarBottomRight, MultiBarLeft, MultiBarRight
local shiftbar, petbar = ShapeshiftBarFrame, PetActionBarFrame
local mainexp, repexp, repstatusbar, repbartext = MainMenuExpBar, ReputationWatchBar, ReputationWatchStatusBar, ReputationWatchStatusBarText
local GetNumShapeshiftForms, InCombatLockdown = GetNumShapeshiftForms, InCombatLockdown
local IsUsableAction, IsActionInRange, HasAction = IsUsableAction, IsActionInRange, HasAction
local oSetPoint, oSetVertexColor = main.SetPoint, ActionButton1Icon.SetVertexColor
local oMainMenuExpBar_Update, oMainMenuExpBar_OnEnter, oReputationWatchBar_Update, oReputationWatchBar_OnEnter, oPerfBar_OnClick
local WOW3 = UnitAura and true

-- LOCAL VARS
local db, opts, lbfgroup, t1, repupdated
local skin = lbf and {  -- LibButtonFacade skin
	Template = "Blizzard",
	Normal = { Hide = true, },
	Backdrop = { Width = 40, Height = 40, Texture = "Interface\\AddOns\\StellarBars\\backdrop", },
	Icon = { Width = 36, Height = 36, TexCoords = { 0.07, 0.93, 0.07, 0.93, }, },
} or { bgFile = "Interface\\AddOns\\StellarBars\\backdrop", }
local buttons = {
	"ActionButton%d", "BonusActionButton%d", "ShapeshiftButton%d", "PetActionButton%d",
	"MultiBarBottomLeftButton%d", "MultiBarBottomRightButton%d", "MultiBarLeftButton%d", "MultiBarRightButton%d",
	"CharacterBag%dSlot",
}

-- LOCAL FUNCS
local nothing = function() end
local ShowOptions
local function FullAdjust(frame, p, rt, rp, x, y)
	local a,b,c,d,e = frame:GetPoint()
	frame:ClearAllPoints()
	oSetPoint(frame, p or a, rt or b, rp or c, x or d, y or e)
end
local function appendpercent(barframe, textframe)
	local vmin, vmax = barframe:GetMinMaxValues()
	local otext = textframe:GetText() or ""
	local perc = barframe:GetValue() * 100 / (vmax-vmin)
	textframe:SetFormattedText("%s (%0.1f%%)", otext, perc)
end
local function lActionButton_UpdateUsable(self)
	self = self or this
	local page = self.action
	if not HasAction(page) then return end
	local icon = _G[self:GetName().."Icon"]
	local isUsable, notEnoughMana = IsUsableAction(page)
	if isUsable then
		if IsActionInRange(page) ~= 0 then
			oSetVertexColor(icon, 1, 1, 1)
		else
			oSetVertexColor(icon, 1, 0.4, 0.4)
		end
	elseif notEnoughMana then
		oSetVertexColor(icon, 0.4, 0.4, 1)
	else
		oSetVertexColor(icon, 0.4, 0.4, 0.4)
	end
end
local function lActionButton_OnUpdate(self, elapsed)
	elapsed = elapsed or self
	self = WOW3 and self or this
	local e = self.stelap
	if not e then
		_G[self:GetName().."HotKey"]:SetVertexColor(1, 1, 1, 1)
		_G[self:GetName().."HotKey"].SetVertexColor = nothing
	end
	e = (e or 0) + elapsed
	if e > 0.3 then
		e = 0
		lActionButton_UpdateUsable(self)
	end
	self.stelap = e
end
local function UpdatePositions(all)
	if InCombatLockdown() then return end
	if all == 1 then
		if db.sideenable then
			oSetPoint(multir, "BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", ((db.sidex == 0 and -7) or db.sidex)/0.92, (98 + db.sidey)/db.scale)
		end
		if db.mainenable then
			oSetPoint(main, "BOTTOM", UIParent, "BOTTOM", db.mainx/db.scale, (db.mainy ~= 0 and db.mainy/db.scale) or nil)
		end
	end
	oSetPoint(shiftbar, "BOTTOMLEFT", main, "TOPLEFT", 30, ((multibl:IsShown() and 30) or -12)/0.92)
	oSetPoint(petbar, "TOPLEFT", main, "BOTTOMLEFT", 
		(GetNumShapeshiftForms() > 0 and 360) or 30, 
		((multibl:IsShown() or (shiftbar:IsShown() and multibr:IsShown())) and 124/0.92) or (83/0.92)
	)
	FullAdjust(repexp, "TOP", (mainexp:IsShown() and mainexp) or main, "BOTTOM", nil, -1)
end
local function UpdateLook()
	local s = db.scale
	local a = db.alpha or 1
	main:SetScale(s)  multibl:SetScale(s)  multibr:SetScale(s)  multir:SetScale(s)  multil:SetScale(s)
	main:SetAlpha(a)  multibl:SetAlpha(a)  multibr:SetAlpha(a)  multir:SetAlpha(a)  multil:SetAlpha(a)
	
	local t = smed:Fetch("statusbar", db.texture)
	mainexp:SetStatusBarTexture(t)
	repstatusbar:SetStatusBarTexture(t)
end


StellarBars:RegisterEvent("ADDON_LOADED")
-------------------------------------
function StellarBars:ADDON_LOADED(a1)
-------------------------------------
	if a1 ~= "StellarBars" then return end
	self:UnregisterEvent("ADDON_LOADED")
	
	StellarBarsDB = StellarBarsDB or {}
	db = (StellarBarsDB.profiles and StellarBarsDB.profiles.Default) or StellarBarsDB
	if db.dbinit ~= 1 then
		db.dbinit = nil
		for k,v in pairs({
			scale = 0.9,
			alpha = 1,
			mainenable = true, mainx = 0, mainy = 20,
			sideenable = true, sidex = 0, sidey = 0,
			r = 0, g = 0, b = 0, a = 0.9,
			texture = "Blizzard", skin = "StellarBars",
			oor = true,
			selfcast = true,
			dbinit = 1,
		}) do
			db[k] = (db[k] ~= nil and db[k]) or v
		end
	end
	
	SlashCmdList.STELLARBARS = ShowOptions
	SLASH_STELLARBARS1, SLASH_STELLARBARS2 = "/stellarbars", "/stellarbar"

	local SetPoints = function(this, lp, lrt, lrp, lx, ly, rp, rrt, rrp, rx, ry)
		this:SetPoint(lp, lrt, lrp, lx, ly)
		this:SetPoint(rp, rrt, rrp, rx, ry)
	end
	
	local panel = CreateFrame("Frame")
	panel.name = "StellarBars"
	panel:SetScript("OnShow", function(this)
		dew:Close()
		if not t1 then
			t1 = this:CreateFontString(nil, "ARTWORK")
			t1:SetFontObject(GameFontNormalLarge)
			t1:SetJustifyH("LEFT") 
			t1:SetJustifyV("TOP")
			t1:SetPoint("TOPLEFT", 16, -16)
			t1:SetText(this.name)
			
			local t2 = this:CreateFontString(nil, "ARTWORK")
			t2:SetFontObject(GameFontHighlightSmall)
			t2:SetJustifyH("LEFT") 
			t2:SetJustifyV("TOP")
			t2:SetHeight(43)
			SetPoints(t2, "TOPLEFT", t1, "BOTTOMLEFT", 0, -8, "RIGHT", this, "RIGHT", -32, 0)
			t2:SetNonSpaceWrap(true)
			local function GetInfo(field)
				return GetAddOnMetadata("StellarBars", field) or "N/A"
			end
			t2:SetFormattedText("Notes: %s\nAuthor: %s\nVersion: %s", GetInfo("Notes"), GetInfo("Author"), GetInfo("Version"))
		
			local b = CreateFrame("Button", nil, this, "UIPanelButtonTemplate")
			b:SetWidth(120)
			b:SetHeight(20)
			b:SetText("Options Menu")
			b:SetScript("OnClick", ShowOptions)
			b:SetPoint("TOPLEFT", t2, "BOTTOMLEFT", -2, -8)
		end
	end)
	InterfaceOptions_AddCategory(panel)
	
	-- hide/disable some stuff
	local stuffToHide = {
		"MainMenuXPBarTexture0", "MainMenuXPBarTexture1", "MainMenuXPBarTexture2", "MainMenuXPBarTexture3",
		"ReputationWatchBarTexture0", "ReputationWatchBarTexture1", "ReputationWatchBarTexture2", "ReputationWatchBarTexture3",
		"ReputationXPBarTexture0", "ReputationXPBarTexture1", "ReputationXPBarTexture2", "ReputationXPBarTexture3",
		"MainMenuBarTexture0", "MainMenuBarTexture1", "MainMenuBarTexture2", "MainMenuBarTexture3",
		"MainMenuBarLeftEndCap", "MainMenuBarRightEndCap",
		"ShapeshiftBarLeft", "ShapeshiftBarRight", "ShapeshiftBarMiddle",
		"MainMenuMaxLevelBar0", "MainMenuMaxLevelBar1", "MainMenuMaxLevelBar2", "MainMenuMaxLevelBar3",
		"BonusActionBarTexture0", "BonusActionBarTexture1",
		"SlidingActionBarTexture0", "SlidingActionBarTexture1",
	}
	for index,value in pairs(stuffToHide) do
		_G[value]:SetAlpha(0)
		_G[value]:Hide()
	end
	stuffToHide = nil
	main:EnableMouse(false)
	BonusActionBarFrame:EnableMouse(false)
	hooksecurefunc("ActionButton_Update", function() if db.skin ~= "Blizzard" then this:SetNormalTexture("") end end)

	-- hack to make the petbar show up in combat, maybe not necessary anymore
	petbar:SetAttribute("unit", "pet")
	RegisterUnitWatch(petbar)
	ShowPetActionBar = nothing
	HidePetActionBar = nothing
	hooksecurefunc("PetActionBar_Update", function()
		for i = 1, 10, 1 do
			_G["PetActionButton"..i]:SetNormalTexture("")
		end
	end)
	
	-- hides main actionbar when bonusactionbar appears
	local function HideMainAction()
		for i = 1, 12, 1 do 
			_G["ActionButton"..i]:SetAlpha(0)
		end
	end
	hooksecurefunc("ShowBonusActionBar", HideMainAction)
	hooksecurefunc("HideBonusActionBar", function() 
		for i = 1, 12, 1 do 
			_G["ActionButton"..i]:SetAlpha(1)
		end
	end)
	if BonusActionBarFrame:IsShown() then HideMainAction() end

	-- skin the buttons
	local r, g, b, a = db.r, db.g, db.b, (db.a or 1)
	local SkinButton
	if lbf then  -- use buttonfacade to skin
		skin.Backdrop.Color = skin.Backdrop.Color or { r, g, b, a, }
		lbf:AddSkin("StellarBars", skin, true) 
		lbfgroup = lbf:Group("StellarBars", "All")
		lbfgroup:Skin(db.skin or "StellarBars", true, true)
		SkinButton = function(b) lbfgroup:AddButton(b) end
	else  -- default skinning
		SkinButton = function(button)
			local name = button:GetName()
			local fbg = CreateFrame("Frame", name.."BG", button)
			fbg:SetFrameStrata("BACKGROUND")
			fbg:SetBackdrop(skin)
			fbg:SetBackdropColor(r, g, b, a)
			fbg:EnableMouse(true)
			SetPoints(fbg, "TOPLEFT", button, "TOPLEFT", -2, 2, "BOTTOMRIGHT", button, "BOTTOMRIGHT", 2, -2)
			_G[name.."Icon"]:SetTexCoord(0.07, 0.93, 0.07, 0.93)
			button:SetNormalTexture("")
		end
	end
	
	local function handlebag(name, adj)  -- adjust bag buttons
		local button = _G[name]
		button:SetWidth(button:GetWidth() + adj)
		button:SetHeight(button:GetHeight() + adj)
		setglobal(name.."Icon", _G[name.."IconTexture"])  -- ButtonFacade workaround
	end
	handlebag("MainMenuBarBackpackButton", -2)
	MainMenuBarBackpackButton:SetPoint("BOTTOMRIGHT", -6, 4)
	for i = 0, 3, 1 do
		handlebag("CharacterBag"..i.."Slot", WOW3 and 0 or -2)
	end
	handlebag = nil

	for _,value in pairs(buttons) do
		for i = 0, 12, 1 do
			local butt = _G[format(value, i)]
			if butt then
				if value == "ActionButton%d" or value == "BonusActionButton%d" then  -- keeps empty buttons shown
					butt.showgrid = 10
					butt:SetAttribute("showgrid", 10)
					butt:Show()
					butt:UnregisterEvent("ACTIONBAR_SHOWGRID")
					butt:UnregisterEvent("ACTIONBAR_HIDEGRID")
				end
				local butthk = _G[format(value.."HotKey", i)]
				if butthk then
					butthk:SetFont("Fonts\\FRIZQT__.TTF", 12)
					butthk:SetShadowOffset(-1, -1)
				end
				SkinButton(butt)
			end
		end
	end
	SkinButton(MainMenuBarBackpackButton)
	
	-- adds a background behind the etc buttons
	local newBG = CreateFrame("Button", "StellarMiscBG", main)
	SetPoints(newBG, "TOPLEFT", ActionBarUpButton, "TOPLEFT", 4, -5, "BOTTOMRIGHT", KeyRingButton, "BOTTOMRIGHT", 1, 0)
	newBG:SetBackdrop({ bgFile = "Interface\\Buttons\\WHITE8X8", })
	newBG:SetBackdropColor(r, g, b, a * 0.8)
	newBG:SetFrameStrata("BACKGROUND")
	
	-- adjust experience bars
	local function createticks(parent)
		local t = parent:CreateTexture(nil, "OVERLAY")
		t:SetTexture("Interface\\AddOns\\StellarBars\\ticks")
		t:SetVertexColor(1, 1, 1, 0.9)
		return t
	end
	local function alterexpbar(f, ftext)
		f:SetHeight(8)
		f:SetWidth(f:GetWidth() - 16)
		SetPoints(createticks(f), "TOPLEFT", f, "TOPLEFT", 0, 0, "BOTTOMRIGHT", f, "BOTTOM", 0, 0)
		SetPoints(createticks(f), "TOPLEFT", f, "TOP", -1, 0, "BOTTOMRIGHT", f, "BOTTOMRIGHT", 0, 0)
		ftext:SetFont("Fonts\\FRIZQT__.TTF", 12)
		ftext:SetVertexColor(1, 1, 1, 1)
		ftext:SetShadowOffset(-1, -1)
	end
	
	-- experience bar
	oMainMenuExpBar_Update = MainMenuExpBar_Update
	MainMenuExpBar_Update = function(...)
		oMainMenuExpBar_Update(...)
		if mainexp.TextString:IsShown() then
			appendpercent(mainexp, mainexp.TextString)
		end
	end
	oMainMenuExpBar_OnEnter = mainexp:GetScript("OnEnter") or nothing
	mainexp:SetScript("OnEnter", function(this)
		oMainMenuExpBar_OnEnter(this)
		appendpercent(this, this.TextString) 
	end)
	alterexpbar(mainexp, MainMenuBarExpText)
	
	-- reputation bar
	oReputationWatchBar_Update = ReputationWatchBar_Update
	ReputationWatchBar_Update = function(...)
		oReputationWatchBar_Update(...)
		repstatusbar:SetHeight(8)
		FullAdjust(repexp, "TOP", (mainexp:IsShown() and mainexp) or main, "BOTTOM", nil, -1)
		if repbartext:IsShown() then
			appendpercent(repstatusbar, repbartext)
		else
			repupdated = true
		end
	end
	oReputationWatchBar_OnEnter = repexp:GetScript("OnEnter") or nothing
	repexp:SetScript("OnEnter", function(this) 
		oReputationWatchBar_OnEnter(this)
		if not repupdated then return end
		appendpercent(repstatusbar, repbartext) 
		repupdated = false
	end)
	alterexpbar(repstatusbar, repbartext)
	repexp:SetWidth(repexp:GetWidth() - 16)
	ExhaustionLevelFillBar:SetHeight(8)
	ExhaustionTick:SetHeight(26)
	ExhaustionTick:SetWidth(26)

	main.SetPoint = db.mainenable and nothing or main.SetPoint
	multir.SetPoint = db.sideenable and nothing or multir.SetPoint
	multibl.SetPoint = nothing
	multibr.SetPoint = nothing
	multil.SetPoint = nothing
	petbar.SetPoint = nothing
	shiftbar.SetPoint = nothing
	FullAdjust(mainexp, "TOP", nil, "BOTTOM")
	FullAdjust(repexp, "TOP", mainexp, "BOTTOM")
	FullAdjust(multibl, "BOTTOMLEFT", main, "TOPLEFT", 8, -8)
	FullAdjust(multibr, "BOTTOMRIGHT", main, "TOPRIGHT", -4, -8)
	FullAdjust(main, nil, nil, nil, nil, 20)
	
	shiftbar:SetScale(0.92)
	petbar:SetScale(0.92)
	
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self.PLAYER_REGEN_ENABLED = UpdatePositions
	self.PLAYER_ENTERING_WORLD = UpdatePositions
	hooksecurefunc("InterfaceOptionsFrameOkay_OnClick", UpdatePositions)
	
	local pb = MainMenuBarPerformanceBarFrameButton
	if pb then
		oPerfBar_OnClick = pb:GetScript("OnClick") or nothing
		pb:RegisterForClicks("LeftButtonUp", "RightButtonUp")
		pb:SetScript("OnClick", function(...)
			oPerfBar_OnClick(...)
			ShowOptions()
		end)
	end
	StellarMiscBG:RegisterForClicks("RightButtonUp")
	StellarMiscBG:SetScript("OnClick", ShowOptions)
	
	if db.selfcast then  -- adds right-click self-casting
		MainMenuBarArtFrame:SetAttribute("unit2", "player")
		multibl:SetAttribute("unit2", "player")
		multibr:SetAttribute("unit2", "player")
		multil:SetAttribute("unit2", "player")
		multir:SetAttribute("unit2", "player")
	end
	if db.oor then  -- out of range/mana recoloring
		ActionButton_OnUpdate = lActionButton_OnUpdate
		ActionButton_UpdateUsable = lActionButton_UpdateUsable
	end
	
	UpdateLook()
	UpdatePositions(1)
	self.ADDON_LOADED = nil
end


do  -- Options table
	local function set(k, v, v2, v3, v4)
		if k == "color" then
			db.r, db.g, db.b, db.a = v, v2, v3, v4
			StellarMiscBG:SetBackdropColor(v, v2, v3, v4 * 0.8)
			if lbf then
				local sbc = skin.Backdrop.Color
				sbc[1], sbc[2], sbc[3], sbc[4] = v, v2, v3, v4
				lbf:AddSkin("StellarBars", skin, true)
				if not db.skin or db.skin == "StellarBars" then
					lbfgroup:Skin(db.skin, true, true)
				end
			else
				for _,value in ipairs(buttons) do
					for i = 0, 12, 1 do
						local b = _G[format(value.."BG", i)]
						if b then b:SetBackdropColor(v, v2, v3, v4) end
					end
				end
				MainMenuBarBackpackButtonBG:SetBackdropColor(v, v2, v3, v4)
			end
		else
			db[k] = v
			if not InCombatLockdown() then
				UpdatePositions(1)
				UpdateLook()
			end
			if k == "skin" then
				lbfgroup:Skin(db.skin, true, true)
			end
		end
	end
	local function get(k)
		if k == "color" then
			return db.r, db.g, db.b, (db.a or 1)
		else
			return db[k]
		end
	end
	local reloaddesc = "Note: May require ReloadUI to take full effect"
	opts = {
		type="group", pass=true, set=set, get=get,
		args = {
			header = { type="header", name="StellarBars", order=1, },
			appearance = {
				type="group", name="Appearance", desc="Appearance", pass=true, set=set, get=get, order=2,
				args = {
					scale = { type="range", name="Scale", desc="Change scale", min=0.5, max=2, step=0.02, disabled=InCombatLockdown, order=1, },
					alpha = { type="range", name="Alpha", desc="Alpha", min=0, max=1, step=0.02, bigStep=0.1, order=2, },
					skin = lbf and { type="text", name="Button skins", desc="Button skins", validate=lbf:ListSkins(), order=3, } or nil,
					color = { type="color", name="Button color", desc="Button background color (only for StellarBars skin)", hasAlpha=true, order=4, },
					texture = { type="text", name="Experience bar texture", desc="Experience bar texture", validate=smed:List("statusbar"), order=5, },
				},
			},
			main = {
				type="group", name="Mainbar position", desc="Adjust position of the mainbar", pass=true, set=set, get=get, disabled=InCombatLockdown, order=3,
				args = {
					mainenable = { type="toggle", name="Enable adjustments", desc=reloaddesc, order=1, },
					mainx = { type="range", name="X", desc="Horizontal adjustments", min=-500, max=500, step=1, bigStep=5, order=2, },
					mainy = { type="range", name="Y", desc="0 for disabled. "..reloaddesc, min=-40, max=1200, step=1, bigStep=5, order=3, },
				},
			},
			side = {
				type="group", name="Sidebars position", desc="Adjust position of the sidebar", pass=true, set=set, get=get, disabled=InCombatLockdown, order=4,
				args = {
					sideenable = { type="toggle", name="Enable adjustments", desc=reloaddesc, order=1, },
					sidex = { type="range", name="X", desc="0 for disabled. "..reloaddesc, min=-2000, max=100, step=1, bigStep=10, order=2, },
					sidey = { type="range", name="Y", desc="Vertical adjustments", min=-500, max=1000, step=1, bigStep=5, order=3, },
				},
			},
			oor = { type="toggle", name="Out-of-range coloring", desc=reloaddesc, order=5, },
			selfcast = { type="toggle", name="Right-click self-cast", desc=reloaddesc, order=6, },
		},
	}
	function ShowOptions() 
		dew:Open( UIParent, 'children', function() dew:FeedAceOptionsTable(opts) end, 'cursorX', true, 'cursorY', true )
	end
end