--[[
	Copyright (C) 2007 Nymbia

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]
local _G = getfenv(0)
local L = LibStub("AceLocale-3.0"):GetLocale("StatStain")
local StatStain = LibStub("AceAddon-3.0"):NewAddon("StatStain", "AceConsole-3.0", "AceHook-3.0")

local transform
local function tocolornums(str)
	local a,r,g,b = str:match("(%x%x)(%x%x)(%x%x)(%x%x)")
	a,r,g,b = tonumber(a,16)/255,tonumber(r,16)/255,tonumber(g,16)/255,tonumber(b,16)/255
	return r,g,b,a
end
local options = {
	type = 'group',
	args = {},
}
do
	local initoptions
	do
		local function set(t,r,g,b,a)
			StatStain.db.profile[t[1]] = ("%02x%02x%02x%02x"):format(a*255,r*255,g*255,b*255)
			StatStain:inittransform()
		end
		local function get(t)
			return tocolornums(StatStain.db.profile[t[1]])
		end
		function initoptions(dbname, longname)
			options.args[dbname] = {
				type = 'color',
				name = longname,
				desc = longname,
				get = get,
				set = set,
			}
		end
	end
	local dbpairs = {
		agi			= L["Agility Color"],
		ap			= L["Attack Power Color"],
		arcanedamage		= L["Arcane Damage Color"],
		arcaneresist		= L["Arcane Resist Color"],
		armor			= L["Armor Color"],
		blockrating		= L["Block Rating Color"],
		blockvalue		= L["Block Value Color"],
		damage			= L["Weapon Damage Color"],
		defense			= L["Defense Skill Color"],
		dodge			= L["Dodge Color"],
		dps			= L["Weapon DPS Color"],
		firedamage		= L["Fire Damage Color"],
		fireresist		= L["Fire Resist Color"],
		frostdamage		= L["Frost Damage Color"],
		frostresist		= L["Frost Resist Color"],
		heal			= L["Healing Color"],
		holydamage		= L["Holy Damage Color"],
		hp5			= L["Health Per Five Color"],
		int			= L["Intellect Color"],
		meleecrit		= L["Melee Crit Color"],
		meleehit		= L["Melee Hit Rating Color"],
		mp5			= L["Mana Per Five Color"],
		naturedamage		= L["Nature Damage Color"],
		natureresist		= L["Nature Resist Color"],
		parry			= L["Parry Color"],
		resil			= L["Resilience Color"],
		shadowdamage		= L["Shadow Damage Color"],
		shadowresist		= L["Shadow Resist Color"],
		speed			= L["Weapon Speed Color"],
		spellcrit		= L["Spell Crit Color"],
		spellhit		= L["Spell Hit Rating Color"],
		spellpenetration	= L["Spell Penetration Color"],
		spellpower		= L["Spell Power Color"],
		spi			= L["Spirit Color"],
		sta			= L["Stamina Color"],
		str			= L["Strength Color"],
		weaponskill		= L["Weapon Skill Color"],
	}
	for k,v in pairs(dbpairs) do
		initoptions(k,v)
	end
end
local gems = {
	--red
	["Interface\\Icons\\INV_Misc_Gem_Bloodstone_01"]		= "ffff2c24",
	["Interface\\Icons\\INV_Misc_Gem_Bloodstone_02"]		= "ffff2c24",
	["Interface\\Icons\\INV_Jewelcrafting_LivingRuby_03"]		= "ffff2c24",
	["Interface\\Icons\\INV_Misc_Gem_Ruby_01"]			= "ffff2c24",
	["Interface\\Icons\\INV_Misc_Gem_Ruby_02"]			= "ffff2c24",
	["Interface\\Icons\\INV_Misc_Gem_Ruby_03"]			= "ffff2c24",
	["Interface\\Icons\\INV_Misc_Gem_BloodGem_02"]			= "ffff2c24",
	--yellow
	["Interface\\Icons\\INV_Misc_Gem_Topaz_01"]			= "fffffc24",
	["Interface\\Icons\\INV_Misc_Gem_Topaz_02"]			= "fffffc24",
	["Interface\\Icons\\INV_Misc_Gem_Topaz_03"]			= "fffffc24",
	["Interface\\Icons\\INV_Jewelcrafting_Dawnstone_03"]		= "fffffc24",
	["Interface\\Icons\\INV_Misc_Gem_GoldenDraenite_02"]		= "fffffc24",
	--blue
	["Interface\\Icons\\INV_Misc_Gem_Crystal_03"]			= "ff4e82ff",
	["Interface\\Icons\\INV_Misc_Gem_AzureDraenite_02"]		= "ff4e82ff",
	["Interface\\Icons\\INV_Jewelcrafting_StarOfElune_03"]		= "ff4e82ff",
	--purple
	["Interface\\Icons\\INV_Jewelcrafting_Nightseye_03"]		= "ffde64ff",
	["Interface\\Icons\\INV_Misc_Gem_EbonDraenite_02"]		= "ffde64ff",
	--orange
	["Interface\\Icons\\INV_Jewelcrafting_NobleTopaz_03"]		= "ffff7100",
	["Interface\\Icons\\INV_Misc_Gem_FlameSpessarite_02"]		= "ffff7100",
	["Interface\\Icons\\INV_Misc_Gem_Opal_01"]			= "ffff7100",
	["Interface\\Icons\\INV_Misc_Gem_Opal_02"]			= "ffff7100",
	--green
	["Interface\\Icons\\INV_Jewelcrafting_Talasite_03"]		= "ff00ff00",
	["Interface\\Icons\\INV_Misc_Gem_DeepPeridot_01"]		= "ff00ff00",
	["Interface\\Icons\\INV_Misc_Gem_DeepPeridot_02"]		= "ff00ff00",
	--meta
	["Interface\\Icons\\INV_Misc_Gem_Diamond_07"]			= "ff00cdca",
	["Interface\\Icons\\INV_Misc_Gem_Diamond_06"]			= "ff00cdca",
	--prismatic
	["Interface\\Icons\\INV_Enchant_VoidSphere"]			= "ffcd7d6b",
	["Interface\\Icons\\INV_Enchant_PrismaticSphere"]		= "ffcd7d6b",
}
function StatStain:OnInitialize()
	StatStain.db = LibStub("AceDB-3.0"):New("StatStainDB", {
		profile = {
			agi			= "ffffee03",
			ap			= "ffff007d",
			arcanedamage		= "ffb3eeff",
			arcaneresist		= "ffa0f2ff",
			armor			= "ffb9b9b9",
			blockrating		= "ffa2793c",
			blockvalue		= "ffa09060",
			damage			= "ffff8930",
			defense			= "ff3f63ff",
			dodge			= "ffbcff00",
			dps			= "ff4bffd7",
			firedamage		= "ffff5d00",
			fireresist		= "ffff8300",
			frostdamage		= "ff0b71ff",
			frostresist		= "ff188bff",
			heal			= "ff02ff59",
			holydamage		= "fff3b8ff",
			hp5			= "ffff99ad",
			int			= "ffb395ff",
			meleecrit		= "ffe8850d",
			meleehit		= "ff00ffba",
			mp5			= "ff00acff",
			naturedamage		= "ff61ff00",
			natureresist		= "ff87ff3c",
			parry			= "fff600ff",
			resil			= "ff686eff",
			shadowdamage		= "ffa03897",
			shadowresist		= "ffbd33b1",
			speed			= "ffe6ff8b",
			spellcrit		= "ffff9b00",
			spellhit		= "ff5feeff",
			spellpenetration	= "ffe047ff",
			spellpower		= "fffffb00",
			spi			= "ff00ff55",
			sta			= "ffdda357",
			str			= "ffff000a",
			weaponskill		= "ffffcc00",
		}
	}, 'global')
	LibStub("AceConfig-3.0"):RegisterOptionsTable("StatStain", options)
	StatStain:RegisterChatCommand("statstain", function() LibStub("AceConfigDialog-3.0"):Open("StatStain") end)
	StatStain:inittransform()
end
local tooltips = {
	ItemRefTooltip,
	GameTooltip,
	ShoppingTooltip1,
	ShoppingTooltip2,
	ItemSocketingDescription,
	--EquipCompare
	ComparisonTooltip1,
	ComparisonTooltip2,
	--EQCompare
	EQCompareTooltip1,
	EQCompareTooltip2,
	-- LinkWrangler
	IRR_ItemRefTooltip1,
	IRR_ItemCompTooltip1,
	IRR_ItemCompTool11,
	IRR_ItemRefTooltip2,
	IRR_ItemCompTooltip2,
	IRR_ItemCompTool12,
	IRR_ItemRefTooltip3,
	IRR_ItemCompTooltip3,
	IRR_ItemCompTool13,
	IRR_ItemRefTooltip4,
	IRR_ItemCompTooltip4,
	IRR_ItemCompTool14,
	IRR_ItemRefTooltip5,
	IRR_ItemCompTooltip5,
	IRR_ItemCompTool15,
	-- MultiTips
	ItemRefTooltip2,
	ItemRefTooltip3,
	ItemRefTooltip4,
	ItemRefTooltip5,
	--Bonuses
	TooltipScan1,
	TooltipScan2,
	TooltipScan3,
	TooltipScan4,
}
function StatStain:OnEnable()
	for _,v in ipairs(tooltips) do
		if v and type(v) == "table" then
			self:HookScript(v, "OnTooltipSetItem")
		end
	end
end
function StatStain:AddTooltip(tooltip)
	if tooltip and type(tooltip) == "table" then
		table.insert(tooltips, tooltip)
		self:HookScript(tooltip, "OnTooltipSetItem")
	end
end
function StatStain:OnTooltipSetItem(tooltip, ...)
	self.hooks[tooltip].OnTooltipSetItem(tooltip, ...)
	self:Modify(tooltip)
end

function StatStain:Modify(tooltip)
	local tooltipname = tooltip:GetName()
	for i=3,tooltip:NumLines() do
		do --left line!
			local stringobj = _G[tooltipname.."TextLeft"..i]
			local text = stringobj:GetText()
			local removedescapes = text:match("^|cffffffff(.+)|r")
			if removedescapes then
				text = removedescapes
			end
			local r,g = stringobj:GetTextColor()
			for k,v in pairs(transform) do
				if text:match(k) then
					stringobj:SetText(('|c%s%s|r'):format(v,text))
				end
			end
			if r < 0.05 and g > 0.95 and not text:match(L["^Equip:"]) and not text:match(L["^Use:"]) and not text:match(L["^Socket"]) and not text:match(L["^<Shift"]) and not text:match(L["^<Right"]) and not text:match(L["^Set:"]) and not text:match(L["^Chance on hit:"]) and not removedescapes then
				stringobj:SetText(L["|cff00ff00Ench: |r"]..text)
			end
		end
		do --right line!
			local stringobj = _G[tooltipname.."TextRight"..i]
			local text = stringobj:GetText()
			if text then
				for k,v in pairs(transform) do
					if text:match(k) then
						stringobj:SetText(('|c%s%s|r'):format(v,text))
					end
				end
			end
		end
	end
	for i = 1,5 do --socket lines
		local texture = _G[tooltipname.."Texture"..i]
		if type(texture) == "table" and texture.GetPoint and texture:IsShown()then
			local newcolor = gems[texture:GetTexture()]
			if newcolor then
				local _,parent = texture:GetPoint()
				if parent then
					local text = parent:GetText():match("^|c........(.+)$")
					if text then
						parent:SetText(text)
					end
					parent:SetTextColor(tocolornums(newcolor))
				end
			end
		end
	end
end
local function matchable(formatstr)
	formatstr = formatstr:gsub("([%.%(%)%%%+%-%*%?%[%]%^%$])", "%%%1")
	formatstr = formatstr:gsub('(%%%%s)','.+')
	formatstr = formatstr:gsub('(%%%%d)','%%d+')
	formatstr = formatstr:gsub('(%%%%%d+d)','%%d+')
	formatstr = formatstr:gsub('(%%%%f)','%d+%%.?%%d*')
	formatstr = formatstr:gsub('(%%%%c)','.')
	formatstr = formatstr:gsub('(%%%%%.?%d*f)', '%d+%%.?%%d*')
	return formatstr
end
function StatStain:inittransform()
	transform = {
		[ITEM_MOD_INTELLECT]						= self.db.profile.int, --"%c%d Intellect"
		[ITEM_MOD_STAMINA]						= self.db.profile.sta, --"%c%d Stamina"
		[ITEM_MOD_STRENGTH]						= self.db.profile.str, --"%c%d Strength"
		[ITEM_MOD_AGILITY]						= self.db.profile.agi, --"%c%d Agility"
		[ITEM_MOD_SPIRIT]						= self.db.profile.spi, --"%c%d Spirit"
		[ARMOR_TEMPLATE]						= self.db.profile.armor, --"%d Armor"
		[SPEED.." %.2f"]						= self.db.profile.speed,
		[DAMAGE_TEMPLATE]						= self.db.profile.damage, --"%d - %d Damage"
		[L["Equip: "]..L["Increases attack power by %d."]]		= self.db.profile.ap,
		[L["Equip: "]..L["Increases healing done by up to %d and damage done by up to %d for all magical spells and effects."]] = self.db.profile.heal,
		[L["Equip: "]..L["Increases damage and healing done by magical spells and effects by up to %d."]] = self.db.profile.spellpower,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Arcane"],"%d")] = self.db.profile.arcanedamage,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Nature"],"%d")] = self.db.profile.naturedamage,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Frost"],"%d")] = self.db.profile.frostdamage,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Fire"],"%d")] = self.db.profile.firedamage,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Shadow"],"%d")] = self.db.profile.shadowdamage,
		[L["Equip: "]..L["Increases damage done by %s spells and effects by up to %s."]:format(L["Holy"],"%d")] = self.db.profile.holydamage,
		[L["Equip: "]..L["Increases your spell penetration by %d."]]	= self.db.profile.spellpenetration,
		[L["Equip: "]..ITEM_MOD_BLOCK_RATING]				= self.db.profile.blockrating, -- "Increases your shield block rating by %d."
		[L["Equip: "]..L["Increases the block value of your shield by %d."]] = self.db.profile.blockvalue,
		[L["Equip: "]..ITEM_MOD_CRIT_RATING]				= self.db.profile.meleecrit,--"Improves critical strike rating by %d.";
		[L["Equip: "]..L["Increases your critical strike rating by %d."]] = self.db.profile.meleecrit,
		[L["Equip: "]..ITEM_MOD_CRIT_SPELL_RATING]			= self.db.profile.spellcrit,--"Improves spell critical strike rating by %d.";
		[L["Equip: "]..L["Increases your spell critical strike rating by %d."]] = self.db.profile.spellcrit,
		[L["Equip: "]..ITEM_MOD_DEFENSE_SKILL_RATING]			= self.db.profile.defense,--"Increases defense rating by %d.";
		[L["Equip: "]..ITEM_MOD_DODGE_RATING]				= self.db.profile.dodge,--"Increases your dodge rating by %d.";
		[L["Equip: "]..ITEM_MOD_HIT_RATING]				= self.db.profile.meleehit,--"Improves hit rating by %d.";
		[L["Equip: "]..L["Increases your hit rating by %d."]]		= self.db.profile.meleehit,
		[L["Equip: "]..ITEM_MOD_HIT_SPELL_RATING]			= self.db.profile.spellhit,--"Improves spell hit rating by %d.";
		[L["Equip: "]..ITEM_MOD_PARRY_RATING]				= self.db.profile.parry,--"Increases your parry rating by %d.";
		[L["Equip: "]..ITEM_MOD_RESILIENCE_RATING]			= self.db.profile.resil,--"Improves your resilience rating by %d.";
		[L["+%s %s Resistance"]:format("%d",L["Arcane"])]		= self.db.profile.arcaneresist,
		[L["+%s %s Resistance"]:format("%d",L["Fire"])]			= self.db.profile.fireresist,
		[L["+%s %s Resistance"]:format("%d",L["Frost"])]		= self.db.profile.frostresist,
		[L["+%s %s Resistance"]:format("%d",L["Nature"])]		= self.db.profile.natureresist,
		[L["+%s %s Resistance"]:format("%d",L["Shadow"])]		= self.db.profile.shadowresist,
		[L["Equip: "]..L["Increases healing done by spells and effects by up to %d."]] = self.db.profile.heal,
		[DPS_TEMPLATE]							= self.db.profile.dps,
		[L["Equip: "]..L["Restores %d mana per 5 sec."]]		= self.db.profile.mp5,
		[L["Equip: "]..L["Restores %d health per 5 sec."]]		= self.db.profile.hp5,
		[L["%c%d Spell Damage and Healing"]]				= self.db.profile.spellpower,
		[L["%c%d Spell Critical Strike Rating"]]			= self.db.profile.spellcrit,
		[L["%s %s Damage"]:format("%c%d",L["Arcane"])]			= self.db.profile.arcanedamage,
		[L["%s %s Damage"]:format("%c%d",L["Nature"])]			= self.db.profile.naturedamage,
		[L["%s %s Damage"]:format("%c%d",L["Frost"])]			= self.db.profile.frostdamage,
		[L["%s %s Damage"]:format("%c%d",L["Fire"])]			= self.db.profile.firedamage,
		[L["%s %s Damage"]:format("%c%d",L["Shadow"])]			= self.db.profile.shadowdamage,
		[L["%s %s Damage"]:format("%c%d",L["Holy"])]			= self.db.profile.holydamage,
		[L["Equip: "]..L["Increases your %s skill rating by %d."]]	= self.db.profile.weaponskill,
		[L["%c%d Healing"]]						= self.db.profile.heal,
		[L["%c%d Critical Strike Rating"]]				= self.db.profile.meleecrit,
		[L["%c%d Attack Power"]]					= self.db.profile.ap,
		[L["%c%d Mana Per 5 sec."]]					= self.db.profile.mp5,
	}
	local new = {}
	for k,v in pairs(transform) do
		local newk = matchable(k)
		new[newk] = v
	end
	transform = new
end
