--[[*****************************************************************
	StanceSets 3 + 1 v2.3
	01.09.2008

	Author: Vorkosigan
	*****************************************************************
	Description:
    Handle the minimap button for StanceSets 3+1 	
	*****************************************************************
]]

function StanceSets3Button_OnClick()
	StanceSets3_Toggle();
end

function StanceSets3Button_Init()
	if(StanceSets3ButtonOptions.ButtonShown) then
		StanceSets3ButtonFrame:Show(); 
	else
		StanceSets3ButtonFrame:Hide(); 
	end
end

function StanceSets3Button_Toggle()
	if (StanceSets3ButtonOptions.ButtonShown) then
    HideUIPanel(StanceSets3ButtonFrame);
		StanceSets3ButtonOptions.ButtonShown = false;
	else
    ShowUIPanel(StanceSets3ButtonFrame);
		StanceSets3ButtonOptions.ButtonShown = true;
	end
end

function StanceSets3Button_UpdatePosition()
	StanceSets3ButtonFrame:SetPoint("TOPLEFT",
		                              "Minimap",
		                              "TOPLEFT",
		                              54 - (StanceSets3ButtonOptions.ButtonRadius * cos(StanceSets3ButtonOptions.ButtonPosition)),
		                              (StanceSets3ButtonOptions.ButtonRadius * sin(StanceSets3ButtonOptions.ButtonPosition)) - 55
	                               );
end

function StanceSets3Button_BeingDragged()
  local xpos,ypos = GetCursorPosition() 
  local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom() 

  xpos = xmin - xpos / UIParent:GetScale() + 70 
  ypos = ypos / UIParent:GetScale() - ymin - 70 

  StanceSets3Button_SetPosition(math.deg(math.atan2(ypos,xpos)));
end

function StanceSets3Button_SetPosition(v)
  if(v < 0) then
    v = v + 360;
  end

  StanceSets3ButtonOptions.ButtonPosition = v;
  StanceSets3Button_UpdatePosition();
end

function StanceSets3Button_OnEnter()
  GameTooltip:SetOwner(this, "ANCHOR_LEFT");
  GameTooltip:SetText(STANCESETS3_BUTTON_TOOLTIP_TITLE);
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
  GameTooltip:AddLine(STANCESETS3_BUTTON_TOOLTIP_HINT);
  GameTooltip:Show();
end
