--[[
    Stable by LordFarlander
    Version 2.1.60
    $Revision: 53 $

    Based on Kennel.
]]--

--[[
Copyright (c) 2008, LordFarlander
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]--

local L = LibStub( "AceLocale-3.0" ):GetLocale( "Stable" );

if( not LibStub( "LibPetAndMountDatabase-1.1", true ) ) then
    error( "Stable requires LibPetAndMountDatabase-1.1" );
    return;
end--if

local LibLordFarlander = LibStub( "LibLordFarlander-2.0", true );
if( not LibLordFarlander ) then
    error( L["%s requires %s"]:format( L["Stable"], "LibLordFarlander-2.0" ) );
    return;
end--if

Stable = LibStub( "AceAddon-3.0" ):NewAddon( "Stable", "AceEvent-3.0", "AceConsole-3.0" );
Stable.version = { major = 2, minor = 1, revision = tonumber( "60" ) };

Stable.bankopen = false;
Stable.swapped = false;
Stable.sets = {};
Stable.ui = { currentSelection = 0, };

function Stable:OnInitialize()
    local defaults = {
            profile = {
                --List of items to never swap
                NoSwap = {},
                --List of sets to swap
                DoSwap = {},
            },
        };
    local PetAndMountDatabase = LibStub( "LibPetAndMountDatabase-1.1" );
    local AceConfigReg = LibStub( "AceConfigRegistry-3.0" );
    local AceConfigDialog = LibStub( "AceConfigDialog-3.0" );
    local Sets = { PetAndMountDatabase:GetSubsets( "MiniPets" ) };
    local MountSubsets = PetAndMountDatabase:GetSubsets( "Mounts" );
    local AllSets = {};
    local neverSwapOptions = {
            type = "group",
            name = L["Never Swap"],
            desc = L["Items that should never be swapped."],
            handler = self;
            args = {
                Items = {
                    type = "select",
                    order = 1,
                    name = L["Items"],
                    desc = L["Items that should never be swapped."],
                    width = "full",
                    cmdHidden = true,
                    values = function( info )
                                 local items = {};
                                 local firstItem = 0;

                                 for itemID, _ in pairs( info.handler.db.profile.NoSwap ) do
                                     local sName, _, _, _, _, _, _, _, _, sItemTexture = GetItemInfo( itemID );
    
                                     if( not sName ) then
                                         sName = tostring( ( itemID < 0 ) and ( itemID * -1 ) or itemID );
                                     end--if
                                     if( sItemTexture ) then
                                         items[itemID] = ("|T%s:0|t %s"):format( sItemTexture, sName );
                                     else
                                         items[itemID] = sName;
                                     end--if                                     
                                     if( firstItem == 0 ) then
                                         firstItem = itemID;
                                     end--if                                     
                                 end--for
                                 if( ( not info.handler.db.profile.NoSwap[info.handler.ui.currentSelection] ) or ( info.handler.ui.currentSelection == 0 ) ) then
                                     info.handler.ui.currentSelection = firstItem;
                                 end--if                                 
                                 return items;
                             end,
                    get = function( info )
                              return info.handler.ui.currentSelection;
                          end,
                    set = function( info, val )
                              info.handler.ui.currentSelection = val;
                          end,
                },
                [L["add"]] = {
                    type = "input",
                    order = 2,
                    name = L["Item"],
                    desc = function( info )
                                if( info.uiType == "cmd" ) then
                                    return L["Add the name, ID, or a link of a minipet or mount to the never swap list."];
                                else
                                    return L["Enter the name or ID of a minipet or mount to add to the list then press Enter or click Okay."];
                                end--if
                           end,                    
                    width = "full",
                    get = function( info )
                              return info.handler.db.profile.NoSwap[info.handler.ui.currentSelection] or "";
                          end,
                    set = function( info, val )
                              local newItemID = LibLordFarlander.GetItemIDFromLink( LibLordFarlander.GetItemLink( val ) );

                              --assume was already validated
                              if( newItemID ) then
                                  info.handler.db.profile.NoSwap[newItemID] = true;
                                  info.handler.ui.currentFavorite = newItemID;
                              end--if
                          end,
                    validate = function( info, val )
                                   local itemLink = LibLordFarlander.GetItemLink( val );
                                   local PetAndMountDatabase = LibStub( "LibPetAndMountDatabase-1.1" );

                                   if( ( val == "" ) or ( itemLink and ( PetAndMountDatabase:ItemInSet( itemLink, "MiniPets" ) or PetAndMountDatabase:ItemInSet( itemLink, "Mounts" ) ) ) ) then
                                       return true;
                                   end--if
                                   if( type( val ) == "number" ) then
                                       return L["Cannot find a minipet or mount with itemID %i!"]:format( val );
                                   else
                                       return L["Cannot find a minipet or mount named %q!"]:format( val );
                                   end--if
                                   return false;
                               end,
                },
                Delete = {
                    type = "execute",
                    order = 3,
                    name = L["Delete"],
                    desc = L["Delete the currently selected item from the list."],
                    cmdHidden = true,
                    func = function( info )
                               if( info.handler.ui.currentSelection > 0 ) then
                                   info.handler.db.profile.NoSwap[info.handler.ui.currentSelection] = nil;
                                   info.handler.ui.currentSelection = 0;
                               end--if
                           end,
                },
                [L["list"]] = {
                    type = "execute",
                    order = 4,
                    guiHidden = true,
                    name = L["List all never swap items"],
                    desc = L["Show a list with all of your never swap items."],
                    func = function( info )
                               info.handler:Print( L["List of your never swap items:"] );
                               for item, _ in pairs( info.handler.db.profile.NoSwap ) do
                                   local link = LibLordFarlander.GetItemLink( item );
                                   local _, _, _, _, _, _, _, _, _, sTexture = GetItemInfo( item );
    
                                   if( sTexture ) then
                                       info.handler:Print( ("|T%s:0|t %s"):format( sTexture, link or tostring( item ) ) );
                                   else
                                       info.handler:Print( ("%s"):format( link or tostring( item ) ) );
                                   end--if
                               end--for
                           end,
                },                
            },
        };
    local options = { handler = self, type = "group",
            args = {},
            name = L["Stable"],
            desc = L["Swap a random minipet and/or mount every time you visit the bank"],
            icon = "Interface\\Icons\\INV_Box_PetCarrier_01",
        };
    local optionsSet = {};
    
    self.db = LibStub( "AceDB-3.0" ):New( "StableDB", defaults );
    self.db.RegisterCallback( self, "OnProfileChanged" );
    self.db.RegisterCallback( self, "OnProfileReset" );
    
    local profileOptions = LibStub( "AceDBOptions-3.0" ):GetOptionsTable( self.db );
    local slashOptions = {
        type = "group",
        handler = self,
        name = options.name,
        desc = options.desc,
        icon = options.icon,
        args = {
            [L["options"]] = options,
            [L["neverSwap"]] = neverSwapOptions,
            [L["profile"]] = profileOptions,
            [L["gui"]] = {
                type = "execute",
                order = -1,
                name = L["Open GUI configurator"],
                desc = L["Open GUI configurator"],
                guiHidden = true,
                func = function( info )
                           InterfaceOptionsFrame_OpenToFrame( L[info.handler.name] );
                       end,
            },
        },
    };

    for _, set in pairs( MountSubsets ) do
        table.insert( Sets, PetAndMountDatabase:GetSubsets( set ) );
    end--for
    -- We want to make sure not to swap Quests and Children and remove the base set
    for _, set in pairs( Sets ) do
        self.CheckSets( set, AllSets );
    end--for
    for _, set in pairs( AllSets ) do
        local setName = set;
        local setParts = { strsplit( ".", set ) };
        local commandString = L["swap"];
        local shortString = "";
        local longString = "";
        local stableSets = self.sets;
        local commandSet = "";
        local setPartsCount = #setParts;

        if( setPartsCount > 1 ) then
            setName = setParts[1];
        end--if
        if( stableSets[setName] == nil ) then
            stableSets[setName] = {};
        end--if
        stableSets[setName][set] = {};
        if( setPartsCount >= 3 ) then
            stableSets[setName][set].subSet = table.concat( setParts, ".", 1, setPartsCount - 1 );
        end--if
        -- Build commands
        for _, setSubname in pairs( setParts ) do
            local shortName = setSubname:lower();
            local longName = setSubname:lower();
            local commandName = setSubname;

            if( L[setSubname .. "_short"] ) then
                shortName = L[setSubname .. "_short"];
            end--if
            if( L[setSubname .. "_long"] ) then
                longName = L[setSubname .. "_long"];
            end--if
            if( L[setSubname .. "_command"] ) then
                commandName = L[setSubname .. "_command"];
            end--if
            commandString = commandString .. commandName;
            if( shortString:len() > 0 ) then
                shortString = " " .. shortString;
            end--if
            shortString = shortName .. shortString;
            if( longString:len() > 0 ) then
                longString = " " .. longString;
            end--if
            longString = longName .. longString;
            if( commandSet:len() > 0 ) then
                commandSet = commandSet .. ".";
            end--if
            commandSet = commandSet .. setSubname;
            if( self.db.profile.DoSwap[commandSet] == nil ) then
                self.db.profile.DoSwap[commandSet] = true;
            end--if
            if( options.args[commandString] == nil ) then
                table.insert( optionsSet, commandString );
                options.args[commandString] = {
                    type = "toggle",
                    name = L["Swap %s"]:format( shortString ),
                    desc = loadstring( ([[return function ( info ) local returnString = L["Toggles the swapping of %%s."]:format( %q );

                                if( info.uiType == "cmd" ) then
                                    returnString = ("%%s |cFFFF0000[%%s]|r"):format( returnString, info.handler.db.profile.DoSwap[%q] and L["yes"] or L["no"] );
                                end--if
                               return returnString;
                           end]]):format( longString, commandSet ) )(),
                    get = loadstring( ("return Stable.db.profile.DoSwap[%q];"):format( commandSet ) ),
                    set = loadstring( ("Stable:PropigateSettingToChildren( %q, not Stable.db.profile.DoSwap[%q] );"):format( commandSet, commandSet ) ),
                    };
            end--if
        end--for
    end--for
    table.sort( optionsSet );
    for index, option in pairs( optionsSet ) do
        options.args[option].order = index;
    end--for

    LibStub( "AceConfig-3.0" ):RegisterOptionsTable( L["Stable"], slashOptions, { L["stable"], L["stbl"] } );
    AceConfigReg:RegisterOptionsTable( "Stable Main Options", options );
    AceConfigReg:RegisterOptionsTable( "Stable Never Swap", neverSwapOptions );
    AceConfigReg:RegisterOptionsTable( "Stable Profile", profileOptions );
    AceConfigDialog:AddToBlizOptions( "Stable Main Options", L["Stable"] );
    AceConfigDialog:AddToBlizOptions( "Stable Never Swap", L["Never Swap"], L["Stable"] );
    AceConfigDialog:AddToBlizOptions( "Stable Profile", L["Profile"], L["Stable"] );
end--Stable:OnInitialize()

function Stable:OnProfileReset()
    self:OnProfileChanged();
end--Coconuts:OnProfileReset()

function Stable:OnProfileChanged()
    if( self.db.profile.DoSwap["GroundMounts"] ~= nil ) then
        self.db.profile.DoSwap["Mounts.Ground"] = self.db.profile.DoSwap["GroundMounts"];
        self.db.profile.DoSwap["GroundMounts"] = nil;
    end--if
    if( self.db.profile.DoSwap["FlyingMounts"] ~= nil ) then
        self.db.profile.DoSwap["Mounts.Flying"] = self.db.profile.DoSwap["FlyingMounts"];
        self.db.profile.DoSwap["FlyingMounts"] = nil;
    end--if
    if( self.db.profile.DoSwap["MiniPets.Holiday"] ~= nil ) then
        self.db.profile.DoSwap["MiniPets.Reagented"] = self.db.profile.DoSwap["MiniPets.Holiday"];
        self.db.profile.DoSwap["MiniPets.Holiday"] = nil;
    end--if
    self.db.profile.LastWoWVersion = tonumber( select( 4, GetBuildInfo() ) );
    self.db.profile.LastVersion = self.version;
end--Coconuts:OnProfileChanged()

function Stable:OnEnable()
    self:RegisterEvent( "BANKFRAME_OPENED" );
    self:RegisterEvent( "BANKFRAME_CLOSED",
        function()
            if( ( not Stable.bankopen ) and ( not Stable.swapped ) ) then
                Stable:BANKFRAME_OPENED();
            end--if
            if( Stable.bankopen and Stable.swapped and FuBar_CorkFu ) then
                FuBar_CorkFu:GetModule( "Minipet" ):ActivatePet();
            end--if
            Stable.bankopen = false;
        end );

    --Upgrade check
    --Convert old save values
    self:OnProfileChanged();
end--Stable:OnEnable()

function Stable:OnDisable()
    self:UnregisterEvent( "BANKFRAME_OPENED" );
    self:UnregisterEvent( "BANKFRAME_CLOSED" );
end--Stable:OnDisable()

function Stable:PropigateSettingToChildren( parent, setting )
    for name, _ in pairs( self.db.profile.DoSwap ) do
        local start = name:find( ("%s."):format( parent ) );

        if( ( start and ( start == 1 ) ) or ( name == parent ) ) then
            self.db.profile.DoSwap[name] = setting;
        end--if
    end--for
end--Stable:PropigateSettingToChildren( parent, setting )

function Stable.CheckSets( sets, dst )
    for _, name in pairs( sets ) do
        if( ( not name:find( ".Quest" ) ) and ( not name:find( ".Children" ) ) ) then
            local start, ends = name:find( "PetAndMountDatabase." );
            
            if( ends ) then
                name = name:sub( ends + 1 );
            end--if
            table.insert( dst, name );
        end--if
    end--for
end--Stable.CheckSets( sets, dst )

function Stable:BANKFRAME_OPENED()
    local doSwap = self.db.profile.DoSwap;
    local stableSets = self.sets;
    local PetAndMountDatabase = LibStub( "LibPetAndMountDatabase-1.1" );
    local NoSwap = self.db.profile.NoSwap;

    self.bankopen = true;
    self.swapped = false;

    for setName, set in pairs( stableSets ) do
        for subsetName, subset in pairs( set ) do
            local doSwapSet = doSwap[setName] and doSwap[subsetName];

            if( subset.subSet ) then
                doSwapSet = doSwapSet and doSwap[subset.subSet];
            end--if
            subset.player = { bag = {}, slot = {}, num = 0 };
            subset.bank = { bag = {}, slot = {}, num = 0 };
            subset.playerEquipment = { slot = {}, num = 0 };
            subset.bankEquipment = {};
            --Scan for items being worn
            if( doSwapSet and subsetName:find( "Equipment" ) ) then
                local iterator, handle = PetAndMountDatabase:IterateSet( subsetName );
                local item, equipmentSlot = iterator( handle );
            
                while item do
                    if( ( not NoSwap[item] ) and ( LibLordFarlander.GetItemIDFromLink( GetInventoryItemLink( "player", GetInventorySlotInfo( equipmentSlot ) ) ) == item ) ) then
                        local equipList = subset.playerEquipment;
                        local n = equipList.num;

                        equipList.num = n;
                        equipList.slot[equipmentSlot] = GetInventorySlotInfo( equipmentSlot );
                    end--if
                    item, equipmentSlot = iterator( handle );
                end--for            
            end--if
        end--for
    end--for
    --Scan for items in bags
    for bag = BANK_CONTAINER, NUM_BAG_SLOTS + NUM_BANKBAGSLOTS do
        for slot = 1, GetContainerNumSlots( bag ) do
            local itemLink = GetContainerItemLink( bag, slot );
            local bagSet = ( bag <= NUM_BAG_SLOTS and bag >= 0 ) and "player" or "bank";

            if( itemLink ) then
                local itemID = LibLordFarlander.GetItemIDFromLink( itemLink );

                for setName, set in pairs( stableSets ) do
                    if( doSwap[setName] ) then
                        for subsetName, subset in pairs( set ) do
                            local doSwapSet = doSwap[subsetName];
                            local value = PetAndMountDatabase:ItemInSet( itemID, subsetName );

                            if( subset.subSet ) then
                                doSwapSet = doSwapSet and doSwap[subset.subSet];
                            end--if
                            if( doSwapSet and ( not NoSwap[itemID] ) and value ) then
                                --Add to the bankEquipment list if equipment of this type is being worn and it is equipment
                                if( subsetName:find( "Equipment" ) and subset.playerEquipment.slot[GetInventorySlotInfo( value )] ) then
                                    local slot = GetInventorySlotInfo( value );

                                    if( not subset.bankEquipment[slot] ) then
                                        subset.bankEquipment[slot] = { bag = {}, slot = {}, num = 0 }
                                    end--if

                                    local petSet = subset.bankEquipment[slot];
                                    local n = petSet.num + 1;
    
                                    petSet.num = n;
                                    petSet.bag[n] = bag;
                                    petSet.slot[n] = slot;
                                else
                                    local petSet = subset[bagSet];
                                    local n = petSet.num + 1;
    
                                    petSet.num = n;
                                    petSet.bag[n] = bag;
                                    petSet.slot[n] = slot;
                                end--if
                            end--if
                        end--for
                    end--if
                end--for
            end--if
        end--for
    end--for
    --Do the swapping
    for setName, set in pairs( stableSets ) do
        if( doSwap[setName] ) then
            for subsetName, subset in pairs( set ) do
                local doSwapSet = doSwap[subsetName];

                if( set.subSet ) then
                    doSwapSet = doSwapSet and doSwap[set.subSet];
                end--if                
                if( doSwapSet ) then
                    self.swapped = self:DoBagSwap( subset ) or self.swapped;
                    self.swapped = self:DoInventorySwap( subset ) or self.swapped;
                end--if
            end--for
        end--if
    end--for
end--Stable:BANKFRAME_OPENED()

------------------------------
--     Helper Functions     --
------------------------------
function Stable:DoBagSwap( set )
    if set.player.num > set.bank.num then
        set.player, set.bank = set.bank, set.player;
    end--if

    local p, b = set.player, set.bank;

    if( p.num == 0 ) then
        return false;
    end--if
    for i = 1, p.num do
        local r = math.random( b.num + 1 - i );

        PickupContainerItem( p.bag[i], p.slot[i] );
        PickupContainerItem( b.bag[r], b.slot[r] );
        table.remove( b.bag, r );
        table.remove( b.slot, r );
    end--for
    return ( p.num > 0 ) and ( b.num > 0 );
end--Stable:DoSwaps( set )

function Stable:DoInventorySwap( set )
    local equipSet = set.playerEquipment;
    local bankSet = set.bankEquipment;
    local bSwapped = false

    if( ( equipSet.num == 0 ) or ( #set.bankEquipment == 0 ) ) then
        return false;
    end--if

    for _, invslot in pairs( equipSet ) do
        local bankSet = set.bankEquipment[invslot];

        if( bankSet and bankSet.num ) then
            local r = math.random( bankSet.num );
    
            PickupContainerItem( bankSet.bag[r], bankSet.slot[r] );
            AutoEquipCursorItem();
            table.remove( bankSet.bag, r );
            table.remove( bankSet.slot, r );
            bSwapped = true;
        end--if
    end--for
    return bSwapped;
end--Stable:DoInventorySwap( type )

