--[[
    Database of all minipets and mounts
    $Revision: 88 $
]]--

--[[
Copyright (c) 2008, LordFarlander
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]--

if( not LibStub( "LibPeriodicTable-3.1", true ) ) then
    error( "PT3 must be loaded before data" );
end--if

if( tonumber( select( 4, GetBuildInfo() ) ) >= 30000 ) then
    LibStub( "LibPeriodicTable-3.1" ):AddData( "PetAndMountDatabase", tostring( tonumber( ("$Rev: 88 $"):match( "%d+" ) ) + 90000 ), {
            ["PetAndMountDatabase.Items.MountEnchant"] = "37750:4,21212:1,21213:5,37816:6,39477:2,39476:3",
            ["PetAndMountDatabase.Critters.Equipment.Head"] = "12185:HEADSLOT,38506:HEADSLOT",
            ["PetAndMountDatabase.Spells.Teleport.Mage.Horde"] = "-3566,-3567,-35715,-32272,-3563,-49358",
            ["PetAndMountDatabase.Critters.Children"] = "31880,31881,18598,18597",
            ["PetAndMountDatabase.Spells.Teleport.Shaman"] = "-556",
            ["PetAndMountDatabase.Mounts.Flying.VeryFast"] = "-43927:280|300,-59996:280|300,-60002:280|300,-59569:280|300,-59571:280|300,33182:280|300,-52649:280|300,-51960:280|300,-39803:280|300,-61229:280|300,-32289:280|300,-41514:280|300,-41516:280|300,-32292:280|300,-32295:280|300,-32296:280|300,-32297:280|300,-61442:280|300,-61444:280|300,-61446:280|300,-43810:280|300,-32242:280|300,-59568:280|300,-59570:280|300,-46199:280|300,-54727:280|300,-39798:280|300,-39800:280|300,-60025:280|300,-44151:280|300,-60024:280|300,-41518:280|300,-61230:280|300,-41513:280|300,-41515:280|300,-59976:280|300,-41517:280|300,-32246:280|300,-32290:280|300,-39802:280|300,-61309:280|300,-59961:280|300,-39801:280|300,-60021:280|300",
            ["PetAndMountDatabase.Spells.Travel.Ground.Shaman"] = "-2645:40",
            ["PetAndMountDatabase.Spells.Teleport.Items.Engineering.Goblin"] = "-36890:30542,-23442:18984",
            ["PetAndMountDatabase.Spells.Travel.Ground.Druid"] = "-783:40",
            ["PetAndMountDatabase.Mounts.Ground.Fast"] = "-17463:60|75,-17464:60|75,-578:60|75,-50869:60|75,-6654:60|75,-18989:60|75,-18990:60|75,-8395:60|75,-35710:60|75,-34769:60|75,-5784:60|75,-25675:60|75,-42776:60|75,-10793:60|75,-35018:60|75,-581:60|75,-16055:60|75,-13819:60|75,-18363:60|75,-10796:60|75,-15780:60|75,-8394:60|75,-34795:60|75,-10792:60|75,-10789:60|75,-10799:60|75,-6648:60|75,-50870:60|75,-17456:60|75,-10873:60|75,-6898:60|75,-580:60|75,-472:60|75,-458:60|75,-6899:60|75,33183:60|75,37011:60|75,-49378:60|75,-33630:60|75,-35711:60|75,-35020:60|75,-35022:60|75,-17453:60|75,-17454:60|75,-459:60|75,-470:60|75,-6777:60|75,-17458:60|75,-34406:60|75,-6653:60|75,-10969:60|75,-17462:60|75,-43899:60|75",
            ["PetAndMountDatabase.Spells.Travel.Ground.Hunter"] = "-5118:30,-13159:30",
            ["PetAndMountDatabase.Mounts.Ground.Slow"] = "33189:0|0,-30174:0|0",
            ["PetAndMountDatabase.Critters.Reagented.Snowball"] = "-26529:17202,-26533:17202,-26045:17202,-26541:17202",
            ["PetAndMountDatabase.Spells.Teleport.Druid"] = "-18960",
            ["PetAndMountDatabase.Spells.Travel.Flying.Druid"] = "-33943:60,-40120:280",
            ["PetAndMountDatabase.Mounts.Flying.ExtremelyFast"] = "-3363:310|300,-58615:310|300,-37015:310|300,-49193:310|300,-32345:310|300,-40192:310|300,-44317:310|300,-44744:310|300",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast"] = "-23338:100|150,-39316:100|150,-16055:100|150,-16056:100|150,-23223:100|150,-22717:100|150,-22719:100|150,-22721:100|150,-22723:100|150,-59799:100|150,-23239:100|150,-23241:100|150,-23243:100|150,-59573:100|150,-23249:100|150,-23251:100|150,-35713:100|150,-49322:100|150,-16080:100|150,-16081:100|150,-16082:100|150,-16083:100|150,-16084:100|150,-39317:100|150,-59788:100|150,-35027:100|150,-17459:100|150,-17461:100|150,-36702:100|150,-17465:100|150,-18991:100|150,-23225:100|150,-46628:100|150,-35025:100|150,-35714:100|150,-35028:100|150,-17481:100|150,-17229:100|75,-60114:100|150,-60118:100|150,-48778:100|75,-48954:100|150,-59793:100|150,-59791:100|150,-23214:100|150,-39318:100|150,-34897:100|150,-23220:100|150,-579:100|150,-23227:100|150,-22718:100|150,-22720:100|150,-49379:100|150,-22724:100|150,-15779:100|150,-24252:100|150,-34790:100|150,-10795:100|150,-43688:100|150,-18992:100|150,-23246:100|150,-23248:100|150,-54753:100|150,-23252:100|150,-34899:100|150,-23510:100|150,-39910:100|150,-23222:100|150,-23228:100|150,-6896:100|150,-60119:100|150,-23240:100|150,-5818:100|150,-42777:100|150,-24242:100|150,-33660:100|150,-39315:100|150,-39319:100|150,-23242:100|150,-23219:100|150,-43900:100|150,-23161:100|150,-34767:100|150,-17450:100|150,-51412:100|150,-23221:100|150,-23250:100|150,-50281:100|150,-17460:100|150,-23229:100|150,-23238:100|150,33184:100|150,-59572:100|150,-34898:100|150,-22722:100|150,-48027:100|150,-35712:100|150,-41252:100|150,-59797:100|150,-23509:100|150,-23247:100|150,-60116:100|150,-34896:100|150,-59785:100|150",
            ["PetAndMountDatabase.Mounts.Variable.Flying"] = "-54729:-1|225",
            ["PetAndMountDatabase.Spells.Teleport.Items.Engineering.Gnomish"] = "-23452:18986,-30544:30544",
            ["PetAndMountDatabase.Mounts.Passenger.Flying.ExtremelyFast"] = "",
            ["PetAndMountDatabase.Mounts.Variable.All"] = "-48025:-1|75",
            ["PetAndMountDatabase.Spells.Teleport.Mage.Alliance"] = "-49359,-33690,-32271,-3561,-3565,-3562",
            ["PetAndMountDatabase.Items.CritterEnchant"] = "35223:1,43352:4,37460:2,37431:3,43626:5",
            ["PetAndMountDatabase.Conversion.Critters"] = "29956:-36028,29958:-36031,29960:-36034,11110:-13548,25535:-42431,31760:-39181,22114:-27241,10360:-10714,10361:-10716,29363:-35156,23015:-28740,12529:-16450,31665:-38842,37297:-48406,29901:-35907,29903:-35910,34535:-10696,20769:-25162,11023:-10685,32588:-40549,8485:-10673,8486:-10674,8487:-10676,8488:-10678,8489:-10679,8490:-10677,8491:-10675,8492:-10683,10398:-12243,23083:-28871,8495:-10684,8496:-10680,8497:-10711,32616:-40614,8499:-10697,37298:-48408,32622:-40634,29957:-36029,15996:-19772,13584:-17708,34425:-54187,30360:-24988,21309:-26045,38628:-51716,27445:-33050,23002:-28738,39656:-53082,19450:-23811,21305:-26541,35350:-46426,8500:-10707,29364:-35239,11826:-15049,21301:-26533,13582:-17709,32233:-39709,12264:-15999,34493:-45127,11027:-10703,33993:-43918,33816:-43697,22235:-27570,11026:-10704,20371:-24696,10822:-10695,21277:-26010,29902:-35909,29904:-35911,4401:-4055,8498:-10698,8494:-10682,32498:-40405,35349:-46425,10392:-10717,33154:-42609,34955:-45890,34492:-45125,10394:-10709,23007:-28739,35504:-46599,11825:-15048,11474:-15067,13583:-17707,23713:-30156,33818:-43698,34478:-45082,8501:-10706,21308:-26529,29953:-36027,38050:-49964,32617:-40613,10393:-10688",
            ["PetAndMountDatabase.Conversion.Mounts"] = "19902:-24252,25528:-32290,29102:-34896,5655:-6648,5656:-458,13322:-17454,13326:-15779,13328:-17461,13332:-17463,13334:-17465,5665:-6653,28915:-39316,5668:-6654,37828:-49379,28927:-34795,12330:-16080,32768:-41252,18241:-22717,29465:-22719,29469:-22724,29222:-35018,29230:-34899,29744:-35710,18787:-23239,28481:-28481,18795:-23248,32314:-39798,32318:-39802,31832:-39317,31836:-39319,25473:-32242,8563:-10873,23720:-30174,34060:-44153,34092:-44744,25529:-32292,8591:-10796,8595:-10969,32857:-41513,32458:-40192,33224:-42776,8627:-10787,8629:-10793,8631:-8394,28936:-33660,18242:-22723,29466:-22718,15277:-18989,29223:-35025,29227:-34896,29231:-34897,29745:-35713,18788:-23241,15293:-18992,18796:-23250,32319:-39803,31829:-39315,31833:-39318,25470:-32235,33225:-42777,19872:-24242,1132:-580,14062:-18363,35600:-3363,29104:-34898,1134:-459,32859:-41515,13317:-17450,13321:-17453,12303:-16055,13327:-17459,13329:-17460,13331:-17462,13333:-17464,13335:-17418,13086:-17229,33999:-43927,35800:-32345,21044:-25675,18243:-22719,18247:-22718,29471:-22723,29220:-35020,29224:-35027,12351:-16081,18777:-23229,29746:-35712,18785:-23240,18789:-23242,18793:-23247,18797:-23251,32316:-39801,37676:-49193,30609:-37015,35226:-46199,34061:-44151,25532:-32296,31830:-39315,31834:-39318,25477:-32246,33976:-43899,2411:-470,25475:-32244,25527:-32289,25533:-32297,25474:-32243,32862:-41518,2414:-472,25471:-32239,32860:-41516,32858:-41514,33809:-43688,29105:-34899,35225:-46197,8586:-16084,8588:-8395,25531:-32295,8592:-10799,25472:-32240,18791:-23246,32861:-41517,21176:-26656,12353:-16083,29228:-34790,18246:-22721,37012:-48025,37719:-49322,18774:-23222,18778:-23228,18773:-23223,35513:-46628,34129:-35028,33977:-43900,18776:-23227,18790:-23243,8628:-10792,18772:-23225,8632:-10789,18786:-23238,5864:-6777,19030:-23510,29103:-34897,30480:-36702,18244:-22720,29468:-22717,29472:-22721,29221:-35022,5872:-6899,5873:-6898,29743:-35711,29747:-35714,15290:-18990,15292:-18991,18794:-23249,18798:-23252,32317:-39800,18902:-23338,18767:-23219,18766:-23221,29229:-34898,12302:-16056,31831:-39317,31835:-39319,35906:-48027,29470:-22722,38576:-51412,25476:-32245,12354:-12354,19029:-23509,18245:-22724,29467:-22720,1041:-578",
            ["PetAndMountDatabase.Critters.Quest"] = "30803:10629,12565:4506,34253:11516",
            ["PetAndMountDatabase.Mounts.Variable.Ground"] = "-58983:-1|75",
            ["PetAndMountDatabase.Spells.Teleport.Translocate"] = "-35727,-30141,-35730,-25649,-25650,-25666,-25140,-25652,-25143,-32568,-35376,-29128,-29129,-26572,-32571,-32572,-45371,-45368,-32569",
            ["PetAndMountDatabase.Mounts.Passenger.Ground.VeryFast"] = "-60424:100|150|2,-59802:100|150|3,-59810:100|150|3,-59811:100|150|3,-59804:100|150|3,-61447:100|150|3,-61425:100|150|3,-60136:100|150|3,-55531:100|150|2,-60140:100|150|3",
            ["PetAndMountDatabase.Spells.Teleport.Mage"] = "-53140",
            ["PetAndMountDatabase.Spells.Travel.Aquatic.Druid"] = "-1066:50",
            ["PetAndMountDatabase.Critters.Normal"] = "-40405,-24988,-13548,-33050,-27570,-48406,-55068,-30152,-40549,-23530,-25849,-40613,-36031,-43697,-17709,-4055,-15648,-16450,-61348,-28738,-28487,-53316,-40319,-40614,-52615,-43698,-42431,-24985,-24989,-61349,-61357,-46599,-48408,-35156,-45125,-23531,-51851,-10674,-10676,-10678,-10680,-10682,-61350,-10688,-40990,-10696,-10698,-10700,-10702,-28739,-10706,-44369,-10712,-10714,-10716,-10718,-45174,-23428,-23432,-36034,-15067,-24986,-24990,-61351,-25018,-35907,-49964,-45127,-46426,-42609,-45175,-23811,-36027,-17707,-45048,-39709,-25162,-28740,-61472,-35239,-36028,-40634,-24987,-35910,-15999,-15048,-10684,-35911,-35909,-10720,-46425,-10704,-58636,-26010,-45082,-35157,-28871,-15049,-26468,-53082,-53768,-43918,-45890,-36029,-38842,-59250,-17708,-10673,-10675,-10677,-10679,-10681,-10683,-10685,-10687,-24696,-51716,-28505,-10695,-10697,-10699,-10701,-10703,-10705,-10707,-10709,-10711,-10713,-10715,-10717,-10719,-10721,-39181,-12243,-23430,-19772,-23431,-30156,-27241,-10710,-54187",
            ["PetAndMountDatabase.Spells.Teleport.Items"] = "-54406:40585|40586,-8690:6948,-46149:35230,-39937:28585",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.TempleOfAhnQiraj"] = "-25863:100|150,-26655:100|150,-26656:100|150,21324:100|75,21321:100|75,21323:100|75,-31700:100|150,21218:100|75",
            ["PetAndMountDatabase.Mounts.Flying.Slow"] = "44221:0|0",
            ["PetAndMountDatabase.Mounts.Flying.Fast"] = "-32244:60|225,-32245:60|225,-54726:60|225,-46197:60|225,33176:60|225,-32239:60|225,-44153:60|225,-48025:60|225,-32243:60|225,-32240:60|225,-32235:60|225",

        -- Shortcuts
            ["PetAndMountDatabase.TempleOfAhnQiraj.Mounts"] = "m,PetAndMountDatabase.Mounts.Ground.VeryFast.TempleOfAhnQiraj",
    } );
else
    LibStub( "LibPeriodicTable-3.1" ):AddData( "PetAndMountDatabase", tostring( tonumber( ("$Rev: 88 $"):match( "%d+" ) ) + 90000 ), {
            ["PetAndMountDatabase.Items.MountEnchant"] = "37750:4,21212:1,21213:5,37816:6,39477:2,39476:3",
            ["PetAndMountDatabase.Critters.Equipment.Head"] = "12185:HEADSLOT,38506:HEADSLOT",
            ["PetAndMountDatabase.Spells.Teleport.Mage.Horde"] = "-3566,-3567,-35715,-32272,-3563,-49358",
            ["PetAndMountDatabase.Critters.Children"] = "31880,31881,18598,18597",
            ["PetAndMountDatabase.Spells.Teleport.Shaman"] = "-556",
            ["PetAndMountDatabase.Mounts.Ground.Slow.Items"] = "33189:0|0,23720:0|0",
            ["PetAndMountDatabase.Spells.Teleport.Items.Engineering.Goblin"] = "-36890:30542,-23442:18984",
            ["PetAndMountDatabase.Spells.Travel.Ground.Druid"] = "-783:40",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.Items"] = "19030:100|150,18778:100|150,34129:100|150,18786:100|150,37828:100|150,18790:100|150,18794:100|150,30480:100|150,29466:100|150,29468:100|150,29470:100|150,29472:100|150,29224:100|150,29228:100|150,29230:100|150,29105:100|150,8586:100|150,29746:100|150,33225:100|150,19872:100|150,33809:100|150,18241:100|150,18243:100|150,18245:100|150,18247:100|150,19902:100|150,12302:100|150,12303:100|150,18767:100|150,18773:100|150,19029:100|150,18777:100|150,13327:100|150,38576:100|150,13329:100|150,18785:100|150,18787:100|150,18789:100|150,18791:100|150,18793:100|150,13335:100|150,29465:100|150,29467:100|150,29469:100|150,29471:100|150,13086:100|75,31833:100|150,29223:100|150,13326:100|150,29227:100|150,29102:100|150,12330:100|150,13317:100|150,18246:100|150,29745:100|150,29747:100|150,37012:100|75,15293:100|150,33977:100|150,37719:100|150,18795:100|150,35513:100|150,28936:100|150,18776:100|150,35906:100|150,33184:100|150,18772:100|150,18788:100|150,29231:100|150,29103:100|150,31836:100|150,31832:100|150,12351:100|150,31834:100|150,12353:100|150,12354:100|150,18902:100|150,18798:100|150,29229:100|150,29104:100|150,31829:100|150,18242:100|150,18244:100|150,31835:100|150,31831:100|150,32768:100|150,28915:100|150,31830:100|150,18797:100|150,18766:100|150,18796:100|150,13334:100|150,15292:100|150,18774:100|150,13328:100|150",
            ["PetAndMountDatabase.Spells.Travel.Ground.Hunter"] = "-5118:30,-13159:30",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.Spells.Paladin.Horde"] = "-34767:100|150",
            ["PetAndMountDatabase.Critters.Reagented.Snowball"] = "21308:17202,21309:17202,21301:17202,21305:17202",
            ["PetAndMountDatabase.Spells.Teleport.Druid"] = "-18960",
            ["PetAndMountDatabase.Mounts.Ground.Fast.Spells.Paladin.Horde"] = "-34769:60|75",
            ["PetAndMountDatabase.Spells.Travel.Flying.Druid"] = "-33943:60,-40120:280",
            ["PetAndMountDatabase.Mounts.Ground.Fast.Spells.Paladin.Alliance"] = "-13819:60|75",
            ["PetAndMountDatabase.Spells.Teleport.Translocate"] = "-35727,-30141,-35730,-25649,-25650,-25666,-25140,-25652,-25143,-32568,-35376,-29128,-29129,-26572,-32571,-32572,-45371,-45368,-32569",
            ["PetAndMountDatabase.Spells.Teleport.Items.Engineering.Gnomish"] = "-23452:18986,-30544:30544",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.Items.TempleOfAhnQiraj"] = "21176:100|150,21324:100|75,21323:100|75,21321:100|75,21218:100|75",
            ["PetAndMountDatabase.Spells.Teleport.Mage.Alliance"] = "-49359,-33690,-32271,-3561,-3565,-3562",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.Spells.Paladin.Alliance"] = "-23214:100|150",
            ["PetAndMountDatabase.Spells.Teleport.Items"] = "-8690:6948,-46149:35230,-39937:28585",
            ["PetAndMountDatabase.Critters.Quest"] = "30803:10629,12565:4506,34253:11516",
            ["PetAndMountDatabase.Spells.Travel.Aquatic.Druid"] = "-1066:50",
            ["PetAndMountDatabase.Mounts.Ground.Fast.Spells.Warlock"] = "-5784:60|75",
            ["PetAndMountDatabase.Spells.Travel.Ground.Shaman"] = "-2645:40",
            ["PetAndMountDatabase.Items.CritterEnchant"] = "35223:1",
            ["PetAndMountDatabase.Mounts.Flying.Fast.Items"] = "25470:60|225,25474:60|225,25471:60|225,25475:60|225,34060:60|225,33176:60|225,25476:60|225,35225:60|225,37012:60|225,25472:60|225",
            ["PetAndMountDatabase.Mounts.Ground.Fast.Items"] = "1132:60|75,37011:60|75,15290:60|75,14062:60|75,5665:60|75,8588:60|75,8591:60|75,8628:60|75,5872:60|75,33976:60|75,8592:60|75,5668:60|75,5873:60|75,8563:60|75,8595:60|75,29220:60|75,29221:60|75,29222:60|75,13322:60|75,8629:60|75,33224:60|75,8632:60|75,5655:60|75,8631:60|75,8627:60|75,2411:60|75,5656:60|75,13321:60|75,1041:60|75,21044:60|75,1134:60|75,2414:60|75,28481:60|75,33183:60|75,29743:60|75,29744:60|75,13331:60|75,28927:60|75,13332:60|75,5864:60|75,13333:60|75,15277:60|75",
            ["PetAndMountDatabase.Mounts.Flying.VeryFast.Items"] = "25477:280|300,33999:280|300,32316:280|300,32857:280|300,32317:280|300,32859:280|300,32860:280|300,32861:280|300,32319:280|300,25529:280|300,25531:280|300,34061:280|300,25532:280|300,37012:280|300,25533:280|300,25527:280|300,35226:280|300,25528:280|300,25473:280|300,33182:280|300,32318:280|300,32862:280|300,32858:280|300,32314:280|300",
            ["PetAndMountDatabase.Mounts.Ground.VeryFast.Spells.Warlock"] = "-23161:100|150",
            ["PetAndMountDatabase.Mounts.Flying.ExtremelyFast.Items"] = "37676:310|300,35600:310|300,30609:310|300,34092:310|300,32458:310|300,35800:310|300",
            ["PetAndMountDatabase.Critters.Normal"] = "29956,29958,29960,11110,25535,31760,22114,10360,10361,29363,23015,12529,31665,37297,29901,29903,34535,20769,11023,32588,8485,8486,8487,8488,8489,8490,8491,8492,10398,23083,8495,8496,8497,32616,8499,37298,32622,29957,15996,13584,34425,30360,38628,27445,23002,39656,19450,35350,29364,11826,13582,32233,12264,34493,11027,33993,33816,22235,11026,20371,10822,21277,29902,29904,4401,8498,8494,32498,35349,10392,33154,34955,34492,10394,23007,35504,11825,11474,13583,23713,33818,34478,8501,8500,29953,38050,32617,10393",

        -- Shortcuts
            ["PetAndMountDatabase.Items.Mounts.Flying.Fast"] = "m,PetAndMountDatabase.Mounts.Flying.Fast.Items",
            ["PetAndMountDatabase.Items.Mounts.Ground.VeryFast"] = "m,PetAndMountDatabase.Mounts.Ground.VeryFast.Items",
            ["PetAndMountDatabase.Spells.Mounts.Ground.VeryFast"] = "m,PetAndMountDatabase.Mounts.Ground.VeryFast.Spells",
            ["PetAndMountDatabase.Items.Mounts.Flying.VeryFast"] = "m,PetAndMountDatabase.Mounts.Flying.VeryFast.Items",
            ["PetAndMountDatabase.MiniPets.Quest"] = "m,PetAndMountDatabase.Critters.Quest",
            ["PetAndMountDatabase.MiniPets.Reagented.Snowball"] = "m,PetAndMountDatabase.Critters.Reagented.Snowball",
            ["PetAndMountDatabase.MiniPets.Equipment.Head"] = "m,PetAndMountDatabase.Critters.Equipment.Head",
            ["PetAndMountDatabase.TempleOfAhnQiraj.Mounts"] = "m,PetAndMountDatabase.Mounts.Ground.VeryFast.Items.TempleOfAhnQiraj",
            ["PetAndMountDatabase.MiniPets.Children"] = "m,PetAndMountDatabase.Critters.Children",
            ["PetAndMountDatabase.Items.Mounts.Ground.Slow"] = "m,PetAndMountDatabase.Mounts.Ground.Slow.Items",
            ["PetAndMountDatabase.Items.Mounts.Flying.ExtremelyFast"] = "m,PetAndMountDatabase.Mounts.Flying.ExtremelyFast.Items",
            ["PetAndMountDatabase.MiniPets.Normal"] = "m,PetAndMountDatabase.Critters.Normal",
            ["PetAndMountDatabase.Items.Mounts.Ground.Fast"] = "m,PetAndMountDatabase.Mounts.Ground.Fast.Items",
            ["PetAndMountDatabase.Items.MiniPets"] = "m,PetAndMountDatabase.Critters",
            ["PetAndMountDatabase.Spells.Mounts.Ground.Fast"] = "m,PetAndMountDatabase.Mounts.Ground.Fast.Spells",
    } );
end--if
