
function SGFunctions.DrawGraph_Button_On_Click()
SGFunctions.GetInputs()
SGFunctions.Load_CalculatedVariables()
SGVariables.XScale = XScale_Slider:GetValue()
SGVariables.YScale = YScale_Slider:GetValue()
SGFunctions.SetGraphAxisLables()
SGFunctions.IncrimentLineNo()
SGFunctions.DrawGraph(SGVariables.XScale , SGVariables.YScale)
end

function SGFunctions.DrawGraph(XScale , YScale)

for GraphXValue = 0 , 1500 do
if (SGVariables.SelectedGraphType == "Spirit") then
SGVariables.GraphSpirit = GraphXValue
else
SGVariables.GraphSpirit = SGVariables.Spirit
end
if (SGVariables.SelectedGraphType == "Intellect") then
SGVariables.GraphIntellect = GraphXValue
else
SGVariables.GraphIntellect = SGVariables.Intellect
end
if (SGVariables.SelectedGraphType == "Fight Length") then
SGVariables.GraphFightLengthTicks = GraphXValue
else
SGVariables.GraphFightLengthTicks = SGVariables.TicksInFight
end
if (SGVariables.SelectedGraphType == "MRC") then
SGVariables.GraphMRC = GraphXValue/SGVariables.XScale
else
SGVariables.GraphMRC = SGVariables.MRC
end

local ManaRegeneration = SGFunctions.GetManaRegen(SGVariables.GraphIntellect , SGVariables.GraphSpirit , SGVariables.BooleanIncludeBaseMana , SGVariables.CurrentManaPool , SGVariables.GraphFightLengthTicks , SGVariables.BangleBoolean , SGVariables.InnervateCount , SGVariables.GraphMRC , SGVariables.PureManaRegenFromItems , SGVariables.AdditionalManaPoolCoefficient)
local PointName = "Point" .. GraphXValue .. "LineNo" .. SGVariables.GraphLineNumber
local XOffset = (((GraphXValue)/XScale)*800)+150
local YOffset = ((ManaRegeneration/YScale)*650)+100
if (getglobal(PointName) == nil) then
local Graphpoint = SG_Graph_1:CreateTexture(PointName, "OVERLAY")
end
local Graphpoint = (getglobal(PointName))
Graphpoint:Show()
if (XOffset > 950) then
Graphpoint:Hide()
end
if (YOffset > 750) then
Graphpoint:Hide()
end
Graphpoint:SetHeight(1)
Graphpoint:SetWidth(1)
Graphpoint:SetTexture(1, 0 , 0.5 , 1)
Graphpoint:SetPoint("BOTTOMLEFT", SG_Graph_1 , "BOTTOMLEFT" , XOffset , YOffset)
end
end


function SGFunctions.ClearGraphs()
for GraphValue = 0 , 1500 do
for GraphLineNumber = 1 , SGVariables.GraphLineNumber do
local name = getglobal("Point" .. GraphValue .. "LineNo" .. GraphLineNumber)
name:Hide()
end
end
SGVariables.GraphLineNumber = 0
end

function SGFunctions.IncrimentLineNo()
SGVariables.GraphLineNumber = SGVariables.GraphLineNumber or 0
SGVariables.GraphLineNumber = SGVariables.GraphLineNumber+1
end

function SGFunctions.IntellectGraphSelect_Button_OnClick()
IntellectGraphSelect_Button:SetChecked(true)
MRCGraphSelect_Button:SetChecked(false)
FightLengthTicksGraphSelect_Button:SetChecked(false)
SpiritGraphSelect_Button:SetChecked(false)
SGVariables.SelectedGraphType = "Intellect"
end

function SGFunctions.SpiritGraphSelect_Button_OnClick()
SpiritGraphSelect_Button:SetChecked(true)
MRCGraphSelect_Button:SetChecked(false)
FightLengthTicksGraphSelect_Button:SetChecked(false)
IntellectGraphSelect_Button:SetChecked(false)
SGVariables.SelectedGraphType = "Spirit"
end

function SGFunctions.FightLengthTicksGraphSelect_Button_OnClick()
FightLengthTicksGraphSelect_Button:SetChecked(true)
MRCGraphSelect_Button:SetChecked(false)
IntellectGraphSelect_Button:SetChecked(false)
SpiritGraphSelect_Button:SetChecked(false)
SGVariables.SelectedGraphType = "Fight Length"
end

function SGFunctions.MRCGraphSelect_Button_OnClick()
MRCGraphSelect_Button:SetChecked(true)
FightLengthTicksGraphSelect_Button:SetChecked(false)
IntellectGraphSelect_Button:SetChecked(false)
SpiritGraphSelect_Button:SetChecked(false)
SGVariables.SelectedGraphType = "MRC"
end

function SGFunctions.SetGraphAxisLables()
local XAxisthreequarter = 0.75*SGVariables.XScale
local XAxisonequarter = 0.25*SGVariables.XScale
local XAxishalf = 0.5*SGVariables.XScale
local YAxisthreequarter = 0.75*SGVariables.YScale
local YAxisonequarter = 0.25*SGVariables.YScale
local YAxishalf = 0.5*SGVariables.YScale
if (SGVariables.SelectedGraphType == "MRC") then
XAxisthreequarter = 0.75
XAxisonequarter = 0.25
XAxishalf = 0.5
end
YAxis_ThreeQuarter_Lable:SetText(YAxisthreequarter)
YAxis_Quarter_Lable:SetText(YAxisonequarter)
YAxis_Half_Lable:SetText(YAxishalf)
XAxis_ThreeQuarter_Lable:SetText(XAxisthreequarter)
XAxis_Quarter_Lable:SetText(XAxisonequarter)
XAxis_Half_Lable:SetText(XAxishalf)
end
