SGConstants = {}
SGConstants.BRMFactor = 0.009327
SGConstants.C = 5*SGConstants.BRMFactor
SGConstants.IntensityRegenRate = 0.3
SGConstants.PrimalMoonClothRegenRate = 0.05
SGConstants.BangleRegenRate = 0.15
SGConstants.BangleProcChance = 0.1
SGConstants.BangleInternalCooldown = 45
SGConstants.BangleProcDuration = 15
SGConstants.BlueDragonProcChance = 0.02
SGConstants.BlueDragonProcDuration = 15
SGConstants.BaseManaRegenFactor = 0.001
SGConstants.MageArmorRegenRate = 0.3
SGConstants.EvocationRegenRate = 0.6
SGConstants.ManaTideTotemRegenRate = 0.24

SGConstants.Spirit_GuideButtonRadius = 78

SGVariables = {}
SGPlayerStats = {}
SGFunctions = {}

-- STANDARD
function SGFunctions.out(text)
DEFAULT_CHAT_FRAME:AddMessage(text, 1.0, 1.0, 0, 1, 10)
UIErrorsFrame:AddMessage(text, 1.0, 1.0, 0, 1, 10) 
end

function SGFunctions.round(n, precision)
  local m = 10^precision
  return floor(m*n + 0.5)/m
end

function SGFunctions.SpiritGuideEventHandler()
if (event == "PLAYER_LOGIN") then
SGFunctions.GetMyStats_OnClick(arg1)
else
end
end

function SGFunctions.Spirit_Guide_OnLoad()

SGFunctions.out("Spirit_Guide_Loaded")
DEFAULT_CHAT_FRAME:AddMessage("To Open Spirit Guide type:", 1.0, 1.0, 0, 1, 10)
DEFAULT_CHAT_FRAME:AddMessage("/sg", 1.0, 1.0, 0, 1, 10)
SLASH_SPIRITGUIDE1 = "/spiritguide";
SLASH_SPIRITGUIDE2 = "/sg";
SlashCmdList["SPIRITGUIDE"] = function(msg)
SGFunctions.Spirit_Guide_SlashCommandHandler(msg)
end
for i=1,20 do
local frame = getglobal("Spirit_Guide" .. i)
if (frame) then
tinsert(UISpecialFrames, frame)
end
end
end

function SGFunctions.Spirit_Guide_SlashCommandHandler(msg)
SGFunctions.out("Spirit_Guide: " .. msg)
if (msg == "0") then
ReloadUI()
end
SGFunctions.Spirit_Guide_Toggle(msg);
end

function SGFunctions.Spirit_Guide_Toggle(num)
local frame = getglobal("Spirit_Guide1")
if (frame) then
if( frame:IsVisible() ) then
frame:Hide()
else
frame:Show()
Fight_Length_Box:SetText("8")
SGFunctions.DruidSelect_Button_OnClick()
InnervateUses_Box:SetText("0")
EvocationCounts_Box:SetText("0")
ManaTideTotemCounts_Box:SetText("0")
ItemMp5_Box:SetText("0")
Intellect_Box:SetText("500")
Spirit_Box:SetText("400")
InnervateWeaponIntellectBonous_Box:SetText("40")
InnervateWeaponSpiritBonous_Box:SetText("40")
IncludeBaseMana_SelectButton:SetChecked(true)
end
end
local frame = getglobal("Spirit_Guide1")
frame:ClearAllPoints()
frame:SetPoint("CENTER" , nil , "CENTER")
local frame = getglobal("Spirit_GuideMainResultsFrame")
frame:ClearAllPoints()
frame:SetPoint("CENTER" , nil , "CENTER")
local frame = getglobal("SG_Graph_1")
frame:ClearAllPoints()
frame:SetPoint("CENTER" , nil , "CENTER")
end

function SGFunctions.HelpButton_OnClick(arg1)
if (Spirit_GuideHelp1:IsVisible() ) then
Spirit_GuideHelp1:Hide();
else
Spirit_GuideHelp1:Show();
end
end

function SGFunctions.ClassSpecificOptions_OnClick()
local Spirit_GuideOptionsFrameToShow = getglobal("Spirit_Guide"..SGVariables.SelectedClass.."Options")
if (Spirit_GuideOptionsFrameToShow:IsVisible() ) then
Spirit_GuideOptionsFrameToShow:Hide()
else
Spirit_GuideOptionsFrameToShow:Show();
end
end

function SGFunctions.AdvancedOptions_OnClick()
if (Spirit_GuideAdvancedOptions:IsVisible() ) then
Spirit_GuideAdvancedOptions:Hide()
else
Spirit_GuideAdvancedOptions:Show()
end
end 

function SGFunctions.GetMyStats_OnClick(arg1)
SGPlayerStats.spirit = UnitStat("Player", 5)
SGPlayerStats.intellect = UnitStat("Player", 4)
Spirit_Box:SetText(SGPlayerStats.spirit)
Intellect_Box:SetText(SGPlayerStats.intellect)
if (IsEquippedItem("Bangle of Endless Blessings")) then
BangleOfBlessings_CheckButton:SetChecked(true)
SGPlayerStats.BangleOfBlessings = 1
else
BangleOfBlessings_CheckButton:SetChecked(false)
SGPlayerStats.BangleOfBlessings = 0
end
if (IsEquippedItem("Darkmoon Card: Blue Dragon")) then
DarkmoonCard_CheckButton:SetChecked(true)
SGPlayerStats.DarkmoonCard = 1
else
DarkmoonCard_CheckButton:SetChecked(false)
SGPlayerStats.DarkmoonCard = 0
end
SGPlayerStats.LocalClass, SGPlayerStats.EnglishClass = UnitClass("player")
if ( SGPlayerStats.EnglishClass == "DRUID" ) then
SGFunctions.Intensity_Check(arg1)
SGFunctions.Dreamstate_Check(arg1)
SGFunctions.DruidSelect_Button_OnClick()
elseif ( SGPlayerStats.EnglishClass == "PRIEST" ) then
SGFunctions.Meditation_Check(arg1)
SGFunctions.PriestSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
elseif ( SGPlayerStats.EnglishClass == "MAGE" ) then
SGFunctions.ArcaneMeditation_Check(arg1)
SGFunctions.MageSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
elseif ( SGPlayerStats.EnglishClass == "PALADIN" ) then
SGFunctions.PaladinSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
elseif ( SGPlayerStats.EnglishClass == "SHAMAN" ) then
SGFunctions.ShamanSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
elseif ( SGPlayerStats.EnglishClass == "WARLOCK" ) then
SGFunctions.WarlockSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
elseif ( SGPlayerStats.EnglishClass == "HUNTER" ) then
SGFunctions.HunterSelect_Button_OnClick()
Dreamstate_CheckButton:SetChecked(false)
else
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
Dreamstate_CheckButton:SetChecked(false)
end
local Mp5PureFromItems = SGFunctions.GetMp5FromItems()
local RoundedMp5PureFromItems = SGFunctions.round(Mp5PureFromItems, 0)
ItemMp5_Box:SetText(RoundedMp5PureFromItems)
end

function SGFunctions.GetMp5FromItems()
SGPlayerStats.ManaRegenPers , SGPlayerStats.CastingManaRegenPers = GetManaRegen()
SGPlayerStats.MP5 = SGFunctions.round((SGPlayerStats.ManaRegenPers*5), 0)
SGPlayerStats.CastingMP5 = SGFunctions.round((SGPlayerStats.CastingManaRegenPers*5), 0)
SGFunctions.GetInputs()
SGFunctions.Load_CalculatedVariables()
local PredictedBaseManaRegenPers = SGFunctions.GetManaRegen(SGVariables.Intellect , SGVariables.Spirit , 0 , SGVariables.CurrentManaPool , SGVariables.TicksInFight , 0 , 0 , 1 , 0 , 0)
local FMp5PureFromItems = SGPlayerStats.MP5-PredictedBaseManaRegenPers
return FMp5PureFromItems
end

-- Mutually exclusive check butons for class

function SGFunctions.PriestSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
PriestSelect_Button:SetChecked(true)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "PRIEST"
ClassSpecificButton:Show()
end
function SGFunctions.WarlockSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
WarlockSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "WARLOCK"
ClassSpecificButton:Hide()
end
function SGFunctions.PaladinSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
PaladinSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "PALADIN"
ClassSpecificButton:Hide()
end
function SGFunctions.HunterSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
HunterSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "HUNTER"
ClassSpecificButton:Hide()
end
function SGFunctions.ShamanSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
ShamanSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "SHAMAN"
ClassSpecificButton:Hide()
end
function SGFunctions.MageSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
MageSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
Intensity_CheckButton:SetChecked(false)
SGVariables.SelectedClass = "MAGE"
ClassSpecificButton:Show()
end
function SGFunctions.DruidSelect_Button_OnClick()
SGFunctions.ClassCheckButtonTasks()
DruidSelect_Button:SetChecked(true)
Meditation_CheckButton:SetChecked(false)
ArcaneMeditation_CheckButton:SetChecked(false)
MageArmor_CheckButton:SetChecked(false)
EvocationCounts_Box:SetText("0")
SGVariables.SelectedClass = "DRUID"
ClassSpecificButton:Show()
end
function SGFunctions.ClassCheckButtonTasks()
PriestSelect_Button:SetChecked(false)
WarlockSelect_Button:SetChecked(false)
PaladinSelect_Button:SetChecked(false)
HunterSelect_Button:SetChecked(false)
ShamanSelect_Button:SetChecked(false)
MageSelect_Button:SetChecked(false)
DruidSelect_Button:SetChecked(false)
Spirit_GuideDRUIDOptions:Hide()
Spirit_GuideHUNTEROptions:Hide()
Spirit_GuideMAGEOptions:Hide()
Spirit_GuidePALADINOptions:Hide()
Spirit_GuideSHAMANOptions:Hide()
Spirit_GuideWARLOCKOptions:Hide()
Spirit_GuidePRIESTOptions:Hide()
end

-- CHECKS

function SGFunctions.Intensity_Check()
local nameTalent, icon, tier, column, currRankIntensity, maxRank= GetTalentInfo(3,6);
if ( currRankIntensity == 3 ) then
Intensity_CheckButton:SetChecked(true);
else
Intensity_CheckButton:SetChecked(false);
end
end

function SGFunctions.Dreamstate_Check()
local nameTalent, icon, tier, column, currRankDreamstate, maxRank= GetTalentInfo(1,17);
if ( currRankDreamstate == 3 ) then
Dreamstate_CheckButton:SetChecked(true);
else
Dreamstate_CheckButton:SetChecked(false);
end
end

function SGFunctions.Meditation_Check()
local nameTalent, icon, tier, column, currRankMeditation, maxRank= GetTalentInfo(1,9);
if ( currRankMeditation == 3 ) then
Meditation_CheckButton:SetChecked(true);
else
Meditation_CheckButton:SetChecked(false);
end
end

function SGFunctions.ArcaneMeditation_Check()
local nameTalent, icon, tier, column, currRankArcaneMeditation, maxRank= GetTalentInfo(1,12);
if ( currRankArcaneMeditation == 3 ) then
ArcaneMeditation_CheckButton:SetChecked(true);
else
ArcaneMeditation_CheckButton:SetChecked(false);
end
end

function SGFunctions.Mooncloth_Check1()
if ((IsEquippedItem("Primal Mooncloth Robe")) and (IsEquippedItem("Primal Mooncloth Shoulders")) and (IsEquippedItem("Primal Mooncloth Belt"))) then
PrimalMooncloth_CheckButton:SetChecked(true)
else
PrimalMooncloth_CheckButton:SetChecked(false)
end
end

function SGFunctions.ValidateChecks()
SGFunctions.GetInputs()
SGFunctions.Load_CalculatedVariables()
if ( SGVariables.Fight_Length > 45 ) then
message("Fight length must be between 0 and 45");
Fight_Length_Box:SetText("8");
elseif ( SGVariables.Fight_Length <= 0 ) then
message("Fight length must be between 0 and 45");
Fight_Length_Box:SetText("8");
elseif ( SGVariables.Fight_Length == nil )then
message("Fight length must be between 0 and 45");
Fight_Length_Box:SetText("8");
elseif ( SGVariables.InnervateCount > 10 ) then
message("Innervate Count must be less than or equal to 10");
InnervateUses_Box:SetText("0");
elseif ( SGVariables.InnervateCount < 0 ) then
message("Innervate Count must be between 0 and 10");
InnervateUses_Box:SetText("0");
elseif ( SGVariables.Intellect > 10000 ) then
message("Intellect must be between 100 and 10000");
Intellect_Box:SetText("100");
elseif ( SGVariables.Intellect < 100 ) then
message("Intellect must be between 100 and 10000");
Intellect_Box:SetText("100");
elseif ( SGVariables.Spirit > 10000 ) then
message("Spirit must be between 100 and 10000");
Spirit_Box:SetText("100");
elseif ( SGVariables.Spirit < 100 ) then
message("Spirit must be between 100 and 10000");
Spirit_Box:SetText("100");
elseif ( SGVariables.PureManaRegenFromItems < 0 ) then
message("Item Based Mp5 must be between 0 and 1000");
ItemMp5_Box:SetText("0");
elseif ( SGVariables.PureManaRegenFromItems > 1000 ) then
message("Item Based Mp5 must be between 0 and 1000");
ItemMp5_Box:SetText("0");
elseif ( SGVariables.EvocationCount > 10 ) then
message("Evocation Count must be less than or equal to 10");
EvocationCounts_Box:SetText("0");
elseif ( SGVariables.ManaTideTotemCount > 10 ) then
message("Mana Tide Totem Count must be less than or equal to 10");
ManaTideTotemCounts_Box:SetText("0");
elseif ( SGVariables.IntellectBoostFromWeapon > 200 ) then
message("Intellect Boost From Innervate Weapon must be less than or equal to 200");
InnervateWeaponIntellectBonous_Box:SetText("40");
elseif ( SGVariables.SpiritBoostFromWeapon > 200 ) then
message("Spirit Boost From Innervate Weapon must be less than or equal to 200");
InnervateWeaponSpiritBonous_Box:SetText("40");
else
SGFunctions.CurrentResults()
SGFunctions.Calculate()
end
end

--Processes

function SGFunctions.GetInputs()
SGVariables.PureManaRegenFromItems = ItemMp5_Box:GetNumber()
SGVariables.IntellectBoostFromWeapon = InnervateWeaponIntellectBonous_Box:GetNumber()
SGVariables.SpiritBoostFromWeapon = InnervateWeaponSpiritBonous_Box:GetNumber()
SGVariables.Fight_Length = Fight_Length_Box:GetNumber()
SGVariables.InnervateCount = InnervateUses_Box:GetNumber()
SGVariables.EvocationCount = EvocationCounts_Box:GetNumber()
SGVariables.ManaTideTotemCount = ManaTideTotemCounts_Box:GetNumber()
SGVariables.Intellect = Intellect_Box:GetNumber()
SGVariables.Spirit = Spirit_Box:GetNumber()
SGVariables.In5SR = 100-(in5SR_Slider:GetValue())
SGVariables.CastFrequency = CastFrequency_Slider:GetValue()
SGVariables.BangleBoolean = BangleOfBlessings_CheckButton:GetChecked() or 0
SGVariables.BlueDragonBoolean = DarkmoonCard_CheckButton:GetChecked()
SGVariables.Intensity_MeditationBoolean = SGFunctions.IntensityMeditation_CheckButtonCheck() 
SGVariables.PrimalMoonclothBoolean = PrimalMooncloth_CheckButton:GetChecked() or 0
SGVariables.DreamstateBoolean = Dreamstate_CheckButton:GetChecked() or 0
SGVariables.MageArmorBoolean = MageArmor_CheckButton:GetChecked() or 0
SGVariables.BooleanIncludeBaseMana = IncludeBaseMana_SelectButton:GetChecked() or 0
end

function SGFunctions.Load_CalculatedVariables()
SGVariables.AdditionalManaPoolCoefficient = (SGVariables.ManaTideTotemCount*SGConstants.ManaTideTotemRegenRate)+(SGVariables.EvocationCount*SGConstants.EvocationRegenRate)
SGVariables.Fight_Length_Seconds = SGVariables.Fight_Length*60
SGVariables.SecondsInnervate = SGVariables.InnervateCount*20
SGVariables.SecondsNoInnervate = SGVariables.Fight_Length_Seconds-SGVariables.SecondsInnervate
SGVariables.PercentInnervate = SGVariables.SecondsInnervate/SGVariables.Fight_Length_Seconds
SGVariables.PercentNoInnervate = SGVariables.SecondsNoInnervate/SGVariables.Fight_Length_Seconds
SGVariables.TicksInFight = SGVariables.Fight_Length_Seconds/5
SGVariables.ManaAt70 = SGFunctions.GetManaAt70(SGVariables.SelectedClass)
SGVariables.CurrentManaPool = 20+((SGVariables.Intellect-20)*15)+SGVariables.ManaAt70
SGVariables.ISRatio = SGVariables.Intellect/SGVariables.Spirit
SGVariables.ManaGainedFromManaTideTotem = SGConstants.ManaTideTotemRegenRate*SGVariables.CurrentManaPool
SGVariables.ManaGainedFromEvocation = SGConstants.EvocationRegenRate*SGVariables.CurrentManaPool

end

function SGFunctions.CurrentResults()
SGVariables.MRC = SGFunctions.Get_MRC(SGVariables.CastFrequency , SGVariables.BangleBoolean , SGVariables.BlueDragonBoolean , SGVariables.In5SR , SGVariables.Intensity_MeditationBoolean , SGVariables.PrimalMoonclothBoolean , SGVariables.MageArmorBoolean)
SGVariables.CurrentManaRegen = SGFunctions.GetManaRegen(SGVariables.Intellect , SGVariables.Spirit , SGVariables.BooleanIncludeBaseMana , SGVariables.CurrentManaPool , SGVariables.TicksInFight , SGVariables.BangleBoolean , SGVariables.InnervateCount , SGVariables.MRC , SGVariables.PureManaRegenFromItems , SGVariables.AdditionalManaPoolCoefficient)
SGVariables.CurrentManaFromInnervate = SGFunctions.ManaReturnFromInnervate(SGVariables.Spirit , SGVariables.Intellect , SGVariables.BangleBoolean)
SGVariables.CurrentManaFromInnervateWithoutBangle = SGFunctions.ManaReturnFromInnervate(SGVariables.Spirit , SGVariables.Intellect , 0)
SGVariables.ManaRegenerated = SGVariables.CurrentManaRegen*SGVariables.TicksInFight
SGFunctions.AdviseMyWeaponType(SGVariables.CurrentManaFromInnervate , SGVariables.CurrentManaPool , SGVariables.IntellectBoostFromWeapon , SGVariables.BangleBoolean , SGVariables.CurrentManaFromInnervateWithoutBangle)
SGVariables.MarginalIntellectPerMP5 , SGVariables.MarginalSpiritPerMP5 = SGFunctions.GetMarginalMP5(SGVariables.Intellect , SGVariables.Spirit , SGVariables.BooleanIncludeBaseMana , SGVariables.CurrentManaPool , SGVariables.TicksInFight , SGVariables.BangleBoolean , SGVariables.InnervateCount , SGVariables.MRC , SGVariables.PureManaRegenFromItems , SGVariables.AdditionalManaPoolCoefficient)
end

function SGFunctions.Get_MRC(CastFrequency , BangleBoolean , BlueDragonBoolean , In5SR , Intensity_MeditationBoolean , PrimalMoonclothBoolean , MageArmorBoolean)
local Out5SR = 100-In5SR
local V_In5SR = In5SR/100
local V_Out5SR = Out5SR/100
SGVariables.PPMBlueDragon = 60/(CastFrequency/SGConstants.BlueDragonProcChance)
SGVariables.PPMBangle = 60/((CastFrequency/SGConstants.BangleProcChance)+SGConstants.BangleInternalCooldown)
--Get % Time Bangle & Blue Dragon Active
if (BangleBoolean == 1) then
SGVariables.PercentTimeBangleActive = (SGVariables.PPMBangle*SGConstants.BangleProcDuration)/60
else
SGVariables.PercentTimeBangleActive = 0
end
if (BlueDragonBoolean == 1) then
SGVariables.PercentTimeBlueDragonActive = 1-((1-SGConstants.BlueDragonProcChance)^(SGConstants.BlueDragonProcDuration/CastFrequency))
else
SGVariables.PercentTimeBlueDragonActive = 0
end
SGVariables.BangleRegenTotal = SGConstants.BangleRegenRate*SGVariables.PercentTimeBangleActive
SGVariables.PercentRegenInside5SR = SGFunctions.Get_PercentRegenInside5SR(Intensity_MeditationBoolean , PrimalMoonclothBoolean , MageArmorBoolean)
SGVariables.PercentTimeBlueDragonInnactive = 1-SGVariables.PercentTimeBlueDragonActive
F_MRC = V_In5SR+(V_Out5SR*(SGVariables.PercentTimeBlueDragonActive+(SGVariables.PercentTimeBlueDragonInnactive*(SGVariables.PercentRegenInside5SR+SGVariables.BangleRegenTotal))))
return F_MRC
end

function SGFunctions.Get_PercentRegenInside5SR(Intensity_MeditationBoolean , PrimalMoonclothBoolean , MageArmorBoolean)
local FPercentRegenInside5SR = 0
if (Intensity_MeditationBoolean == 1) then
FPercentRegenInside5SR = FPercentRegenInside5SR+SGConstants.IntensityRegenRate
end
if (PrimalMoonclothBoolean == 1) then
FPercentRegenInside5SR = FPercentRegenInside5SR+SGConstants.PrimalMoonClothRegenRate
end
if (MageArmorBoolean ==1) then
FPercentRegenInside5SR = FPercentRegenInside5SR+SGConstants.MageArmorRegenRate
end
return FPercentRegenInside5SR
end

function SGFunctions.GetManaRegen(Intellect , Spirit , IncludeBaseManaBoolean , ManaPool , TicksInFight , BangleBoolean , InnervateCount , MRC , PureMp5FromItems , AdditionalManaPoolCoefficient)
local CurrentManaFromInnervate = SGFunctions.ManaReturnFromInnervate(Spirit , Intellect , BangleBoolean)
local CurrentManaFromInnervateWithoutBangle = SGFunctions.ManaReturnFromInnervate(Spirit , Intellect , 0)
local CurrentSpiritBasedRegen = SGFunctions.GetSpiritBasedManaRegen(Intellect , Spirit , TicksInFight , MRC)
local MyDreamstateManaRegen = SGFunctions.DreamstateManaRegen(Intellect)
local AdditionalManaRegenFromSpells = (ManaPool*AdditionalManaPoolCoefficient)/TicksInFight
if (CurrentManaFromInnervate > ManaPool) then
SGVariables.FCurrentManaRegenFromInnervate = ManaPool*InnervateCount/TicksInFight
elseif (InnervateCount > 0 ) then
SGVariables.FCurrentManaRegenFromInnervate = (4*SGVariables.InnervateCount*5*SGConstants.C*(Spirit+(140*BangleBoolean))*(Intellect^0.5))/TicksInFight
else
SGVariables.FCurrentManaRegenFromInnervate = 0
end
return PureMp5FromItems+CurrentSpiritBasedRegen+AdditionalManaRegenFromSpells+SGConstants.BaseManaRegenFactor+MyDreamstateManaRegen+SGVariables.FCurrentManaRegenFromInnervate+(IncludeBaseManaBoolean*ManaPool/TicksInFight)
end

function SGFunctions.GetManaAt70(SelectedClass)
if (SelectedClass == "DRUID") then
SGVariables.ManaAt70 = 2370
elseif (SelectedClass == "PRIEST") then
SGVariables.ManaAt70 = 2940
elseif (SelectedClass == "HUNTER") then
SGVariables.ManaAt70 = 3383
elseif (SelectedClass == "WARLOCK") then
SGVariables.ManaAt70 = 2838
elseif (SelectedClass == "MAGE") then
SGVariables.ManaAt70 = 2241
elseif (SelectedClass == "SHAMAN") then
SGVariables.ManaAt70 = 2958
elseif (SelectedClass == "PALADIN") then
SGVariables.ManaAt70 = 2953
end
return SGVariables.ManaAt70
end

function SGFunctions.IntensityMeditation_CheckButtonCheck()
if (Meditation_CheckButton:GetChecked() == 1) then
SGVariables.FIntensity_MeditationBoolean = 1
elseif (Intensity_CheckButton:GetChecked() == 1) then
SGVariables.FIntensity_MeditationBoolean = 1
elseif (ArcaneMeditation_CheckButton:GetChecked() == 1) then
SGVariables.FIntensity_MeditationBoolean = 1
else
SGVariables.FIntensity_MeditationBoolean = 0
end
return SGVariables.FIntensity_MeditationBoolean
end

function SGFunctions.GetSpiritBasedManaRegen(Intellect , Spirit , TicksInFight , MRC)
SpiritBasedRegen = (MRC*SGConstants.C*Spirit*(Intellect^0.5)*(TicksInFight-(4*SGVariables.InnervateCount)/TicksInFight))/TicksInFight
return SpiritBasedRegen
end

function SGFunctions.DreamstateManaRegen(FIntellect)
if (SGVariables.DreamstateBoolean == 1) then
SGVariables.FMyDreamstateManaRegen = (FIntellect*SGVariables.DreamstateBoolean)/10
else
SGVariables.FMyDreamstateManaRegen = 0
end
return SGVariables.FMyDreamstateManaRegen
end

function SGFunctions.ManaReturnFromInnervate(FSpirit , FIntellect , FBangleBoolean)
SGVariables.FManaFromInnervate = 4*5*SGConstants.C*(FSpirit+(140*FBangleBoolean))*(FIntellect^0.5)
return SGVariables.FManaFromInnervate
end

function SGFunctions.GetMarginalMP5(Intellect , Spirit , IncludeBaseManaBoolean , ManaPool , TicksInFight , BangleBoolean , InnervateCount , MRC , PureMp5FromItems , AdditionalManaPoolCoefficient)
local dblMP5 = SGFunctions.GetManaRegen(Intellect , Spirit , IncludeBaseManaBoolean , ManaPool , TicksInFight , BangleBoolean , InnervateCount , MRC , PureMp5FromItems , AdditionalManaPoolCoefficient)
		
local dblMP5Intellect = SGFunctions.GetManaRegen((Intellect + 1), Spirit , IncludeBaseManaBoolean , ManaPool , TicksInFight , BangleBoolean , InnervateCount , MRC , PureMp5FromItems , AdditionalManaPoolCoefficient)
local dblMarginalIntellectPerMP5 = 1/(dblMP5Intellect - dblMP5)
		
local dblMP5Spirit = SGFunctions.GetManaRegen(Intellect, (Spirit + 1), IncludeBaseManaBoolean , ManaPool , TicksInFight , BangleBoolean , InnervateCount , MRC , PureMp5FromItems , AdditionalManaPoolCoefficient)
local dblMarginalSpiritPerMP5 = 1/(dblMP5Spirit - dblMP5)
		
return dblMarginalIntellectPerMP5 , dblMarginalSpiritPerMP5
end

function SGFunctions.AdviseMyWeaponType(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
if((CurrentManaFromInnervate-ManaPool) >= (IntellectBoostFromWeapon*15)) then
-- if current mana regened from innervate is greater than your mana pool even with int weapon equiped then Check to see if you are using bangle
SGFunctions.AdviseMyWeaponType_TooMuchManaBangleCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
else
--current mana regened from innervate is less than your mana pool with int weapon equiped
--check to see if it wouldnt fill mana bar without int weap equiped
SGFunctions.AdviseMyWeaponType_TooLittleIntellectWeaponCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
end
end

function SGFunctions.AdviseMyWeaponType_TooMuchManaBangleCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
if (BangleBoolean == 1) then
--i am wearing bangle and my mana from innervate is too much, would innervate fill mana bar without bangle equiped?
SGFunctions.AdviseMyWeaponType_TooMuchManaWithoutBangleCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
else
--i am not wearing bangle and my mana from innervate is too much, so i should use a high intellect weapon to get as much as i can out of innervate
SGVariables.InnervateWeaponAdvise = "Use a high intellect weapon to maximise return during innervate"
end
end

function SGFunctions.AdviseMyWeaponType_TooMuchManaWithoutBangleCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
if ((CurrentManaFromInnervateWithoutBangle-ManaPool) >= (IntellectBoostFromWeapon*15)) then
SGVariables.InnervateWeaponAdvise = "Use a High Intellect weapon during innervate and DO NOT use |nbangle in conjunction with innervate, this wastes mana unless |nyou can use it quick"
else
SGVariables.InnervateWeaponAdvise = "Use a High Intellect weapon during innervate"
end
end

function SGFunctions.AdviseMyWeaponType_TooLittleIntellectWeaponCheck(CurrentManaFromInnervate , ManaPool , IntellectBoostFromWeapon , BangleBoolean , CurrentManaFromInnervateWithoutBangle)
if ((CurrentManaFromInnervate-ManaPool) < 0) then
SGVariables.InnervateWeaponAdvise = "Use a High Spirit weapon during innervate"
else
SGVariables.InnervateWeaponAdvise = "Use a weapon with a combination of Intellect and Spirit to |nmaintain your I/S ratio during innervate"
end
end


function SGFunctions.ChooseResultsToShow()
if (SGVariables.InnervateCount > 0) then
ManaReturnFromInnervate_Results:Show()
ManaReturnFromInnervate_ResultsValue:Show()
ManaReturnFromInnervateInfo:Show()
else
ManaReturnFromInnervate_Results:Hide()
ManaReturnFromInnervate_ResultsValue:Hide()
ManaReturnFromInnervateInfo:Hide()
end
if (SGVariables.ManaTideTotemCount > 0) then
ManaReturnFromManaTideTotem_Results:Show()
ManaReturnFromManaTideTotem_ResultsValue:Show()
ManaReturnFromManaTideTotemInfo:Show()
else
ManaReturnFromManaTideTotem_Results:Hide()
ManaReturnFromManaTideTotem_ResultsValue:Hide()
ManaReturnFromManaTideTotemInfo:Hide()
end
if (SGVariables.EvocationCount > 0) then
ManaReturnFromEvocation_Results:Show()
ManaReturnFromEvocation_ResultsValue:Show()
ManaReturnFromEvocationInfo:Show()
else
ManaReturnFromEvocation_Results:Hide()
ManaReturnFromEvocation_ResultsValue:Hide()
ManaReturnFromEvocationInfo:Hide()
end
if (BangleBoolean == 1) then
PercentTimeBangleActive_Results:Show()
PercentTimeBangleActive_ResultsValue:Show()
PercentTimeBangleActiveInfo:Show()
else
PercentTimeBangleActive_Results:Hide()
PercentTimeBangleActive_ResultsValue:Hide()
PercentTimeBangleActiveInfo:Hide()
end
if (BlueDragonBoolean == 1) then
PercentTimeBlueDragonActive_Results:Show()
PercentTimeBlueDragonActive_ResultsValue:Show()
PercentTimeBlueDragonActiveInfo:Show()
else
PercentTimeBlueDragonActive_Results:Hide()
PercentTimeBlueDragonActive_ResultsValue:Hide()
PercentTimeBlueDragonActiveInfo:Hide()
end
end

function SGFunctions.Calculate()
local RoundedSpirit_GuideMRC = SGFunctions.round(SGVariables.MRC, 3)
MRC_Results:SetText("MRC:")
MRC_ResultsValue:SetText(RoundedSpirit_GuideMRC)

local RoundedSG_CurrentManaRegen = SGFunctions.round(SGVariables.CurrentManaRegen, 0)
ManaRegen_Results:SetText("Mana Regeneration (Mp5):")
ManaRegen_ResultsValue:SetText(RoundedSG_CurrentManaRegen)

local RoundedSG_ManaRegenerated = SGFunctions.round(SGVariables.ManaRegenerated, 0)
ManaRegenerated_Results:SetText("Mana Regenerated Over Fight:")
ManaRegenerated_ResultsValue:SetText(RoundedSG_ManaRegenerated)

ManaPool_Results:SetText("Mana Pool:")
ManaPool_ResultsValue:SetText(SGVariables.CurrentManaPool)

local RoundedCurrentManaFromInnervate = SGFunctions.round(SGVariables.CurrentManaFromInnervate, 0)
ManaReturnFromInnervate_Results:SetText("Mana Return From Innervate:")
ManaReturnFromInnervate_ResultsValue:SetText(RoundedCurrentManaFromInnervate)

local RoundedManaGainedFromManaTideTotem = SGFunctions.round(SGVariables.ManaGainedFromManaTideTotem, 0)
ManaReturnFromManaTideTotem_Results:SetText("Mana Return From Mana Tide Totem:")
ManaReturnFromManaTideTotem_ResultsValue:SetText(RoundedManaGainedFromManaTideTotem)

local RoundedManaGainedFromEvocation = SGFunctions.round(SGVariables.ManaGainedFromEvocation, 0)
ManaReturnFromEvocation_Results:SetText("Mana Return From Evocation:")
ManaReturnFromEvocation_ResultsValue:SetText(RoundedManaGainedFromEvocation)

local RoundedPercentTimeBangleActive = SGFunctions.round((SGVariables.PercentTimeBangleActive*100), 1)
PercentTimeBangleActive_Results:SetText("Percent of time Bangle is Active:")
PercentTimeBangleActive_ResultsValue:SetText(RoundedPercentTimeBangleActive.." %")

local RoundedPercentTimeBlueDragonActive = SGFunctions.round((SGVariables.PercentTimeBlueDragonActive*100), 1)
PercentTimeBlueDragonActive_Results:SetText("Percent of time Blue Dragon is Active:")
PercentTimeBlueDragonActive_ResultsValue:SetText(RoundedPercentTimeBlueDragonActive.." %")

InnervateWeaponAdvice_Results:SetText("Innervate Weapon Advice:   |n|n" .. SGVariables.InnervateWeaponAdvise)

local RoundedISRatio = SGFunctions.round(SGVariables.ISRatio, 2)
IntSpiRatio_Results:SetText("Intellect/Spirit Ratio:")
IntSpiRatio_ResultsValue:SetText(RoundedISRatio)

local RoundedMarginalMarginalIntellectPerMP5 = SGFunctions.round(SGVariables.MarginalIntellectPerMP5, 2)
local RoundedMarginalSpiritPerMP5 = SGFunctions.round(SGVariables.MarginalSpiritPerMP5, 2)
MarginalMp5_Results:SetText("1 Mp5 equals:")
MarginalMp5_ResultsValue:SetText(RoundedMarginalMarginalIntellectPerMP5 .. " Intellect, Or " .. RoundedMarginalSpiritPerMP5 .. " Spirit" )

SGFunctions.ChooseResultsToShow()
Spirit_GuideMainResultsFrame:Show()
end

function SGFunctions.OptionsButton_On_Click()
Spirit_GuideOptions:Show()
end
