--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]

--Note to those who wish to help localize this addon. Just copy and paste
--everthing below, and just translate the words/sentences inside quotes.

--General Things You Need to Know:

--These "--" that I put before these sentences on every new line are called
--comment prefixes. They make sure these "comments" are not considered
--"code" by the game.

--I use colors for some of these, for example: "|cff00ff00Blah|r". Just ignore
--the parts having to do with color (|cff00ff00 and |r) and just change the
--words (Blah).

--'\n' means start a new line.

--When a line is longer than 80 characters I break the sentence up so it's more
--readable. I do this by "concatenating" the strings using "..". You'll see
--this as something like: K = "Dogs".." bark"
--This becomes internally: "Dogs bark"

--Sometimes so I can dynamically create a string, I use symbols such as "%s" or
--"%d" to represent a string of characters or a number respectively. I will
--usually describe to you how I'm using these so you can make sure your
--sentences are syntactically correct.
--For example, if I have: SC_GROUPS = "Group %d"
--I will internally make this become something like: "Group 5" or "Group 4"

--Finally, if you are confused by any of this but would like to help, please
--give me an e-mail at batrick@unm.edu


if GetLocale() ~= "frFR" then return end;

SC_Localized = true;

--==========================
--Setting up the environment
--==========================

local Spellcraft = Spellcraft or { };
local _G = getfenv(0);

Spellcraft.name = "Spellcraft";

_G[Spellcraft.name] = Spellcraft;

setmetatable(Spellcraft, getmetatable(Spellcraft) or {__index = _G});
setfenv(1, Spellcraft);


--=======
--MODULES
--=======

SC_ENABLED = "Activ\195\169 ";
SC_DISABLED = "D\195\169sactiv\195\169 ";
SC_MODULE_BANDAGE = "Bandage";
SC_MODULE_BUFFS = "Buffs";
SC_MODULE_BUTTONS = "Boutons";
SC_MODULE_COLLECT = "R\195\169cup\195\169ration";
SC_MODULE_EVOCATE = "Evocation";
SC_MODULE_INVISIBILITY = "Invisibilit\195\169";
SC_MODULE_MERCHANT = "Marchand";
SC_MODULE_MINIMAP = "Minicarte";
SC_MODULE_POLY = "M\195\169tamorphose";
SC_MODULE_RELEASE = "Lib\195\169rer";
SC_MODULE_MOUNT = "Mount";-- Translate

SC_MODULE_MOUNT_INFO = "Automatically equips trinkets that increase"..
    " your mount speed when are mounted.";--Translate
SC_MODULE_BANDAGE_INFO = "Pr\195\169vient les soigneurs que vous appliquez un "..
    "bandage.";
SC_MODULE_BUFFS_INFO = "Interface pour buffer les groupes intelligemment."
SC_MODULE_BUTTONS_INFO = "Cr\195\169\195\169 des boutons pour les gemmes de Mana, "..
    "Boisson, etc.";
SC_MODULE_COLLECT_INFO = "R\195\169cup\195\168re et lib\195\168re la m\195\169moire utilis\195\169e par les "..
    "addons quand le personnge meurt.";
SC_MODULE_EVOCATE_INFO = "Maximise Intelligence en changeant d'armes avant et "..
    "apr\195\168s l'\195\169vocation.";
SC_MODULE_INVISIBILITY_INFO = "Permet d'\195\180ter l'armure lorsque l'on \195\169chappe "..
	"\195\160 un combat gr\195\162ce \195\160 l'invisibilit\195\169 (ex : pendant un wipe).";
SC_MODULE_MERCHANT_INFO = "Facilite l'achat de composants, la r\195\169paration, "..
	"et la vente d'objets gris.";
SC_MODULE_MINIMAP_INFO = "Ajoute un bouton \195\160 la minicarte pour les portails "..
	"et les am\195\169liorations.";
SC_MODULE_POLY_INFO = "Automatise certains messages lorsque vous m\195\169tamorphosez "..
	"un ennemi.";
SC_MODULE_RELEASE_INFO = "Lib\195\168re automatiquement l'esprit quand le personnage "..
	"meurt sur un champ de bataille.";


--====
--MISC
--====

SC_GROUP = "Groupe";
SC_BETA = "Ceci est une version BETA. Veuillez Signaler tout bogue "..
    "\195\160 curse-gaming.com.";
SC_RELOAD = "Certains r\195\169glages n\195\169cessitent le red\195\169marrage de l'UI. Voulez-vous "..
	"recharger votre UI ?";
GOLD = "Gold"; -- Translate
SILVER = "Silver"; -- Translate
COPPER = "Copper"; -- Translate


--======
--SPELLS
--======

SC_SPELL_EVOCATION = "Evocation";
SC_SPELL_TELEPORT_STORMWIND = "T\195\169l\195\169portation\194\160: Hurlevent";
SC_SPELL_TELEPORT_IRONFORGE = "T\195\169l\195\169portation\194\160: Forgefer";
SC_SPELL_TELEPORT_EXODAR = "T\195\169l\195\169portation\194\160: Exodar";
SC_SPELL_TELEPORT_DARNASSUS = "T\195\169l\195\169portation\194\160: Darnassus";
SC_SPELL_TELEPORT_THERAMORE = "T\195\169l\195\169portation\194\160: Theramore";
SC_SPELL_PORTAL_STORMWIND = "Portail\194\160: Hurlevent";
SC_SPELL_PORTAL_IRONFORGE = "Portail\194\160: Forgefer";
SC_SPELL_PORTAL_EXODAR = "Portail\194\160: Exodar";
SC_SPELL_PORTAL_DARNASSUS = "Portail\194\160: Darnassus";
SC_SPELL_PORTAL_THERAMORE = "Portail\194\160: Theramore";

SC_SPELL_TELEPORT_ORGRIMMAR = "T\195\169l\195\169portation\194\160: Orgrimmar";
SC_SPELL_TELEPORT_UNDERCITY = "T\195\169l\195\169portation\194\160: Fossoyeuse";
SC_SPELL_TELEPORT_SILVERMOON = "T\195\169l\195\169portation\194\160: Lune-d'argent";
SC_SPELL_TELEPORT_THUNDER = "T\195\169l\195\169portation\194\160: les Pitons du Tonnerre";
SC_SPELL_TELEPORT_STONARD = "T\195\169l\195\169portation\194\160: Stonard";
SC_SPELL_PORTAL_ORGRIMMAR = "Portail\194\160: Orgrimmar";
SC_SPELL_PORTAL_UNDERCITY = "Portail\194\160: Fossoyeuse";
SC_SPELL_PORTAL_SILVERMOON = "Portail\194\160: Lune-d'argent";
SC_SPELL_PORTAL_THUNDER = "Portail\194\160: les Pitons du Tonnerre";
SC_SPELL_PORTAL_STONARD = "Portail\194\160: Stonard";

SC_SPELL_TELEPORT_SHATTRATH = "T\195\169l\195\169portation\194\160: Shattrath";
SC_SPELL_PORTAL_SHATTRATH = "Portail\194\160: Shattrath";

SC_SPELL_AI = "Intelligence des arcanes";
SC_SPELL_AB = "Illumination des arcanes";

SC_SPELL_POLY = "Polymorph";--Translate
SC_SPELL_TURTLE = "Polymorph: Turtle";--Translate
SC_SPELL_PIG = "Polymorph: Pig";--Translate


--=====
--Items
--=====

SC_TIME_REMAINING = "Temps de recharge : ";

SC_HEARTH = "Pierre de foyer";


--=======
--Weapons
--=======

SC_WEAPON_TH = "Deux mains";
SC_WEAPON_ONEH = "\195\128 une main";
SC_WEAPON_MH = "Main droite";
SC_WEAPON_OH = "Main gauche";
SC_WEAPON_W = "\195\128 distance";


--========
--Reagents
--========

SC_REAGENT_MAGE_POWDER = "Poudre des arcanes";
SC_REAGENT_MAGE_TELE = "Rune de t\195\169l\195\169portation";
SC_REAGENT_MAGE_PORT = "Rune des portails";

SC_REAGENT_PRIEST_HOLY = "Bougie sanctifi\195\169e";
SC_REAGENT_PRIEST_SACRED = "Bougie sacr\195\169e";

SC_REAGENT_DRUID_MAPLE = "Graine d'\195\169rable";
SC_REAGENT_DRUID_STRANGLE = "Graine de strangleronce";
SC_REAGENT_DRUID_ASH = "Graine de fr\195\168ne";
SC_REAGENT_DRUID_HORN = "Graine de charme";
SC_REAGENT_DRUID_IRON = "Graine de bois de fer";
SC_REAGENT_DRUID_FLINT = "Graine d'herbe-silex";
SC_REAGENT_DRUID_BERRIES = "Baies sauvages";
SC_REAGENT_DRUID_THORN = "Ronceterre sauvage";
SC_REAGENT_DRUID_QUILL = "Vigneplume sauvage";

SC_REAGENT_PALADIN_KINGS = "Symbole des rois";
SC_REAGENT_PALADIN_DIVINITY = "Symbole de divinit\195\169";

SC_REAGENT_SHAMAN_ANKH = "Ankh";

SC_REAGENT_WARLOCK_INFERNAL = "Pierre infernale";
SC_REAGENT_WARLOCK_DEMONIC = "Figurine d\195\169moniaque";


--=====
--NOTES
--=====

SC_NAME = "Spellcraft";
SC_LOADED = "Activ\195\169. Configurez avec /sc."

SC_MAIN_NOTEB = "Vous pouvez afficher cette fen\195\170tre avec /sc ou /spellcraft";

SC_MAIN_GENERAL = "G\195\169n\195\169ral";
SC_MAIN_GENERAL_OPTIONS = "Options";
SC_MAIN_GENERAL_MODULES = "Active/D\195\169sactive les modules";
SC_MAIN_GENERAL_DEFAULTS = "R\195\169initialiser les r\195\169gages de TOUS les modules ?\n"..
	"Cela rechargera votre UI.";
SC_MAIN_GENERAL_OPTION1 = "Recevoir des messages d'information ?";

SC_MAIN_POLY = "M\195\169tamorphose";
SC_MAIN_POLY_OPTION1 = "Automatiser l'envoi de messages \195\160 qui cible votre "..
	"mouton ?";
SC_MAIN_POLY_OPTION2 = "Poursuivre la surveillance durant toute la dur\195\169e de "..
	"la transformation ?"
SC_MAIN_POLY_OPTION3 = "Chuchoter \195\160 qui cible votre mouton pendant "..
	"l'incantation du sort ?";
SC_MAIN_POLY_OPTION4 = "Envoyer un message \195\160 votre groupe ?";
SC_MAIN_POLY_OPTION5 = "Envoyer un message \195\160 votre raid ?";
SC_MAIN_POLY_OPTION6 = "Announce who broke your sheep in Party/Raid?";
                                                          -- Translate
SC_MAIN_POLY_SLIDERSTATE1 = "Message chuchot\195\169 pendant l'incantation.";
SC_MAIN_POLY_SLIDERSTATE2 = "Message chuchot\195\169 \195\160 qui cible le mouton.";
SC_MAIN_POLY_SLIDERSTATE3 = "Message de groupe";
SC_MAIN_POLY_SLIDERSTATE4 = "Message de raid";
SC_MAIN_POLY_SCROLLNOTE = "Cliquer sur un message pour l'\195\169diter.";
SC_MAIN_POLY_EDITFRAME_REMOVE = "Supprimer";
SC_MAIN_POLY_EDIT = "Edition : ";
SC_MAIN_POLY_DEFAULTS = "R\195\169initialiser les r\195\169glages de M\195\169tamorphose ?";
SC_MAIN_POLY_EDITFRAMENOTE = "Edition du message";
SC_MAIN_POLY_EDITFRAMENOTE2 = "Nouveau message";
SC_MAIN_POLY_ADDMSG = "Ajouter";

SC_MAIN_MERCHANT = "Marchand";
SC_MAIN_MERCHANT_OPTION1 = "D\195\169sactiver les confirmations pour les achats, "..
	"ventes, et r\195\169parations ? (mode silencieux)";
SC_MAIN_MERCHANT_OPTION2 = "Activer les notifications lorsque le nombre de composants est faible ?";

SC_MINIMAP_TOOLTIP = "Spellcraft\n|cFF4422FFClic-gauche pour les portails|r\n"..
    "|cFFAAAAFFClic-droit pour d\195\169placer ce bouton|r";
SC_MINIMAP_ALLIANCEPORT = "Portails de l'Alliance";
SC_MINIMAP_HORDEPORT = "Portails de la Horde";
SC_MINIMAP_GENERALPORT = "Portails G\195\169n\195\169raux";
SC_MINIMAP_HEARTH = "Activer le bouton de la Pierre de foyer ?";

SC_BUFFS_TOOLTIP = "Am\195\169liorations (%s)\nClic-gauche ouvre le menu des "..
	"am\195\169liorations\n"..
	"Clic-droit am\195\169liore le groupe %d (%d ont besoin d'Intelligence)\n"..
	"Shift + Clic-gauche am\195\169liore %s (%s)";
	           -- First %s = "Unlocked" or "Locked"
               -- First %d = Group Number
               -- Second %d = Number of players in a group that need AI
               -- Third %s = A Player's Name

SC_BUFFS_GROUP_TOOLTIP = "Groupe %d :\nClic-gauche ouvre la fen\195\170tre du groupe.\n"..
	"Shift + Clic-gauche incante Intelligence sur %s.\n"..
	"Clic-droit incante Intelligence sur ce groupe.";
    			-- %d = Group Number
                -- %s = A Player Name
SC_BUFFS_AI = "Clic-gauche pour incanter Intelligence sur %s.";
    --%s = Player
SC_BUFFS_LOCKED = "Verrouill\195\169";
SC_BUFFS_UNLOCKED = "D\195\169v\195\169rouill\195\169";

SC_INVIS_GEAROFF = "Spellcraft: vous avez quitt\195\169 un combat en vous rendant "..
	"invisible alors que vous \195\169tiez en groupe.";
SC_INVIS_GEAROFF2 = "Voulez-vous enlever votre \195\169quipement ?";
SC_INVIS_GEARON = "Voulez-vous remettre votre \195\169quipement ?";
SC_INVIS_GEARON2 = "Note : vous pouvez aussi utiliser /gearon.";

SC_MERCHANT_GRAY = "Vendre tous vos objets gris ?";
SC_MERCHANT_REPAIR = "R\195\169parer l'\195\169quipement ?";
SC_MERCHANT_REAGENT = "Acheter des composants ?";

SC_REAGENT_CHANGE = "Modifier la quantit\195\169 maximale\nde composants \195\160 acheter ?";
SC_REAGENT_CHANGE2 = "Modifier la quantit\195\169 maximale de composants \195\160 acheter :";
SC_REAGENT_CHANGE3 = "Note : /changereagent r\195\169affiche cette fen\195\170tre.";


--========
--MESSAGES
--========

SC_MSG_ERROR_MONEY = "Vous n'avez pas assez d'argent pour r\195\169parer.";
SC_MSG_REAGENTS_NEED = "Vous devriez racheter des composants.";
SC_MSG_SILENT_REAGENT = "Achat de composants.";
SC_MSG_SETTINGS_COMBAT = "Impossible de modifier les r\195\169glages durant un combat.";
SC_MSG_POLY_PERCENT_ERROR = "Le pourcentage ne peut pas \195\170tre de '0'";
SC_MSG_RESET = "R\195\169initialisation des options en raison d'une incompatibilit\195\169 "..
	"de version.";
SC_MSG_VERSION_UPDATE = "Mise \195\160 jour de la structure des composants ; R\195\169glages "..
	"des composants r\195\169initialis\195\169s.";
SC_MSG_CHANGEREAGENT_ERROR = "Le nombre maximal de composants est invalide. "..
	"Veuillez utiliser /changereagent pour modifier cette valeur : ";
SC_MSG_NAKED_ERROR = "Impossible d'enlever l'\195\169quipement en combat.";
SC_MSG_EQUIP_ERROR = "Impossible de remettre l'\195\169quipement en combat.";
SC_MSG_TELEPORT_ERROR = "Impossible d'incanter un sort de t\195\169l\195\169portation en "..
	"combat";
SC_MSG_WIPE = "On se d\195\169nude !";
SC_MSG_CREAGENT_ERROR = "Le nombre maximal de composants est invalide. "..
	"Veuillez utiliser /changereagent pour modifier cette valeur : ";
SC_MSG_GRAYTRASH = "Vente des objets gris : ";
SC_MSG_EVOCATE = "Evocation : changement d'armes pour maximiser Intelligence.";
SC_MSG_DEEVOCATE = "Evocation termin\195\169e : retour aux armes d'origine.";
SC_MSG_POLYM_ERROR = "Usage : /polym [option]\n"..
 	"Options : config = ouvre le panneau de configration de M\195\169tamorphose.\n"..
    "          t      = envoie un message \195\160 ceux qui ciblent votre cible.\n"..
    "          f      = envoie un message \195\160 ceux qui ciblent votre focus.\n"..
    "Utiliser cette commande uniquement si les messages automatiques sont "..
	"d\195\169sactiv\195\169es !";
SC_MSG_EVOCATE_ERROR = "Vous n'avez pas le contr\195\180le de votre "..
    "personnage ; Impossible de se r\195\169\195\169quiper pour le moment.";
SC_MSG_GARBAGE = "Optimisation de la m\195\169moire.";
SC_MSG_POLY_BREAK = "Votre m\195\169tamorphose a \195\169t\195\169 "..
    "annul\195\169e par %s's %s.";-- %s = Player who broke it
SC_MSG_POLY_BREAK_MELEE = "Votre m\195\169tamorphose a \195\169t\195\169 "..
    "annul\195\169e par %s's degats de melee.";
SC_MSG_POLY_BREAK_ANN = "%s's  m\195\169tamorphose a \195\169t\195\169 "..
    "annul\195\169e par %s's %s.";
                                        -- First %s = Player
                                        -- Second %s = Player who broke it
                                        -- Translate
SC_MSG_POLY_BREAK_ANN_MELEE = "%s's m\195\169tamorphose a \195\169t\195\169 "..
    "annul\195\169e par %s's degats de melee.";

SC_MSG_POLY_SAYINGS_ERROR = "Vous n'avez pas de message de M\195\169tamorphose pour "..
	"%t. Veuillez d\195\169sactiver les messages de type %s \195\160 l'aide de /poly config, "..
    "retourner aux r\195\169glages par d\195\169faut, ou ajouter le v\195\180tres."
     -- Both %s = "Whisper" or "Party" or "Raid"

SC_MSG_ERROR = "Spellcraft a d\195\169tect\195\169 une erreur !\n"..
    "Ev\195\168nement re\195\167u : %s.\nErreur :\n%s\nSuivi de pile :\n%s";-- First %s = The Event
                                  -- Second %s = Error Message
                                  -- Third %s = Stack Trace

--========
--WHISPERS
--========

SC_WHISPER_POLY_DEFAULT1 = "**Attention !** Je vais métamorphoser ta cible !";-- \195\169

SC_WHISPER_BANDAGE = "Je m'applique un bandage ! Economise la Mana!";


--=====
--PARTY
--=====


SC_PARTY_POLY_DEFAULT1 = "Je m\195\169tamorphose %t. Laissez-le tranquille.";
SC_PARTY_POLY_DEFAULT2 = "Les boules de feu sont rouges, les \195\169clairs de givre "..
	"bleus. Touche \195\160 mon mouton et ton compte est bon.";
SC_PARTY_POLY_DEFAULT3 = "Je moutonne %t. Tu le casses, tu le tankes.";

SC_PARTY_BANDAGE = "Je m'applique un bandage ! Economisez votre Mana !";

--====
--Raid
--====

SC_RAID_POLY_DEFAULT1 = ">>>> Je m\195\169tamorphose %t. <<<<";

--=====
--Sheep
--=====

SC_SHEEP_POLY_DEFAULT1 = "Tu cibles un mob m\195\169tamorphos\195\169 ! Change de cible !";

--======
--CITIES
--======

SC_CITY_SHATTRATH = "Shattrath";

SC_CITY_ALLIANCE_STORMWIND = "Hurlevent";
SC_CITY_ALLIANCE_IRONFORGE = "Forgefer";
SC_CITY_ALLIANCE_EXODAR = "Exodar";
SC_CITY_ALLIANCE_DARNASSUS = "Darnassus";
SC_CITY_ALLIANCE_THERAMORE = "Theramore";

SC_CITY_HORDE_ORGRIMMAR = "Orgrimmar";
SC_CITY_HORDE_UNDERCITY = "Fossoyeuse";
SC_CITY_HORDE_SILVERMOON = "Lune-d'argent";
SC_CITY_HORDE_THUNDER = "les Pitons du Tonnerre";
SC_CITY_HORDE_STONARD = "Stonard";


--=====
--ZONES
--=====

SC_ZONE_ALTERACVALLEY = "Vall\195\169e d'Alterac";
SC_ZONE_WARSONG = "Goulet des Chanteguerre";
SC_ZONE_ARATHIBASIN = "Bassin d'Arathi";
SC_ZONE_EYE = "L'Oeil du Cyclone";


--=====
--Buffs
--=====

SC_BUFF_SELF_INVIS = "Invisibilit\195\169";
SC_BUFF_SELF_DETECTINVIS = "D\195\169tecte Invisibilit\195\169 %w* *"; -- The '%w*' and
                                          -- ' *' allow us to
                                          -- catch "Detect Invisibility" and
                                          -- "Detect Lesser Invisibility".
                                          -- Put "%w* *" wherever 'Lesser' would
                                          -- appear in the buff.
SC_DEBUFF_OTHER_POLY = "M\195\169tamorphose";
SC_DEBUFF_SELF_FA = "Premiers soins";
