--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]

--Note to those who wish to help localize this addon. Just copy and paste
--everthing below, and just translate the words/sentences inside quotes.

--General Things You Need to Know:

--These "--" that I put before these sentences on every new line are called
--comment prefixes. They make sure these "comments" are not considered
--"code" by the game.

--I use colors for some of these, for example: "|cff00ff00Blah|r". Just ignore
--the parts having to do with color (|cff00ff00 and |r) and just change the
--words (Blah).

--'\n' means start a new line.

--When a line is longer than 80 characters I break the sentence up so it's more
--readable. I do this by "concatenating" the strings using "..". You'll see
--this as something like: K = "Dogs".." bark"
--This becomes internally: "Dogs bark"

--Sometimes, so I can dynamically create a string, I use symbols such as "%s" or
--"%d" to represent a string of characters or a number respectively. I will
--usually describe to you how I'm using these so you can make sure your
--sentences are syntactically correct.
--For example, if I have: SC_GROUPS = "Group %d"
--I will internally make this become something like: "Group 5" or "Group 4"

--Finally, if you are confused by any of this but would like to help, please
--give me an e-mail at batrick@unm.edu


if SC_Localized then SC_Localized = nil; return end;

--==========================
--Setting up the environment
--==========================

local Spellcraft = Spellcraft or { };
local _G = getfenv(0);

Spellcraft.name = "Spellcraft";

_G[Spellcraft.name] = Spellcraft;

setmetatable(Spellcraft, getmetatable(module) or {__index = _G});
setfenv(1, Spellcraft);


--=======
--MODULES
--=======

SC_ENABLED = "Enabled";
SC_DISABLED = "Disabled";
SC_MODULE_BANDAGE = "Bandage";
SC_MODULE_BUFFS = "Buffs";
SC_MODULE_BUTTONS = "Buttons";
SC_MODULE_COLLECT = "Collect";
SC_MODULE_EVOCATE = "Evocate";
SC_MODULE_INVISIBILITY = "Invisibility";
SC_MODULE_MERCHANT = "Merchant";
SC_MODULE_MINIMAP = "Minimap";
SC_MODULE_POLY = "Poly";
SC_MODULE_RELEASE = "Release";
SC_MODULE_MOUNT = "Mount";

SC_MODULE_MOUNT_INFO = "Automatically equips trinkets that increase"..
    " your mount speed when are mounted.";
SC_MODULE_BANDAGE_INFO = "Messages healers to not heal when you are bandaging.";
SC_MODULE_BUFFS_INFO = "Interface for buffing groups intelligently.";
SC_MODULE_BUTTONS_INFO = "Creates useful buttons for Mana Gems, Food/Water,"..
    " etc.";
SC_MODULE_COLLECT_INFO = "Collects Garbage after death.";
SC_MODULE_EVOCATE_INFO = "Equips intellect weapons when evocating.";
SC_MODULE_INVISIBILITY_INFO = "Provides an interface to remove armor during\n"..
    "a wipe when you escape as a result of Invisibility.";
SC_MODULE_MERCHANT_INFO = "Makes it easy to buy Reagents, sell Gray Trash,\n"..
    "and Repair.";
SC_MODULE_MINIMAP_INFO = "Makes a Minimap Button for this addon, for\n"..
    "portals and buffs.";
SC_MODULE_POLY_INFO = "Allows for automatically saying a variety of\n"..
    "things when you polymorph.";
SC_MODULE_RELEASE_INFO = "Automatically releases you when you die in a"..
    " battleground.";


--====
--MISC
--====

SC_GROUP = "Group";
SC_BETA = "This is a BETA version of this mod. Please report any bugs on "..
    "curse-gaming.com";
SC_RELOAD = "Some settings you have changed require you to reload your UI to "..
    "be effected.\nWould you like to reload your UI?";
GOLD = "Gold";
SILVER = "Silver";
COPPER = "Copper";


--======
--SPELLS
--======

SC_SPELL_EVOCATION = "Evocation";
SC_SPELL_TELEPORT_STORMWIND = "Teleport: Stormwind";
SC_SPELL_TELEPORT_IRONFORGE = "Teleport: Ironforge";
SC_SPELL_TELEPORT_EXODAR = "Teleport: Exodar";
SC_SPELL_TELEPORT_DARNASSUS = "Teleport: Darnassus";
SC_SPELL_TELEPORT_THERAMORE = "Teleport: Theramore";
SC_SPELL_PORTAL_STORMWIND = "Portal: Stormwind";
SC_SPELL_PORTAL_IRONFORGE = "Portal: Ironforge";
SC_SPELL_PORTAL_EXODAR = "Portal: Exodar";
SC_SPELL_PORTAL_DARNASSUS = "Portal: Darnassus";
SC_SPELL_PORTAL_THERAMORE = "Portal: Theramore";


SC_SPELL_TELEPORT_ORGRIMMAR = "Teleport: Orgrimmar";
SC_SPELL_TELEPORT_UNDERCITY = "Teleport: Undercity";
SC_SPELL_TELEPORT_SILVERMOON = "Teleport: Silvermoon";
SC_SPELL_TELEPORT_THUNDER = "Teleport: Thunder Bluff";
SC_SPELL_TELEPORT_STONARD = "Teleport: Stonard";
SC_SPELL_PORTAL_ORGRIMMAR = "Portal: Orgrimmar";
SC_SPELL_PORTAL_UNDERCITY = "Portal: Undercity";
SC_SPELL_PORTAL_SILVERMOON = "Portal: Silvermoon";
SC_SPELL_PORTAL_THUNDER = "Portal: Thunder Bluff";
SC_SPELL_PORTAL_STONARD = "Portal: Stonard";


SC_SPELL_TELEPORT_SHATTRATH = "Teleport: Shattrath";
SC_SPELL_PORTAL_SHATTRATH = "Portal: Shattrath";

SC_SPELL_AI = "Arcane Intellect";
SC_SPELL_AB = "Arcane Brilliance";

SC_SPELL_POLY = "Polymorph";
SC_SPELL_TURTLE = "Polymorph: Turtle";
SC_SPELL_PIG = "Polymorph: Pig";


--=====
--ITEMS
--=====

SC_TIME_REMAINING = "Time Remaining: ";

SC_HEARTH = "Hearthstone";


--=======
--WEAPONS
--=======

SC_WEAPON_TH = "Two-Hand";
SC_WEAPON_ONEH = "One-Hand";
SC_WEAPON_MH = "Main Hand";
SC_WEAPON_OH = "Held In Off-hand";
SC_WEAPON_W = "Wand";


--========
--REAGENTS
--========

SC_REAGENT_MAGE_POWDER = "Arcane Powder";
SC_REAGENT_MAGE_TELE = "Rune of Teleportation";
SC_REAGENT_MAGE_PORT = "Rune of Portals";

SC_REAGENT_PRIEST_HOLY = "Holy Candle";
SC_REAGENT_PRIEST_SACRED = "Sacred Candle";

SC_REAGENT_DRUID_MAPLE = "Maple Seed";
SC_REAGENT_DRUID_STRANGLE = "Stranglethorn Seed";
SC_REAGENT_DRUID_ASH = "Ashwood Seed";
SC_REAGENT_DRUID_HORN = "Hornbeam Seed";
SC_REAGENT_DRUID_IRON = "Ironwood Seed";
SC_REAGENT_DRUID_FLINT = "Flintweed Seed";
SC_REAGENT_DRUID_BERRIES = "Wild Berries";
SC_REAGENT_DRUID_THORN = "Wild Thornroot";
SC_REAGENT_DRUID_QUILL = "Wild Quillvine";

SC_REAGENT_PALADIN_KINGS = "Symbol of Kings";
SC_REAGENT_PALADIN_DIVINITY = "Symbol of Divinity";

SC_REAGENT_SHAMAN_ANKH = "Ankh";

SC_REAGENT_WARLOCK_INFERNAL = "Infernal Stone";
SC_REAGENT_WARLOCK_DEMONIC = "Demonic Figurine";


--=====
--NOTES
--=====

SC_NAME = "Spellcraft";
SC_LOADED = "Loaded. Use /sc to configure."

SC_MAIN_NOTEB = "You can bring up this frame with /sc or /spellcraft";

SC_MAIN_GENERAL = "General";
SC_MAIN_GENERAL_OPTIONS = "Options";
SC_MAIN_GENERAL_MODULES = "Enable/Disable Modules";
SC_MAIN_GENERAL_DEFAULTS = "Restore ALL default settings? (all modules)\n"..
    "This will Reload your UI";
SC_MAIN_GENERAL_OPTION1 = "Receive Informational Messages?";

SC_MAIN_POLY = "Polymorph";
SC_MAIN_POLY_OPTION1 = "Automatically Message those targeting your sheep?";
SC_MAIN_POLY_OPTION2 = "Continue to whisper those who target your sheep for "..
    "its duration?";
SC_MAIN_POLY_OPTION3 = "Whisper those targeting your sheep?";
SC_MAIN_POLY_OPTION4 = "Message your party?";
SC_MAIN_POLY_OPTION5 = "Message your raid?";
SC_MAIN_POLY_OPTION6 = "Announce who broke your sheep in Party/Raid?";
SC_MAIN_POLY_SLIDERSTATE1 = "Whispers to those targeting your sheep on cast";
SC_MAIN_POLY_SLIDERSTATE2 = "Whispers to those who target your sheep";
SC_MAIN_POLY_SLIDERSTATE3 = "Party Messages";
SC_MAIN_POLY_SLIDERSTATE4 = "Raid Messages";
SC_MAIN_POLY_SCROLLNOTE = "Click on message to edit";
SC_MAIN_POLY_EDITFRAME_REMOVE = "Remove";
SC_MAIN_POLY_EDIT = "Editing: ";
SC_MAIN_POLY_DEFAULTS = "Restore All Default Polymorph Values?";
SC_MAIN_POLY_EDITFRAMENOTE = "Editing Message";
SC_MAIN_POLY_EDITFRAMENOTE2 = "Add Message";
SC_MAIN_POLY_ADDMSG = "Add Message";

SC_MAIN_MERCHANT = "Merchant";
SC_MAIN_MERCHANT_OPTION1 = "Disable Reagent/Repair/Gray Selling "..
  "Notifications? (silent)";
SC_MAIN_MERCHANT_OPTION2 = "Enable Notifications when low on reagents?";

SC_MINIMAP_TOOLTIP = "Spellcraft\n|cFF4422FFLeft Click for Portals|r\n"..
    "|cFFAAAAFFRight Click to Move this Button|r";
SC_MINIMAP_ALLIANCEPORT = "Alliance Portals";
SC_MINIMAP_HORDEPORT = "Horde Portals";
SC_MINIMAP_GENERALPORT = "General Portals";
SC_MINIMAP_HEARTH = "Enable Minimap Hearthstone Button?";

SC_BUFFS_TOOLTIP = "Buffs (%s)\nLeft Click to open Buff Menu\n"..
    "Right Click to Buff Group %d (%d need AI)\nShift + Left Click to "..
    "buff %s (%s)"; -- First %s = "Unlocked" or "Locked"
               -- First %d = Group Number
               -- Second %d = Number of players in a group that need AI
               -- Second %s = A Player's Name
               -- Third %s = Time left on player's AI/AB
SC_BUFFS_GROUP_TOOLTIP = "Group %d\nLeft Click to open group member window\n"..
    "Shift + Left Click to cast AI on %s.\nRight Click to cast to cast AB on"..
    " this group.";-- %d = Group Number
                  -- %s = A Player Name
SC_BUFFS_AI = "Left Click to cast AI on %s.";-- %s = Player
SC_BUFFS_LOCKED = "Locked";
SC_BUFFS_UNLOCKED = "Unlocked";

SC_INVIS_GEAROFF = "Spellcraft has detected you have left combat through "..
    "Invisibility while in a group."
SC_INVIS_GEAROFF2 = "Would you like to remove your gear?";
SC_INVIS_GEARON = "Put gear back on?";
SC_INVIS_GEARON2 = "Note: You can use /gearon as well.";

SC_MERCHANT_GRAY = "Sell your gray items?";
SC_MERCHANT_REPAIR = "Repair All Items?";
SC_MERCHANT_REAGENT = "Buy Reagents?";

SC_REAGENT_CHANGE = "Change your Reagents' Maximum Buy Amount?";
SC_REAGENT_CHANGE2 = "Change your Reagents' Maximum Buy Amount:";
SC_REAGENT_CHANGE3 = "Note: /changereagent brings this window back up.";


--========
--MESSAGES
--========

SC_MSG_ERROR_MONEY = "You do not have enough money to repair.";
SC_MSG_REAGENTS_NEED = "You should buy reagents; You are low.";
SC_MSG_SILENT_REAGENT = "Buying Reagents.";
SC_MSG_SETTINGS_COMBAT = "Cannot modify settings while in combat.";
SC_MSG_POLY_PERCENT_ERROR = "Percent cannot be '0'";
SC_MSG_RESET = "Resetting Options due to incompatible version.";
SC_MSG_VERSION_UPDATE = "Updating Reagent Structure; Reagents Settings Reset!";
SC_MSG_CHANGEREAGENT_ERROR = "Maximum Buy Amount was invalid. Please use "..
    "/changereagent to try again. Value entered was: ";
SC_MSG_NAKED_ERROR = "Cannot Remove Items: In Combat";
SC_MSG_EQUIP_ERROR = "Cannot Equip Items: In Combat";
SC_MSG_TELEPORT_ERROR = "Cannot cast teleportation spells: In Combat";
SC_MSG_WIPE = "It's a wipe!";
SC_MSG_CREAGENT_ERROR = "Maximum Buy Amount was invalid. Please use "..
    "/changereagent to try again. Value entered was";
SC_MSG_GRAYTRASH = "Selling Gray Trash: ";
SC_MSG_EVOCATE = "Evocating: Changing weapons to maximize intellect.";
SC_MSG_DEEVOCATE = "No Longer Evocating: Changing back to old weapons.";
SC_MSG_POLYM_ERROR = "/polym Usage: /polym [option]   Valid Options: "..
    "[config] = Open Polymorph Message Configuration; [t] = Message those "..
    "targeting your target; [f] = Message those targeting your focus. Only "..
    "use this command to message others if you are NOT using automatic "..
    "messaging.";
SC_MSG_EVOCATE_ERROR = "You do not have full control of your character; "..
    "Cannot reequip your old items yet.";
SC_MSG_GARBAGE = "Collecting Garbage.";
SC_MSG_POLY_BREAK = "Your sheep was broken by %s's %s.";
							-- First %s = Player who broke it
							-- Second %s = Spell used to brake it
SC_MSG_POLY_BREAK_MELEE = "Your sheep was broken by %s's melee damage.";  -- -- First %s = Player who broke it
SC_MSG_POLY_BREAK_ANN = "%s's sheep was broken by %s's %s.";
                                        -- First %s = Player
                                        -- Second %s = Player who broke it
                                        -- Third %s = Spell used to brake it
SC_MSG_POLY_BREAK_ANN_MELEE = "%s's sheep was broken by %s's melee damage.";
                                        -- First %s = Player
                                        -- Second %s = Player who broke it
SC_MSG_POLY_SAYINGS_ERROR = "You do not have any polymorph sayings for: %s. "..
    "Please turn off %s messaging with /polym config, or restore "..
    "default sayings, or add your own.";-- Both %s = "Whisper" or "Party" or
                                        -- "Raid"

SC_MSG_ERROR = "Spellcraft has caught an error!\n"..
    "Error:\n%s\nStack Trace:\n%s\Event received: %s.\n"..
    "Event Args:\n%s";
                                  -- First %s = The Event
                                  -- Second %s = Error Message
                                  -- Third %s = Stack Trace
                                  -- Translate
--========
--WHISPERS
--========

SC_WHISPER_POLY_DEFAULT1 = "**Warning!!** I'm shepherding your target!";

SC_WHISPER_BANDAGE = "I'm Bandaging Myself!! Conserve your mana!";


--=====
--PARTY
--=====

SC_PARTY_POLY_DEFAULT1 = "I am polymorphing %t. Stay the flock off my sheep!";
SC_PARTY_POLY_DEFAULT2 = "Fireballs are red, Frostbolts are blue, mess with "..
    "my sheep and I'll QQ!";
SC_PARTY_POLY_DEFAULT3 = "Sheeping %t, spank it and I'll tank it!";

SC_PARTY_BANDAGE = "I am Bandaging Myself!! Conserve your mana!!";

--====
--RAID
--====

SC_RAID_POLY_DEFAULT1 = ">>>> Polymorphing %t. <<<<";

--=====
--SHEEP
--=====

SC_SHEEP_POLY_DEFAULT1 = "You are targeting my sheep!";

--======
--CITIES
--======

SC_CITY_SHATTRATH = "Shattrath";

SC_CITY_ALLIANCE_STORMWIND = "Stormwind";
SC_CITY_ALLIANCE_IRONFORGE = "Ironforge";
SC_CITY_ALLIANCE_EXODAR = "Exodar";
SC_CITY_ALLIANCE_DARNASSUS = "Darnassus";
SC_CITY_ALLIANCE_THERAMORE = "Theramore";

SC_CITY_HORDE_ORGRIMMAR = "Orgrimmar";
SC_CITY_HORDE_UNDERCITY = "Undercity";
SC_CITY_HORDE_SILVERMOON = "Silvermoon";
SC_CITY_HORDE_THUNDER = "Thunder Bluff";
SC_CITY_HORDE_STONARD = "Stonard";


--=====
--ZONES
--=====

SC_ZONE_ALTERACVALLEY = "Alterac Valley";
SC_ZONE_WARSONG = "Warsong Gulch";
SC_ZONE_ARATHIBASIN = "Arathi Basin";
SC_ZONE_EYE = "Eye of the Storm";


--=====
--BUFFS
--=====

SC_BUFF_SELF_INVIS = "Invisibility";
SC_BUFF_SELF_DETECTINVIS = "Detect %w* *Invisibility"; -- The '%w*' and
                                          -- ' *' allow us to
                                          -- catch "Detect Invisibility" and
                                          -- "Detect Lesser Invisibility".
                                          -- Put "%w* *" wherever 'Lesser' would
                                          -- appear in the buff.
SC_DEBUFF_OTHER_POLY = "Polymorph";
SC_DEBUFF_SELF_FA = "First Aid";
