--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]

--Special thanks to Gafarion of Alleria-EU for these translations!


--Note to those who wish to help localize this addon. Just copy and paste
--everthing below, and just translate the words/sentences inside quotes.

--General Things You Need to Know:

--These "--" that I put before these sentences on every new line are called
--comment prefixes. They make sure these "comments" are not considered
--"code" by the game.

--I use colors for some of these, for example: "|cff00ff00Blah|r". Just ignore
--the parts having to do with color (|cff00ff00 and |r) and just change the
--words (Blah).

--'\n' means start a new line.

--When a line is longer than 80 characters I break the sentence up so it's more
--readable. I do this by "concatenating" the strings using "..". You'll see
--this as something like: K = "Dogs".." bark"
--This becomes internally: "Dogs bark"

--Sometimes, so I can dynamically create a string, I use symbols such as "%s" or
--"%d" to represent a string of characters or a number respectively. I will
--usually describe to you how I'm using these so you can make sure your
--sentences are syntactically correct.
--For example, if I have: SC_GROUPS = "Group %d"
--I will internally make this become something like: "Group 5" or "Group 4"

--Finally, if you are confused by any of this but would like to help, please
--give me an e-mail at batrick@unm.edu


if GetLocale() ~= "deDE" then return end;

SC_Localized = true;


--==========================
--Setting up the environment
--==========================

local Spellcraft = Spellcraft or { };
local _G = getfenv(0);

Spellcraft.name = "Spellcraft";

_G[Spellcraft.name] = Spellcraft;

setmetatable(Spellcraft, getmetatable(Spellcraft) or {__index = _G});
setfenv(1, Spellcraft);


--=======
--MODULES
--=======

SC_ENABLED = "Aktiviert";
SC_DISABLED = "Deaktiviert";
SC_MODULE_BANDAGE = "Verband";
SC_MODULE_BUFFS = "Buffs";
SC_MODULE_BUTTONS = "Kn\195\182pfe";
SC_MODULE_COLLECT = "Speichernutzung";
SC_MODULE_EVOCATE = "Hervorrufung";
SC_MODULE_INVISIBILITY = "Unsichtbarkeit";
SC_MODULE_MERCHANT = "H\195\164ndler";
SC_MODULE_MINIMAP = "Minimap";
SC_MODULE_POLY = "Verwandlung";
SC_MODULE_RELEASE = "Freilassen";
SC_MODULE_MOUNT = "Mount";-- Translate

SC_MODULE_MOUNT_INFO = "Automatically equips trinkets that increase"..
    " your mount speed when are mounted.";-- Translate
SC_MODULE_BANDAGE_INFO = "Heiler anfl\195\188stern, nicht zu heilen bei "..
    "Verwendung eines Verbandes.";
SC_MODULE_BUFFS_INFO = "Men\195\188 f\195\188r das intelligente Buffen von "..
    "Gruppen.";
SC_MODULE_BUTTONS_INFO = "Stellt Kn\195\182pfe f\195\188r Mana-Edelsteine, "..
    "Wasser/Brot, etc. bereit.";
SC_MODULE_COLLECT_INFO = "Speichernutzung des Addons optimieren wenn der "..
    "Charakter stirbt.";
SC_MODULE_EVOCATE_INFO = "Intelligenz-Waffe anlegen w\195\164hrend "..
    "Hervorrufung.";
SC_MODULE_INVISIBILITY_INFO = "Bietet die M\195\182glichkeit die "..
    "Ausr\195\188stung abzulegen\n nach dem Verlassen des Kampfmodus "..
    "mittels Unsichtbarkeit (z.B. vor einem Wipe).";
SC_MODULE_MERCHANT_INFO = "Erleichtert den Einkauf von Reagenzien, den "..
    "Verkauf von grauen Items,\nund das Reparieren.";
SC_MODULE_MINIMAP_INFO = "Erzeugt einen Minimap-Knopf f\195\188r\n"..
    "Portale und Buffs.";
SC_MODULE_POLY_INFO = "Verschiedene Meldungen ausgeben bei Verwendung von "..
    "Verwandlung.";
SC_MODULE_RELEASE_INFO = "Im Schlachtfeld automatisch freilassen";


--====
--MISC
--====

SC_GROUP = "Gruppe";
SC_BETA = "Dies ist eine Beta-Version. Fehler bitte auf "..
    "curse-gaming.com melden.";
SC_RELOAD = "Einige Einstellungen erfordern ein Neuladen des "..
    "Interfaces.\nInterface jetzt neu laden?";
GOLD = "Gold"; -- Translate
SILVER = "Silver"; -- Translate
COPPER = "Copper"; -- Translate


--======
--SPELLS
--======

SC_SPELL_EVOCATION = "Hervorrufung";
SC_SPELL_TELEPORT_STORMWIND = "Teleportieren: Sturmwind";
SC_SPELL_TELEPORT_IRONFORGE = "Teleportieren: Eisenschmiede";
SC_SPELL_TELEPORT_EXODAR = "Teleportieren: Exodar";
SC_SPELL_TELEPORT_DARNASSUS = "Teleportieren: Darnassus";
SC_SPELL_TELEPORT_THERAMORE = "Teleportieren: Theramore";
SC_SPELL_PORTAL_STORMWIND = "Portal: Sturmwind";
SC_SPELL_PORTAL_IRONFORGE = "Portal: Eisenschmiede";
SC_SPELL_PORTAL_EXODAR = "Portal: Exodar";
SC_SPELL_PORTAL_DARNASSUS = "Portal: Darnassus";
SC_SPELL_PORTAL_THERAMORE = "Portal: Theramore";

SC_SPELL_TELEPORT_ORGRIMMAR = "Teleportieren: Orgrimmar";
SC_SPELL_TELEPORT_UNDERCITY = "Teleportieren: Unterstadt";
SC_SPELL_TELEPORT_SILVERMOON = "Teleportieren: Silbermond";
SC_SPELL_TELEPORT_THUNDER = "Teleportieren: Donnerfels";
SC_SPELL_TELEPORT_STONARD = "Teleportieren: Stonard";
SC_SPELL_PORTAL_ORGRIMMAR = "Portal: Orgrimmar";
SC_SPELL_PORTAL_UNDERCITY = "Portal: Unterstadt";
SC_SPELL_PORTAL_SILVERMOON = "Portal: Silbermond";
SC_SPELL_PORTAL_THUNDER = "Portal: Donnerfels";
SC_SPELL_PORTAL_STONARD = "Portal: Stonard";

SC_SPELL_TELEPORT_SHATTRATH = "Teleportieren: Shattrath";
SC_SPELL_PORTAL_SHATTRATH = "Portal: Shattrath";

SC_SPELL_AI = "Arkane Intelligenz";
SC_SPELL_AB = "Arkane Brillanz";

SC_SPELL_POLY = "Polymorph";--Translate
SC_SPELL_TURTLE = "Polymorph: Turtle";--Translate
SC_SPELL_PIG = "Polymorph: Pig";--Translate


--=====
--Items
--=====

SC_TIME_REMAINING = "Verbleibende Zeit: ";

SC_HEARTH = "Ruhestein";


--=======
--Weapons
--=======

SC_WEAPON_TH = "Zweih\195\164ndig";
SC_WEAPON_ONEH = "Einh\195\164ndig";
SC_WEAPON_MH = "Waffenhand";
SC_WEAPON_OH = "In Schildhand gef\195\188hrt";
SC_WEAPON_W = "Zauberstab";


--========
--Reagents
--========

SC_REAGENT_MAGE_POWDER = "Arkanes Pulver";
SC_REAGENT_MAGE_TELE = "Rune der Teleportation";
SC_REAGENT_MAGE_PORT = "Rune der Portale";

SC_REAGENT_PRIEST_HOLY = "Heilige Kerze";
SC_REAGENT_PRIEST_SACRED = "Hochheilige Kerze";

SC_REAGENT_DRUID_MAPLE = "Ahornsamenkorn";
SC_REAGENT_DRUID_STRANGLE = "Schlingendornsamenkorn";
SC_REAGENT_DRUID_ASH = "Eschenholzsamenkorn";
SC_REAGENT_DRUID_HORN = "Hainbuchensamenkorn";
SC_REAGENT_DRUID_IRON = "Eisenholzsamenkorn";
SC_REAGENT_DRUID_FLINT = "Flintgrassaat";
SC_REAGENT_DRUID_BERRIES = "Wilde Beeren";
SC_REAGENT_DRUID_THORN = "Wilder Dornwurz";
SC_REAGENT_DRUID_QUILL = "Wilde Federranke";

SC_REAGENT_PALADIN_KINGS = "Symbol der K\195\182nige";
SC_REAGENT_PALADIN_DIVINITY = "Symbol der Offenbarung";

SC_REAGENT_SHAMAN_ANKH = "Ankh";

SC_REAGENT_WARLOCK_INFERNAL = "H\195\182llenstein";
SC_REAGENT_WARLOCK_DEMONIC = "D\195\164monenstatuette";


--=====
--NOTES
--=====

SC_NAME = "Spellcraft";
SC_LOADED = "Geladen. Benutze /sc zum Konfigurieren."

SC_MAIN_NOTEB = "Dieses Frame \195\182ffnen mit /sc oder /spellcraft";

SC_MAIN_GENERAL = "Allgemein";
SC_MAIN_GENERAL_OPTIONS = "Optionen";
SC_MAIN_GENERAL_MODULES = "Module ein-/ ausschalten";
SC_MAIN_GENERAL_DEFAULTS = "Standardeinstellungen wiederherstellen "..
    "(f\195\188r alle Module)?\nDies wird das Interface neu laden.";
SC_MAIN_GENERAL_OPTION1 = "Info-Meldungen anzeigen?";

SC_MAIN_POLY = "Verwandlung";
SC_MAIN_POLY_OPTION1 = "Automatische Nachricht an Spieler senden die dein"..
    "Schaf anvisieren?";
SC_MAIN_POLY_OPTION2 = "Nachrichten fortsetzen solange das Schaf h\195\164lt?";
SC_MAIN_POLY_OPTION3 = "Spieler anfl\195\188stern die dein Schaf anvisieren?";
SC_MAIN_POLY_OPTION4 = "Nachricht an die Gruppe?";
SC_MAIN_POLY_OPTION5 = "Nachricht an den Raid?";
SC_MAIN_POLY_OPTION6 = "Announce who broke your sheep in Party/Raid?";
                                                          -- Translate
SC_MAIN_POLY_SLIDERSTATE1 = "Spieler anfl\195\188stern die das Ziel "..
    "f\195\188r dein Schaf anvisieren";
SC_MAIN_POLY_SLIDERSTATE2 = "Spieler anfl\195\188stern die dein Schaf "..
    "anvisieren";
SC_MAIN_POLY_SLIDERSTATE3 = "Gruppenmeldungen";
SC_MAIN_POLY_SLIDERSTATE4 = "Raidmeldungen";
SC_MAIN_POLY_SCROLLNOTE = "Nachricht anklicken zum \195\164ndern";
SC_MAIN_POLY_EDITFRAME_REMOVE = "Entfernen";
SC_MAIN_POLY_EDIT = "Bearbeiten: ";
SC_MAIN_POLY_DEFAULTS = "Standard wiederherstellen (Verwandlung)?";
SC_MAIN_POLY_EDITFRAMENOTE = "Meldung bearbeiten";
SC_MAIN_POLY_EDITFRAMENOTE2 = "neue Meldung";
SC_MAIN_POLY_ADDMSG = "neue Meldung";

SC_MAIN_MERCHANT = "H\195\164ndler";
SC_MAIN_MERCHANT_OPTION1 = "Benachrichtigungen f\195\188r "..
    "Reagenzienkauf/Reparieren/ Graue-Items-Verkauf deaktivieren?";
SC_MAIN_MERCHANT_OPTION2 = "Benachrichtigung wenn wenig Reagenzien \195\188brig sind?";

SC_MINIMAP_TOOLTIP = "Spellcraft\n|cFF4422FFLinksklick f\195\188r "..
    "Portale|r\n|cFFAAAAFFRechtsklick zum Ziehen|r";
SC_MINIMAP_ALLIANCEPORT = "Allianz-Portale";
SC_MINIMAP_HORDEPORT = "Horde-Portale";
SC_MINIMAP_GENERALPORT = "Allgemeine Portale";
SC_MINIMAP_HEARTH = "Minimapknopf f\195\188r den Ruhestein anzeigen?";

SC_BUFFS_TOOLTIP = "Buffs (%s)\nLinksklick \195\182ffnet das "..
    "Buffmen\195\188\nRechtsklick um Gruppe %d zu buffen (%dx Arkane "..
    "Intelligenz ben\195\182tigt)\nShift + Linksklick um "..
    "%s zu buffen"; -- First %s = "Unlocked" or "Locked"
               -- First %d = Group Number
               -- Second %d = Number of players in a group that need AI
               -- Third %s = A Player's Name 

SC_BUFFS_GROUP_TOOLTIP = "Gruppe %d:\nLinksklick \195\182ffnet das "..
    "Gruppenmitglieder-Fenster\nShift + Linksklick um Arkane Intelligenz "..
    "auf %s zu zaubern.\nRechtsklick um Arkane Brillanz auf diese "..
    "Gruppe zu wirken.";-- %d = Group Number
                        -- %s = A Player Name
SC_BUFFS_AI = "Linksklick um Arkane Intelligenz auf %s zu zaubern.";
    --%s = Player
SC_BUFFS_LOCKED = "Gesperrt";
SC_BUFFS_UNLOCKED = "M\195\182glich";

SC_INVIS_GEAROFF = "Spellcraft: Kampfmodus durch Unsichtbarkeit verlassen.";
SC_INVIS_GEAROFF2 = "Ausr\195\188stung ablegen?";
SC_INVIS_GEARON = "Ausr\195\188stung wieder anlegen?";
SC_INVIS_GEARON2 = "Hinweis: Du kannst dazu auch /gearon verwenden.";

SC_MERCHANT_GRAY = "Graue Gegenst\195\164nde verkaufen?";
SC_MERCHANT_REPAIR = "Komplett reparieren?";
SC_MERCHANT_REAGENT = "Reagenzien auff\195\188llen?";

SC_REAGENT_CHANGE = "Kaufmenge f\195\188r Reagenzien \195\164ndern?";
SC_REAGENT_CHANGE2 = "neue Kaufmenge f\195\188r Reagenzien:";
SC_REAGENT_CHANGE3 = "Hinweis: /changereagent \195\182ffnet dieses Fenster "..
    "erneut.";


--========
--MESSAGES
--========

SC_MSG_ERROR_MONEY = "Nicht genug Gold zum Reparieren.";
SC_MSG_REAGENTS_NEED = "Wenig Reagenzien vorhanden, Zeit zum einkaufen.";
SC_MSG_SILENT_REAGENT = "Reagenzien gekauft.";
SC_MSG_SETTINGS_COMBAT = "Einstellungen k\195\182nnen im Kampf nicht "..
    "ver\195\164ndert werden.";
SC_MSG_POLY_PERCENT_ERROR = "Prozentzahl kann nicht '0' sein";
SC_MSG_RESET = "Einstelleungen zur\195\188ckgesetzt wegen inkompatiblen "..
    "Versionen.";
SC_MSG_VERSION_UPDATE = "Reagenzienstruktur aktualisiert: Einstellungen "..
    "zur\195\188ckgesetzt!";
SC_MSG_CHANGEREAGENT_ERROR = "Kaufmenge ung\195\188ltig. Bitte verwende "..
    "/changereagent zum wiederholen. Der eingegebene Wert war: ";
SC_MSG_NAKED_ERROR = "Ausr\195\188stung ablegen nicht m\195\182glich: Im Kampf";
SC_MSG_EQUIP_ERROR = "Ausr\195\188stung anlegen nicht m\195\182glich: Im Kampf";
SC_MSG_TELEPORT_ERROR = "Teleportieren nicht m\195\182glich: Im Kampf";
SC_MSG_WIPE = "Das wird ein wipe!";
SC_MSG_CREAGENT_ERROR = "Kaufmenge ung\195\188ltig. Bitte verwende "..
    "/changereagent zum wiederholen. Der eingegebene Wert war:";
SC_MSG_GRAYTRASH = "Graues Item verkauft: ";
SC_MSG_EVOCATE = "Hervorrufung: Waffenwechsel f\195\188r maximale "..
    "Intelligenz.";
SC_MSG_DEEVOCATE = "Hervorrufung beendet: urspr\195\188ngliche Waffen "..
    "angelegt.";
SC_MSG_POLYM_ERROR = "/polym Benutzung: /polym [option]   Optionen: "..
    "[config] = \195\182ffne Verwandlungs-Meldungen; [t] = Spieler "..
    "anfl\195\188stern die Dein Ziel anvisieren; [f] = Spieler "..
    "anfl\195\188stern die Deinen Fokus anvisieren. Nur verwenden wenn "..
    "keine automatischen Meldungen benutzt werden.";
SC_MSG_EVOCATE_ERROR = "Du hast nicht die Kontrolle \195\188ber deinen "..
    "Charakter; Ausr\195\188stung kann nicht gewechselt werden.";
SC_MSG_GARBAGE = "Speichernutzung wird optimiert.";
SC_MSG_POLY_BREAK = "Dein Schaf wurde unterbrochen von %s's %s.";
                                        -- %s = Player who broke it
SC_MSG_POLY_BREAK_MELEE = "Dein Schaf wurde unterbrochen von %s's nahkampfschaden.";
SC_MSG_POLY_BREAK_ANN = "%s's Schaf wurde unterbrochen von %s's %s.";
                                        -- First %s = Player
                                        -- Second %s = Player who broke it
                                        -- Translate
SC_MSG_POLY_BREAK_ANN_MELEE = "%s's Schaf wurde unterbrochen von %s's nahkampfschaden.";

SC_MSG_POLY_SAYINGS_ERROR = "Keine Verwandlungs-Meldung f\195\188r: %s. "..
     "Bitte Meldungen mit %s /polym config abschalten oder "..
     "Standard-Meldungen wiederherstellen oder eingene Meldungen erstellen."
     -- Both %s = "Whisper" or "Party" or "Raid"

SC_MSG_ERROR = "Spellcraft hat einen Fehler festgestellt!\n"..
    "Error:\n%s\nStack Trace:\n%s\Event received: %s.\n"..
    "Event Args:\n%s";
                                  -- First %s = The Event
                                  -- Second %s = Error Message
                                  -- Third %s = Stack Trace

--========
--WHISPERS
--========

SC_WHISPER_POLY_DEFAULT1 = "**Achtung!!** Ich sheepe Dein Ziel!";

SC_WHISPER_BANDAGE = "Ich nehme einen Verband! Spar Dein Mana!";


--=====
--PARTY
--=====

SC_PARTY_POLY_DEFAULT1 = "Ich verwandle %t. Pfoten weg von meinem Schaf!";
SC_PARTY_POLY_DEFAULT2 = "Feuerb\195\164lle sind rot, Eisblitze blau. "..
    "Finger weg von meinem Schaf oder ich mach dich zur Sau!";
SC_PARTY_POLY_DEFAULT3 = "Ich mache %t zum Schaf. Wer es haut muss tanken!";

SC_PARTY_BANDAGE = "Ich nehme einen Verband! Spar Dein Mana!";

--====
--Raid
--====

SC_RAID_POLY_DEFAULT1 = ">>>> Ich schafe %t. <<<<";

--=====
--Sheep
--=====

SC_SHEEP_POLY_DEFAULT1 = "Du visierst mein Schaf an!";

--======
--CITIES
--======

SC_CITY_SHATTRATH = "Shattrath";

SC_CITY_ALLIANCE_STORMWIND = "Sturmwind";
SC_CITY_ALLIANCE_IRONFORGE = "Eisenschmiede";
SC_CITY_ALLIANCE_EXODAR = "Exodar";
SC_CITY_ALLIANCE_DARNASSUS = "Darnassus";
SC_CITY_ALLIANCE_THERAMORE = "Theramore";

SC_CITY_HORDE_ORGRIMMAR = "Orgrimmar";
SC_CITY_HORDE_UNDERCITY = "Unterstadt";
SC_CITY_HORDE_SILVERMOON = "Silbermond";
SC_CITY_HORDE_THUNDER = "Donnerfels";
SC_CITY_HORDE_STONARD = "Stonard";


--=====
--ZONES
--=====

SC_ZONE_ALTERACVALLEY = "Alteractal";
SC_ZONE_WARSONG = "Warsongschlucht";
SC_ZONE_ARATHIBASIN = "Arathibecken";
SC_ZONE_EYE = "Auge des Sturms";


--=====
--Buffs
--=====

SC_BUFF_SELF_INVIS = "Unsichtbarkeit";
SC_BUFF_SELF_DETECTINVIS = "%w* *Unsichtbarkeit entdecken"; -- The '%w*' and
                                          -- ' *' allow us to
                                          -- catch "Detect Invisibility" and
                                          -- "Detect Lesser Invisibility".
                                          -- Put "%w* *" wherever 'Lesser' would
                                          -- appear in the buff.
SC_DEBUFF_OTHER_POLY = "Verwandlung";
SC_DEBUFF_SELF_FA = "Erste Hilfe";
