--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

--]]


--[[

This module is for creating buttons that can be configured extensively
  for using different consumables. These consumables can be anything,
  but the general intent of this module is conjured food/water and
  mana gems.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Buttons";
module.lname = SC_MODULE_BUTTONS;
module.version = 1.1;
module.info = SC_MODULE_BUTTONS_INFO;

_G.Spellcraft[module.name] = module;

RegisterModule(module);

--======
--Locals
--======

local buttons;


--============
--Button Class
--============

do
  local Button = { };

  function Button:new(object)
    object = object or { };
    setmetatable(object, self);
    self.__index = self;
    return object;
  end;
end;


--===============
--Local Functions
--===============

  --=======================
  --Button Frame Management
  --=======================

local function Update()
  this:ClearAllPoints();
  --[[
  this:SetPoint("CENTER", "Minimap", "CENTER",
    SC_myConfig.Minimap.button.position.radius *
    math.cos(SC_myConfig.Minimap.button.position.degree),
    SC_myConfig.Minimap.button.position.radius *
    math.sin(SC_myConfig.Minimap.button.position.degree));--]]
  this:SetUserPlaced(false);
end;

local function Dragging()
  local UIParent = UIParent;
  local position = { };
  local size = UIParent:GetHeight() / 2;
  
  position.x, position.y = GetCursorPosition();
  --[[
  position.x = -(-(position.x / UIParent:GetScale())
    + Minimap:GetLeft() + size);
  position.y = position.y / UIParent:GetScale() - Minimap:GetBottom() - size;
  
  --Snapping to other nearby buttons
  SC_myConfig.Minimap.button.position.radius =
    math.pow((math.pow(position.x, 2)
    + math.pow(position.y, 2)), 0.5);
  
  if SC_myConfig.Minimap.button.position.radius < size + 15 and
     size - 15 < SC_myConfig.Minimap.button.position.radius then
    SC_myConfig.Minimap.button.position.radius = size + 10;
  end;
  if SC_myConfig.Minimap.button.position.radius < size + 75 and 
     size + 45 < SC_myConfig.Minimap.button.position.radius then
    SC_myConfig.Minimap.button.position.radius = size + 50;
  end;

  SC_myConfig.Minimap.button.position.degree =
    math.atan2(position.y, position.x);--In Radians
  --]]
  Update()
end;
     
local function CreateButton(Name, SizeX, SizeY, Anchor, aX, aY)
  local x = CreateSecureButton(Name, UIParent, SizeX, SizeY,
      Anchor, aX, aY);
  msg("Have question mark texture for default button!");
  --x:SetNormalTexture();
  return x;
end;

local function NewButton(Name, SizeX, SizeY, Anchor, aX, aY)
  table.insert(buttons, {
    name = "SC_Buttons_"..Name,
    sizeX = SizeX,
    sizeY = SizeY,
    anchor = Anchor,
    aX = aX,
    aY = aY
  });
  local x = CreateButton("SC_Buttons_"..Name, SizeX, SizeY, Anchor, aX, aY);

  return x;
end;

local function LoadButtons()
  for _,v in pairs(buttons) do
    CreateButton(v.name, v.sizeX, v.sizeY, v.anchor, v.aX, v.aY);
  end;
end;

local function CreateStateButton()
  -- Changes state on cast/use
end;


--================
--Module Functions
--================

function Load()
  buttons = SC_myConfig.Buttons.buttons;
  -- Events
  --SC_RegEvent(name, "UNIT_TARGET");
end;

function Notify()
end;

function Defaults()
  SC_myConfig.Buttons = {load = true};
  SC_myConfig.Buttons.buttons = { };
end;
