--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Release";
module.lname = SC_MODULE_RELEASE;
module.version = 1.111;
module.info = SC_MODULE_RELEASE_INFO;

RegisterModule(module);

--====================
--Battleground Release
--====================

local function CheckRelease()
  if isInBattleground() then
    RepopMe();
  end
end

--================
--Module Functions
--================

function Load()
  -- Events
  SC_RegEvent(module, "PLAYER_DEAD");
end

function Defaults()
  config.Release = {load = true};
end


  --==============
  --Event Handlers
  --==============

function PLAYER_DEAD()
  CheckRelease();
end
