--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

Skybreaker Whip: 32863
Riding Crop: 25653
Carrot on a Stick: 11122

==========================================================================
--Version 1.110--
-New Module "Mount". Equips riding trinkets when you mount. Unequips the
 the trinket when you dismount.
-New Module "Buffs". Interface for buffing groups intelligently. Added
 to Minimap by Default.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Mount";
module.lname = SC_MODULE_MOUNT;
module.version = 1.111;
module.info = SC_MODULE_MOUNT_INFO;

RegisterModule(module);


--======
--Locals
--======

local equip = false;
local IsMounted = IsMounted;
local InCombatLockdown = InCombatLockdown;

local trinkets = {
  ["32863"] = 10,
  ["25653"] = 10,
  ["11122"] = 3
};

--========
--Mounting
--========

local function GetItemID(item)
  return item:match('item:(%d+)');
end;

local function HasTrinket()
  local current = GetItemID(GetInventoryItemLink(
      "player", config.Mount.inv) or "");
  if trinkets[current] then
    return true;
  else
    return false;
  end
end;


--================
--Module Functions
--================

function Load()
  -- Events
  --SC_RegEvent(module, "PLAYER_CONTROL_GAINED");
  --SC_RegEvent(module, "UNIT_AURA");
  --SC_RegEvent(module, "PLAYER_AURAS_CHANGED");
end;

function Defaults()
  config.Mount = {load = true, inv = 13, auto = false, bag = 4, slot = 13};
end;


  --==============
  --Event Handlers
  --==============

function PLAYER_REGEN_ENABLED()
  if HasTrinket() then
    Demounting();
  end;
  SC_UnregEvent(module, "PLAYER_REGEN_ENABLED");
end;

function UNIT_AURA(unit)
  if unit == "player" then
    -- The game doesn't have IsMounted() set yet when you mount so...
    SC_RegEvent(module, "ACTIONBAR_SLOT_CHANGED");-- This is tentative...
  end;
end;

function ACTIONBAR_SLOT_CHANGED()
  local config = config.Mount;
  if IsMounted() then
    -- Check if trinket is already equipped
    if not HasTrinket() then
      if InCombatLockdown() then
        SC_RegEvent(module, "PLAYER_REGEN_ENABLED");
      else
        PickupContainerItem(config.bag, config.slot);
        EquipCursorItem(config.inv);
      end;
    end;
  else
    -- Check if trinket is equipped, then unequip
    print("wut!?")
    if HasTrinket() then
    print("lkasjdlfk")
      if InCombatLockdown() then
        SC_RegEvent(module, "PLAYER_REGEN_ENABLED");
      else
        print("harro")
        PickupContainerItem(config.bag, config.slot);
        EquipCursorItem(config.inv);
      end;
    end;
  end;
  SC_UnRegEvent(module, "ACTIONBAR_SLOT_CHANGED")
end;
